/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuraRemoteServiceServlet
extends RemoteServiceServlet {
    private static final long serialVersionUID = 3473193315046407200L;
    private static Logger logger = LoggerFactory.getLogger(KuraRemoteServiceServlet.class);

    public void checkXSRFToken(GwtXSRFToken xsrfToken) throws GwtKuraException {
        HttpServletRequest req = (HttpServletRequest)this.perThreadRequest.get();
        KuraRemoteServiceServlet.performXSRFTokenValidation(req, xsrfToken);
    }

    private static void performXSRFTokenValidation(HttpServletRequest req, GwtXSRFToken userToken) throws GwtKuraException {
        HttpSession session = req.getSession();
        if (!KuraRemoteServiceServlet.isValidXSRFToken(session, userToken)) {
            logger.info("XSRF token is NOT VALID");
            if (userToken != null) {
                logger.info("Invalid User Token={}", (Object)userToken.getToken());
            }
            logger.debug("\tSender IP: {}", (Object)req.getRemoteAddr());
            logger.debug("\tSender Host: {}", (Object)req.getRemoteHost());
            logger.debug("\tSender Port: {}", (Object)req.getRemotePort());
            logger.debug("\tFull Request URL\n {}?{}\n\n", (Object)req.getRequestURL().toString(), (Object)req.getQueryString());
            session.invalidate();
            logger.debug("Session invalidated.");
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, null, "Invalid XSRF token");
        }
    }

    public static boolean isValidXSRFToken(HttpSession session, GwtXSRFToken userToken) {
        String serverToken;
        logger.debug("Starting XSRF Token validation...'");
        if (userToken == null) {
            logger.debug("XSRF Token is NOT VALID -> NULL TOKEN");
            return false;
        }
        GwtXSRFToken serverXSRFToken = (GwtXSRFToken)session.getAttribute("XSRF_TOKEN");
        if (serverXSRFToken != null && KuraRemoteServiceServlet.isValidStringToken(serverToken = serverXSRFToken.getToken()) && KuraRemoteServiceServlet.isValidStringToken(userToken.getToken()) && serverToken.equals(userToken.getToken())) {
            if (new Date().before(userToken.getExpiresOn())) {
                logger.debug("XSRF Token is VALID - {}", (Object)userToken.getToken());
                session.setAttribute("XSRF_TOKEN", null);
                return true;
            }
            session.setAttribute("XSRF_TOKEN", null);
            logger.error("XSRF Token is EXPIRED - {}", (Object)userToken.getToken());
        }
        logger.debug("XSRF Token is NOT VALID - {}", (Object)userToken.getToken());
        return false;
    }

    private static boolean isValidStringToken(String token) {
        boolean result = false;
        if (token != null && !token.isEmpty()) {
            result = true;
        }
        return result;
    }

    public static String getFieldFromMultiPartForm(HttpServletRequest req, String fieldName) throws Exception {
        String fieldValue = null;
        ServletFileUpload upload = new ServletFileUpload();
        List items = upload.parseRequest(req);
        for (FileItem item : items) {
            String name;
            if (!item.isFormField() || !(name = item.getFieldName()).equals(fieldName)) continue;
            fieldValue = item.getString();
            logger.debug("Found field name '{}' with value: {}", (Object)name, (Object)fieldValue);
        }
        return fieldValue;
    }

    public static void checkXSRFToken(HttpServletRequest req, GwtXSRFToken token) throws Exception {
        KuraRemoteServiceServlet.performXSRFTokenValidation(req, token);
    }

    public static void checkXSRFTokenMultiPart(HttpServletRequest req, GwtXSRFToken token) throws Exception {
        KuraRemoteServiceServlet.performXSRFTokenValidation(req, token);
    }
}

