/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.network;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.network.NetworkTab;
import org.eclipse.kura.web.client.util.HelpButton;
import org.eclipse.kura.web.shared.model.GwtModemInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.gwtbootstrap3.client.ui.FieldSet;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.InlineRadio;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.html.Span;

public class TabModemGpsUi
extends Composite
implements NetworkTab {
    private static TabModemGpsUiUiBinder uiBinder = (TabModemGpsUiUiBinder)GWT.create(TabModemGpsUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    GwtSession session;
    boolean dirty;
    GwtModemInterfaceConfig selectedModemIfConfig;
    boolean formInitialized;
    @UiField
    FormLabel labelGps;
    @UiField
    InlineRadio radio1;
    @UiField
    InlineRadio radio2;
    @UiField
    PanelHeader helpTitle;
    @UiField
    ScrollPanel helpText;
    @UiField
    FieldSet field;
    @UiField
    HelpButton gpsHelp;

    public TabModemGpsUi(GwtSession currentSession) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.session = currentSession;
        this.initForm();
        this.gpsHelp.setHelpText(MSGS.netModemToolTipEnableGps());
    }

    @Override
    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void setNetInterface(GwtNetInterfaceConfig config) {
        this.dirty = true;
        if (config instanceof GwtModemInterfaceConfig) {
            this.selectedModemIfConfig = (GwtModemInterfaceConfig)config;
        }
    }

    @Override
    public void getUpdatedNetInterface(GwtNetInterfaceConfig updatedNetIf) {
        GwtModemInterfaceConfig updatedModemNetIf = (GwtModemInterfaceConfig)updatedNetIf;
        if (this.formInitialized) {
            updatedModemNetIf.setGpsEnabled(this.radio1.getValue());
        } else {
            updatedModemNetIf.setGpsEnabled(this.selectedModemIfConfig.isGpsEnabled());
        }
    }

    @Override
    public void refresh() {
        if (this.isDirty()) {
            this.setDirty(false);
            if (this.selectedModemIfConfig == null) {
                this.reset();
            } else {
                this.update();
            }
        }
    }

    private void initForm() {
        this.labelGps.setText(MSGS.netModemEnableGps());
        this.radio1.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabModemGpsUi.this.radio1.isEnabled()) {
                    TabModemGpsUi.this.helpText.clear();
                    TabModemGpsUi.this.helpText.add((Widget)new Span(MSGS.netModemToolTipEnableGps()));
                }
            }
        });
        this.radio1.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabModemGpsUi.this.resetHelp();
            }
        });
        this.radio2.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabModemGpsUi.this.radio2.isEnabled()) {
                    TabModemGpsUi.this.helpText.clear();
                    TabModemGpsUi.this.helpText.add((Widget)new Span(MSGS.netModemToolTipEnableGps()));
                }
            }
        });
        this.radio2.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabModemGpsUi.this.resetHelp();
            }
        });
        this.radio1.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                TabModemGpsUi.this.dirty = true;
            }
        });
        this.radio2.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                TabModemGpsUi.this.dirty = true;
            }
        });
        this.helpTitle.setText(MSGS.netHelpTitle());
        this.radio1.setText(MSGS.trueLabel());
        this.radio2.setText(MSGS.falseLabel());
        this.radio1.setValue(Boolean.valueOf(true));
        this.radio2.setValue(Boolean.valueOf(false));
        this.formInitialized = true;
    }

    private void resetHelp() {
        this.helpText.clear();
        this.helpText.add((Widget)new Span(MSGS.netHelpDefaultHint()));
    }

    private void update() {
        if (this.selectedModemIfConfig != null) {
            if (this.selectedModemIfConfig.isGpsEnabled()) {
                this.radio1.setValue(Boolean.valueOf(true));
                this.radio2.setValue(Boolean.valueOf(false));
            } else {
                this.radio1.setValue(Boolean.valueOf(false));
                this.radio2.setValue(Boolean.valueOf(true));
            }
        }
        this.refreshForm();
    }

    private void refreshForm() {
        if (this.selectedModemIfConfig.isGpsSupported()) {
            this.radio1.setEnabled(true);
            this.radio2.setEnabled(true);
        } else {
            this.radio1.setEnabled(false);
            this.radio2.setEnabled(false);
        }
    }

    private void reset() {
        this.radio1.setValue(Boolean.valueOf(true));
        this.radio2.setValue(Boolean.valueOf(false));
        this.update();
    }

    static interface TabModemGpsUiUiBinder
    extends UiBinder<Widget, TabModemGpsUi> {
    }
}

