/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.jetty.customizer;

import java.util.Dictionary;
import java.util.LinkedList;
import org.eclipse.equinox.http.jetty.JettyCustomizer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ServerConnector;

public class KuraJettyCustomizer
extends JettyCustomizer {
    public Object customizeHttpConnector(Object connector, Dictionary<String, ?> settings) {
        this.customizeConnector(connector);
        return connector;
    }

    public Object customizeHttpsConnector(Object connector, Dictionary<String, ?> settings) {
        this.customizeConnector(connector);
        return connector;
    }

    private void customizeConnector(Object connector) {
        if (!(connector instanceof ServerConnector)) {
            return;
        }
        ServerConnector serverConnector = (ServerConnector)connector;
        for (ConnectionFactory factory : serverConnector.getConnectionFactories()) {
            if (!(factory instanceof HttpConnectionFactory)) continue;
            HttpConnectionFactory httpConnectionFactory = (HttpConnectionFactory)factory;
            httpConnectionFactory.getHttpConfiguration().setSendServerVersion(false);
            LinkedList<ForwardedRequestCustomizer> customizers = httpConnectionFactory.getHttpConfiguration().getCustomizers();
            if (customizers == null) {
                customizers = new LinkedList<ForwardedRequestCustomizer>();
                httpConnectionFactory.getHttpConfiguration().setCustomizers(customizers);
            }
            customizers.add(new ForwardedRequestCustomizer());
        }
    }
}

