/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.firewall;

import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetProtocol;
import org.eclipse.kura.net.NetworkPair;
import org.eclipse.kura.net.firewall.FirewallPortForwardConfig;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class FirewallPortForwardConfigIP<T extends IPAddress>
implements FirewallPortForwardConfig {
    private String inboundIface;
    private String outboundIface;
    private IP4Address address;
    private NetProtocol protocol;
    private int inPort;
    private int outPort;
    private boolean masquerade;
    private NetworkPair<T> permittedNetwork;
    private String permittedMac;
    private String sourcePortRange;

    public FirewallPortForwardConfigIP() {
    }

    public FirewallPortForwardConfigIP(String inboundIface, String outboundIface, IP4Address address, NetProtocol protocol, int inPort, int outPort, boolean masquerade, NetworkPair<T> permittedNetwork, String permittedMac, String sourcePortRange) {
        this.inboundIface = inboundIface;
        this.outboundIface = outboundIface;
        this.address = address;
        this.protocol = protocol;
        this.inPort = inPort;
        this.outPort = outPort;
        this.masquerade = masquerade;
        this.permittedNetwork = permittedNetwork;
        this.permittedMac = permittedMac;
        this.sourcePortRange = sourcePortRange;
    }

    @Override
    public String getInboundInterface() {
        return this.inboundIface;
    }

    public void setInboundInterface(String interfaceName) {
        this.inboundIface = interfaceName;
    }

    @Override
    public String getOutboundInterface() {
        return this.outboundIface;
    }

    public void setOutboundInterface(String interfaceName) {
        this.outboundIface = interfaceName;
    }

    @Override
    public IP4Address getAddress() {
        return this.address;
    }

    public void setAddress(IP4Address address) {
        this.address = address;
    }

    @Override
    public NetProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(NetProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public int getInPort() {
        return this.inPort;
    }

    public void setInPort(int inPort) {
        this.inPort = inPort;
    }

    @Override
    public int getOutPort() {
        return this.outPort;
    }

    public void setOutPort(int outPort) {
        this.outPort = outPort;
    }

    @Override
    public boolean isMasquerade() {
        return this.masquerade;
    }

    public void setMasquerade(boolean masquerade) {
        this.masquerade = masquerade;
    }

    public NetworkPair<T> getPermittedNetwork() {
        return this.permittedNetwork;
    }

    public void setPermittedNetwork(NetworkPair<T> permittedNetwork) {
        this.permittedNetwork = permittedNetwork;
    }

    @Override
    public String getPermittedMac() {
        return this.permittedMac;
    }

    public void setPermittedMac(String permittedMac) {
        this.permittedMac = permittedMac;
    }

    @Override
    public String getSourcePortRange() {
        return this.sourcePortRange;
    }

    public void setSourcePortRange(String sourcePortRange) {
        this.sourcePortRange = sourcePortRange;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + this.inPort;
        result = 31 * result + (this.inboundIface == null ? 0 : this.inboundIface.hashCode());
        result = 31 * result + (this.outboundIface == null ? 0 : this.outboundIface.hashCode());
        result = 31 * result + (this.masquerade ? 1231 : 1237);
        result = 31 * result + this.outPort;
        result = 31 * result + (this.permittedMac == null ? 0 : this.permittedMac.hashCode());
        result = 31 * result + (this.permittedNetwork == null ? 0 : this.permittedNetwork.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.sourcePortRange == null ? 0 : this.sourcePortRange.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirewallPortForwardConfigIP other = (FirewallPortForwardConfigIP)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.inPort != other.inPort) {
            return false;
        }
        if (this.inboundIface == null ? other.inboundIface != null : !this.inboundIface.equals(other.inboundIface)) {
            return false;
        }
        if (this.outboundIface == null ? other.outboundIface != null : !this.outboundIface.equals(other.outboundIface)) {
            return false;
        }
        if (this.outPort != other.outPort) {
            return false;
        }
        if (this.masquerade != other.masquerade) {
            return false;
        }
        if (this.permittedMac == null ? other.permittedMac != null : !this.permittedMac.equals(other.permittedMac)) {
            return false;
        }
        if (this.permittedNetwork == null ? other.permittedNetwork != null : !this.permittedNetwork.equals(other.permittedNetwork)) {
            return false;
        }
        if (this.protocol != other.protocol) {
            return false;
        }
        return !(this.sourcePortRange == null ? other.sourcePortRange != null : !this.sourcePortRange.equals(other.sourcePortRange));
    }

    @Override
    public boolean isValid() {
        if (this.inboundIface == null || this.inboundIface.trim().isEmpty()) {
            return false;
        }
        if (this.outboundIface == null || this.outboundIface.trim().isEmpty()) {
            return false;
        }
        if (this.address == null) {
            return false;
        }
        if (this.inPort < 0 || this.inPort > 65535 || this.outPort < 0 || this.outPort > 65535) {
            return false;
        }
        return this.protocol != null && this.protocol.equals((Object)NetProtocol.tcp) && this.protocol.equals((Object)NetProtocol.udp);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FirewallPortForwardConfigIP [inboundIface=");
        builder.append(this.inboundIface);
        builder.append(", outboundIface=");
        builder.append(this.outboundIface);
        builder.append(", address=");
        builder.append(this.address);
        builder.append(", protocol=");
        builder.append((Object)this.protocol);
        builder.append(", inPort=");
        builder.append(this.inPort);
        builder.append(", outPort=");
        builder.append(this.outPort);
        builder.append(", permittedNetwork=");
        builder.append(this.permittedNetwork);
        builder.append(", permittedMac=");
        builder.append(this.permittedMac);
        builder.append(", sourcePortRange=");
        builder.append(this.sourcePortRange);
        builder.append("]");
        return builder.toString();
    }
}

