/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl;

import io.moquette.interception.InterceptHandler;
import io.moquette.server.config.IConfig;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.ISessionsStore;
import io.moquette.spi.impl.BrokerInterceptor;
import io.moquette.spi.impl.ProtocolProcessor;
import io.moquette.spi.impl.security.ACLFileParser;
import io.moquette.spi.impl.security.AcceptAllAuthenticator;
import io.moquette.spi.impl.security.DenyAllAuthorizator;
import io.moquette.spi.impl.security.FileAuthenticator;
import io.moquette.spi.impl.security.PermitAllAuthorizator;
import io.moquette.spi.impl.subscriptions.SubscriptionsStore;
import io.moquette.spi.persistence.MapDBPersistentStore;
import io.moquette.spi.security.IAuthenticator;
import io.moquette.spi.security.IAuthorizator;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMessaging {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMessaging.class);
    private SubscriptionsStore subscriptions;
    private MapDBPersistentStore m_mapStorage;
    private BrokerInterceptor m_interceptor;
    private static SimpleMessaging INSTANCE;
    private final ProtocolProcessor m_processor = new ProtocolProcessor();

    private SimpleMessaging() {
    }

    public static SimpleMessaging getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SimpleMessaging();
        }
        return INSTANCE;
    }

    public ProtocolProcessor init(IConfig props, List<? extends InterceptHandler> embeddedObservers, IAuthenticator authenticator, IAuthorizator authorizator) {
        String authorizatorClassName;
        this.subscriptions = new SubscriptionsStore();
        this.m_mapStorage = new MapDBPersistentStore(props);
        this.m_mapStorage.initStore();
        IMessagesStore messagesStore = this.m_mapStorage.messagesStore();
        ISessionsStore sessionsStore = this.m_mapStorage.sessionsStore(messagesStore);
        ArrayList<InterceptHandler> observers = new ArrayList<InterceptHandler>(embeddedObservers);
        String interceptorClassName = props.getProperty("intercept.handler");
        if (interceptorClassName != null && !interceptorClassName.isEmpty()) {
            try {
                InterceptHandler handler = Class.forName(interceptorClassName).asSubclass(InterceptHandler.class).newInstance();
                observers.add(handler);
            }
            catch (Throwable ex) {
                LOG.error("Can't load the intercept handler {}", ex);
            }
        }
        this.m_interceptor = new BrokerInterceptor(observers);
        this.subscriptions.init(sessionsStore);
        String configPath = System.getProperty("moquette.path", null);
        String authenticatorClassName = props.getProperty("authenticator_class", "");
        if (!authenticatorClassName.isEmpty()) {
            authenticator = (IAuthenticator)this.loadClass(authenticatorClassName, IAuthenticator.class);
            LOG.info("Loaded custom authenticator {}", (Object)authenticatorClassName);
        }
        if (authenticator == null) {
            String passwdPath = props.getProperty("password_file", "");
            authenticator = passwdPath.isEmpty() ? new AcceptAllAuthenticator() : new FileAuthenticator(configPath, passwdPath);
        }
        if (!(authorizatorClassName = props.getProperty("authorizator_class", "")).isEmpty()) {
            authorizator = (IAuthorizator)this.loadClass(authorizatorClassName, IAuthorizator.class);
            LOG.info("Loaded custom authorizator {}", (Object)authorizatorClassName);
        }
        if (authorizator == null) {
            String aclFilePath = props.getProperty("acl_file", "");
            if (aclFilePath != null && !aclFilePath.isEmpty()) {
                authorizator = new DenyAllAuthorizator();
                File aclFile = new File(configPath, aclFilePath);
                try {
                    authorizator = ACLFileParser.parse(aclFile);
                }
                catch (ParseException pex) {
                    LOG.error(String.format("Format error in parsing acl file %s", aclFile), pex);
                }
                LOG.info("Using acl file defined at path {}", (Object)aclFilePath);
            } else {
                authorizator = new PermitAllAuthorizator();
                LOG.info("Starting without ACL definition");
            }
        }
        boolean allowAnonymous = Boolean.parseBoolean(props.getProperty("allow_anonymous", "true"));
        this.m_processor.init(this.subscriptions, messagesStore, sessionsStore, authenticator, allowAnonymous, authorizator, this.m_interceptor);
        return this.m_processor;
    }

    private Object loadClass(String className, Class<?> cls) {
        Object instance = null;
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod("getInstance", new Class[0]);
            try {
                instance = method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                LOG.error(null, ex);
                throw new RuntimeException("Cannot call method " + className + ".getInstance", ex);
            }
        }
        catch (NoSuchMethodException nsmex) {
            try {
                instance = this.getClass().getClassLoader().loadClass(className).asSubclass(cls).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                LOG.error(null, ex);
                throw new RuntimeException("Cannot load custom authenticator class " + className, ex);
            }
        }
        catch (ClassNotFoundException ex) {
            LOG.error(null, ex);
            throw new RuntimeException("Class " + className + " not found", ex);
        }
        catch (SecurityException ex) {
            LOG.error(null, ex);
            throw new RuntimeException("Cannot call method " + className + ".getInstance", ex);
        }
        return instance;
    }

    public void shutdown() {
        this.m_mapStorage.close();
    }
}

