/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

public class Semaphore {
    private boolean m_available;

    public Semaphore() {
        this.m_available = true;
    }

    public Semaphore(boolean isAvailable) {
        this.m_available = isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                if (!this.m_available) {
                    this.wait();
                }
                this.m_available = false;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }

    public boolean tryAcquire(long timeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.m_available) {
                this.m_available = false;
                return true;
            }
            if (timeout <= 0L) {
                return false;
            }
            long startTime = System.currentTimeMillis();
            try {
                do {
                    this.wait(timeout);
                    if (!this.m_available) continue;
                    this.m_available = false;
                    return true;
                } while ((timeout -= System.currentTimeMillis() - startTime) > 0L);
                return false;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }

    public synchronized void release() {
        this.m_available = true;
        this.notify();
    }
}

