/*
 * Decompiled with CFR 0.152.
 */
package com.codeminders.hidapi;

import com.codeminders.hidapi.HIDDevice;
import com.codeminders.hidapi.HIDDeviceInfo;
import com.codeminders.hidapi.HIDDeviceNotFoundException;
import java.io.IOException;

public class HIDManager {
    private static HIDManager instance;
    protected long peer;

    public native HIDDeviceInfo[] listDevices() throws IOException;

    private native void init() throws IOException;

    public native void release();

    private HIDManager() throws IOException {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public HIDDevice openByPath(String path) throws IOException, HIDDeviceNotFoundException {
        HIDDeviceInfo[] devs;
        for (HIDDeviceInfo d : devs = this.listDevices()) {
            if (!d.getPath().equals(path)) continue;
            return d.open();
        }
        throw new HIDDeviceNotFoundException();
    }

    public HIDDevice openById(int vendor_id, int product_id, String serial_number) throws IOException, HIDDeviceNotFoundException {
        HIDDeviceInfo[] devs;
        for (HIDDeviceInfo d : devs = this.listDevices()) {
            if (d.getVendor_id() != vendor_id || d.getProduct_id() != product_id || serial_number != null && !d.getSerial_number().equals(serial_number)) continue;
            return d.open();
        }
        throw new HIDDeviceNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HIDManager getInstance() throws IOException {
        if (instance != null) return instance;
        Class<HIDManager> clazz = HIDManager.class;
        synchronized (HIDManager.class) {
            if (null != instance) return instance;
            instance = new HIDManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static {
        System.loadLibrary("hidapi");
        instance = null;
    }
}

