/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest readManifest(File manifestFile) throws IOException {
        GZIPInputStream is = null;
        Manifest mf = null;
        try {
            is = new GZIPInputStream(new FileInputStream(manifestFile));
            mf = new Manifest(is);
        }
        catch (Throwable throwable) {
            Utils.closeSilently(is);
            throw throwable;
        }
        Utils.closeSilently(is);
        return mf;
    }

    public static void readUntilEndOfStream(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        int c = is.read(buffer);
        while (c != -1) {
            c = is.read(buffer);
        }
    }

    public static boolean replace(File target, File source) {
        return Utils.delete(target, true) && Utils.rename(source, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File from, File to) {
        boolean result;
        block12: {
            block11: {
                result = true;
                if (!from.isDirectory()) break block11;
                if (to.isDirectory()) break block12;
                if (!to.mkdirs()) {
                    return false;
                }
                File[] files = from.listFiles();
                if (files == null) {
                    return false;
                }
                for (int i = 0; i < files.length; ++i) {
                    result &= Utils.copy(files[i], new File(to, files[i].getName()));
                }
                break block12;
            }
            FileInputStream input = null;
            FileOutputStream output = null;
            try {
                input = new FileInputStream(from);
                output = new FileOutputStream(to);
                byte[] buffer = new byte[4096];
                int i = ((InputStream)input).read(buffer);
                while (i > -1) {
                    ((OutputStream)output).write(buffer, 0, i);
                    i = ((InputStream)input).read(buffer);
                }
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (!Utils.closeSilently(output)) {
                    result = false;
                }
                if (!Utils.closeSilently(input)) {
                    result = false;
                }
            }
        }
        return result;
    }

    public static boolean rename(File from, File to) {
        if (!from.renameTo(to)) {
            if (Utils.copy(from, to)) {
                if (!Utils.delete(from, true)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean delete(File root, boolean deleteRoot) {
        boolean result = true;
        if (root.isDirectory()) {
            File[] files = root.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    result &= Utils.delete(files[i], true);
                    continue;
                }
                result &= files[i].delete();
            }
        }
        if (deleteRoot && root.exists()) {
            result &= root.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(File targetIndex, File target, File sourceIndex, File source) throws IOException {
        String path;
        List targetFiles = Utils.readIndex(targetIndex);
        List sourceFiles = Utils.readIndex(sourceIndex);
        ArrayList<String> result = new ArrayList<String>(targetFiles);
        File manifestFile = new File(source, (String)sourceFiles.remove(0));
        Manifest resultManifest = Utils.readManifest(manifestFile);
        resultManifest.getMainAttributes().remove(new Attributes.Name("DeploymentPackage-FixPack"));
        Iterator i = result.iterator();
        while (i.hasNext()) {
            String targetFile = (String)i.next();
            if ("META-INF/MANIFEST.MF".equals(targetFile) || resultManifest.getEntries().containsKey(targetFile)) continue;
            i.remove();
        }
        Iterator<Object> iter = sourceFiles.iterator();
        while (iter.hasNext()) {
            path = (String)iter.next();
            File from = new File(source, path);
            File to = new File(target, path);
            if (targetFiles.contains(path)) {
                if (!to.delete()) {
                    throw new IOException("Could not delete " + to);
                }
            } else {
                result.add(path);
            }
            if (Utils.rename(from, to)) continue;
            throw new IOException("Could not rename " + from + " to " + to);
        }
        targetFiles.removeAll(sourceFiles);
        iter = resultManifest.getEntries().keySet().iterator();
        while (iter.hasNext()) {
            path = (String)iter.next();
            Attributes sourceAttribute = resultManifest.getEntries().get(path);
            if (!"true".equals(sourceAttribute.remove(new Attributes.Name("DeploymentPackage-Missing")))) continue;
            targetFiles.remove(path);
        }
        iter = targetFiles.iterator();
        while (iter.hasNext()) {
            path = (String)iter.next();
            File targetFile = new File(target, path);
            if (targetFile.delete()) continue;
            throw new IOException("Could not delete " + targetFile);
        }
        GZIPOutputStream outputStream = new GZIPOutputStream(new FileOutputStream(new File(target, "META-INF/MANIFEST.MF")));
        try {
            resultManifest.write(outputStream);
        }
        finally {
            outputStream.close();
        }
        Utils.writeIndex(targetIndex, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List readIndex(File index) throws IOException {
        ArrayList<String> arrayList;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(index));
            ArrayList<String> result = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                result.add(line);
                line = reader.readLine();
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            Utils.closeSilently(reader);
            throw throwable;
        }
        Utils.closeSilently(reader);
        return arrayList;
    }

    static boolean closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException exception) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIndex(File index, List input) throws IOException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(index));
            Iterator iterator = input.iterator();
            while (iterator.hasNext()) {
                writer.println(iterator.next());
            }
        }
        catch (Throwable throwable) {
            Utils.closeSilently(writer);
            throw throwable;
        }
        Utils.closeSilently(writer);
    }
}

