/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.eclipse.kura.core.util.IOUtil;
import org.eclipse.kura.core.util.ProcessUtil;
import org.eclipse.kura.net.NetworkService;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemServiceImpl
implements SystemService {
    private static final Logger s_logger = LoggerFactory.getLogger(SystemServiceImpl.class);
    private static final boolean onCloudbees = new File("/private/eurotech/settings-security.xml").exists();
    private Properties m_kuraProperties;
    private ComponentContext m_ctx;
    private NetworkService m_networkService;

    public void setNetworkService(NetworkService networkService) {
        this.m_networkService = networkService;
    }

    public void unsetNetworkService(NetworkService networkService) {
        this.m_networkService = null;
    }

    protected void activate(ComponentContext componentContext) {
        this.m_ctx = componentContext;
        Properties kuraDefaults = new Properties();
        boolean updateTriggered = false;
        try {
            File directory;
            if (System.getProperty("kura.configuration") != null && System.getProperty("kura.configuration").trim().equals("file:kura/kura.properties")) {
                System.setProperty("kura.configuration", "file:/opt/eclipse/kura/kura/kura.properties");
                updateTriggered = true;
                s_logger.warn("Overridding invalid kura.properties location");
            }
            if (System.getProperty("dpa.configuration") != null && System.getProperty("dpa.configuration").trim().equals("kura/dpa.properties")) {
                System.setProperty("dpa.configuration", "/opt/eclipse/kura/kura/dpa.properties");
                updateTriggered = true;
                s_logger.warn("Overridding invalid dpa.properties location");
            }
            if (System.getProperty("log4j.configuration") != null && System.getProperty("log4j.configuration").trim().equals("file:kura/log4j.properties")) {
                System.setProperty("log4j.configuration", "file:/opt/eclipse/kura/kura/log4j.properties");
                updateTriggered = true;
                s_logger.warn("Overridding invalid log4j.properties location");
            }
            String kuraHome = System.getProperty("kura.home");
            String kuraConfig = System.getProperty("kura.configuration");
            String kuraProperties = IOUtil.readResource("kura.properties");
            if (kuraProperties != null) {
                kuraDefaults.load(new StringReader(kuraProperties));
                s_logger.info("Loaded Jar Resource kura.properties.");
            } else if (kuraConfig != null) {
                try {
                    URL kuraConfigUrl = new URL(kuraConfig);
                    kuraDefaults.load(kuraConfigUrl.openStream());
                    s_logger.info("Loaded URL kura.properties: " + kuraConfig);
                }
                catch (Exception e) {
                    s_logger.warn("Could not open kuraConfig URL", (Throwable)e);
                }
            } else if (kuraHome != null) {
                File kuraPropsFile = new File(String.valueOf(kuraHome) + File.separator + "kura.properties");
                if (kuraPropsFile.exists()) {
                    kuraDefaults.load(new FileReader(kuraPropsFile));
                    s_logger.info("Loaded File kura.properties: " + kuraPropsFile);
                } else {
                    s_logger.warn("File does not exist: " + kuraPropsFile);
                }
            } else {
                s_logger.error("Could not located kura.properties with kura.home " + kuraHome);
            }
            Properties kuraCustomProps = new Properties();
            String kuraCustomConfig = System.getProperty("kura.custom.configuration");
            String kuraCustomProperties = IOUtil.readResource("kura_custom.properties");
            if (kuraCustomProperties != null) {
                kuraCustomProps.load(new StringReader(kuraCustomProperties));
                s_logger.info("Loaded Jar Resource: kura_custom.properties");
            } else if (kuraCustomConfig != null) {
                try {
                    URL kuraConfigUrl = new URL(kuraCustomConfig);
                    kuraCustomProps.load(kuraConfigUrl.openStream());
                    s_logger.info("Loaded URL kura_custom.properties: " + kuraCustomConfig);
                }
                catch (Exception e) {
                    s_logger.warn("Could not open kuraCustomConfig URL: " + e);
                }
            } else if (kuraHome != null) {
                File kuraCustomPropsFile = new File(String.valueOf(kuraHome) + File.separator + "kura_custom.properties");
                if (kuraCustomPropsFile.exists()) {
                    kuraCustomProps.load(new FileReader(kuraCustomPropsFile));
                    s_logger.info("Loaded File kura_custom.properties: " + kuraCustomPropsFile);
                } else {
                    s_logger.warn("File does not exist: " + kuraCustomPropsFile);
                }
            } else {
                s_logger.info("Did not locate a kura_custom.properties file in " + kuraHome);
            }
            kuraDefaults.putAll((Map<?, ?>)kuraCustomProps);
            if (kuraDefaults.getProperty("kura.home") != null && kuraDefaults.getProperty("kura.home").trim().equals("kura")) {
                kuraDefaults.setProperty("kura.home", "/opt/eclipse/kura/kura");
                updateTriggered = true;
                s_logger.warn("Overridding invalid kura.home location");
            }
            if (kuraDefaults.getProperty("kura.plugins") != null && kuraDefaults.getProperty("kura.plugins").trim().equals("kura/plugins")) {
                kuraDefaults.setProperty("kura.plugins", "/opt/eclipse/kura/kura/plugins");
                updateTriggered = true;
                s_logger.warn("Overridding invalid kura.plugins location");
            }
            if (kuraDefaults.getProperty("kura.packages") != null && kuraDefaults.getProperty("kura.packages").trim().equals("kura/packages")) {
                kuraDefaults.setProperty("kura.packages", "/opt/eclipse/kura/kura/packages");
                updateTriggered = true;
                s_logger.warn("Overridding invalid kura.packages location");
            }
            if (updateTriggered && ((directory = new File("/opt/eclipse/kura").getAbsoluteFile()).exists() || directory.mkdirs())) {
                boolean result;
                String oldDir = System.getProperty("user.dir");
                boolean bl = result = System.setProperty("user.dir", directory.getAbsolutePath()) != null;
                if (result) {
                    s_logger.warn("Changed working directory to /opt/eclipse/kura from " + oldDir);
                }
            }
            this.m_kuraProperties = new Properties(kuraDefaults);
            if (onCloudbees) {
                this.m_kuraProperties.put("os.name", "Linux (Cloudbees)");
            }
            Boolean hasNetAdmin = Boolean.valueOf(this.m_kuraProperties.getProperty("kura.have.net.admin", "true"));
            this.m_kuraProperties.put("kura.have.net.admin", hasNetAdmin);
            s_logger.info("Kura has net admin? " + hasNetAdmin);
            String hasWebInterface = this.m_kuraProperties.getProperty("kura.have.web.inter", "true");
            this.m_kuraProperties.put("kura.have.web.inter", hasWebInterface);
            s_logger.info("Kura has web interface? " + hasWebInterface);
            String kuraVersion = this.m_kuraProperties.getProperty("kura.version", "version-unknown");
            this.m_kuraProperties.put("kura.version", kuraVersion);
            s_logger.info("Kura version? " + kuraVersion);
            Properties systemProperties = System.getProperties();
            this.m_kuraProperties.putAll((Map<?, ?>)systemProperties);
            if (this.getKuraHome() == null) {
                s_logger.error("Did not initialize kura.home");
            } else {
                s_logger.info("Kura home directory is " + this.getKuraHome());
                this.createDirIfNotExists(this.getKuraHome());
            }
            if (this.getKuraSnapshotsDirectory() == null) {
                s_logger.error("Did not initialize kura.snapshots");
            } else {
                s_logger.info("Kura snapshots directory is " + this.getKuraSnapshotsDirectory());
                this.createDirIfNotExists(this.getKuraSnapshotsDirectory());
            }
            if (this.getKuraTemporaryConfigDirectory() == null) {
                s_logger.error("Did not initialize kura.tmp");
            } else {
                s_logger.info("Kura tmp directory is " + this.getKuraTemporaryConfigDirectory());
                this.createDirIfNotExists(this.getKuraTemporaryConfigDirectory());
            }
            s_logger.info(new StringBuffer().append("Kura version ").append(this.getKuraVersion()).append(" is starting").toString());
        }
        catch (IOException e) {
            throw new ComponentException("Error loading default properties", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.m_ctx = null;
        this.m_kuraProperties = null;
    }

    public void updated(Map<String, Object> properties) {
    }

    public Properties getProperties() {
        return this.m_kuraProperties;
    }

    /*
     * Exception decompiling
     */
    public String getPrimaryMacAddress() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getPrimaryNetworkInterfaceName() {
        if (this.m_kuraProperties.getProperty("kura.primary.network.interface") != null) {
            return this.m_kuraProperties.getProperty("kura.primary.network.interface");
        }
        if ("Mac OS X".equals(this.getOsName())) {
            return "en0";
        }
        if ("Linux".equals(this.getOsName())) {
            return "eth0";
        }
        s_logger.error("Unsupported platform");
        return null;
    }

    public String getPlatform() {
        return this.m_kuraProperties.getProperty("kura.platform");
    }

    public String getOsArch() {
        String override = this.m_kuraProperties.getProperty("os.arch");
        if (override != null) {
            return override;
        }
        return System.getProperty("os.arch");
    }

    public String getOsName() {
        String override = this.m_kuraProperties.getProperty("os.name");
        if (override != null) {
            return override;
        }
        return System.getProperty("os.name");
    }

    public String getOsVersion() {
        String override = this.m_kuraProperties.getProperty("os.version");
        if (override != null) {
            return override;
        }
        return System.getProperty("os.version");
    }

    public String getOsDistro() {
        return this.m_kuraProperties.getProperty("os.distribution");
    }

    public String getOsDistroVersion() {
        return this.m_kuraProperties.getProperty("os.distribution.version");
    }

    public String getJavaVendor() {
        String override = this.m_kuraProperties.getProperty("java.runtime.name");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.runtime.name");
    }

    public String getJavaVersion() {
        String override = this.m_kuraProperties.getProperty("java.runtime.version");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.runtime.version");
    }

    public String getJavaVmName() {
        String override = this.m_kuraProperties.getProperty("java.vm.name");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.vm.name");
    }

    public String getJavaVmVersion() {
        String override = this.m_kuraProperties.getProperty("java.vm.version");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.vm.version");
    }

    public String getJavaVmInfo() {
        String override = this.m_kuraProperties.getProperty("java.vm.info");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.vm.info");
    }

    public String getOsgiFwName() {
        String override = this.m_kuraProperties.getProperty("org.osgi.framework.vendor");
        if (override != null) {
            return override;
        }
        return System.getProperty("org.osgi.framework.vendor");
    }

    public String getOsgiFwVersion() {
        String override = this.m_kuraProperties.getProperty("org.osgi.framework.version");
        if (override != null) {
            return override;
        }
        return System.getProperty("org.osgi.framework.version");
    }

    public int getNumberOfProcessors() {
        try {
            return Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory() / 1024L;
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory() / 1024L;
    }

    public String getFileSeparator() {
        String override = this.m_kuraProperties.getProperty("file.separator");
        if (override != null) {
            return override;
        }
        return System.getProperty("file.separator");
    }

    public String getJavaHome() {
        String override = this.m_kuraProperties.getProperty("java.home");
        if (override != null) {
            return override;
        }
        return System.getProperty("java.home");
    }

    public String getKuraName() {
        return this.m_kuraProperties.getProperty("kura.name");
    }

    public String getKuraVersion() {
        return this.m_kuraProperties.getProperty("kura.version");
    }

    public String getKuraHome() {
        if ("emulator".equals(System.getProperty("org.eclipse.kura.mode"))) {
            StringBuffer sb = new StringBuffer();
            sb.append(System.getProperty("java.io.tmpdir")).append(this.getFileSeparator()).append("kura_emulator_base").append(this.getFileSeparator());
            return sb.toString();
        }
        return this.m_kuraProperties.getProperty("kura.home");
    }

    public String getKuraPluginsDirectory() {
        return this.m_kuraProperties.getProperty("kura.plugins");
    }

    public String getKuraDataDirectory() {
        return this.m_kuraProperties.getProperty("kura.data");
    }

    public String getKuraTemporaryConfigDirectory() {
        return this.m_kuraProperties.getProperty("kura.tmp");
    }

    public String getKuraSnapshotsDirectory() {
        return this.m_kuraProperties.getProperty("kura.snapshots");
    }

    public int getKuraSnapshotsCount() {
        int iMaxCount = 10;
        String maxCount = this.m_kuraProperties.getProperty("kura.snapshots.count");
        if (maxCount != null && maxCount.trim().length() > 0) {
            try {
                iMaxCount = Integer.parseInt(maxCount);
            }
            catch (NumberFormatException nfe) {
                s_logger.error("Error - Invalid kura.snapshots.count setting. Using default.", (Throwable)nfe);
            }
        }
        return iMaxCount;
    }

    public int getKuraWifiTopChannel() {
        String topWifiChannel = this.m_kuraProperties.getProperty("kura.wifi.top.channel");
        if (topWifiChannel != null && topWifiChannel.trim().length() > 0) {
            return Integer.parseInt(topWifiChannel);
        }
        s_logger.warn("The last wifi channel is not defined for this system - setting to lowest common value of 11");
        return 11;
    }

    public String getKuraStyleDirectory() {
        return this.m_kuraProperties.getProperty("kura.style.dir");
    }

    public String getKuraWebEnabled() {
        return this.m_kuraProperties.getProperty("kura.have.web.inter");
    }

    public String getBiosVersion() {
        String[] cmds;
        String biosTmp;
        String override = this.m_kuraProperties.getProperty("kura.bios.version");
        if (override != null) {
            return override;
        }
        String biosVersion = "UNSUPPORTED";
        if ("Linux".equals(this.getOsName())) {
            if ("2.6.34.9-WR4.2.0.0_standard".equals(this.getOsVersion()) || "2.6.34.12-WR4.3.0.0_standard".equals(this.getOsVersion())) {
                biosVersion = this.runSystemInfoCommand("eth_vers_bios");
            } else {
                String biosTmp2 = this.runSystemInfoCommand("dmidecode -s bios-version");
                if (biosTmp2.length() > 0 && !biosTmp2.contains("Permission denied")) {
                    biosVersion = biosTmp2;
                }
            }
        } else if ("Mac OS X".equals(this.getOsName()) && (biosTmp = this.runSystemInfoCommand(cmds = new String[]{"/bin/sh", "-c", "system_profiler SPHardwareDataType | grep 'Boot ROM'"})).contains(": ")) {
            biosVersion = biosTmp.split(":\\s+")[1];
        }
        return biosVersion;
    }

    public String getDeviceName() {
        String displayTmp;
        String override = this.m_kuraProperties.getProperty("kura.device.name");
        if (override != null) {
            return override;
        }
        String deviceName = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String displayTmp2 = this.runSystemInfoCommand("scutil --get ComputerName");
            if (displayTmp2.length() > 0) {
                deviceName = displayTmp2;
            }
        } else if (("Linux".equals(this.getOsName()) || "Linux (Cloudbees)".equals(this.getOsName())) && (displayTmp = this.runSystemInfoCommand("hostname")).length() > 0) {
            deviceName = displayTmp;
        }
        return deviceName;
    }

    public String getFirmwareVersion() {
        String override = this.m_kuraProperties.getProperty("kura.firmware.version");
        if (override != null) {
            return override;
        }
        String fwVersion = "UNSUPPORTED";
        if ("Linux".equals(this.getOsName()) && ("2.6.34.9-WR4.2.0.0_standard".equals(this.getOsVersion()) || "2.6.34.12-WR4.3.0.0_standard".equals(this.getOsVersion()))) {
            fwVersion = String.valueOf(this.runSystemInfoCommand("eth_vers_cpld")) + " " + this.runSystemInfoCommand("eth_vers_uctl");
        }
        return fwVersion;
    }

    public String getModelId() {
        String modelTmp;
        String override = this.m_kuraProperties.getProperty("kura.model.id");
        if (override != null) {
            return override;
        }
        String modelId = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String modelTmp2 = this.runSystemInfoCommand("sysctl -b hw.model");
            if (modelTmp2.length() > 0) {
                modelId = modelTmp2;
            }
        } else if ("Linux".equals(this.getOsName()) && (modelTmp = this.runSystemInfoCommand("dmidecode -t system")).contains("Version: ")) {
            modelId = modelTmp.split("Version:\\s+")[1].split("\n")[0];
        }
        return modelId;
    }

    public String getModelName() {
        String modelTmp;
        String override = this.m_kuraProperties.getProperty("kura.model.name");
        if (override != null) {
            return override;
        }
        String modelName = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String[] cmds = new String[]{"/bin/sh", "-c", "system_profiler SPHardwareDataType | grep 'Model Name'"};
            String modelTmp2 = this.runSystemInfoCommand(cmds);
            if (modelTmp2.contains(": ")) {
                modelName = modelTmp2.split(":\\s+")[1];
            }
        } else if ("Linux".equals(this.getOsName()) && (modelTmp = this.runSystemInfoCommand("dmidecode -t system")).contains("Product Name: ")) {
            modelName = modelTmp.split("Product Name:\\s+")[1].split("\n")[0];
        }
        return modelName;
    }

    public String getPartNumber() {
        String override = this.m_kuraProperties.getProperty("kura.partNumber");
        if (override != null) {
            return override;
        }
        String partNumber = "UNSUPPORTED";
        if ("Linux".equals(this.getOsName()) && ("2.6.34.9-WR4.2.0.0_standard".equals(this.getOsVersion()) || "2.6.34.12-WR4.3.0.0_standard".equals(this.getOsVersion()))) {
            partNumber = String.valueOf(this.runSystemInfoCommand("eth_partno_bsp")) + " " + this.runSystemInfoCommand("eth_partno_epr");
        }
        return partNumber;
    }

    public String getSerialNumber() {
        String serialTmp;
        String override = this.m_kuraProperties.getProperty("kura.serialNumber");
        if (override != null) {
            return override;
        }
        String serialNum = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String[] cmds = new String[]{"/bin/sh", "-c", "system_profiler SPHardwareDataType | grep 'Serial Number'"};
            String serialTmp2 = this.runSystemInfoCommand(cmds);
            if (serialTmp2.contains(": ")) {
                serialNum = serialTmp2.split(":\\s+")[1];
            }
        } else if ("Linux".equals(this.getOsName()) && (serialTmp = this.runSystemInfoCommand("dmidecode -t system")).contains("Serial Number: ")) {
            serialNum = serialTmp.split("Serial Number:\\s+")[1].split("\n")[0];
        }
        return serialNum;
    }

    public char[] getJavaKeyStorePassword() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException {
        String keyStorePwd = this.m_kuraProperties.getProperty("kura.ssl.keyStorePassword");
        if (keyStorePwd != null) {
            return keyStorePwd.toCharArray();
        }
        return null;
    }

    public char[] getJavaTrustStorePassword() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException {
        String trustStorePwd = this.m_kuraProperties.getProperty("kura.ssl.trustStorePassword");
        if (trustStorePwd != null) {
            return trustStorePwd.toCharArray();
        }
        return null;
    }

    public Bundle[] getBundles() {
        if (this.m_ctx == null) {
            return null;
        }
        return this.m_ctx.getBundleContext().getBundles();
    }

    public List<String> getDeviceManagementServiceIgnore() {
        String[] servicesArray;
        String servicesToIgnore = this.m_kuraProperties.getProperty("console.device.management.service.ignore");
        if (servicesToIgnore != null && !servicesToIgnore.trim().isEmpty() && (servicesArray = servicesToIgnore.split(",")) != null && servicesArray.length > 0) {
            ArrayList<String> services = new ArrayList<String>();
            String[] stringArray = servicesArray;
            int n = servicesArray.length;
            int n2 = 0;
            while (n2 < n) {
                String service = stringArray[n2];
                services.add(service);
                ++n2;
            }
            return services;
        }
        return null;
    }

    private String runSystemInfoCommand(String command) {
        return this.runSystemInfoCommand(command.split("\\s+"));
    }

    /*
     * Unable to fully structure code
     */
    private String runSystemInfoCommand(String[] commands) {
        block16: {
            block14: {
                block15: {
                    response = new StringBuffer();
                    proc = null;
                    br = null;
                    try {
                        try {
                            proc = ProcessUtil.exec(commands);
                            proc.waitFor();
                            br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                            line = null;
                            newLine = "";
                            while ((line = br.readLine()) != null) {
                                response.append(newLine);
                                response.append(line);
                                newLine = "\n";
                            }
                            break block14;
                        }
                        catch (Exception e) {
                            command = "";
                            delim = "";
                            i = 0;
                            ** while (i < commands.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            command = String.valueOf(command) + delim + commands[i];
                            delim = " ";
                            ++i;
                            continue;
                        }
lbl29:
                        // 1 sources

                        SystemServiceImpl.s_logger.error("failed to run commands " + command, (Throwable)e);
                        if (br == null || br == null) break block15;
                    }
                    catch (Throwable var9_11) {
                        if (br != null && br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException v0) {
                                SystemServiceImpl.s_logger.error("I/O Exception while closing BufferedReader!");
                            }
                        }
                        ProcessUtil.destroy(proc);
                        throw var9_11;
                    }
                    try {
                        br.close();
                    }
                    catch (IOException v1) {
                        SystemServiceImpl.s_logger.error("I/O Exception while closing BufferedReader!");
                    }
                }
                ProcessUtil.destroy(proc);
                break block16;
            }
            if (br != null && br != null) {
                try {
                    br.close();
                }
                catch (IOException v2) {
                    SystemServiceImpl.s_logger.error("I/O Exception while closing BufferedReader!");
                }
            }
            ProcessUtil.destroy(proc);
        }
        return response.toString();
    }

    private void createDirIfNotExists(String fileName) {
        File file = new File(fileName);
        if (!file.exists() && !file.mkdirs()) {
            s_logger.error("Failed to create the temporary configuration directory: " + fileName);
            System.exit(-1);
        }
    }
}

