/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.deployment.agent.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.eclipse.kura.deployment.agent.DeploymentAgentService;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentAgent
implements DeploymentAgentService {
    private static Logger s_logger = LoggerFactory.getLogger(DeploymentAgent.class);
    private static final String DPA_CONF_PATH_PROPNAME = "dpa.configuration";
    private static final String KURA_CONF_URL_PROPNAME = "kura.configuration";
    private static final String PACKAGES_PATH_PROPNAME = "kura.packages";
    private static final String CONN_TIMEOUT_PROPNAME = "dpa.connection.timeout";
    private static final String READ_TIMEOUT_PROPNAME = "dpa.read.timeout";
    private static final long THREAD_TERMINATION_TOUT = 1L;
    private static Future<?> s_installerTask;
    private static Future<?> s_uninstallerTask;
    private DeploymentAdmin m_deploymentAdmin;
    private EventAdmin m_eventAdmin;
    private Queue<String> m_instPackageUrls;
    private Queue<String> m_uninstPackageNames;
    private ExecutorService m_installerExecutor;
    private ExecutorService m_uninstallerExecutor;
    private String m_dpaConfPath;
    private String m_packagesPath;
    private Properties m_deployedPackages;
    private int m_connTimeout;
    private int m_readTimeout;

    protected void activate(ComponentContext componentContext) {
        File packagesDir;
        File dpaConfFile;
        String sReadTimeout;
        String sConnTimeout;
        this.m_deployedPackages = new Properties();
        this.m_dpaConfPath = System.getProperty(DPA_CONF_PATH_PROPNAME);
        if (this.m_dpaConfPath == null || this.m_dpaConfPath.isEmpty()) {
            throw new ComponentException("The value of 'dpa.configuration' is not defined");
        }
        String sKuraConfUrl = System.getProperty(KURA_CONF_URL_PROPNAME);
        if (sKuraConfUrl == null || sKuraConfUrl.isEmpty()) {
            throw new ComponentException("The value of 'kura.configuration' is not defined");
        }
        URL kuraUrl = null;
        try {
            kuraUrl = new URL(sKuraConfUrl);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ComponentException("Invalid Kura configuration URL");
        }
        Properties kuraProperties = new Properties();
        try {
            kuraProperties.load(kuraUrl.openStream());
        }
        catch (FileNotFoundException e) {
            throw new ComponentException("Kura configuration file not found", (Throwable)e);
        }
        catch (IOException e) {
            throw new ComponentException("Exception loading Kura configuration file", (Throwable)e);
        }
        this.m_packagesPath = kuraProperties.getProperty(PACKAGES_PATH_PROPNAME);
        if (this.m_packagesPath == null || this.m_packagesPath.isEmpty()) {
            throw new ComponentException("The value of 'kura.packages' is not defined");
        }
        if (kuraProperties.getProperty(PACKAGES_PATH_PROPNAME) != null && kuraProperties.getProperty(PACKAGES_PATH_PROPNAME).trim().equals("kura/packages")) {
            kuraProperties.setProperty(PACKAGES_PATH_PROPNAME, "/opt/eclipse/kura/kura/packages");
            this.m_packagesPath = kuraProperties.getProperty(PACKAGES_PATH_PROPNAME);
            s_logger.warn("Overridding invalid kura.packages location");
        }
        if ((sConnTimeout = kuraProperties.getProperty(CONN_TIMEOUT_PROPNAME)) != null) {
            this.m_connTimeout = Integer.valueOf(sConnTimeout);
        }
        if ((sReadTimeout = kuraProperties.getProperty(READ_TIMEOUT_PROPNAME)) != null) {
            this.m_readTimeout = Integer.valueOf(sReadTimeout);
        }
        if ((dpaConfFile = new File(this.m_dpaConfPath)).getParentFile() != null && !dpaConfFile.getParentFile().exists()) {
            dpaConfFile.getParentFile().mkdirs();
        }
        if (!dpaConfFile.exists()) {
            try {
                dpaConfFile.createNewFile();
            }
            catch (IOException e) {
                throw new ComponentException("Cannot create empty DPA configuration file", (Throwable)e);
            }
        }
        if (!(packagesDir = new File(this.m_packagesPath)).exists() && !packagesDir.mkdir()) {
            throw new ComponentException("Cannot create packages directory");
        }
        this.m_instPackageUrls = new ConcurrentLinkedQueue<String>();
        this.m_uninstPackageNames = new ConcurrentLinkedQueue<String>();
        this.m_installerExecutor = Executors.newSingleThreadExecutor();
        this.m_uninstallerExecutor = Executors.newSingleThreadExecutor();
        s_installerTask = this.m_installerExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("DeploymentAgent");
                DeploymentAgent.this.installer();
            }
        });
        s_uninstallerTask = this.m_uninstallerExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("DeploymentAgent:Uninstall");
                DeploymentAgent.this.uninstaller();
            }
        });
        this.installPackagesFromConfFile();
    }

    protected void deactivate(ComponentContext componentContext) {
        this.m_dpaConfPath = null;
        this.m_deployedPackages = null;
        if (s_installerTask != null && !s_installerTask.isDone()) {
            s_logger.debug("Cancelling DeploymentAgent task ...");
            s_installerTask.cancel(true);
            s_logger.info("DeploymentAgent task cancelled? = {}", (Object)s_installerTask.isDone());
            s_installerTask = null;
        }
        if (this.m_installerExecutor != null) {
            s_logger.debug("Terminating DeploymentAgent Thread ...");
            this.m_installerExecutor.shutdownNow();
            try {
                this.m_installerExecutor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                s_logger.warn("Interrupted", (Throwable)e);
            }
            s_logger.info("DeploymentAgent Thread terminated? - {}", (Object)this.m_installerExecutor.isTerminated());
            this.m_installerExecutor = null;
        }
        if (s_uninstallerTask != null && !s_uninstallerTask.isDone()) {
            s_logger.debug("Cancelling DeploymentAgent:Uninstall task ...");
            s_uninstallerTask.cancel(true);
            s_logger.info("DeploymentAgent:Uninstall task cancelled? = {}", (Object)s_uninstallerTask.isDone());
            s_uninstallerTask = null;
        }
        if (this.m_uninstallerExecutor != null) {
            s_logger.debug("Terminating DeploymentAgent:Uninstall Thread ...");
            this.m_uninstallerExecutor.shutdownNow();
            try {
                this.m_uninstallerExecutor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                s_logger.warn("Interrupted", (Throwable)e);
            }
            s_logger.info("DeploymentAgent:Uninstall Thread terminated? - {}", (Object)this.m_uninstallerExecutor.isTerminated());
            this.m_uninstallerExecutor = null;
        }
        this.m_uninstPackageNames = null;
        this.m_instPackageUrls = null;
    }

    public void setDeploymentAdmin(DeploymentAdmin deploymentAdmin) {
        this.m_deploymentAdmin = deploymentAdmin;
    }

    public void unsetDeploymentAdmin(DeploymentAdmin deploymentAdmin) {
        this.m_deploymentAdmin = null;
    }

    protected void setEventAdmin(EventAdmin eventAdmin) {
        this.m_eventAdmin = eventAdmin;
    }

    protected void unsetEventAdmin(EventAdmin eventAdmin) {
        this.m_eventAdmin = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installDeploymentPackageAsync(String url) throws Exception {
        if (this.m_instPackageUrls.contains(url)) {
            throw new Exception("Element already exists");
        }
        this.m_instPackageUrls.offer(url);
        Queue<String> queue = this.m_instPackageUrls;
        synchronized (queue) {
            this.m_instPackageUrls.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallDeploymentPackageAsync(String name) throws Exception {
        if (this.m_uninstPackageNames.contains(name)) {
            throw new Exception("Element already exists");
        }
        this.m_uninstPackageNames.offer(name);
        Queue<String> queue = this.m_uninstPackageNames;
        synchronized (queue) {
            this.m_uninstPackageNames.notifyAll();
        }
    }

    @Override
    public boolean isInstallingDeploymentPackage(String url) {
        return this.m_instPackageUrls.contains(url);
    }

    @Override
    public boolean isUninstallingDeploymentPackage(String name) {
        return this.m_uninstPackageNames.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void installer() {
        while (true) {
            try {
                try {
                    while (true) {
                        var1_1 = this.m_instPackageUrls;
                        synchronized (var1_1) {
                            this.m_instPackageUrls.wait();
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5, 11, 12] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                            if (true) ** GOTO lbl44
                        }
                        do {
                            if ((url = this.m_instPackageUrls.peek()) == null) continue;
                            DeploymentAgent.s_logger.info("About to install package at URL {}", (Object)url);
                            dp = null;
                            ex = null;
                            try {
                                try {
                                    dp = this.installDeploymentPackageInternal(url);
                                }
                                catch (Exception e) {
                                    ex = e;
                                    DeploymentAgent.s_logger.error("Exception installing package at URL {}", (Object)url, (Object)e);
                                    successful = dp != null;
                                    DeploymentAgent.s_logger.info("Posting INSTALLED event for package at URL {}: {}", (Object)url, (Object)(successful != false ? "successful" : "unsuccessful"));
                                    this.m_instPackageUrls.poll();
                                    this.postInstalledEvent(dp, url, successful, ex);
                                    continue;
                                }
                            }
                            catch (Throwable var5_7) {
                                successful = dp != null;
                                DeploymentAgent.s_logger.info("Posting INSTALLED event for package at URL {}: {}", (Object)url, (Object)(successful != false ? "successful" : "unsuccessful"));
                                this.m_instPackageUrls.poll();
                                this.postInstalledEvent(dp, url, successful, ex);
                                throw var5_7;
                            }
                            successful = dp != null;
                            DeploymentAgent.s_logger.info("Posting INSTALLED event for package at URL {}: {}", (Object)url, (Object)(successful != false ? "successful" : "unsuccessful"));
                            this.m_instPackageUrls.poll();
                            this.postInstalledEvent(dp, url, successful, ex);
lbl44:
                            // 4 sources

                        } while (!this.m_instPackageUrls.isEmpty());
                    }
                }
                catch (InterruptedException v1) {
                    DeploymentAgent.s_logger.info("Exiting...");
                    Thread.interrupted();
                    return;
                }
            }
            catch (Throwable t) {
                DeploymentAgent.s_logger.error("Unexpected throwable", t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void uninstaller() {
        while (true) {
            try {
                try {
                    while (true) {
                        var1_1 = this.m_uninstPackageNames;
                        synchronized (var1_1) {
                            this.m_uninstPackageNames.wait();
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5, 11, 12] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                            if (true) ** GOTO lbl50
                        }
                        do {
                            if ((name = this.m_uninstPackageNames.peek()) == null) continue;
                            DeploymentAgent.s_logger.info("About to uninstall package ", (Object)name);
                            dp = null;
                            successful = false;
                            ex = null;
                            try {
                                try {
                                    dp = this.m_deploymentAdmin.getDeploymentPackage(name);
                                    if (dp != null) {
                                        dp.uninstall();
                                        sUrl = this.m_deployedPackages.getProperty(name);
                                        dpFile = new File(new URL(sUrl).getPath());
                                        if (!dpFile.delete()) {
                                            DeploymentAgent.s_logger.warn("Cannot delete file at URL: {}", (Object)sUrl);
                                        }
                                        successful = true;
                                        this.removePackageFromConfFile(name);
                                    }
                                }
                                catch (Exception e) {
                                    ex = e;
                                    DeploymentAgent.s_logger.error("Exception uninstalling package {}", (Object)name, (Object)e);
                                    DeploymentAgent.s_logger.info("Posting UNINSTALLED event for package {}: {}", (Object)name, (Object)(successful != false ? "successful" : "unsuccessful"));
                                    this.m_uninstPackageNames.poll();
                                    this.postUninstalledEvent(name, successful, ex);
                                    continue;
                                }
                            }
                            catch (Throwable var7_9) {
                                DeploymentAgent.s_logger.info("Posting UNINSTALLED event for package {}: {}", (Object)name, (Object)(successful != false ? "successful" : "unsuccessful"));
                                this.m_uninstPackageNames.poll();
                                this.postUninstalledEvent(name, successful, ex);
                                throw var7_9;
                            }
                            DeploymentAgent.s_logger.info("Posting UNINSTALLED event for package {}: {}", (Object)name, (Object)(successful != false ? "successful" : "unsuccessful"));
                            this.m_uninstPackageNames.poll();
                            this.postUninstalledEvent(name, successful, ex);
lbl50:
                            // 4 sources

                        } while (!this.m_uninstPackageNames.isEmpty());
                    }
                }
                catch (InterruptedException v1) {
                    DeploymentAgent.s_logger.info("Exiting...");
                    Thread.interrupted();
                    return;
                }
            }
            catch (Throwable t) {
                DeploymentAgent.s_logger.error("Unexpected throwable", t);
                continue;
            }
            break;
        }
    }

    private void postInstalledEvent(DeploymentPackage dp, String url, boolean successful, Exception e) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (dp != null) {
            props.put("deploymentpackage.name", dp.getName());
            Version version = dp.getVersion();
            props.put("deploymentpackage.version", version.toString());
        } else {
            props.put("deploymentpackage.name", "UNKNOWN");
            props.put("deploymentpackage.version", "UNKNOWN");
        }
        props.put("deploymentpackage.url", url);
        props.put("successful", successful);
        props.put("exception", e);
        EventProperties eventProps = new EventProperties(props);
        this.m_eventAdmin.postEvent(new Event(EVENT_INSTALLED_TOPIC, (Map)eventProps));
    }

    private void postUninstalledEvent(String name, boolean successful, Exception e) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("deploymentpackage.name", name);
        props.put("successful", successful);
        props.put("exception", e);
        EventProperties eventProps = new EventProperties(props);
        this.m_eventAdmin.postEvent(new Event(EVENT_UNINSTALLED_TOPIC, (Map)eventProps));
    }

    private void installPackagesFromConfFile() {
        if (this.m_dpaConfPath != null) {
            try {
                this.m_deployedPackages.load(new FileReader(this.m_dpaConfPath));
            }
            catch (IOException e) {
                s_logger.error("Exception loading deployment packages configuration file", (Throwable)e);
            }
        }
        Set<Object> packageNames = this.m_deployedPackages.keySet();
        for (Object packageName : packageNames) {
            String packageUrl = (String)this.m_deployedPackages.get(packageName);
            s_logger.info("Deploying package name {} at URL {}", packageName, (Object)packageUrl);
            try {
                this.installDeploymentPackageAsync(packageUrl);
            }
            catch (Exception e) {
                s_logger.error("Error installing package {}", packageName, (Object)e);
            }
        }
    }

    private DeploymentPackage installDeploymentPackageInternal(String urlSpec) throws DeploymentException, IOException, URISyntaxException {
        URL url = new URL(urlSpec);
        String urlPath = url.getPath();
        String[] parts = urlPath.split("/");
        String dpBasename = parts[parts.length - 1];
        String dpPersistentFilePath = String.valueOf(this.m_packagesPath) + File.separator + dpBasename;
        File dpPersistentFile = new File(dpPersistentFilePath);
        DeploymentPackage dp = null;
        File dpFile = null;
        InputStream dpInputStream = null;
        BufferedReader br = null;
        try {
            try {
                if (!url.getProtocol().equals("file")) {
                    dpFile = File.createTempFile("dpa", null);
                    dpFile.deleteOnExit();
                    FileUtils.copyURLToFile((URL)url, (File)dpFile, (int)this.m_connTimeout, (int)this.m_readTimeout);
                } else {
                    dpFile = new File(url.getPath());
                }
                dpInputStream = new FileInputStream(dpFile);
                dp = this.m_deploymentAdmin.installDeploymentPackage(dpInputStream);
                if (!dpFile.getCanonicalPath().equals(dpPersistentFile.getCanonicalPath())) {
                    s_logger.info("dpFile.getCanonicalPath(): " + dpFile.getCanonicalPath());
                    s_logger.info("dpPersistentFile.getCanonicalPath(): " + dpPersistentFile.getCanonicalPath());
                    String line = null;
                    Process proc = Runtime.getRuntime().exec("pwd");
                    br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = br.readLine()) != null) {
                        s_logger.info("PWD: " + line);
                    }
                    FileUtils.copyFile((File)dpFile, (File)dpPersistentFile);
                    this.addPackageToConfFile(dp.getName(), "file:" + dpPersistentFilePath);
                }
            }
            catch (DeploymentException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    s_logger.error("I/O Exception while closing BufferedReader!");
                }
            }
            if (dpInputStream != null) {
                try {
                    dpInputStream.close();
                }
                catch (IOException e) {
                    s_logger.warn("Cannot close input stream", (Throwable)e);
                }
            }
            if (dpFile != null && !dpFile.getCanonicalPath().equals(dpPersistentFile.getCanonicalPath())) {
                dpFile.delete();
            }
            throw throwable;
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {
                s_logger.error("I/O Exception while closing BufferedReader!");
            }
        }
        if (dpInputStream != null) {
            try {
                dpInputStream.close();
            }
            catch (IOException e) {
                s_logger.warn("Cannot close input stream", (Throwable)e);
            }
        }
        if (dpFile != null && !dpFile.getCanonicalPath().equals(dpPersistentFile.getCanonicalPath())) {
            dpFile.delete();
        }
        return dp;
    }

    private void addPackageToConfFile(String packageName, String packageUrl) {
        this.m_deployedPackages.setProperty(packageName, packageUrl);
        if (this.m_dpaConfPath == null) {
            s_logger.warn("Configuration file not specified");
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.m_dpaConfPath);
            this.m_deployedPackages.store(fos, null);
            fos.flush();
            fos.getFD().sync();
            fos.close();
        }
        catch (IOException e) {
            s_logger.error("Error writing package configuration file", (Throwable)e);
        }
    }

    private void removePackageFromConfFile(String packageName) {
        this.m_deployedPackages.remove(packageName);
        if (this.m_dpaConfPath == null) {
            s_logger.warn("Configuration file not specified");
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.m_dpaConfPath);
            this.m_deployedPackages.store(fos, null);
            fos.flush();
            fos.getFD().sync();
            fos.close();
        }
        catch (IOException e) {
            s_logger.error("Error writing package configuration file", (Throwable)e);
        }
    }
}

