/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.SelfConfiguringComponent;
import org.eclipse.kura.core.configuration.ConfigurationServiceImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableComponentTracker
extends ServiceTracker {
    private static final Logger s_logger = LoggerFactory.getLogger(ConfigurableComponentTracker.class);
    private ConfigurationServiceImpl m_confService;

    public ConfigurableComponentTracker(BundleContext context, ConfigurationServiceImpl confService) throws InvalidSyntaxException {
        super(context, context.createFilter("(objectClass=*)"), null);
        this.m_confService = confService;
    }

    public void open(boolean trackAllServices) {
        block13: {
            s_logger.info("Opening ServiceTracker");
            super.open(trackAllServices);
            try {
                s_logger.info("Getting ServiceReferences");
                ServiceReference[] refs = this.context.getServiceReferences(null, null);
                if (refs == null) break block13;
                ServiceReference[] serviceReferenceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference ref = serviceReferenceArray[n2];
                    String pid = (String)ref.getProperty("component.name");
                    if (pid != null && !this.m_confService.hasConfigurableComponent(pid)) {
                        Object obj = this.context.getService(ref);
                        try {
                            if (obj == null) {
                                s_logger.info("Could not find service for: {}", (Object)ref);
                            } else if (obj instanceof ConfigurableComponent) {
                                s_logger.info("Adding ConfigurableComponent {}", (Object)pid);
                                this.m_confService.registerComponentConfiguration(ref.getBundle(), pid);
                            } else if (obj instanceof SelfConfiguringComponent) {
                                s_logger.info("Adding SelfConfiguringComponent {}", (Object)pid);
                                this.m_confService.registerSelfConfiguringComponent(pid);
                            }
                        }
                        finally {
                            this.context.ungetService(ref);
                        }
                    }
                    ++n2;
                }
            }
            catch (InvalidSyntaxException ise) {
                s_logger.error("Error in addingBundle", (Throwable)ise);
            }
            catch (KuraException e) {
                s_logger.error("Error in addingBundle", (Throwable)e);
            }
        }
    }

    public Object addingService(ServiceReference ref) {
        Object service = super.addingService(ref);
        String pid = (String)ref.getProperty("component.name");
        if (pid != null) {
            if (service instanceof ConfigurableComponent) {
                s_logger.info("Adding ConfigurableComponent {}", (Object)pid);
                try {
                    this.m_confService.registerComponentConfiguration(ref.getBundle(), pid);
                }
                catch (KuraException e) {
                    s_logger.info("Error adding ConfigurableComponent {} {}", (Object)pid, (Object)e);
                }
            } else if (service instanceof SelfConfiguringComponent) {
                s_logger.info("Adding SelfConfiguringComponent {}", (Object)pid);
                try {
                    this.m_confService.registerSelfConfiguringComponent(pid);
                }
                catch (KuraException e) {
                    s_logger.info("Error adding SelfConfiguringComponent {} {}", (Object)pid, (Object)e);
                }
            }
        }
        return service;
    }

    public void removedService(ServiceReference reference, Object service) {
        super.removedService(reference, service);
        String pid = (String)reference.getProperty("component.name");
        if (pid != null) {
            if (service instanceof ConfigurableComponent) {
                s_logger.info("Removed  ConfigurableComponent {}", (Object)pid);
                this.m_confService.unregisterComponentConfiguration(pid);
            } else if (service instanceof SelfConfiguringComponent) {
                s_logger.info("Removed  SelfConfiguringComponent {}", (Object)pid);
                this.m_confService.unregisterComponentConfiguration(pid);
            }
        }
    }
}

