/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.manager;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.AbstractGenerationEvent;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.listener.IGenerationListener;

public class GenerationEventManager {
    private static final GenerationEventManager instance_ = new GenerationEventManager();
    private List<IGenerationListener> _listeners = new ArrayList<IGenerationListener>();

    private GenerationEventManager() {
    }

    public static GenerationEventManager getInstance() {
        return instance_;
    }

    public synchronized void addGenerationListener(IGenerationListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public synchronized void removeGenerationListener(IGenerationListener listener) {
        if (this._listeners.contains(listener)) {
            this._listeners.remove(listener);
        }
    }

    public synchronized void removeAllGenerationListener() {
        this._listeners.clear();
    }

    public synchronized void notifyGenerationListener(AbstractGenerationEvent event) {
        for (IGenerationListener listener : this._listeners) {
            switch (event.getKind()) {
                case BEGIN: {
                    listener.generationBegin(event);
                    break;
                }
                case END: {
                    listener.generationEnd(event);
                }
            }
        }
    }
}

