/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.edit.command;

import java.util.Collection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.command.EditSelectionCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.EditSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.massactions.core.data.accessor.IMAColumnPropertyAccessor;

public class MEEditSelectionCommandHandler
extends EditSelectionCommandHandler {
    private IMAColumnPropertyAccessor columnPropertyAccessor;
    private SelectionLayer selectionLayer;

    public MEEditSelectionCommandHandler(SelectionLayer selectionLayer, IMAColumnPropertyAccessor columnPropertyAccessor) {
        super(selectionLayer);
        this.columnPropertyAccessor = columnPropertyAccessor;
        this.selectionLayer = selectionLayer;
    }

    public boolean doCommand(EditSelectionCommand command) {
        boolean performed;
        Shell shell;
        Collection selectedCells = EditUtils.getSelectedCellsForEditing((SelectionLayer)this.selectionLayer);
        Shell shell2 = shell = command.getParent() != null ? command.getParent().getShell() : null;
        if (!EditUtils.allCellsEditable((Collection)selectedCells, (IConfigRegistry)command.getConfigRegistry())) {
            MessageDialog.openWarning((Shell)shell, (String)"Edit", (String)(selectedCells.size() > 1 ? "Selected cells are not editable." : "Selected cell is not editable."));
            return true;
        }
        if (selectedCells.size() != 1) {
            if (!EditUtils.isEditorSame((Collection)selectedCells, (IConfigRegistry)command.getConfigRegistry()) || !EditUtils.isConverterSame((Collection)selectedCells, (IConfigRegistry)command.getConfigRegistry())) {
                MessageDialog.openWarning((Shell)shell, (String)"Edit", (String)"Selected cells don't have the same type.");
                return true;
            }
            try {
                this.columnPropertyAccessor.beforeEditSelectionCommand();
                performed = super.doCommand(command);
                this.columnPropertyAccessor.afterEditSelectionCommand();
            }
            finally {
                this.columnPropertyAccessor.cleanResources();
            }
        } else {
            performed = super.doCommand(command);
        }
        return performed;
    }
}

