/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.registry.ModelBasedReader;
import org.polarsys.kitalpha.resourcereuse.registry.ModelBasedRegistry;
import org.polarsys.kitalpha.resourcereuse.registry.ResourceRegistry;

public class TargetPlatformReader
extends ModelBasedReader {
    private List<String> clearedBundles = new ArrayList<String>();

    @Override
    protected IPluginModelBase[] getModels() {
        return new IPluginModelBase[0];
    }

    @Override
    public ResourceRegistry readResources(ResourceRegistry parent) {
        String bundleName;
        IConfigurationElement confElement;
        this.registry = new ModelBasedRegistry(parent, this);
        this.clearedBundles.clear();
        IExtensionRegistry extensionRegistry = RegistryFactory.getRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor("org.polarsys.kitalpha.resourcereuse.concerns");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            confElement = iConfigurationElementArray[n2];
            bundleName = this.getBundleName(confElement);
            String concernName = confElement.getAttribute("name");
            String user = confElement.getAttribute("userResourceId");
            String used = confElement.getAttribute("usedResourceId");
            if (!this.clearedBundles.contains(bundleName)) {
                this.registry.clear(bundleName);
                this.clearedBundles.add(bundleName);
            }
            this.registry.addConcern(bundleName, concernName, user, used);
            ++n2;
        }
        iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor("org.polarsys.kitalpha.resourcereuse.resources");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            confElement = iConfigurationElementArray[n2];
            bundleName = this.getBundleName(confElement);
            Resource res = this.createResource(confElement);
            if (!this.clearedBundles.contains(bundleName)) {
                this.registry.clear(bundleName);
                this.clearedBundles.add(bundleName);
            }
            this.registry.addResource(bundleName, res);
            ++n2;
        }
        this.clearedBundles.clear();
        return this.registry;
    }

    private String getBundleName(IConfigurationElement confElement) {
        IExtension declaringExtension = confElement.getDeclaringExtension();
        IContributor contributor = declaringExtension.getContributor();
        String bundleName = contributor instanceof RegistryContributor ? ((RegistryContributor)contributor).getActualName() : contributor.getName();
        return bundleName;
    }

    private Resource createResource(IConfigurationElement confElement) {
        String tags;
        String metadata;
        String path;
        String version;
        String description;
        String domain;
        String weight;
        String name;
        Resource res = new Resource();
        String symbolicName = this.getBundleName(confElement);
        res.setProviderSymbolicName(symbolicName);
        res.setProviderLocation(this.getLocation());
        String id = confElement.getAttribute("id");
        if (id != null) {
            res.setId(id);
        }
        if ((name = confElement.getAttribute("name")) != null) {
            res.setName(name.trim());
        }
        if ((weight = confElement.getAttribute("weight")) != null) {
            res.setWeight(Integer.parseInt(weight));
        }
        if ((domain = confElement.getAttribute("domain")) != null) {
            res.setDomain(domain.trim());
        }
        if ((description = confElement.getAttribute("description")) != null) {
            res.setDescription(description.trim());
        }
        if ((version = confElement.getAttribute("version")) != null) {
            res.setVersion(version.trim());
        }
        if ((path = confElement.getAttribute("path")) != null) {
            res.setPath(path.trim());
        }
        if ((metadata = confElement.getAttribute("metadata")) != null) {
            res.setMetadataPath(metadata.trim());
        }
        if ((tags = confElement.getAttribute("tags")) != null) {
            String[] stringArray = tags.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                res.getTags().add(tag.trim());
                ++n2;
            }
        }
        return res;
    }

    @Override
    protected Location getLocation() {
        return Location.TARGET;
    }
}

