/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.column;

import java.util.Comparator;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.polarsys.kitalpha.massactions.core.column.IMAColumn;
import org.polarsys.kitalpha.massactions.core.data.error.CustomDialogErrorHandling;
import org.polarsys.kitalpha.massactions.core.editor.AbstractMACellEditor;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;

public abstract class AbstractMAColumn
implements IMAColumn {
    private static final String SORT_LABEL_PREFIX = "SORT_LABEL_PREFIX_";
    protected String name;
    protected String label;
    protected String sortLabel;
    protected String id;
    protected int index;
    protected boolean editable = true;
    protected IMABodyLayer bodyLayer;

    protected ICellEditor createCellEditor() {
        return null;
    }

    protected IDataValidator createDataValidator() {
        return null;
    }

    protected IDisplayConverter createDisplayConverter() {
        return null;
    }

    protected ICellPainter createCellPainter() {
        return null;
    }

    protected Comparator<Object> createCellComparator() {
        return null;
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        Comparator<Object> cellComparator;
        ICellPainter cellPainter;
        IDisplayConverter displayConverter;
        if (this.editable) {
            IDataValidator dataValidator;
            configRegistry.registerConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_HANDLER, (Object)new CustomDialogErrorHandling(), DisplayMode.EDIT, this.label);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, DisplayMode.EDIT, this.label);
            ICellEditor cellEditor = this.createCellEditor();
            if (cellEditor != null) {
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)cellEditor, DisplayMode.EDIT, this.label);
                if (cellEditor instanceof AbstractMACellEditor) {
                    AbstractMACellEditor meCellEditor = (AbstractMACellEditor)cellEditor;
                    boolean openInDialog = meCellEditor.isOpenInDialog();
                    configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_IN_DIALOG, (Object)openInDialog, DisplayMode.EDIT, this.label);
                }
            }
            if ((dataValidator = this.createDataValidator()) != null) {
                configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)dataValidator, DisplayMode.EDIT, this.label);
            }
        }
        if ((displayConverter = this.createDisplayConverter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)displayConverter, DisplayMode.NORMAL, this.label);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)displayConverter, DisplayMode.EDIT, this.label);
        }
        if ((cellPainter = this.createCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)cellPainter, DisplayMode.NORMAL, this.label);
        }
        if ((cellComparator = this.createCellComparator()) != null) {
            configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, cellComparator, DisplayMode.NORMAL, this.sortLabel);
        }
    }

    @Override
    public void destroyRegistry(IConfigRegistry configRegistry) {
        configRegistry.unregisterConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_HANDLER, DisplayMode.EDIT, this.label);
        configRegistry.unregisterConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, DisplayMode.EDIT, this.label);
        configRegistry.unregisterConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, DisplayMode.NORMAL, this.label);
        configRegistry.unregisterConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, DisplayMode.EDIT, this.label);
        configRegistry.unregisterConfigAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.EDIT, this.label);
        configRegistry.unregisterConfigAttribute(EditConfigAttributes.OPEN_IN_DIALOG, DisplayMode.EDIT, this.label);
        configRegistry.unregisterConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, DisplayMode.EDIT, this.label);
        configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, this.label);
        configRegistry.unregisterConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, DisplayMode.NORMAL, this.label);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
        this.label = "COLUMN_" + index;
        this.sortLabel = SORT_LABEL_PREFIX + this.label;
        if (this.name == null) {
            this.name = this.label;
            this.id = this.label;
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getSortLabel() {
        return this.sortLabel;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.id = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setBodyLayer(IMABodyLayer bodyLayer) {
        this.bodyLayer = bodyLayer;
    }
}

