/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.task;

import java.security.InvalidParameterException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.Activator;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.message.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.PDEUtility;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.task.AbstractPdeHelperTask;

public class UpdateBuildPropertiesTask
extends AbstractPdeHelperTask {
    @Override
    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        IProject project;
        Boolean silent;
        String pluginID = (String)productionContext.getInputValue((Object)"plugin.id", String.class);
        if (pluginID == null || pluginID.trim().length() < 1) {
            throw new InvalidParameterException(Messages.bind((String)Messages.Pde_Helper__Contract_Value_Required, (Object)"plugin.id"));
        }
        String entryName = (String)productionContext.getInputValue((Object)"entry.name", String.class);
        if (entryName == null || entryName.trim().length() < 1) {
            throw new InvalidParameterException(Messages.bind((String)Messages.Pde_Helper__Contract_Value_Required, (Object)"entry.name"));
        }
        Boolean isFolder = (Boolean)productionContext.getInputValue((Object)"is.folder", Boolean.class);
        if (isFolder == null) {
            isFolder = false;
        }
        if ((silent = (Boolean)productionContext.getInputValue((Object)"silent", Boolean.class)) == null) {
            silent = true;
        }
        if ((project = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginID)).exists()) {
            boolean doUpdate = false;
            if (isFolder.booleanValue()) {
                IFolder folder = project.getFolder(entryName);
                doUpdate = folder.exists();
            } else {
                IFile file = project.getFile(entryName);
                doUpdate = file.exists();
            }
            if (doUpdate) {
                PDEUtility.updateBuild_BinInclude(project, entryName, isFolder, monitor);
            } else if (!silent.booleanValue()) {
                Object[] binding = new Object[]{entryName, pluginID};
                String errorMessage = Messages.bind((String)Messages.Pde_Helper__Update_Bin, (Object[])binding);
                Status status = new Status(4, "org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper", errorMessage);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
    }
}

