/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.services.cs.text.generators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.ArchitectureFramework;
import org.polarsys.kitalpha.ad.af.dsl.services.cs.text.generators.messages.Messages;
import org.polarsys.kitalpha.ad.af.dsl.services.cs.text.generators.util.AfdslGeneratorsUtil;

public class BackwardSynchronizer {
    private static final String AFTEXT_EXTENSION = "aftext";
    private Resource afdescResource;
    private XtextResource aftextResource;

    public void backwardSynchronize(IFile file) {
        IPath emfResourcePath = file.getFullPath();
        URI emfUri = AfdslGeneratorsUtil.URIFix.createPlatformResourceURI(emfResourcePath.toString(), true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.afdescResource = resourceSet.getResource(emfUri, true);
        ArchitectureFramework modelRoot = (ArchitectureFramework)this.afdescResource.getContents().get(0);
        if (modelRoot != null) {
            EcoreUtil.resolveAll((EObject)modelRoot);
            IPath xtextResourcePath = file.getFullPath().removeFileExtension().addFileExtension(AFTEXT_EXTENSION);
            URI xtextUri = AfdslGeneratorsUtil.URIFix.createPlatformResourceURI(xtextResourcePath.toString(), true);
            this.aftextResource = (XtextResource)resourceSet.createResource(xtextUri);
            this.initializeAftextResource((EObject)modelRoot);
        }
        resourceSet.eSetDeliver(false);
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
    }

    private void initializeAftextResource(EObject rootObject) {
        EcoreUtil.resolveAll((EObject)rootObject);
        EObject clone = EcoreUtil.copy((EObject)rootObject);
        if (this.validateObject(clone)) {
            this.aftextResource.getContents().add((Object)clone);
            String serializationContent = this.aftextResource.getSerializer().serialize(clone);
            String newContent = String.valueOf(BackwardSynchronizer.getHeaderComment(rootObject)) + serializationContent;
            try {
                HashMap<String, String> saveOptions = new HashMap<String, String>();
                saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
                this.aftextResource.reparse(newContent);
                this.aftextResource.save(saveOptions);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            MessageDialog.openInformation(null, (String)"Aftext Backward Synchronizer", (String)Messages.AFDSLActions_BackwardSynchronizer_SerializationException);
        }
    }

    private boolean validateObject(EObject object) {
        ArrayList diagnostics = new ArrayList();
        IConcreteSyntaxValidator concreteSyntaxValidator = this.aftextResource.getConcreteSyntaxValidator();
        concreteSyntaxValidator.validateRecursive(object, (IConcreteSyntaxValidator.IDiagnosticAcceptor)new IConcreteSyntaxValidator.DiagnosticListAcceptor(diagnostics), new HashMap());
        return diagnostics.isEmpty();
    }

    public static String getCurrentYear() {
        return String.valueOf(Calendar.getInstance().get(1));
    }

    private static String getHeaderComment(EObject root) {
        String fileHeader = null;
        if (root instanceof ArchitectureFramework) {
            ArchitectureFramework afRoot = (ArchitectureFramework)root;
            fileHeader = "/**\n * Copyright (c) PolarSys, " + BackwardSynchronizer.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tArchitecture Framework " + afRoot.getShortName() + "\n" + " *\t@author: " + AfdslGeneratorsUtil.getCurrentUserName() + "\n" + " *\t@date: " + AfdslGeneratorsUtil.getCurrentDate() + "\n" + " *\n" + " */\n";
        }
        return fileHeader;
    }
}

