/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.launcher.precondition;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.domain.Activator;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.adapter.TaskProductionAdapter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.launcher.precondition.ViewpointGenerationPreconditionManager;

public class GenerationPreconditionTask
extends TaskProductionAdapter {
    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        super.doExecute(productionContext, monitor);
        EMFDomain domain = (EMFDomain)productionContext.getInputValue((Object)"vpdesc.model", EMFDomain.class);
        if (domain != null && domain.isLoaded()) {
            Viewpoint viewpoint = null;
            EList content = domain.getContent();
            if (!content.isEmpty()) {
                viewpoint = (Viewpoint)content.get(0);
            }
            if (viewpoint != null) {
                try {
                    boolean stopsGeneration = false;
                    List<IStatus> statuses = ViewpointGenerationPreconditionManager.checkPreconditions(viewpoint);
                    for (IStatus iStatus : statuses) {
                        Activator.getDefault().getLog().log(iStatus);
                        if (stopsGeneration || iStatus.getSeverity() != 4) continue;
                        stopsGeneration = true;
                    }
                    if (stopsGeneration) {
                        throw new InvocationException("Viewpoint generation aborted");
                    }
                }
                catch (CoreException e) {
                    throw new InvocationException((Throwable)e);
                }
            }
        }
    }
}

