/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.extension.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.extension.constant.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.extension.data.LauncherExtension;

public class ExtensionSelectionMainPage
extends WizardPage {
    private List<LauncherExtension> availableExtensions_;
    private Table availableExtensionsTable_;
    private Text extensionsDescriptionText_;
    private Button selectlAllButton_;

    protected ExtensionSelectionMainPage(List<LauncherExtension> availableExtensions) {
        super(Messages.ExtensionSelection_MainPage_Name, Messages.ExtensionSelection_MainPage_Title, null);
        this.availableExtensions_ = availableExtensions;
    }

    public void createControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 66048);
        sashForm.setVisible(true);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.createTopCompositeControls((Composite)sashForm);
        this.setControl((Control)sashForm);
    }

    private void createTopCompositeControls(Composite parent) {
        if (this.availableExtensions_.size() > 0) {
            this.createExtensionTable(parent);
            this.populateExtensionsInTabe();
            this.createDescriptionWidgets(parent);
        } else {
            this.cerateNoExtentionComposite(parent);
        }
    }

    private void cerateNoExtentionComposite(Composite parent) {
        Composite noExtensionComposite = new Composite(parent, 0);
        noExtensionComposite.setLayoutData((Object)new GridData(1808));
        GridLayout noExtensionGL = new GridLayout();
        noExtensionComposite.setLayout((Layout)noExtensionGL);
        Label label = new Label(noExtensionComposite, 0);
        label.setText("No extensions are available");
        label.setAlignment(0x1000000);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
    }

    private Composite createExtensionTable(Composite parent) {
        Composite extensionListComposite = new Composite(parent, 0);
        extensionListComposite.setLayoutData((Object)new GridData(1808));
        GridLayout extensionListGL = new GridLayout();
        extensionListComposite.setLayout((Layout)extensionListGL);
        Label availableExtensionsLabel = new Label(extensionListComposite, 0);
        availableExtensionsLabel.setText(Messages.ExtensionSelection_MainPage_Label_Available);
        availableExtensionsLabel.setLayoutData((Object)new GridData(768));
        availableExtensionsLabel.setEnabled(true);
        this.availableExtensionsTable_ = new Table(extensionListComposite, 68128);
        this.availableExtensionsTable_.setLinesVisible(true);
        this.availableExtensionsTable_.setHeaderVisible(true);
        this.availableExtensionsTable_.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.availableExtensionsTable_.setEnabled(true);
        this.availableExtensionsTable_.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Widget widget;
                TableItem selection;
                Object object;
                if (ExtensionSelectionMainPage.this.availableExtensionsTable_.getSelectionCount() > 0 && (object = (selection = ExtensionSelectionMainPage.this.availableExtensionsTable_.getSelection()[0]).getData()) != null) {
                    LauncherExtension launcherExtension = (LauncherExtension)object;
                    String desc = launcherExtension.extensionDescriptionAttributeValue;
                    if (desc != null && ExtensionSelectionMainPage.this.extensionsDescriptionText_ != null) {
                        ExtensionSelectionMainPage.this.extensionsDescriptionText_.setText(desc);
                    }
                }
                if (e.detail == 32 && (widget = e.item) instanceof TableItem) {
                    TableItem tableItem = (TableItem)widget;
                    ExtensionSelectionMainPage.this.availableExtensionsTable_.setSelection(tableItem);
                    ExtensionSelectionMainPage.this.synchronizeTableItemWithExtension(tableItem);
                }
            }
        });
        this.selectlAllButton_ = new Button(extensionListComposite, 32);
        this.selectlAllButton_.setText("Unselect all");
        this.selectlAllButton_.setLayoutData((Object)new GridData(768));
        this.selectlAllButton_.setSelection(true);
        this.selectlAllButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean checkState = ExtensionSelectionMainPage.this.selectlAllButton_.getSelection();
                ExtensionSelectionMainPage.this.changeExtensionState(checkState);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return extensionListComposite;
    }

    private void changeExtensionState(boolean state) {
        TableItem[] tableItems;
        if (this.selectlAllButton_.getSelection()) {
            this.selectlAllButton_.setText("Unselect all");
        } else {
            this.selectlAllButton_.setText("Select all");
        }
        TableItem[] tableItemArray = tableItems = this.availableExtensionsTable_.getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            tableItem.setChecked(state);
            this.synchronizeTableItemWithExtension(tableItem);
            ++n2;
        }
    }

    private void synchronizeTableItemWithExtension(TableItem tableItem) {
        Object data = tableItem.getData();
        if (data != null) {
            LauncherExtension launcherExtension = (LauncherExtension)data;
            for (LauncherExtension iLauncherExtension : this.availableExtensions_) {
                if (!iLauncherExtension.equals(launcherExtension) || iLauncherExtension.isActive() == tableItem.getChecked()) continue;
                iLauncherExtension.setActive(tableItem.getChecked());
                break;
            }
        }
    }

    private void populateExtensionsInTabe() {
        boolean generateCategoryColumn = false;
        for (LauncherExtension iLauncherExtension : this.availableExtensions_) {
            if (iLauncherExtension.extensionCategoryAttributeValue.trim().length() <= 0) continue;
            generateCategoryColumn = true;
            break;
        }
        String[] titles = new String[]{Messages.ExtensionSelection_MainPage_Column1, Messages.ExtensionSelection_MainPage_Column2, Messages.ExtensionSelection_MainPage_Column3};
        int columncount = generateCategoryColumn ? 3 : 2;
        int i = 0;
        while (i < columncount) {
            TableColumn column = new TableColumn(this.availableExtensionsTable_, 0, i);
            column.setText(titles[i]);
            column.setMoveable(i != 0);
            column.setWidth(i == 0 ? 20 : (i == 1 ? 190 : 140));
            ++i;
        }
        for (LauncherExtension taguableExtension : this.availableExtensions_) {
            this.addOneExtensionInTable(taguableExtension);
        }
    }

    private void addOneExtensionInTable(LauncherExtension extension) {
        TableItem item = new TableItem(this.availableExtensionsTable_, 0);
        item.setData((Object)extension);
        item.setText(1, extension.extensionNameAttributeValue);
        item.setText(2, extension.extensionCategoryAttributeValue);
        item.setChecked(true);
    }

    private void createDescriptionWidgets(Composite parent) {
        boolean createWidgets = false;
        for (LauncherExtension iLauncherExtension : this.availableExtensions_) {
            if (iLauncherExtension.extensionDescriptionAttributeValue.trim().length() <= 0) continue;
            createWidgets = true;
            break;
        }
        if (createWidgets) {
            Composite descriptionComposite = new Composite(parent, 0);
            descriptionComposite.setLayoutData((Object)new GridData(1808));
            GridLayout extensionListGL = new GridLayout();
            descriptionComposite.setLayout((Layout)extensionListGL);
            Label extensionsDescriptionLabel = new Label(descriptionComposite, 0);
            extensionsDescriptionLabel.setText(Messages.ExtensionSelection_MainPage_Label_Description);
            extensionsDescriptionLabel.setLayoutData((Object)new GridData(768));
            extensionsDescriptionLabel.setEnabled(true);
            this.extensionsDescriptionText_ = new Text(descriptionComposite, 2626);
            this.extensionsDescriptionText_.setEditable(false);
            GridData gd = new GridData(1808);
            this.extensionsDescriptionText_.setLayoutData((Object)gd);
            this.extensionsDescriptionText_.setEnabled(true);
        }
    }

    public List<LauncherExtension> getAvailableExtensions() {
        if (this.availableExtensions_ != null) {
            return this.availableExtensions_;
        }
        return new ArrayList<LauncherExtension>();
    }
}

