/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.explorer.contextual.category;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.explorer.contextual.category.ContextualExplorerCategories;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.explorer.contextual.category.ContextualExplorerCategoriesException;

public class ContextualExplorerCategoriesHelper {
    public static String getCategoryID(ContextualExplorerCategories category, Class vpClass, String projectName) throws ContextualExplorerCategoriesException {
        Assert.isNotNull((Object)vpClass, (String)"Viewpoint Class must be not null");
        Assert.isNotNull((Object)((Object)category), (String)"Category must be not null");
        return String.valueOf(projectName) + ".queries." + vpClass.getName() + "." + category.getCategoryIdentifier();
    }

    public boolean canGenerateCategoryFor(Class vpClass, ContextualExplorerCategories category) {
        boolean result = false;
        return result;
    }

    public static String getQueryJavaClassFQN(ContextualExplorerCategories category, Class vpClass, String projectName) throws ContextualExplorerCategoriesException {
        Assert.isNotNull((Object)vpClass, (String)"Viewpoint Class must be not null");
        Assert.isNotNull((Object)((Object)category), (String)"Category must be not null");
        String queryJavaClassFQN = String.valueOf(projectName.toLowerCase()) + ".queries." + vpClass.getName().toLowerCase() + ".";
        String queryJavaClassName = ContextualExplorerCategoriesHelper.getQueryJavaClassName(category);
        if (queryJavaClassName.length() > 0) {
            queryJavaClassFQN = String.valueOf(queryJavaClassFQN) + queryJavaClassName;
        }
        if (ContextualExplorerCategoriesHelper.javaClassFileExist(queryJavaClassFQN, projectName)) {
            return queryJavaClassFQN;
        }
        throw new ContextualExplorerCategoriesException();
    }

    private static String getQueryJavaClassName(ContextualExplorerCategories category) {
        String result = "";
        switch (category) {
            case Parent: {
                result = "ParentQuery";
                break;
            }
            case OwnedExternalElement: {
                result = "OwnedExternalElementQuery";
                break;
            }
            case OwnedViewpointElement: {
                result = "OwnedViewpointElementQuery";
                break;
            }
            case ReferencedViewpointElement: {
                result = "ReferencedViewpointElementQuery";
                break;
            }
            case ReferencedExternalElement: {
                result = "ReferencedExternalElementQuery";
                break;
            }
            case ReferencingViewpointElement: {
                result = "ReferencingViewpointElementQuery";
            }
        }
        return result;
    }

    private static boolean javaClassFileExist(String javaClassFQN, String projectName) throws ContextualExplorerCategoriesException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            throw new ContextualExplorerCategoriesException();
        }
        IFolder src_folder = project.getFolder("src");
        if (!src_folder.exists()) {
            throw new ContextualExplorerCategoriesException();
        }
        IFolder currentParentFolder = src_folder;
        String[] FQNSegments = javaClassFQN.split("\\.");
        int i = 0;
        while (i < FQNSegments.length - 1) {
            String segment = FQNSegments[i].toLowerCase();
            IFolder subFolder = currentParentFolder.getFolder(segment);
            if (!subFolder.exists()) {
                throw new ContextualExplorerCategoriesException();
            }
            currentParentFolder = subFolder;
            ++i;
        }
        String fileName = String.valueOf(FQNSegments[FQNSegments.length - 1]) + ".java";
        IFile queryJavaClass = currentParentFolder.getFile(fileName);
        if (!queryJavaClass.exists()) {
            throw new ContextualExplorerCategoriesException();
        }
        return true;
    }
}

