/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius;

import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.IExpressionFormat;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.OCLExpressionNotSupported;

public enum ExpressionKind implements IExpressionFormat
{
    QueryLegacy,
    Acceleo_3_x,
    Ocl;


    @Override
    public String format(String expression) {
        if (this.isFormated(expression)) {
            return expression;
        }
        switch (this) {
            case QueryLegacy: {
                return this.getExpression_QueryLegacy(expression);
            }
            case Acceleo_3_x: {
                return this.getExpression_Acceleo_3(expression);
            }
            case Ocl: {
                return this.getExpression_Ocl(expression);
            }
        }
        throw new RuntimeException("Expression kind not supported");
    }

    public String getConcatenationCharacter() {
        switch (this) {
            case QueryLegacy: {
                return "";
            }
            case Acceleo_3_x: {
                return "+";
            }
            case Ocl: {
                throw new OCLExpressionNotSupported();
            }
        }
        throw new RuntimeException("Expression kind not supported");
    }

    @Override
    public boolean isFormated(String expression) {
        switch (this) {
            case QueryLegacy: {
                return this.containsDelimiters(expression, 2, 2);
            }
            case Acceleo_3_x: {
                return this.containsDelimiters(expression, 1, 2);
            }
            case Ocl: {
                return this.containsDelimiters(expression, 4, -1);
            }
        }
        return false;
    }

    public String toString() {
        switch (this) {
            case QueryLegacy: {
                return "QueryLegacy";
            }
            case Acceleo_3_x: {
                return "Acceleo3";
            }
            case Ocl: {
                return "Ocl";
            }
        }
        throw new RuntimeException();
    }

    public static ExpressionKind getExpressionKind(String expressionKind) {
        if (expressionKind.equals(QueryLegacy.toString())) {
            return QueryLegacy;
        }
        if (expressionKind.equals(Acceleo_3_x.toString())) {
            return Acceleo_3_x;
        }
        if (expressionKind.equals(Ocl.toString())) {
            return Ocl;
        }
        throw new RuntimeException();
    }

    private String getExpression_QueryLegacy(String expression) {
        if (expression.contains("<%") && expression.contains("%>")) {
            return expression;
        }
        return "<%" + expression + "%>";
    }

    private String getExpression_Acceleo_3(String expression) {
        return "[" + expression + "/]";
    }

    private String getExpression_Ocl(String expression) {
        throw new OCLExpressionNotSupported();
    }

    private boolean containsDelimiters(String expression, int beginPrefixLenght, int endPrefixLenght) {
        boolean result = false;
        boolean checkExpressionEnd = false;
        if (expression == null || expression != null && expression.length() < beginPrefixLenght) {
            return false;
        }
        String beginDelimiter = expression.substring(0, beginPrefixLenght);
        switch (this) {
            case QueryLegacy: {
                result = beginDelimiter.equals("<%");
                checkExpressionEnd = true;
                break;
            }
            case Acceleo_3_x: {
                result = beginDelimiter.equals("[");
                checkExpressionEnd = true;
                break;
            }
            case Ocl: {
                result = beginDelimiter.equals("ocl:");
            }
        }
        if (checkExpressionEnd && endPrefixLenght > 0) {
            String endDelimiter = expression.substring(0, beginPrefixLenght);
            switch (this) {
                case QueryLegacy: {
                    result &= endDelimiter.equals("%>");
                    break;
                }
                case Acceleo_3_x: {
                    result &= endDelimiter.equals("/]");
                    break;
                }
                case Ocl: {
                    result &= true;
                }
            }
        }
        return result;
    }
}

