/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.detachment.ui.action;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.IProgressService;
import org.polarsys.kitalpha.model.common.precondition.exception.InvalidPreconditionException;
import org.polarsys.kitalpha.model.common.precondition.runner.PreconditionRunner;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.Scrutineer;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;
import org.polarsys.kitalpha.model.detachment.ui.editor.DetachmentEditorInput;
import org.polarsys.kitalpha.model.detachment.ui.editor.ModelDetachmentEditor;
import org.polarsys.kitalpha.model.detachment.ui.internal.DetachmentResourceProviderUtil;

public class DetachmentActionHandler
extends AbstractHandler {
    private final Logger LOGGER = Logger.getLogger(DetachmentActionHandler.class);
    private final IProgressService pMonitorService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getWorkbench().getProgressService();
    private final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    private IFile airdIResource;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
        Object firstElement = structuredSelection.getFirstElement();
        this.airdIResource = (IFile)firstElement;
        try {
            this.pMonitorService.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        DetachmentActionHandler.this.exec_preconditions();
                        monitor.beginTask("Analyzing of resource: " + DetachmentActionHandler.this.airdIResource.getProjectRelativePath(), 2);
                        monitor.subTask("Loading : " + DetachmentActionHandler.this.airdIResource.getProjectRelativePath());
                        Resource resource = DetachmentResourceProviderUtil.getResource(DetachmentActionHandler.this.airdIResource);
                        monitor.worked(1);
                        monitor.subTask("Scrutinizing : " + resource.getURI());
                        ModelScrutinyRegistry analysis = Scrutineer.startScrutiny((Resource)resource);
                        monitor.worked(1);
                        monitor.done();
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        DetachmentEditorInput detachmentInput = new DetachmentEditorInput(analysis);
                        IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)detachmentInput, (String)"org.polarsys.kitalpha.model.detachment.ui.editor");
                        if (editor != null && editor instanceof ModelDetachmentEditor) {
                            ModelDetachmentEditor modelDetachmentEditor = (ModelDetachmentEditor)editor;
                            modelDetachmentEditor.initAndLaunchDetachmentAction(resource);
                        }
                    }
                    catch (PartInitException e) {
                        DetachmentActionHandler.this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (InvalidPreconditionException e) {
                        this.handlePreconditionError(e);
                    }
                }

                private void handlePreconditionError(InvalidPreconditionException e) {
                    final String msg = e.getMessage();
                    DetachmentActionHandler.this.LOGGER.error((Object)e.getMessage());
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Status status = new Status(4, "org.polarsys.kitalpha.model.detachment.ui", msg, null);
                            ErrorDialog.openError((Shell)DetachmentActionHandler.this.shell, (String)"Detachment Error", (String)"Cannot perform Detach on your model. See the reasons below", (IStatus)status);
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void exec_preconditions() throws InvalidPreconditionException {
        PreconditionRunner preconditionRunner = new PreconditionRunner();
        preconditionRunner.run((Object)this.airdIResource, (IProgressMonitor)new NullProgressMonitor());
    }
}

