/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.report.registry;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.polarsys.kitalpha.report.model.ReportElementFactory;
import org.polarsys.kitalpha.report.model.ReportElementPackage;
import org.polarsys.kitalpha.report.model.ReportList;
import org.polarsys.kitalpha.report.model.Severity;

public class ReportRegistry {
    protected static final Map<String, ReportList> id2list = new HashMap<String, ReportList>();
    public static final ReportRegistry INSTANCE = new ReportRegistry();
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final SortedSet<Severity> severities = new TreeSet<Severity>(new SeverityComparator());
    private final ListListener listListener = new ListListener();

    protected ReportRegistry() {
    }

    public void disposeList(String id) {
        ReportList removed = id2list.remove(id);
        if (removed != null) {
            removed.eAdapters().remove((Object)this.listListener);
            removed.getReports().clear();
        }
        this.fireRemoved(removed);
    }

    public SortedSet<Severity> getSeverities() {
        return this.severities;
    }

    public ReportList[] getLists() {
        return id2list.values().toArray(new ReportList[id2list.size()]);
    }

    public ReportList getList(String id) {
        ReportList result = id2list.get(id);
        if (result == null) {
            result = ReportElementFactory.eINSTANCE.createReportList();
            result.setId(id);
            id2list.put(id, result);
            result.eAdapters().add((Object)this.listListener);
            this.fireAdded(result);
        }
        return result;
    }

    public void addListener(Listener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void fireAdded(ReportList list) {
        for (Listener l : this.listeners) {
            l.reportListAdded(list);
        }
    }

    private void fireUpdated(ReportList list) {
        for (Listener l : this.listeners) {
            l.reportListUpdated(list);
        }
    }

    private void fireRemoved(ReportList list) {
        for (Listener l : this.listeners) {
            l.reportListRemoved(list);
        }
    }

    private final class ListListener
    extends AdapterImpl {
        private ListListener() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() != null && msg.getFeature().equals(ReportElementPackage.eINSTANCE.getReportList_Reports())) {
                ReportRegistry.this.fireUpdated((ReportList)msg.getNotifier());
            }
        }
    }

    public static abstract class Listener {
        public void reportListAdded(ReportList list) {
        }

        public void reportListRemoved(ReportList list) {
        }

        public void reportListUpdated(ReportList list) {
        }
    }

    private static class SeverityComparator
    implements Comparator<Severity> {
        private SeverityComparator() {
        }

        @Override
        public int compare(Severity o1, Severity o2) {
            return o2.getCode() - o1.getCode();
        }
    }
}

