/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.report.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.polarsys.kitalpha.report.ui.description.DateColumnDescription;
import org.polarsys.kitalpha.report.ui.description.MessageColumnDescription;
import org.polarsys.kitalpha.report.ui.description.ReportsUI;
import org.polarsys.kitalpha.report.utils.SeverityFactory;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.polarsys.kitalpha.report.ui";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        SeverityFactory.INSTANCE.registerSeverities();
        ReportsUI.registerImage(SeverityFactory.INSTANCE.createDebug(), Activator.getDefault().getImage("icons/severity/debug.gif"));
        ReportsUI.registerImage(SeverityFactory.INSTANCE.createInfo(), Activator.getDefault().getImage("icons/severity/info.gif"));
        ReportsUI.registerImage(SeverityFactory.INSTANCE.createWarning(), Activator.getDefault().getImage("icons/severity/warning.gif"));
        ReportsUI.registerImage(SeverityFactory.INSTANCE.createError(), Activator.getDefault().getImage("icons/severity/error.gif"));
        ReportsUI.getDisplayedColumns().add("msg");
        ReportsUI.getDisplayedColumns().add("date");
        ReportsUI.registerColumnDescription(new MessageColumnDescription("Message", "msg", 16384, 250));
        ReportsUI.registerColumnDescription(new DateColumnDescription("Date", "date", 16384, 100));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        ImageDescriptor image = imageRegistry.getDescriptor(key);
        if (image == null) {
            image = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)key);
            imageRegistry.put(key, image);
        }
        return image;
    }

    public Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)key);
            imageRegistry.put(key, imageDescriptor);
            image = imageRegistry.get(key);
        }
        return image;
    }
}

