/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.actions;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.kitalpha.ad.integration.sirius.Activator;
import org.polarsys.kitalpha.ad.integration.sirius.dialog.ViewpointSelectionDialog;

public class ViewpointsSelectionAction
implements IObjectActionDelegate {
    private Shell shell;
    private IStructuredSelection sselect;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        Map<Viewpoint, Boolean> changes;
        final Session session = ViewpointsSelectionAction.getSessionFromSelection(this.sselect);
        if (session == null) {
            Activator.getDefault().logError("Cannot find the related Doremi session. Exiting.");
            return;
        }
        session.getSemanticCrossReferencer();
        SortedMap<Viewpoint, Boolean> viewpointsMap = ViewpointsSelectionAction.getViewpointsWithMonitor(session);
        TreeMap copyOfViewpointsMap = Maps.newTreeMap((Comparator)new ViewpointRegistry.ViewpointComparator());
        copyOfViewpointsMap.putAll(viewpointsMap);
        ViewpointSelectionDialog dialog = new ViewpointSelectionDialog(this.shell, viewpointsMap);
        if (dialog.open() == 0 && !(changes = dialog.getChanges()).isEmpty()) {
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    ViewpointSelectionCallback viewpointSelectionCallback = new ViewpointSelectionCallback();
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    for (Map.Entry entry : changes.entrySet()) {
                        if (((Boolean)entry.getValue()).booleanValue()) {
                            viewpointSelectionCallback.selectViewpoint((Viewpoint)entry.getKey(), session, (IProgressMonitor)monitor);
                            continue;
                        }
                        viewpointSelectionCallback.deselectViewpoint((Viewpoint)entry.getKey(), session, (IProgressMonitor)monitor);
                    }
                }
            });
        }
    }

    private static SortedMap<Viewpoint, Boolean> getViewpointsWithMonitor(Session session) {
        TreeSet allViewpoints = new TreeSet(new ViewpointRegistry.ViewpointComparator());
        TreeMap viewpointsMap = Maps.newTreeMap((Comparator)new ViewpointRegistry.ViewpointComparator());
        for (Resource resource : session.getSemanticResources()) {
            String currentFileExtension;
            if (resource == null || resource.getURI() == null || (currentFileExtension = resource.getURI().fileExtension()) == null) continue;
            allViewpoints.addAll(ViewpointSelection.getViewpoints((String)currentFileExtension));
        }
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        for (Viewpoint viewpoint : allViewpoints) {
            boolean selected = false;
            for (Viewpoint selectedViewpoint : selectedViewpoints) {
                if (!EqualityHelper.areEquals((EObject)selectedViewpoint, (EObject)viewpoint)) continue;
                selected = true;
                break;
            }
            viewpointsMap.put(viewpoint, selected);
        }
        return viewpointsMap;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.sselect = (IStructuredSelection)selection;
        }
        if (this.sselect == null || this.sselect.isEmpty()) {
            action.setEnabled(false);
        } else {
            Session session = ViewpointsSelectionAction.getSessionFromSelection(this.sselect);
            action.setEnabled(session != null && session.isOpen());
        }
    }

    protected static Session getSessionFromSelection(IStructuredSelection selection) {
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof Session) {
                return (Session)object;
            }
            if (object instanceof IFile) {
                return ViewpointsSelectionAction.getSessionForDiagramFile((IFile)object);
            }
            ++n2;
        }
        return null;
    }

    public static Session getSessionForDiagramFile(IFile diagramResourceFile) {
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            if (!(session instanceof DAnalysisSession) || !ViewpointsSelectionAction.isAnalysisFileInvolvedIn((DAnalysisSession)session, diagramResourceFile)) continue;
            return session;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAnalysisFileInvolvedIn(DAnalysisSession session, IFile analysisFile) {
        try {
            Resource resource;
            if (session == null) return false;
            if (analysisFile == null) {
                return false;
            }
            Iterator<Resource> iterator = ViewpointsSelectionAction.getAllAirdResources((Session)session).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!analysisFile.equals((Object)WorkspaceSynchronizer.getFile((Resource)(resource = iterator.next()))));
            return true;
        }
        catch (IllegalStateException illegalStateException) {}
        return false;
    }

    public static Collection<Resource> getAllAirdResources(Session session) {
        HashSet<Resource> allAnalysisResources = new HashSet<Resource>(session.getReferencedSessionResources());
        allAnalysisResources.add(session.getSessionResource());
        return allAnalysisResources;
    }
}

