/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.decoration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.DecorationDescriptor;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.SiriusDecorationDescriptorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.DecorationDistributionDirection;
import org.eclipse.sirius.viewpoint.description.Position;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationNavigationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.swt.graphics.Image;

public class SubDiagramDecorationDescriptorProvider
implements SiriusDecorationDescriptorProvider {
    private static final String NAME = "subDiagramStatus";

    @Override
    public boolean provides(IDiagramElementEditPart editPart) {
        try {
            if (editPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart || editPart instanceof AbstractConnectionEditPart) {
                Optional<View> view = Optional.ofNullable((View)editPart.getModel());
                return view.filter(View::isSetElement).map(View::getElement).filter(model -> model instanceof DNode || model instanceof DDiagramElementContainer).isPresent();
            }
        }
        catch (IllegalStateException illegalStateException) {}
        return false;
    }

    @Override
    public List<DecorationDescriptor> getDecorationDescriptors(IDiagramElementEditPart editPart, Session session) {
        List<DecorationDescriptor> results = new ArrayList<DecorationDescriptor>();
        EObject model = ((View)editPart.getModel()).getElement();
        if (model instanceof DRepresentationElement) {
            DRepresentationElement node = (DRepresentationElement)model;
            DRepresentationElementQuery dRepresentationElementQuery = new DRepresentationElementQuery(node);
            DRepresentation parentRepresentation = dRepresentationElementQuery.getParentRepresentation();
            Object decorationDescriptor = null;
            Map subDiagramDecorationDescriptors = null;
            if (parentRepresentation != null) {
                subDiagramDecorationDescriptors = parentRepresentation.getUiState().getSubDiagramDecorationDescriptors();
                decorationDescriptor = subDiagramDecorationDescriptors.get(node);
            }
            if (decorationDescriptor instanceof DecorationDescriptor) {
                results = Arrays.asList(decorationDescriptor);
            } else if (this.shouldHaveSubDiagDecoration(node, session)) {
                DecorationDescriptor decoDesc = new DecorationDescriptor();
                decoDesc.setName(NAME);
                decoDesc.setPosition(Position.SOUTH_EAST_LITERAL);
                decoDesc.setDistributionDirection(DecorationDistributionDirection.HORIZONTAL);
                decoDesc.setDisplayPriority(DecorationDescriptor.DisplayPriority.HIGH_PRIORITY.getValue());
                decoDesc.setDecorationAsImage(this.getSubDiagramImage());
                subDiagramDecorationDescriptors.put(node, decoDesc);
                results = Arrays.asList(decoDesc);
            }
        }
        return results;
    }

    private Image getSubDiagramImage() {
        return WorkspaceImageFigure.flyWeightImage(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/HasLink.gif"));
    }

    private boolean shouldHaveSubDiagDecoration(DRepresentationElement node, Session session) {
        EObject target = node.getTarget();
        boolean shouldHaveSubDiagramDecorator = false;
        if (target != null && target.eResource() != null && session != null && !this.parentHasSameSemanticElement(node)) {
            shouldHaveSubDiagramDecorator = this.checkExistingRepresentationDescriptors(node, session);
            if (node.getMapping() != null && !shouldHaveSubDiagramDecorator) {
                shouldHaveSubDiagramDecorator = this.checkRepresentationNavigationDescriptions(node, session);
            }
        }
        return shouldHaveSubDiagramDecorator;
    }

    private boolean checkExistingRepresentationDescriptors(DRepresentationElement node, Session session) {
        EObject semanticObject = node.getTarget();
        DRepresentation representation = new DRepresentationElementQuery(node).getParentRepresentation();
        DRepresentationDescriptor representationDescriptor = new DRepresentationQuery(representation, session).getRepresentationDescriptor();
        return DialectManager.INSTANCE.getRepresentationDescriptors(semanticObject, session).stream().filter(repDesc -> !Objects.equals(repDesc, representationDescriptor)).count() > 0L;
    }

    private boolean parentHasSameSemanticElement(DRepresentationElement element) {
        return element.eContainer() instanceof DDiagramElement && ((DDiagramElement)element.eContainer()).getTarget() == element.getTarget();
    }

    private boolean checkRepresentationNavigationDescriptions(DRepresentationElement element, Session session) {
        boolean isAnyRepresentation = false;
        EObject target = element.getTarget();
        if (session.isOpen()) {
            IInterpreter interpreter = session.getInterpreter();
            Iterator navDescIterator = element.getMapping().getNavigationDescriptions().iterator();
            while (!isAnyRepresentation && navDescIterator.hasNext()) {
                RepresentationNavigationDescription navDesc = (RepresentationNavigationDescription)navDescIterator.next();
                if (!this.isFromActiveViewpoint(navDesc.getRepresentationDescription(), session)) continue;
                interpreter.setVariable(navDesc.getContainerVariable().getName(), (Object)target);
                interpreter.setVariable(navDesc.getContainerViewVariable().getName(), (Object)element);
                boolean precondition = true;
                if (!StringUtil.isEmpty((String)navDesc.getPrecondition())) {
                    try {
                        precondition = interpreter.evaluateBoolean(target, navDesc.getPrecondition());
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                    }
                }
                if (precondition) {
                    isAnyRepresentation = this.checkRepresentationNavigationDescription(interpreter, navDesc, element, session);
                }
                interpreter.unSetVariable(navDesc.getContainerVariable().getName());
                interpreter.unSetVariable(navDesc.getContainerViewVariable().getName());
            }
        }
        return isAnyRepresentation;
    }

    private boolean isFromActiveViewpoint(RepresentationDescription description, Session session) {
        Viewpoint vp = ViewpointRegistry.getInstance().getViewpoint(description);
        return vp != null && session.getSelectedViewpoints(false).contains(vp);
    }

    private boolean checkRepresentationNavigationDescription(IInterpreter interpreter, RepresentationNavigationDescription navDesc, DRepresentationElement element, Session session) {
        ArrayList<EObject> candidates = new ArrayList<EObject>();
        if (!StringUtil.isEmpty((String)navDesc.getBrowseExpression())) {
            candidates.addAll(RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateCollection(element.getTarget(), (EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getRepresentationNavigationDescription_BrowseExpression()));
        } else {
            TreeIterator it = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(element.getTarget()).eAllContents(element.getTarget());
            while (it.hasNext()) {
                candidates.add((EObject)it.next());
            }
        }
        long count = 0L;
        for (EObject candidate : candidates) {
            count += DialectManager.INSTANCE.getRepresentationDescriptors(candidate, session).stream().filter(repDesc -> repDesc.getDescription().equals(navDesc.getRepresentationDescription())).count();
        }
        return count > 0L;
    }

    @Override
    public void activate(IDecoratorTarget decoratorTarget, IDecorator decorator, GraphicalEditPart editPart) {
    }

    @Override
    public void deactivate(IDecorator decorator, GraphicalEditPart editPart) {
    }
}

