/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationGraph;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationNode;

public class GenerationGraphCycle {
    private List<Vector<GenerationNode>> cycles = new ArrayList<Vector<GenerationNode>>();
    private GenerationNode currentRoot = null;
    private Vector<GenerationNode> visited = new Vector();
    private Stack<GenerationNode> cycle = new Stack();
    private GenerationGraph _graph = null;

    public GenerationGraphCycle(GenerationGraph graph) {
        this._graph = graph;
    }

    public boolean exist() {
        return !this.cycles.isEmpty();
    }

    public int count() {
        return this.cycles.size();
    }

    public List<Vector<GenerationNode>> getCycles() {
        return this.cycles;
    }

    public void analyse() {
        this.cycles.clear();
        Vector<GenerationNode> nodes = this._graph.getOwnedNodes();
        int i = 0;
        while (i < nodes.size()) {
            this.visited.clear();
            this.cycle.clear();
            this.currentRoot = nodes.elementAt(i);
            this.cycle.push(this.currentRoot);
            this.analyse(this.currentRoot);
            ++i;
        }
    }

    private void analyse(GenerationNode node) {
        this.visited.add(node);
        Vector<GenerationNode> neighbors = this._graph.getNeighbors(node);
        for (GenerationNode neighbor : neighbors) {
            if (neighbor.equals(this.currentRoot)) {
                Vector<GenerationNode> vector = new Vector<GenerationNode>();
                for (GenerationNode gnode : this.cycle) {
                    vector.add(gnode);
                }
                if (this.isDetected(vector)) continue;
                this.cycles.add(vector);
                continue;
            }
            if (this.visited.contains(neighbor)) continue;
            this.cycle.push(neighbor);
            this.analyse(neighbor);
            this.cycle.pop();
        }
    }

    private boolean isDetected(Vector<GenerationNode> cycle) {
        int i = 0;
        while (i < this.cycles.size()) {
            Vector<GenerationNode> currentCycle = this.cycles.get(i);
            if (currentCycle.size() == cycle.size() && currentCycle.contains(cycle.get(0))) {
                int index = currentCycle.indexOf(cycle.get(0));
                boolean gap = false;
                int j = 0;
                while (j < cycle.size()) {
                    if (!cycle.get(j).equals(currentCycle.get((index + j) % currentCycle.size()))) {
                        gap = true;
                        break;
                    }
                    ++j;
                }
                if (!gap) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void print() {
        int i = 0;
        while (i < this.cycles.size()) {
            Vector<GenerationNode> currentCycle = this.cycles.get(i);
            for (GenerationNode noeud : currentCycle) {
                System.out.print(" " + noeud.getName());
            }
            System.out.println();
            ++i;
        }
    }

    public String cyclesToString() {
        String result = "";
        if (!this.cycles.isEmpty()) {
            int i = 0;
            while (i < this.cycles.size()) {
                Vector<GenerationNode> currentCycle = this.cycles.get(i);
                result = String.valueOf(result) + "\t [";
                int j = 0;
                while (j < currentCycle.size()) {
                    if (j != 0) {
                        result = String.valueOf(result) + " --> ";
                    }
                    GenerationNode noeud = currentCycle.get(j);
                    result = String.valueOf(result) + noeud.getName();
                    ++j;
                }
                result = String.valueOf(result) + "] \n";
                ++i;
            }
        }
        return result;
    }
}

