/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import ca.odell.glazedlists.TreeList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByObject;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.IGroupByComparator;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;

public class GroupByTreeFormat<T>
implements TreeList.Format<Object> {
    private final GroupByModel model;
    private final IColumnAccessor<T> columnAccessor;
    private IGroupByComparator<T> groupByComparator;

    public GroupByTreeFormat(GroupByModel model, IColumnAccessor<T> columnAccessor) {
        this.model = model;
        this.columnAccessor = columnAccessor;
    }

    public void getPath(List<Object> path, Object element) {
        List<Integer> groupByColumns = this.model.getGroupByColumnIndexes();
        if (!groupByColumns.isEmpty()) {
            LinkedHashMap<Integer, Object> descriptor = new LinkedHashMap<Integer, Object>();
            for (int columnIndex : groupByColumns) {
                Object columnValue = this.columnAccessor.getDataValue(element, columnIndex);
                descriptor.put(columnIndex, columnValue);
                GroupByObject groupByObject = this.getGroupByObject(columnValue, descriptor);
                path.add(groupByObject);
            }
        }
        path.add(element);
    }

    protected GroupByObject getGroupByObject(Object columnValue, Map<Integer, Object> descriptor) {
        return new GroupByObject(columnValue, new LinkedHashMap<Integer, Object>(descriptor));
    }

    public boolean allowsChildren(Object element) {
        return true;
    }

    public Comparator<Object> getComparator(int depth) {
        if (this.model.getGroupByColumnIndexes().isEmpty()) {
            return null;
        }
        return this.groupByComparator;
    }

    public void clearComparatorCache() {
        this.groupByComparator.clearCache();
    }

    public void setSortModel(ISortModel model) {
        this.groupByComparator.setSortModel(model);
    }

    public ISortModel getSortModel() {
        return this.groupByComparator.getSortModel();
    }

    void setTreeLayer(IUniqueIndexLayer treeLayer) {
        this.groupByComparator.setTreeLayer(treeLayer);
    }

    void setDataLayer(GroupByDataLayer<T> dataLayer) {
        this.groupByComparator.setDataLayer(dataLayer);
    }

    public void setComparator(IGroupByComparator<T> comparator) {
        this.groupByComparator = comparator;
    }
}

