/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.diffmerge.patterns.diagrams.PatternCoreDiagramPlugin;
import org.eclipse.emf.diffmerge.patterns.diagrams.util.AbstractDiagramUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternBasedSpecification;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractPatternWizard;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractPatternPage<T extends ITemplatePatternBasedSpecification>
extends WizardPage {
    private final String _defaultMessage;
    private final T _data;
    private final boolean _isBlocking;
    private final Set<IPageValidatedListener> _validationListeners;
    protected AbstractDiagramUtil _diagramUtil = PatternCoreDiagramPlugin.getDefault().getDiagramUtilityClass();

    protected AbstractPatternPage(String pageName_p, String pageTitle_p, String defaultMessage_p, T data_p, boolean isBlocking_p) {
        super(pageName_p, pageTitle_p, null);
        this._data = data_p;
        this._isBlocking = isBlocking_p;
        this.setPageComplete(!this._isBlocking);
        this._defaultMessage = defaultMessage_p;
        this._validationListeners = new HashSet<IPageValidatedListener>();
    }

    protected Control addEmptyControl(Composite parent_p) {
        return new Label(parent_p, 0);
    }

    public void addValidationListener(IPageValidatedListener listener_p) {
        this._validationListeners.add(listener_p);
    }

    protected Group createGroup(Composite parent_p, String title_p, boolean isHorizontalFill_p, int columns_p) {
        Group result = new Group(parent_p, 0);
        GridData data = new GridData(isHorizontalFill_p ? 4 : 0, 4, isHorizontalFill_p, true);
        result.setLayoutData((Object)data);
        result.setText(title_p);
        GridLayout layout = new GridLayout(columns_p, false);
        result.setLayout((Layout)layout);
        return result;
    }

    protected String getMultiEntryString(Iterable<String> lines_p) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String line : lines_p) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(line);
        }
        return builder.toString();
    }

    public AbstractPatternWizard<T> getWizard() {
        return (AbstractPatternWizard)super.getWizard();
    }

    public void enableAll(Composite composite_p, boolean enable_p, boolean deep_p) {
        this.enableAll((Control)composite_p, enable_p, deep_p, Collections.emptySet(), Collections.emptySet());
    }

    protected void enableAll(Control control_p, boolean enable_p, boolean deep_p, Collection<? extends Control> alwaysEnabled_p, Collection<? extends Control> alwaysDisabled_p) {
        if (alwaysEnabled_p.contains(control_p)) {
            control_p.setEnabled(true);
        } else if (alwaysDisabled_p.contains(control_p)) {
            control_p.setEnabled(false);
        } else {
            control_p.setEnabled(enable_p);
        }
        if (deep_p && control_p instanceof Composite) {
            Control[] controlArray = ((Composite)control_p).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.enableAll(child, enable_p, deep_p, alwaysEnabled_p, alwaysDisabled_p);
                ++n2;
            }
        }
    }

    protected void finishRow(Composite parent_p, boolean extendLastControl_p) {
        int remaining = this.getRemainingColumns(parent_p);
        if (remaining > 0 || extendLastControl_p) {
            GridData gd;
            Control[] controls = parent_p.getChildren();
            Control lastControl = controls.length > 0 && extendLastControl_p ? controls[controls.length - 1] : this.addEmptyControl(parent_p);
            if (lastControl.getLayoutData() instanceof GridData) {
                gd = (GridData)lastControl.getLayoutData();
            } else {
                gd = new GridData();
                lastControl.setLayoutData((Object)gd);
            }
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = remaining + 1;
            gd.grabExcessHorizontalSpace = true;
            lastControl.setLayoutData((Object)gd);
        }
    }

    public T getData() {
        return this._data;
    }

    protected int getRemainingColumns(Composite parent_p) {
        int result = 0;
        Layout layout = parent_p.getLayout();
        if (layout instanceof GridLayout) {
            int width = ((GridLayout)layout).numColumns;
            int used = 0;
            Control[] controlArray = parent_p.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Object data = child.getLayoutData();
                used = data instanceof GridData ? (used += ((GridData)data).horizontalSpan) : ++used;
                ++n2;
            }
            result = used % width;
        }
        return result;
    }

    protected String getValidationMessage() {
        return null;
    }

    protected boolean blockWithoutErrorMessages() {
        return false;
    }

    protected String nonNull(String string_p) {
        return string_p == null ? "" : string_p;
    }

    protected void selectTextContent(Text text_p) {
        text_p.setFocus();
        text_p.setSelection(0, text_p.getText().length());
    }

    protected final void setDefaultMessage() {
        this.setMessage(this._defaultMessage);
    }

    public void setMessage(String newMessage_p, int newType_p) {
        super.setMessage(newMessage_p, newType_p);
        for (IPageValidatedListener listener : this._validationListeners) {
            listener.messageUpdated(this, newMessage_p, newType_p);
        }
    }

    public void setVisible(boolean visible_p) {
        super.setVisible(visible_p);
        this.validate();
    }

    public void validate() {
        String validationMessage = this.getValidationMessage();
        this.setErrorMessage(validationMessage);
        if (this._isBlocking) {
            this.setPageComplete(validationMessage == null && !this.blockWithoutErrorMessages());
        }
        try {
            IWizardContainer container = this.getWizard().getContainer();
            if (container instanceof WizardDialog) {
                ((WizardDialog)container).updateButtons();
            }
        }
        catch (NullPointerException container) {
            // empty catch block
        }
        for (IPageValidatedListener listener : this._validationListeners) {
            listener.pageValidated(this, validationMessage);
        }
    }

    public static interface IPageValidatedListener {
        public void pageValidated(AbstractPatternPage<?> var1, String var2);

        public void messageUpdated(AbstractPatternPage<?> var1, String var2, int var3);
    }

    protected static class NonUserSelection
    extends StructuredSelection {
        public static NonUserSelection newInstance(Object element_p) {
            return element_p == null ? new NonUserSelection() : new NonUserSelection(element_p);
        }

        private NonUserSelection(Object element_p) {
            super(element_p);
        }

        private NonUserSelection() {
        }
    }
}

