/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.history.FindResults;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevObject;

public class FindToolbarJob
extends Job {
    private static final int MAX_RESULTS = 20000;
    private static final ISchedulingRule SINGLE_JOB_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }
    };
    String pattern;
    SWTCommit[] fileRevisions;
    boolean ignoreCase;
    boolean findInCommitId;
    boolean findInComments;
    boolean findInAuthor;
    boolean findInCommitter;
    boolean findInReference;
    private final FindResults findResults;

    public FindToolbarJob(String name, FindResults findResults) {
        super(name);
        this.findResults = findResults;
        this.setRule(SINGLE_JOB_RULE);
    }

    private boolean find(String needle, String text) {
        if (text == null) {
            return false;
        }
        if (this.ignoreCase) {
            return text.toLowerCase().contains(needle);
        }
        return text.contains(needle);
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.findResults.clear();
        if (this.pattern == null || this.pattern.isEmpty() || this.fileRevisions == null || this.fileRevisions.length == 0) {
            return Status.OK_STATUS;
        }
        String findPattern = this.pattern;
        if (this.ignoreCase) {
            findPattern = this.pattern.toLowerCase();
        }
        int totalRevisions = this.fileRevisions.length;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)totalRevisions);
        int i = 0;
        while (i < totalRevisions) {
            block24: {
                if (progress.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.findResults.size() >= 20000) {
                    this.findResults.setOverflow();
                    break;
                }
                SWTCommit revision = this.fileRevisions[i];
                try {
                    revision.parseBody();
                }
                catch (IOException e) {
                    Activator.logError("Error parsing body", e);
                    break block24;
                }
                if (this.findInCommitId && this.find(findPattern, revision.getId().name())) {
                    if (progress.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    this.findResults.add(i, (RevObject)revision);
                } else if (this.findInComments && this.find(findPattern, revision.getFullMessage())) {
                    if (progress.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    this.findResults.add(i, (RevObject)revision);
                } else if (this.findInAuthor && (this.find(findPattern, revision.getAuthorIdent().getName()) || this.find(findPattern, revision.getAuthorIdent().getEmailAddress()))) {
                    if (progress.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    this.findResults.add(i, (RevObject)revision);
                } else if (this.findInCommitter && (this.find(findPattern, revision.getCommitterIdent().getName()) || this.find(findPattern, revision.getCommitterIdent().getEmailAddress()))) {
                    if (progress.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    this.findResults.add(i, (RevObject)revision);
                } else {
                    if (this.findInReference) {
                        int j = 0;
                        while (j < revision.getRefCount()) {
                            if (progress.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            Ref ref = revision.getRef(j);
                            String refName = ref.getName();
                            if (this.find(findPattern, refName = Repository.shortenRefName((String)refName))) {
                                if (progress.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                this.findResults.add(i, (RevObject)revision);
                                break;
                            }
                            ++j;
                        }
                    }
                    progress.worked(1);
                }
            }
            ++i;
        }
        return progress.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }
}

