/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore.importer;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.mapping.xsd2ecore.XSD2EcoreMapper;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.ecore.MapBuilder;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xsd.ecore.importer.XSDImporterPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDImporter
extends ModelImporter {
    protected static final String SORT_ATTRIBUTES_KEY = "sortAttributes";
    protected static final String CREATE_MAP_KEY = "createMap";
    protected boolean createEcoreMap;
    protected EObject mappingRoot;
    protected boolean sortAttributes = true;

    public void dispose() {
        this.mappingRoot = null;
        super.dispose();
    }

    public String getID() {
        return "org.eclipse.xsd.ecore.importer";
    }

    public boolean canCreateEcoreMap() {
        return Platform.getBundle((String)"org.eclipse.emf.mapping.xsd2ecore") != null;
    }

    public void setCreateEcoreMap(boolean createEcoreMap) {
        this.createEcoreMap = createEcoreMap;
    }

    public boolean createEcoreMap() {
        return this.createEcoreMap && this.canCreateEcoreMap();
    }

    public void setSortAttributes(boolean sortAttributes) {
        this.sortAttributes = sortAttributes;
    }

    public boolean sortAttributes() {
        return this.sortAttributes;
    }

    public void setMappingRoot(EObject mappingRoot) {
        this.mappingRoot = mappingRoot;
    }

    public EObject getMappingRoot() {
        return this.mappingRoot;
    }

    protected Diagnostic doComputeEPackages(Monitor monitor) throws Exception {
        BasicDiagnostic basicDiagnostic = null;
        List locationURIs = this.getModelLocationURIs();
        if (locationURIs.isEmpty()) {
            basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.converter", 264, XSDImporterPlugin.INSTANCE.getString("_UI_SpecifyAValidXMLSchema_message"), null);
        } else {
            this.setMappingRoot(null);
            Builder ecoreBuilder = new Builder();
            if (this.createEcoreMap()) {
                new MapHelper(monitor).setNewMapper(ecoreBuilder);
            } else {
                monitor.beginTask("", 2);
                monitor.subTask(XSDImporterPlugin.INSTANCE.getString("_UI_Loading_message", new Object[]{locationURIs}));
            }
            List result = (List)ecoreBuilder.generate(locationURIs);
            Object lastElement = this.removeNonEPackageFromTheEnd(result);
            if (lastElement instanceof List) {
                List diagnostics = (List)lastElement;
                if (!diagnostics.isEmpty()) {
                    BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.converter", 1, XSDImporterPlugin.INSTANCE.getString("_UI_ErrorsWereDetectedXMLSchema_message"), null);
                    for (List information : diagnostics) {
                        diagnostic.add((Diagnostic)new BasicDiagnostic("fatal".equals(information.get(0)) || "error".equals(information.get(0)) ? 4 : ("warning".equals(information.get(0)) ? 2 : 1), XSDImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, (String)information.get(1), null));
                    }
                    basicDiagnostic = diagnostic;
                }
                lastElement = this.removeNonEPackageFromTheEnd(result);
            }
            if (lastElement instanceof EObject) {
                this.setMappingRoot((EObject)lastElement);
            }
            List ePackages = result;
            this.getEPackages().addAll(ePackages);
        }
        if (basicDiagnostic == null) {
            return Diagnostic.OK_INSTANCE;
        }
        return basicDiagnostic;
    }

    protected Object removeNonEPackageFromTheEnd(List<Object> list) {
        int lastIndex = list.size() - 1;
        if (lastIndex >= 0 && !(list.get(lastIndex) instanceof EPackage)) {
            return list.remove(lastIndex);
        }
        return null;
    }

    protected void adjustGenPackageDuringTraverse(GenPackage genPackage) {
        genPackage.setResource(GenResourceKind.XML_LITERAL);
    }

    protected void adjustGenModel(Monitor monitor) {
        super.adjustGenModel(monitor);
        IPath genModelFileFullPath = this.getGenModelPath();
        URI genModelURI = this.createFileURI(genModelFileFullPath.toString());
        GenModel genModel = this.getGenModel();
        EList foreignModel = genModel.getForeignModel();
        for (URI uri : this.getModelLocationURIs()) {
            foreignModel.add((Object)this.makeRelative(uri, genModelURI).toString());
        }
        if (this.getMappingRoot() != null) {
            IPath mappingPath = genModelFileFullPath.removeFileExtension().addFileExtension("xsd2ecore");
            URI mappingModelURI = this.createFileURI(mappingPath.toString());
            Resource mappingModelResource = this.getGenModelResourceSet().createResource(mappingModelURI);
            mappingModelResource.getContents().add((Object)this.getMappingRoot());
        }
    }

    public void prepareGenModelAndEPackages(Monitor monitor) {
        super.prepareGenModelAndEPackages(monitor);
        GenModel genModel = this.getGenModel();
        GenAnnotation annotation = genModel.getGenAnnotation(this.getConverterGenAnnotationSource());
        if (!this.sortAttributes()) {
            if (annotation == null) {
                annotation = genModel.createGenAnnotation();
                annotation.setSource(this.getConverterGenAnnotationSource());
            }
            annotation.getDetails().put((Object)SORT_ATTRIBUTES_KEY, (Object)"false");
            genModel.getGenAnnotations().add((Object)annotation);
        } else if (annotation != null) {
            annotation.getDetails().removeKey((Object)SORT_ATTRIBUTES_KEY);
        }
        if (this.getMappingRoot() != null) {
            if (annotation == null) {
                annotation = genModel.createGenAnnotation();
                annotation.setSource(this.getConverterGenAnnotationSource());
                genModel.getGenAnnotations().add((Object)annotation);
            }
            annotation.getDetails().put((Object)CREATE_MAP_KEY, (Object)"true");
        } else if (annotation != null) {
            annotation.getDetails().removeKey((Object)CREATE_MAP_KEY);
        }
        if (annotation != null && annotation.getDetails().isEmpty()) {
            genModel.getGenAnnotations().remove((Object)annotation);
        }
    }

    protected List<Resource> computeResourcesToBeSaved() {
        List resources = super.computeResourcesToBeSaved();
        if (this.getMappingRoot() != null) {
            resources.add(this.getMappingRoot().eResource());
        }
        return resources;
    }

    protected void handleOriginalGenModel() throws DiagnosticException {
        GenModel originalGenModel = this.getOriginalGenModel();
        URI genModelURI = originalGenModel.eResource().getURI();
        StringBuffer text = new StringBuffer();
        for (String value : originalGenModel.getForeignModel()) {
            if (!value.endsWith(".xsd") && !value.endsWith(".wsdl")) continue;
            text.append(this.makeAbsolute(URI.createURI((String)value), genModelURI).toString());
            text.append(" ");
        }
        GenAnnotation annotation = originalGenModel.getGenAnnotation(this.getConverterGenAnnotationSource());
        if (annotation != null) {
            this.setSortAttributes(!"false".equals(annotation.getDetails().get((Object)SORT_ATTRIBUTES_KEY)));
            this.setCreateEcoreMap("true".equals(annotation.getDetails().get((Object)CREATE_MAP_KEY)));
        }
        this.setModelLocation(text.toString().trim());
    }

    protected class Builder
    extends XSDEcoreBuilder {
        public ResourceSet resourceSet;

        protected Builder() {
        }

        protected ResourceSet createResourceSet() {
            this.resourceSet = super.createResourceSet();
            return this.resourceSet;
        }

        protected boolean useSortedAttributes() {
            return XSDImporter.this.sortAttributes;
        }
    }

    public static class MapHelper {
        protected Monitor monitor;

        public MapHelper() {
        }

        public MapHelper(Monitor monitor) {
            this.monitor = monitor;
        }

        public void setNewMapper(XSDEcoreBuilder ecoreBuilder) {
            try {
                final Builder builder = ecoreBuilder instanceof Builder ? (Builder)ecoreBuilder : null;
                XSD2EcoreMapper mapper = new XSD2EcoreMapper(){
                    boolean initialized;
                    int mappings;
                    int count;

                    public void map(Collection<? extends EObject> inputs, Collection<? extends EObject> outputs) {
                        if (MapHelper.this.monitor != null) {
                            if (!this.initialized) {
                                this.initialized = true;
                                if (builder == null) {
                                    this.mappings = 1;
                                } else {
                                    TreeIterator i = builder.resourceSet.getAllContents();
                                    while (i.hasNext()) {
                                        Object object = i.next();
                                        if (!(object instanceof XSDSchema) && !(object instanceof XSDTypeDefinition) && !(object instanceof XSDFeature) && !(object instanceof XSDEnumerationFacet)) continue;
                                        ++this.mappings;
                                    }
                                }
                                MapHelper.this.monitor.beginTask("", this.mappings);
                            }
                            MapHelper.this.monitor.worked(1);
                            if (this.count++ % 100 == 0) {
                                MapHelper.this.monitor.subTask(XSDImporterPlugin.INSTANCE.getString("_UI_Mapping_message", new Object[]{EcoreUtil.getURI((EObject)inputs.iterator().next()).trimFragment()}));
                                if (MapHelper.this.monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                            }
                        }
                        super.map(inputs, outputs);
                    }
                };
                ecoreBuilder.setMapper((MapBuilder.Mapper)mapper);
            }
            catch (Exception e) {
                XSDImporterPlugin.INSTANCE.log(e);
            }
        }
    }
}

