/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.view.handlers;

import org.eclipse.amalgam.explorer.contextual.core.ui.view.ExplorerContextualView;
import org.eclipse.amalgam.explorer.contextual.view.focus.FocusInEditorExtensionsManager;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class SelectInCurrentEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        ExplorerContextualView explorerContextualView;
        ISelection selection;
        IEvaluationContext evaluationContext;
        Object variable;
        Object applicationContext = event_p.getApplicationContext();
        if (applicationContext instanceof IEvaluationContext && (variable = (evaluationContext = (IEvaluationContext)applicationContext).getVariable("activePart")) instanceof IViewPart && variable instanceof ExplorerContextualView && (selection = (explorerContextualView = (ExplorerContextualView)variable).getSite().getSelectionProvider().getSelection()) instanceof IStructuredSelection) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart activeEditor = page.getActiveEditor();
            if (activeEditor != null) {
                boolean done = FocusInEditorExtensionsManager.getInstance().doFocus(activeEditor, selection);
                if (!done) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MessageDialog.openInformation((Shell)shell, (String)"Contextual Explorer", (String)"Can't focus on the selected element in the open editor");
                }
            } else {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openInformation((Shell)shell, (String)"Contextual Explorer", (String)"There is no open editor");
            }
        }
        return null;
    }
}

