/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.tasks;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.tasks.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.templates.GenBuildModelRunner;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.util.JavaUtil;

public class CreateBuildModelRunnerTask
implements ITaskProduction {
    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String buildModelPath = (String)productionContext.getInputValue((Object)"build.model.path", String.class);
        if (buildModelPath == null || "".equals(buildModelPath)) {
            throw new InvocationException(Messages.GeneratorError_BuildModelNotFound);
        }
        String rootProjectName = (String)productionContext.getInputValue((Object)"root.project.name", String.class);
        if (rootProjectName == null || "".equals(rootProjectName)) {
            throw new InvocationException(Messages.GeneratorError_ProjectNameNotFound);
        }
        String lvpsShortName = (String)productionContext.getInputValue((Object)"short.name", String.class);
        if (lvpsShortName == null || "".equals(lvpsShortName)) {
            throw new InvocationException(Messages.GeneratorError_ViewpointShortNameNotFound);
        }
        String projectId = String.valueOf(rootProjectName) + "." + "releng";
        JavaUtil.createFolder(projectId, "egf");
        String buildModelRunnerPath = String.valueOf(projectId) + "/egf/" + "run_" + lvpsShortName + ".fcore";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource egfBuildRunnerResource = resourceSet.createResource(URI.createPlatformResourceURI((String)buildModelRunnerPath, (boolean)false));
        GenBuildModelRunner generator = new GenBuildModelRunner();
        JavaUtil.createFolder(projectId, "releng-scripts");
        String generationPath = String.valueOf(projectId) + "/" + "releng-scripts";
        FactoryComponent fc = generator.doGenerate(buildModelPath, lvpsShortName, generationPath);
        egfBuildRunnerResource.getContents().add((Object)fc);
        try {
            egfBuildRunnerResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
        if (project != null && project.exists()) {
            try {
                project.refreshLocal(2, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        String buildRunnerURI = String.valueOf(URI.createPlatformPluginURI((String)buildModelRunnerPath, (boolean)false).toString()) + "#" + fc.getID();
        productionContext.setOutputValue((Object)"build.runner.uri", (Object)buildRunnerURI);
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

