/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.common;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;

public final class TextSearch {
    public static final String FORCE_NOT_RECURSIVE = "__FORCE_NOT_RECURSIVE__";

    private TextSearch() {
    }

    public static Region indexIn(String buffer, String tag, Region region, String spec, String[][] inhibs) {
        Region toReturn;
        if (buffer == null || region.b() < 0 || region.e() <= region.b() || region.e() > buffer.length()) {
            toReturn = Region.NOT_FOUND;
        } else if (spec == null && inhibs == null) {
            toReturn = TextSearch.indexIn(buffer, tag, region);
        } else if (tag == null) {
            toReturn = Region.NOT_FOUND;
        } else {
            int inhibsSize = 0;
            if (inhibs != null) {
                inhibsSize = inhibs.length;
            }
            Region notInitialized = new Region(-2, -2);
            Region[] positions = new Region[3 + inhibsSize];
            int i = 0;
            while (i < positions.length) {
                positions[i] = notInitialized;
                ++i;
            }
            toReturn = null;
            int pos = region.b();
            while (toReturn == null && pos > -1 && pos < region.e()) {
                if (positions[0].b() != -1 && spec != null && pos > positions[0].b()) {
                    positions[0] = TextSearch.indexIn(buffer, spec, new Region(pos, region.e()));
                }
                if (positions[1].b() != -1 && pos > positions[1].b()) {
                    positions[1] = TextSearch.indexIn(buffer, tag, new Region(pos, region.e()));
                }
                int i2 = 3;
                while (i2 < positions.length) {
                    if (positions[i2].b() != -1 && pos > positions[i2].b()) {
                        assert (inhibs != null);
                        positions[i2] = TextSearch.indexIn(buffer, inhibs[i2 - 3][0], new Region(pos, region.e()));
                    }
                    ++i2;
                }
                int positionMin = region.e();
                int iPositionMin = -1;
                int i3 = 0;
                while (i3 < positions.length) {
                    if (positions[i3].b() > -1 && positions[i3].b() < positionMin) {
                        iPositionMin = i3;
                        positionMin = positions[i3].b();
                    }
                    ++i3;
                }
                if (iPositionMin == -1) {
                    toReturn = Region.NOT_FOUND;
                    continue;
                }
                if (iPositionMin == 0) {
                    pos = positions[iPositionMin].e();
                    continue;
                }
                if (iPositionMin == 1) {
                    toReturn = positions[iPositionMin];
                    continue;
                }
                if (iPositionMin < 3) continue;
                assert (inhibs != null);
                boolean forceNotRecursive = inhibs[iPositionMin - 3].length >= 3 && inhibs[iPositionMin - 3][2] != null ? inhibs[iPositionMin - 3][2].indexOf(FORCE_NOT_RECURSIVE) > -1 : false;
                pos = !forceNotRecursive ? TextSearch.blockIndexEndIn(buffer, inhibs[iPositionMin - 3][0], inhibs[iPositionMin - 3][1], new Region(positions[iPositionMin].b(), region.e()), true, spec, inhibs).e() : TextSearch.blockIndexEndIn(buffer, inhibs[iPositionMin - 3][0], inhibs[iPositionMin - 3][1], new Region(positions[iPositionMin].b(), region.e()), false, spec, null).e();
            }
            if (toReturn == null) {
                toReturn = Region.NOT_FOUND;
            }
        }
        return toReturn;
    }

    public static Region indexIn(String buffer, String tag, Region region) {
        Region toReturn;
        if (buffer == null) {
            toReturn = Region.NOT_FOUND;
        } else if (region.b() < 0 || region.e() <= 0 || region.e() <= region.b() || region.e() > buffer.length()) {
            toReturn = Region.NOT_FOUND;
        } else if (tag == null || tag.length() == 0) {
            toReturn = Region.NOT_FOUND;
        } else {
            String substring = buffer.substring(region.b(), region.e());
            int i = substring.indexOf(tag);
            if (i > -1) {
                int b = region.b() + i;
                toReturn = new Region(b, b + tag.length());
            } else {
                toReturn = Region.NOT_FOUND;
            }
        }
        return toReturn;
    }

    public static Region blockIndexEndIn(String buffer, String beginTag, String endTag, Region region, boolean recursive, String spec, String[][] inhibs) {
        if (buffer == null || region.b() < 0 || region.e() <= region.b() || region.e() > buffer.length()) {
            return Region.NOT_FOUND;
        }
        if (beginTag == null || endTag == null) {
            return Region.NOT_FOUND;
        }
        Region posBeginInt2 = TextSearch.indexIn(buffer, beginTag, region);
        if (posBeginInt2.b() != region.b() && beginTag.length() > 0) {
            return Region.NOT_FOUND;
        }
        if (endTag.length() == 0) {
            return new Region(region.e(), region.e());
        }
        int nbBeginTagOuvert = 1;
        int pos = posBeginInt2.e();
        int inhibsSize = 0;
        if (inhibs != null) {
            inhibsSize = inhibs.length;
        }
        Region notInitialized = new Region(-2, -2);
        Region[] positions = new Region[4 + inhibsSize];
        int i = 0;
        while (i < positions.length) {
            positions[i] = notInitialized;
            ++i;
        }
        while (pos > -1 && pos < region.e()) {
            if (positions[0].b() != -1 && spec != null && pos > positions[0].b()) {
                positions[0] = TextSearch.indexIn(buffer, spec, new Region(pos, region.e()));
            }
            if (positions[1].b() != -1 && pos > positions[1].b()) {
                positions[1] = TextSearch.indexIn(buffer, endTag, new Region(pos, region.e()));
            }
            if (positions[2].b() != -1 && recursive && beginTag.length() > 0 && pos > positions[2].b()) {
                positions[2] = TextSearch.indexIn(buffer, beginTag, new Region(pos, region.e()));
            }
            i = 4;
            while (i < positions.length) {
                if (positions[i].b() != -1 && pos > positions[i].b()) {
                    assert (inhibs != null);
                    positions[i] = TextSearch.indexIn(buffer, inhibs[i - 4][0], new Region(pos, region.e()));
                }
                ++i;
            }
            int positionMin = region.e();
            int iPositionMin = -1;
            int i2 = 0;
            while (i2 < positions.length) {
                if (positions[i2].b() > -1 && positions[i2].b() < positionMin) {
                    iPositionMin = i2;
                    positionMin = positions[i2].b();
                }
                ++i2;
            }
            if (iPositionMin == -1) {
                return Region.NOT_FOUND;
            }
            if (iPositionMin == 0) {
                pos = positions[iPositionMin].e();
            } else if (iPositionMin == 1) {
                --nbBeginTagOuvert;
                pos = positions[iPositionMin].e();
                if (!recursive || beginTag.length() == 0) {
                    return positions[iPositionMin];
                }
            } else if (iPositionMin == 2) {
                ++nbBeginTagOuvert;
                pos = positions[iPositionMin].e();
            } else if (iPositionMin >= 4) {
                assert (inhibs != null);
                boolean forceNotRecursive = inhibs[iPositionMin - 4].length >= 3 && inhibs[iPositionMin - 4][2] != null ? inhibs[iPositionMin - 4][2].indexOf(FORCE_NOT_RECURSIVE) > -1 : false;
                pos = !forceNotRecursive ? TextSearch.blockIndexEndIn(buffer, inhibs[iPositionMin - 4][0], inhibs[iPositionMin - 4][1], new Region(positions[iPositionMin].b(), region.e()), true, spec, inhibs).e() : TextSearch.blockIndexEndIn(buffer, inhibs[iPositionMin - 4][0], inhibs[iPositionMin - 4][1], new Region(positions[iPositionMin].b(), region.e()), false, spec, null).e();
            }
            if (nbBeginTagOuvert != 0) continue;
            return positions[iPositionMin];
        }
        return Region.NOT_FOUND;
    }

    public static Region lastIndexIn(String buffer, String tag, int posBegin, int posEnd, String spec, String[][] inhibs) {
        Region i;
        if (buffer == null || posBegin < 0 || posEnd <= posBegin || posEnd > buffer.length()) {
            return Region.NOT_FOUND;
        }
        Region lastI = i = TextSearch.indexIn(buffer, tag, new Region(posBegin, posEnd), spec, inhibs);
        while (i.b() > -1) {
            if ((i = TextSearch.indexIn(buffer, tag, new Region(i.e(), posEnd), spec, inhibs)).b() <= -1) continue;
            lastI = i;
        }
        return lastI;
    }

    public static Region[] splitPositionsIn(String buffer, Region region, String[] separators, boolean keepSeparators, String spec, String[][] inhibs) {
        List<Region> list = TextSearch.splitPositions(buffer, region, separators, keepSeparators, spec, inhibs);
        return list.toArray(new Region[list.size()]);
    }

    private static List<Region> splitPositions(String buffer, Region region, String[] separators, boolean keepSeparators, String spec, String[][] inhibs) {
        if (buffer.length() == 0 || region.b() < 0 || region.e() <= region.b() || region.e() > buffer.length()) {
            return new LinkedList<Region>();
        }
        List<Object> result = null;
        int i = 0;
        while (result == null && i < separators.length) {
            Region index = TextSearch.indexIn(buffer, separators[i], region, spec, inhibs);
            if (keepSeparators) {
                if (index.b() == region.b()) {
                    result = TextSearch.splitPositions(buffer, new Region(index.e(), region.e()), separators, keepSeparators, spec, inhibs);
                    result.add(new Region(index.b(), index.e()));
                } else if (index.e() == buffer.length()) {
                    result = TextSearch.splitPositions(buffer, new Region(region.b(), index.b()), separators, keepSeparators, spec, inhibs);
                    result.add(new Region(index.b(), index.e()));
                } else if (index.b() > -1) {
                    result = TextSearch.splitPositions(buffer, new Region(region.b(), index.b()), separators, keepSeparators, spec, inhibs);
                    result.add(new Region(index.b(), index.e()));
                    result.addAll(TextSearch.splitPositions(buffer, new Region(index.e(), region.e()), separators, keepSeparators, spec, inhibs));
                }
            } else if (index.b() == 0) {
                result = TextSearch.splitPositions(buffer, new Region(index.e(), region.e()), separators, keepSeparators, spec, inhibs);
            } else if (index.e() == buffer.length()) {
                result = TextSearch.splitPositions(buffer, new Region(region.b(), index.b()), separators, keepSeparators, spec, inhibs);
            } else if (index.b() > -1) {
                result = TextSearch.splitPositions(buffer, new Region(region.b(), index.b()), separators, keepSeparators, spec, inhibs);
                result.addAll(TextSearch.splitPositions(buffer, new Region(index.e(), region.e()), separators, keepSeparators, spec, inhibs));
            }
            ++i;
        }
        if (result == null) {
            result = new LinkedList<Region>();
            result.add(region);
        }
        return result;
    }

    public static Region trim(String buffer, int posBegin, int posEnd) {
        if (posBegin >= 0 && posBegin < buffer.length() && posBegin <= posEnd && posEnd <= buffer.length()) {
            char c;
            int begin = posBegin;
            int end = posEnd;
            while (begin < end) {
                c = buffer.charAt(begin);
                if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
                ++begin;
            }
            while (end > begin) {
                c = buffer.charAt(end - 1);
                if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
                --end;
            }
            if (begin < end) {
                return new Region(begin, end);
            }
        }
        return Region.NOT_FOUND;
    }
}

