/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.sirius.operations;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.AbstractHighlightOperation;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.operations.SiriusFilteredGraphicalUpdateOperation;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.util.BasicRGB;
import org.eclipse.sirius.diagram.BeginLabelStyle;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.CenterLabelStyle;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EndLabelStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.tools.api.command.view.RefreshSiriusElement;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DRefreshable;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class SiriusHighlightOperation
extends SiriusFilteredGraphicalUpdateOperation {
    public SiriusHighlightOperation(Object diagram_p, IPatternInstance instance_p, BasicRGB color_p, int borderSize_p, boolean coverEdges_p, boolean coverNodes_p, boolean coverPorts_p) {
        this(diagram_p, Collections.singleton(instance_p), color_p, borderSize_p, coverEdges_p, coverNodes_p, coverPorts_p);
        this._innerGraphicalOperation = new InnerHighlightOperation(diagram_p, instance_p, color_p, borderSize_p, coverEdges_p, coverNodes_p, coverPorts_p);
    }

    public SiriusHighlightOperation(Object diagram_p, Collection<? extends IPatternInstance> instances_p, BasicRGB color_p, int borderSize_p, boolean coverEdges_p, boolean coverNodes_p, boolean coverPorts_p) {
        super(AbstractHighlightOperation.getName(), diagram_p, instances_p, true, instances_p);
        this._innerGraphicalOperation = new InnerHighlightOperation(diagram_p, instances_p, color_p, borderSize_p, coverEdges_p, coverNodes_p, coverPorts_p);
    }

    protected void update(Object decorator_p, boolean isMerged) {
        this._innerGraphicalOperation.update(decorator_p, isMerged);
    }

    protected class InnerHighlightOperation
    extends AbstractHighlightOperation {
        private InnerHighlightOperation _innerHighlightOperation;

        public InnerHighlightOperation(Object diagram_p, IPatternInstance instance_p, BasicRGB color_p, int borderSize_p, boolean coverEdges_p, boolean coverNodes_p, boolean coverPorts_p) {
            super(diagram_p, instance_p, color_p, borderSize_p, coverEdges_p, coverNodes_p, coverPorts_p);
        }

        public InnerHighlightOperation(Object diagram_p, Collection<? extends IPatternInstance> instances_p, BasicRGB color_p, int borderSize_p, boolean coverEdges_p, boolean coverNodes_p, boolean coverPorts_p) {
            super(diagram_p, instances_p, color_p, borderSize_p, coverEdges_p, coverNodes_p, coverPorts_p);
        }

        public void update(Object decorator_p, boolean isMerged) {
            if (decorator_p instanceof DSemanticDecorator) {
                this._innerHighlightOperation = (InnerHighlightOperation)SiriusHighlightOperation.this._innerGraphicalOperation;
                if (decorator_p instanceof DEdge && this._innerHighlightOperation.isCoverEdges()) {
                    this.updateEdge((DEdge)decorator_p);
                } else if (decorator_p instanceof DNode) {
                    DNode node = (DNode)decorator_p;
                    if (SiriusUtil.isBorderedNode(node)) {
                        if (this._innerHighlightOperation.isCoverPorts()) {
                            this.updateNode(node);
                        }
                    } else if (this._innerHighlightOperation.isCoverNodes()) {
                        this.updateNode(node);
                    }
                } else if (decorator_p instanceof DNodeContainer && this._innerHighlightOperation.isCoverNodes()) {
                    this.updateContainer((DNodeContainer)decorator_p);
                } else if (decorator_p instanceof DNodeList && this._innerHighlightOperation.isCoverNodes()) {
                    this.updateList((DNodeList)decorator_p);
                }
            }
        }

        private void updateContainer(DNodeContainer container_p) {
            if (container_p.getStyle() instanceof BorderedStyle) {
                BorderedStyle style = (BorderedStyle)container_p.getStyle();
                RGBValues highlightColor = this.highlightColor();
                style.setBorderColor(highlightColor);
                style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getBorderedStyle_BorderColor().getName());
                style.setBorderSize(this._innerHighlightOperation.getBorderSize());
                style.setBorderSizeComputationExpression(this._innerHighlightOperation.getBorderSize().toString());
                style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getBorderedStyle_BorderSize().getName());
                style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getBorderedStyle_BorderSizeComputationExpression().getName());
                RefreshSiriusElement.refresh((DRefreshable)style);
            }
        }

        private void updateEdge(DEdge edge_p) {
            if (edge_p.getStyle() instanceof EdgeStyle) {
                EdgeStyle style = (EdgeStyle)edge_p.getStyle();
                if (style.getStrokeColor() != null) {
                    RGBValues highlightColor = this.highlightColor();
                    style.setStrokeColor(highlightColor);
                    style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getEdgeStyle_StrokeColor().getName());
                }
                style.setSize(Integer.valueOf(3));
                style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getEdgeStyle_Size().getName());
                CenterLabelStyle centerlabelStyle = style.getCenterLabelStyle();
                if (centerlabelStyle != null) {
                    this.updateBasicLabelStyle((BasicLabelStyle)centerlabelStyle);
                } else {
                    CenterLabelStyle newLabelStyle = DiagramFactory.eINSTANCE.createCenterLabelStyle();
                    this.highlightBasicLabelStyle((BasicLabelStyle)newLabelStyle);
                    style.setCenterLabelStyle(newLabelStyle);
                }
                BeginLabelStyle beginlabelStyle = style.getBeginLabelStyle();
                if (beginlabelStyle != null) {
                    this.updateBasicLabelStyle((BasicLabelStyle)beginlabelStyle);
                } else {
                    BeginLabelStyle newLabelStyle = DiagramFactory.eINSTANCE.createBeginLabelStyle();
                    this.highlightBasicLabelStyle((BasicLabelStyle)newLabelStyle);
                    style.setBeginLabelStyle(newLabelStyle);
                }
                EndLabelStyle endlabelStyle = style.getEndLabelStyle();
                if (endlabelStyle != null) {
                    this.updateBasicLabelStyle((BasicLabelStyle)endlabelStyle);
                } else {
                    EndLabelStyle newLabelStyle = DiagramFactory.eINSTANCE.createEndLabelStyle();
                    this.highlightBasicLabelStyle((BasicLabelStyle)newLabelStyle);
                    style.setEndLabelStyle(newLabelStyle);
                }
                style.getCustomFeatures().add((Object)ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelColor().getName());
                RefreshSiriusElement.refresh((DRefreshable)style);
            }
        }

        private void updateBasicLabelStyle(BasicLabelStyle labelStyle_p) {
            RGBValues highlightColor = this.highlightColor();
            labelStyle_p.setLabelColor(highlightColor);
            labelStyle_p.getCustomFeatures().add((Object)ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelColor().getName());
        }

        private void updateNode(DNode node_p) {
            if (node_p.getOwnedStyle() instanceof Square) {
                Square style = (Square)node_p.getStyle();
                RGBValues highlightColor = this.highlightColor();
                style.setLabelColor(highlightColor);
                style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getBorderedStyle_BorderColor().getName());
                style.setBorderSize(this._innerHighlightOperation.getBorderSize());
                style.setBorderSizeComputationExpression(this._innerHighlightOperation.getBorderSize().toString());
                style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getBorderedStyle_BorderSize().getName());
                style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getBorderedStyle_BorderSizeComputationExpression().getName());
                RefreshSiriusElement.refresh((DRefreshable)style);
            }
        }

        private RGBValues highlightColor() {
            RGBValues color_p = RGBValues.create((int)this._innerHighlightOperation.getColor().red, (int)this._innerHighlightOperation.getColor().green, (int)this._innerHighlightOperation.getColor().blue);
            return color_p;
        }

        private void highlightBasicLabelStyle(BasicLabelStyle newLabelStyle) {
            RGBValues highlightColor = this.highlightColor();
            newLabelStyle.setLabelColor(highlightColor);
            newLabelStyle.getCustomFeatures().add((Object)ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelColor().getName());
        }

        private void updateList(DNodeList list_p) {
            if (list_p.getStyle() instanceof BorderedStyle) {
                BorderedStyle style = (BorderedStyle)list_p.getStyle();
                RGBValues highlightColor = this.highlightColor();
                style.setBorderColor(highlightColor);
                style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getBorderedStyle_BorderColor().getName());
                style.setBorderSize(this._innerHighlightOperation.getBorderSize());
                style.setBorderSizeComputationExpression(this._innerHighlightOperation.getBorderSize().toString());
                style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getBorderedStyle_BorderSize().getName());
                style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getBorderedStyle_BorderSizeComputationExpression().getName());
                RefreshSiriusElement.refresh((DRefreshable)style);
            }
        }
    }
}

