/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.osgi.util.NLS;
import org.polarsys.kitalpha.emde.extension.ExtendedModel;
import org.polarsys.kitalpha.emde.extension.ExtensibleModel;
import org.polarsys.kitalpha.emde.extension.i18n.Messages;
import org.polarsys.kitalpha.emde.extension.registry.ItemProviderAdapterFactoriesRegistryProvider;
import org.polarsys.kitalpha.emde.extension.registry.URIFactory;
import org.polarsys.kitalpha.emde.extension.utils.Log;

public class ModelExtensionDescriptor {
    private static final Set<String> discardedModels = new HashSet<String>();
    private final Map<String, ExtensibleModel> extensibleModelsKeyURI = new HashMap<String, ExtensibleModel>();
    private final Map<String, ExtendedModel> extendedModelsKeyURI = new HashMap<String, ExtendedModel>();
    public static final ModelExtensionDescriptor INSTANCE = new ModelExtensionDescriptor();

    protected ExtendedModel getExtendedModel(String extendedModel) {
        return this.extendedModelsKeyURI.get(extendedModel);
    }

    public ExtensibleModel getExtensibleModel(String extensibleModel) {
        if (extensibleModel != null && extensibleModel.trim().length() > 0) {
            return this.extensibleModelsKeyURI.get(extensibleModel.trim());
        }
        return null;
    }

    public void loadExtensibleModels() {
        for (Map.Entry<String, URIFactory> entry : ItemProviderAdapterFactoriesRegistryProvider.getItemProviderAdapterFactories().entrySet()) {
            try {
                if (discardedModels.contains(entry.getKey())) continue;
                ExtensibleModel extensibleModel = new ExtensibleModel(entry.getKey(), entry.getValue());
                this.extensibleModelsKeyURI.put(entry.getKey(), extensibleModel);
                Collection descriptors = EMFEditPlugin.getChildCreationExtenderDescriptorRegistry().getDescriptors(entry.getKey());
                if (descriptors == null || descriptors.isEmpty()) continue;
                for (IChildCreationExtender.Descriptor descriptor : descriptors) {
                    String factory;
                    IChildCreationExtender extender;
                    block11: {
                        extender = null;
                        try {
                            extender = descriptor.createChildCreationExtender();
                        }
                        catch (WrappedException e1) {
                            discardedModels.add(entry.getKey());
                            Log.getDefault().logError("Cannot create extender for model:'" + entry.getKey() + "' -> model is discarded.", (Throwable)e1);
                        }
                        catch (Exception exception) {
                            System.out.println();
                        }
                        if (extender == null) continue;
                        factory = null;
                        try {
                            if (extender.getClass().getDeclaringClass() != null) {
                                factory = extender.getClass().getDeclaringClass().getName();
                            }
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            String name = extender.getClass().getName();
                            int indexOf = name.indexOf("$");
                            if (indexOf == -1) break block11;
                            factory = name.substring(0, indexOf);
                        }
                    }
                    if (factory == null) continue;
                    URIFactory uriFactory = ItemProviderAdapterFactoriesRegistryProvider.getURIFactoryFromAdapterFactoryName(factory);
                    if (uriFactory != null) {
                        ExtendedModel extendedModel = new ExtendedModel(extensibleModel, uriFactory.getNsURI(), uriFactory);
                        this.extendedModelsKeyURI.put(uriFactory.getNsURI(), extendedModel);
                        continue;
                    }
                    String msg = NLS.bind((String)Messages.ImplementationRegistryProvider_unknownClass, (Object[])new String[]{ItemProviderAdapterFactoriesRegistryProvider.getName(), extender.getClass().getDeclaringClass().getName()});
                    Log.getDefault().logError(msg);
                }
            }
            catch (Throwable e) {
                Log.getDefault().logError("Cannot load model:" + entry.getKey(), e);
            }
        }
    }

    public Collection<AdapterFactory> getExtendedModelAdapterFactories(String clazz) {
        ArrayList<AdapterFactory> adapterFactories = new ArrayList<AdapterFactory>();
        if (clazz == null || clazz.trim().length() == 0) {
            return adapterFactories;
        }
        clazz = clazz.trim();
        for (ExtensibleModel extensibleModel : this.extensibleModelsKeyURI.values()) {
            if (!extensibleModel.getURIFactory().getAdapterFactoryName().equals(clazz)) continue;
            for (ExtendedModel extendedModel : extensibleModel.getAllExtendedModels()) {
                adapterFactories.add(extendedModel.getAdapterFactory());
            }
        }
        return adapterFactories;
    }

    private ModelExtensionDescriptor() {
        this.loadExtensibleModels();
    }
}

