/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;

public class EclipseGitProgressTransformer
implements ProgressMonitor {
    private static long UPDATE_INTERVAL = TimeUnit.MILLISECONDS.toMillis(100L);
    private final SubMonitor root;
    private String msg;
    private int lastWorked;
    private int lastShown;
    private int totalWork;
    private long lastUpdatedAt;

    public EclipseGitProgressTransformer(IProgressMonitor eclipseMonitor) {
        this.root = SubMonitor.convert((IProgressMonitor)eclipseMonitor);
    }

    public void start(int totalTasks) {
    }

    public void beginTask(String name, int total) {
        this.msg = name;
        this.lastWorked = 0;
        this.lastShown = 0;
        this.lastUpdatedAt = 0L;
        this.totalWork = total <= 0 ? 0 : total;
        this.root.subTask(this.msg);
    }

    public void update(int work) {
        if (work <= 0) {
            return;
        }
        int cmp = this.lastWorked + work;
        if (this.totalWork == 0) {
            long now = System.currentTimeMillis();
            if (now < this.lastUpdatedAt || now - this.lastUpdatedAt > UPDATE_INTERVAL) {
                this.root.subTask(String.valueOf(this.msg) + ", " + cmp);
                this.root.setWorkRemaining(100);
                this.root.worked(1);
                this.lastUpdatedAt = now;
            }
        } else if (this.lastShown == 0 || cmp * 100 / this.totalWork != this.lastShown * 100 / this.totalWork) {
            StringBuilder m = new StringBuilder();
            m.append(this.msg);
            m.append(": ");
            while (m.length() < 25) {
                m.append(' ');
            }
            String twstr = String.valueOf(this.totalWork);
            String cmpstr = String.valueOf(cmp);
            while (cmpstr.length() < twstr.length()) {
                cmpstr = String.valueOf(' ') + cmpstr;
            }
            int pcnt = cmp * 100 / this.totalWork;
            if (pcnt < 100) {
                m.append(' ');
            }
            if (pcnt < 10) {
                m.append(' ');
            }
            m.append(pcnt);
            m.append("% (");
            m.append(cmpstr);
            m.append('/');
            m.append(twstr);
            m.append(')');
            this.root.subTask(m.toString());
            this.root.setWorkRemaining(100);
            this.root.worked(1);
            this.lastShown = cmp;
        }
        this.lastWorked = cmp;
    }

    public void endTask() {
    }

    public boolean isCancelled() {
        return this.root.isCanceled();
    }
}

