/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ga extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ccp = "Seácmais";
        final String metaValue_nqo = "N-cóis";
        final String metaValue_vai = "Vadhais";
        final Object[][] data = new Object[][] {
            { "001", "an Domhan" },
            { "002", "an Afraic" },
            { "003", "Meiriceá Thuaidh" },
            { "005", "Meiriceá Theas" },
            { "009", "an Aigéine" },
            { "011", "Iarthar na hAfraice" },
            { "013", "Meiriceá Láir" },
            { "014", "Oirthear na hAfraice" },
            { "015", "Tuaisceart na hAfraice" },
            { "017", "an Afraic Láir" },
            { "018", "Deisceart na hAfraice" },
            { "019", "Críocha Mheiriceá" },
            { "021", "Tuaisceart Mheiriceá" },
            { "029", "an Mhuir Chairib" },
            { "030", "Oirthear na hÁise" },
            { "034", "Deisceart na hÁise" },
            { "035", "an Áise Thoir Theas" },
            { "039", "Deisceart na hEorpa" },
            { "053", "an Astraláise" },
            { "054", "an Mheilinéis" },
            { "057", "an Réigiún Micrinéiseach" },
            { "061", "an Pholainéis" },
            { "142", "an Áise" },
            { "143", "an Áise Láir" },
            { "145", "Iarthar na hÁise" },
            { "150", "an Eoraip" },
            { "151", "Oirthear na hEorpa" },
            { "154", "Tuaisceart na hEorpa" },
            { "155", "Iarthar na hEorpa" },
            { "202", "an Afraic fho-Shahárach" },
            { "419", "Meiriceá Laidineach" },
            { "AC", "Oileán na Deascabhála" },
            { "AD", "Andóra" },
            { "AE", "Aontas na nÉimíríochtaí Arabacha" },
            { "AF", "an Afganastáin" },
            { "AG", "Antigua agus Barbúda" },
            { "AI", "Angaíle" },
            { "AL", "an Albáin" },
            { "AM", "an Airméin" },
            { "AO", "Angóla" },
            { "AQ", "Antartaice" },
            { "AR", "an Airgintín" },
            { "AS", "Samó Mheiriceá" },
            { "AT", "an Ostair" },
            { "AU", "an Astráil" },
            { "AW", "Arúba" },
            { "AX", "Oileáin Åland" },
            { "AZ", "an Asarbaiseáin" },
            { "BA", "an Bhoisnia agus an Heirseagaivéin" },
            { "BB", "Barbadós" },
            { "BD", "an Bhanglaidéis" },
            { "BE", "an Bheilg" },
            { "BF", "Buircíne Fasó" },
            { "BG", "an Bhulgáir" },
            { "BH", "Bairéin" },
            { "BI", "an Bhurúin" },
            { "BJ", "Beinin" },
            { "BL", "Saint Barthélemy" },
            { "BM", "Beirmiúda" },
            { "BN", "Brúiné" },
            { "BO", "an Bholaiv" },
            { "BQ", "an Ísiltír Chairibeach" },
            { "BR", "an Bhrasaíl" },
            { "BS", "na Bahámaí" },
            { "BT", "an Bhútáin" },
            { "BV", "Oileán Bouvet" },
            { "BW", "an Bhotsuáin" },
            { "BY", "an Bhealarúis" },
            { "BZ", "an Bheilís" },
            { "CA", "Ceanada" },
            { "CC", "Oileáin Cocos (Keeling)" },
            { "CD", "Poblacht Dhaonlathach an Chongó" },
            { "CF", "Poblacht na hAfraice Láir" },
            { "CG", "Congó-Brazzaville" },
            { "CH", "an Eilvéis" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Oileáin Cook" },
            { "CL", "an tSile" },
            { "CM", "Camarún" },
            { "CN", "an tSín" },
            { "CO", "an Cholóim" },
            { "CP", "Oileán Clipperton" },
            { "CQ", "an tSairc" },
            { "CR", "Cósta Ríce" },
            { "CU", "Cúba" },
            { "CV", "Poblacht Cabo Verde" },
            { "CW", "Cúrasó" },
            { "CX", "Oileán na Nollag" },
            { "CY", "an Chipir" },
            { "CZ", "an tSeicia" },
            { "DE", "an Ghearmáin" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "an Danmhairg" },
            { "DM", "Doiminice" },
            { "DO", "an Phoblacht Dhoiminiceach" },
            { "DZ", "an Ailgéir" },
            { "EA", "Ceuta agus Melilla" },
            { "EC", "Eacuadór" },
            { "EE", "an Eastóin" },
            { "EG", "an Éigipt" },
            { "EH", "an Sahára Thiar" },
            { "ER", "an Eiritré" },
            { "ES", "an Spáinn" },
            { "ET", "an Aetóip" },
            { "EU", "an tAontas Eorpach" },
            { "EZ", "Limistéar an euro" },
            { "FI", "an Fhionlainn" },
            { "FJ", "Fidsí" },
            { "FK", "Oileáin Fháclainne" },
            { "FM", "an Mhicrinéis" },
            { "FO", "Oileáin Fharó" },
            { "FR", "an Fhrainc" },
            { "GA", "an Ghabúin" },
            { "GB", "an Ríocht Aontaithe" },
            { "GD", "Greanáda" },
            { "GE", "an tSeoirsia" },
            { "GF", "Guáin na Fraince" },
            { "GG", "Geansaí" },
            { "GH", "Gána" },
            { "GI", "Giobráltar" },
            { "GL", "an Ghraonlainn" },
            { "GM", "an Ghaimbia" },
            { "GN", "an Ghuine" },
            { "GP", "Guadalúip" },
            { "GQ", "an Ghuine Mheánchiorclach" },
            { "GR", "an Ghréig" },
            { "GS", "An tSeoirsia Theas agus Oileáin Sandwich Theas" },
            { "GT", "Guatamala" },
            { "GU", "Guam" },
            { "GW", "Guine Bissau" },
            { "GY", "An Ghuáin" },
            { "HK", "Sainréigiún Riaracháin Hong Cong, Daonphoblacht na Síne" },
            { "HM", "Oileán Heard agus Oileáin McDonald" },
            { "HN", "Hondúras" },
            { "HR", "an Chróit" },
            { "HT", "Háítí" },
            { "HU", "an Ungáir" },
            { "IC", "na hOileáin Chanáracha" },
            { "ID", "an Indinéis" },
            { "IE", "Éire" },
            { "IL", "Iosrael" },
            { "IM", "Oileán Mhanann" },
            { "IN", "an India" },
            { "IO", "Críoch Aigéan Indiach na Breataine" },
            { "IQ", "an Iaráic" },
            { "IR", "an Iaráin" },
            { "IS", "an Íoslainn" },
            { "IT", "an Iodáil" },
            { "JE", "Geirsí" },
            { "JM", "Iamáice" },
            { "JO", "an Iordáin" },
            { "JP", "an tSeapáin" },
            { "KE", "an Chéinia" },
            { "KG", "an Chirgeastáin" },
            { "KH", "an Chambóid" },
            { "KI", "Ciribeas" },
            { "KM", "Oileáin Chomóra" },
            { "KN", "San Críostóir-Nimheas" },
            { "KP", "an Chóiré Thuaidh" },
            { "KR", "an Chóiré Theas" },
            { "KW", "Cuáit" },
            { "KY", "Oileáin Cayman" },
            { "KZ", "an Chasacstáin" },
            { "LA", "Laos" },
            { "LB", "an Liobáin" },
            { "LC", "Saint Lucia" },
            { "LI", "Lichtinstéin" },
            { "LK", "Srí Lanca" },
            { "LR", "an Libéir" },
            { "LS", "Leosóta" },
            { "LT", "an Liotuáin" },
            { "LU", "Lucsamburg" },
            { "LV", "an Laitvia" },
            { "LY", "an Libia" },
            { "MA", "Maracó" },
            { "MC", "Monacó" },
            { "MD", "an Mholdóiv" },
            { "ME", "Montainéagró" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagascar" },
            { "MH", "Oileáin Marshall" },
            { "MK", "an Mhacadóin Thuaidh" },
            { "ML", "Mailí" },
            { "MM", "Maenmar (Burma)" },
            { "MN", "an Mhongóil" },
            { "MO", "Sainréigiún Riaracháin Macao, Daonphoblacht na Síne" },
            { "MP", "Na hOileáin Mháirianacha Thuaidh" },
            { "MQ", "Martinique" },
            { "MR", "an Mháratáin" },
            { "MS", "Montsarat" },
            { "MT", "Málta" },
            { "MU", "Oileán Mhuirís" },
            { "MV", "Oileáin Mhaildíve" },
            { "MW", "an Mhaláiv" },
            { "MX", "Meicsiceo" },
            { "MY", "an Mhalaeisia" },
            { "MZ", "Mósaimbíc" },
            { "NA", "an Namaib" },
            { "NC", "an Nua-Chaladóin" },
            { "NE", "an Nígir" },
            { "NF", "Oileán Norfolk" },
            { "NG", "an Nigéir" },
            { "NI", "Nicearagua" },
            { "NL", "an Ísiltír" },
            { "NO", "an Iorua" },
            { "NP", "Neipeal" },
            { "NR", "Nárú" },
            { "NU", "Niue" },
            { "NZ", "an Nua-Shéalainn" },
            { "OM", "Óman" },
            { "PA", "Panama" },
            { "PE", "Peiriú" },
            { "PF", "Polainéis na Fraince" },
            { "PG", "Nua-Ghuine Phapua" },
            { "PH", "Na hOileáin Fhilipíneacha" },
            { "PK", "an Phacastáin" },
            { "PL", "an Pholainn" },
            { "PM", "San Pierre agus Miquelon" },
            { "PN", "Oileáin Pitcairn" },
            { "PR", "Pórtó Ríce" },
            { "PS", "na Críocha Palaistíneacha" },
            { "PT", "an Phortaingéil" },
            { "PW", "Oileáin Palau" },
            { "PY", "Paragua" },
            { "QA", "Catar" },
            { "QO", "an Aigéine Imeallach" },
            { "RE", "La Réunion" },
            { "RO", "an Rómáin" },
            { "RS", "an tSeirbia" },
            { "RU", "an Rúis" },
            { "RW", "Ruanda" },
            { "SA", "an Araib Shádach" },
            { "SB", "Oileáin Sholaimh" },
            { "SC", "na Séiséil" },
            { "SD", "an tSúdáin" },
            { "SE", "an tSualainn" },
            { "SG", "Singeapór" },
            { "SH", "San Héilin" },
            { "SI", "an tSlóivéin" },
            { "SJ", "Svalbard agus Jan Mayen" },
            { "SK", "an tSlóvaic" },
            { "SL", "Siarra Leon" },
            { "SM", "San Mairíne" },
            { "SN", "an tSeineagáil" },
            { "SO", "an tSomáil" },
            { "SR", "Suranam" },
            { "SS", "an tSúdáin Theas" },
            { "ST", "São Tomé agus Príncipe" },
            { "SV", "An tSalvadóir" },
            { "SX", "Sint Maarten" },
            { "SY", "an tSiria" },
            { "SZ", "Esuaitíní" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Oileáin na dTurcach agus Caicos" },
            { "TD", "Sead" },
            { "TF", "Críocha Francacha Dheisceart an Domhain" },
            { "TG", "Tóga" },
            { "TH", "an Téalainn" },
            { "TJ", "an Táidsíceastáin" },
            { "TK", "Tócalá" },
            { "TL", "Tíomór Thoir" },
            { "TM", "an Tuircméanastáin" },
            { "TN", "an Tuinéis" },
            { "TO", "Tonga" },
            { "TR", "an Tuirc" },
            { "TT", "Oileán na Tríonóide agus Tobága" },
            { "TV", "Túvalú" },
            { "TW", "an Téaváin" },
            { "TZ", "an Tansáin" },
            { "UA", "an Úcráin" },
            { "UG", "Uganda" },
            { "UM", "Oileáin Imeallacha S.A.M." },
            { "UN", "na Náisiúin Aontaithe" },
            { "US", "Stáit Aontaithe Mheiriceá" },
            { "UY", "Uragua" },
            { "UZ", "an Úisbéiceastáin" },
            { "VA", "Cathair na Vatacáine" },
            { "VC", "San Uinseann agus na Greanáidíní" },
            { "VE", "Veiniséala" },
            { "VG", "Oileáin Bhriotanacha na Maighdean" },
            { "VI", "Oileáin Mheiriceánacha na Maighdean" },
            { "VN", "Vítneam" },
            { "VU", "Vanuatú" },
            { "WF", "Vailís agus Futúna" },
            { "WS", "Samó" },
            { "XA", "Bréagaicinn" },
            { "XB", "Bréag-Bidi" },
            { "XK", "an Chosaiv" },
            { "YE", "Éimin" },
            { "YT", "Mayotte" },
            { "ZA", "an Afraic Theas" },
            { "ZM", "an tSaimbia" },
            { "ZW", "an tSiombáib" },
            { "ZZ", "Réigiún Anaithnid" },
            { "aa", "Afáiris" },
            { "ab", "Abcáisis" },
            { "ae", "Aivéistis" },
            { "af", "Afracáinis" },
            { "ak", "Acáinis" },
            { "am", "Amáiris" },
            { "an", "Aragóinis" },
            { "ar", "Araibis" },
            { "as", "Asaimis" },
            { "av", "Aváiris" },
            { "ay", "Aidhmiris" },
            { "az", "Asarbaiseáinis" },
            { "ba", "Baiscíris" },
            { "be", "Bealarúisis" },
            { "bg", "Bulgáiris" },
            { "bi", "Bioslaimis" },
            { "bm", "Bambairis" },
            { "bn", "Beangáilis" },
            { "bo", "Tibéidis" },
            { "br", "Briotáinis" },
            { "bs", "Boisnis" },
            { "ca", "Catalóinis" },
            { "ce", "Seisnis" },
            { "ch", "Seamóiris" },
            { "co", "Corsaicis" },
            { "cr", "Craís" },
            { "cs", "Seicis" },
            { "cu", "Slavais na hEaglaise" },
            { "cv", "Suvaisis" },
            { "cy", "Breatnais" },
            { "da", "Danmhairgis" },
            { "de", "Gearmáinis" },
            { "dv", "Divéihis" },
            { "dz", "Seoinicis" },
            { "ee", "Éabhais" },
            { "el", "Gréigis" },
            { "en", "Béarla" },
            { "eo", "Esperanto" },
            { "es", "Spáinnis" },
            { "et", "Eastóinis" },
            { "eu", "Bascais" },
            { "fa", "Peirsis" },
            { "ff", "Fuláinis" },
            { "fi", "Fionlainnis" },
            { "fj", "Fidsis" },
            { "fo", "Faróis" },
            { "fr", "Fraincis" },
            { "fy", "Freaslainnis Iartharach" },
            { "ga", "Gaeilge" },
            { "gd", "Gaeilge na hAlban" },
            { "gl", "Gailísis" },
            { "gn", "Guaráinis" },
            { "gu", "Gúisearáitis" },
            { "gv", "Manainnis" },
            { "ha", "Hásais" },
            { "he", "Eabhrais" },
            { "hi", "Hiondúis" },
            { "ho", "Motúis Hírí" },
            { "hr", "Cróitis" },
            { "ht", "Críol Háítí" },
            { "hu", "Ungáiris" },
            { "hy", "Airméinis" },
            { "hz", "Heiréiris" },
            { "ia", "Interlingua" },
            { "id", "Indinéisis" },
            { "ie", "Interlingue" },
            { "ig", "Íogbóis" },
            { "ii", "Ís Sichuan" },
            { "ik", "Iniúipiaicis" },
            { "io", "Ídis" },
            { "is", "Íoslainnis" },
            { "it", "Iodáilis" },
            { "iu", "Ionúitis" },
            { "ja", "Seapáinis" },
            { "jv", "Iáivis" },
            { "ka", "Seoirsis" },
            { "kg", "Congóis" },
            { "ki", "Ciocúis" },
            { "kj", "Cuainiáimis" },
            { "kk", "Casaicis" },
            { "kl", "Kalaallisut" },
            { "km", "Ciméiris" },
            { "kn", "Cannadais" },
            { "ko", "Cóiréis" },
            { "kr", "Canúiris" },
            { "ks", "Caismíris" },
            { "ku", "Curmainsis" },
            { "kv", "Coimis" },
            { "kw", "Coirnis" },
            { "ky", "Cirgisis" },
            { "la", "Laidin" },
            { "lb", "Lucsambuirgis" },
            { "lg", "Lugandais" },
            { "li", "Liombuirgis" },
            { "ln", "Liongáilis" },
            { "lo", "Laoisis" },
            { "lt", "Liotuáinis" },
            { "lu", "Lúba-Cataingis" },
            { "lv", "Laitvis" },
            { "mg", "Malagáisis" },
            { "mh", "Mairsillis" },
            { "mi", "Maorais" },
            { "mk", "Macadóinis" },
            { "ml", "Mailéalaimis" },
            { "mn", "Mongóilis" },
            { "mr", "Maraitis" },
            { "ms", "Malaeis" },
            { "mt", "Máltais" },
            { "my", "Burmais" },
            { "na", "Nárúis" },
            { "nb", "Bocmál" },
            { "nd", "N-deibéilis an Tuaiscirt" },
            { "ne", "Neipeailis" },
            { "ng", "Ndongais" },
            { "nl", "Ollainnis" },
            { "nn", "Nua-Ioruais" },
            { "no", "Ioruais" },
            { "nr", "Ndeibéilis an Deiscirt" },
            { "nv", "Navachóis" },
            { "ny", "Siséivis" },
            { "oc", "Ocsatáinis" },
            { "oj", "Óisibis" },
            { "om", "Oraimis" },
            { "or", "Oirísis" },
            { "os", "Oiséitis" },
            { "pa", "Puinseáibis" },
            { "pi", "Páilis" },
            { "pl", "Polainnis" },
            { "ps", "Paistis" },
            { "pt", "Portaingéilis" },
            { "qu", "Ceatsuais" },
            { "rm", "Rómainis" },
            { "rn", "Rúindis" },
            { "ro", "Rómáinis" },
            { "ru", "Rúisis" },
            { "rw", "Ciniaruaindis" },
            { "sa", "Sanscrait" },
            { "sc", "Sairdínis" },
            { "sd", "Sindis" },
            { "se", "Sáimis an Tuaiscirt" },
            { "sg", "Sangóis" },
            { "sh", "Seirbea-Chróitis" },
            { "si", "Siolóinis" },
            { "sk", "Slóvaicis" },
            { "sl", "Slóivéinis" },
            { "sm", "Samóis" },
            { "sn", "Seoinis" },
            { "so", "Somáilis" },
            { "sq", "Albáinis" },
            { "sr", "Seirbis" },
            { "ss", "Suaisis" },
            { "st", "Sútúis an Deiscirt" },
            { "su", "Sundais" },
            { "sv", "Sualainnis" },
            { "sw", "Svahaílis" },
            { "ta", "Tamailis" },
            { "te", "Teileagúis" },
            { "tg", "Taidsícis" },
            { "th", "Téalainnis" },
            { "ti", "Tigrinis" },
            { "tk", "Tuircméinis" },
            { "tl", "Tagálaigis" },
            { "tn", "Suáinis" },
            { "to", "Tongais" },
            { "tr", "Tuircis" },
            { "ts", "Songais" },
            { "tt", "Tatairis" },
            { "tw", "Tíbhis" },
            { "ty", "Taihítis" },
            { "ug", "Uigiúiris" },
            { "uk", "Úcráinis" },
            { "ur", "Urdúis" },
            { "uz", "Úisbéiceastáinis" },
            { "ve", "Veindis" },
            { "vi", "Vítneaimis" },
            { "vo", "Volapük" },
            { "wa", "Vallúnais" },
            { "wo", "Volaifis" },
            { "xh", "Cóisis" },
            { "yi", "Giúdais" },
            { "yo", "Iarúibis" },
            { "za", "Siuáingis" },
            { "zh", "Sínis" },
            { "zu", "Súlúis" },
            { "ace", "Aicinéis" },
            { "ada", "Daingmis" },
            { "ady", "Adaigéis" },
            { "agq", "Aigeimis" },
            { "ain", "Aidhniúis" },
            { "akk", "Acáidis" },
            { "ale", "Ailiúitis" },
            { "alt", "Altaeis an Deiscirt" },
            { "ang", "Sean-Bhéarla" },
            { "ann", "Obolo" },
            { "anp", "Aingícis" },
            { "arc", "Aramais" },
            { "arn", "Mapúitsis" },
            { "arp", "Arapachóis" },
            { "ars", "Araibis Najdi" },
            { "asa", "Asúis" },
            { "ast", "Astúiris" },
            { "atj", "Atikamekw" },
            { "awa", "Avaidis" },
            { "bal", "Balúitsis" },
            { "ban", "Bailís" },
            { "bar", "Baváiris" },
            { "bas", "Basáis" },
            { "bem", "Beimbis" },
            { "bez", "Beinis" },
            { "bgc", "Haryanvi" },
            { "bho", "Vóispiris" },
            { "bin", "Binis" },
            { "bla", "Sicsicis" },
            { "blo", "Anii" },
            { "brx", "Bódóis" },
            { "bua", "Buiriáitis" },
            { "bug", "Buiginis" },
            { "byn", "Blinis" },
            { "cay", "teanga Cayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "Seabúáinis" },
            { "cgg", "Cígis" },
            { "chk", "Siúicísis" },
            { "chm", "Mairis" },
            { "cho", "Seactáis" },
            { "chp", "Siopúáinis" },
            { "chr", "Seiricis" },
            { "chy", "Siáinis" },
            { "ckb", "Coirdis Lárnach" },
            { "clc", "Chilcotin" },
            { "cop", "Coptais" },
            { "crg", "Michif" },
            { "crj", "Craís an Deiscirt Thoir" },
            { "crk", "Plains Cree" },
            { "crl", "Craís Thoir Thuaidh" },
            { "crm", "Moose Cree" },
            { "crr", "teanga Algancach Carolina" },
            { "crs", "Criól Fraincise Seselwa" },
            { "csb", "Caisiúibis" },
            { "csw", "Craís na gCorcach" },
            { "dak", "Dacótais" },
            { "dar", "Dargais" },
            { "dav", "Taita" },
            { "dgr", "Dograibis" },
            { "dje", "Zarmais" },
            { "doi", "Dóigris" },
            { "dsb", "Sorbais Íochtarach" },
            { "dua", "Duailis" },
            { "dum", "Meán-Ollainnis" },
            { "dyo", "Jóla-Fainis" },
            { "dzg", "Dazaga" },
            { "ebu", "Ciambúis" },
            { "efi", "Eificis" },
            { "egy", "Sean-Éigiptis" },
            { "eka", "Acaidiúcais" },
            { "enm", "Meán-Bhéarla" },
            { "ewo", "Éabhandóis" },
            { "fil", "Filipínis" },
            { "fon", "Fonais" },
            { "frc", "Fraincis Cajun" },
            { "frm", "Meán-Fhraincis" },
            { "fro", "Sean-Fhraincis" },
            { "frr", "Freaslainnis an Tuaiscirt" },
            { "fur", "Friúilis" },
            { "gaa", "Geáis" },
            { "gan", "Sínis Gan" },
            { "gez", "Aetóipis" },
            { "gil", "Gilbeartais" },
            { "gmh", "Meán-Ard-Ghearmáinis" },
            { "goh", "Sean-Ard-Ghearmáinis" },
            { "gor", "Gorantalais" },
            { "grc", "Sean-Ghréigis" },
            { "gsw", "Gearmáinis Eilvéiseach" },
            { "guc", "Uaúis" },
            { "guz", "Gúsaís" },
            { "gwi", "Goitsinis" },
            { "hai", "Haídis" },
            { "hak", "Haicéis" },
            { "haw", "Haváis" },
            { "hax", "Haídis an Deiscirt" },
            { "hif", "Hiondúis Fhidsí" },
            { "hil", "Hilgeanóinis" },
            { "hit", "Hitis" },
            { "hmn", "Hmongais" },
            { "hsb", "Sorbais Uachtarach" },
            { "hsn", "Sínis Xiang" },
            { "hup", "Húipis" },
            { "hur", "Halkomelem" },
            { "iba", "Ibeainis" },
            { "ibb", "Ibibis" },
            { "ikt", "Ionúitis Iarthar Cheanada" },
            { "ilo", "Ileacáinis" },
            { "inh", "Iongúis" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jut", "Iútlainnis" },
            { "kaa", "Cara-Chalpáis" },
            { "kab", "Caibílis" },
            { "kac", "Caitsinis" },
            { "kaj", "Jju" },
            { "kam", "Cambais" },
            { "kbd", "Cabairdis" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Criól Cabo Verde" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Caisis" },
            { "khq", "Songais Iartharach" },
            { "kkj", "Cacóis" },
            { "kln", "Kalenjin" },
            { "kmb", "Ciombundais" },
            { "kok", "Concáinis" },
            { "kpe", "Caipeilis" },
            { "krc", "Caraicí-Balcáiris" },
            { "krl", "Cairéilis" },
            { "kru", "Curúicis" },
            { "ksb", "Shambala" },
            { "ksf", "Baifiais" },
            { "ksh", "Coilsis" },
            { "kum", "Cúimicis" },
            { "kwk", "Kwakʼwala" },
            { "kxv", "Kuvi" },
            { "lad", "Laidínis" },
            { "lag", "Ciolaingis" },
            { "lah", "Puinseáibis Iartharach" },
            { "lez", "Leisgis" },
            { "lij", "Liogúiris" },
            { "lil", "Lillooet" },
            { "liv", "Liovóinis" },
            { "lkt", "Lacótais" },
            { "lmo", "Lombairdis" },
            { "lou", "Criól Louisiana" },
            { "loz", "Lóisis" },
            { "lrc", "Lúiris an Tuaiscirt" },
            { "lsm", "Saamia" },
            { "lua", "Luba-Lulua" },
            { "lun", "Lundais" },
            { "luo", "Lúóis" },
            { "lus", "Míosóis" },
            { "luy", "Luyia" },
            { "mad", "Maidiúiris" },
            { "mag", "Magaidis" },
            { "mai", "Maitilis" },
            { "mak", "Macasairis" },
            { "mas", "Másais" },
            { "mdf", "Mocsais" },
            { "men", "Meindis" },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Meán-Ghaeilge" },
            { "mgh", "Meiteo-Macuais" },
            { "mgo", "Metaʼ" },
            { "mic", "Micmeaicis" },
            { "min", "Míneangcababhais" },
            { "mni", "Manapúiris" },
            { "moe", "Innu-aimun" },
            { "moh", "Móháicis" },
            { "mos", "Mosais" },
            { "mrj", "Mairis Iartharach" },
            { "mua", "Mundang" },
            { "mul", "Ilteangacha" },
            { "mus", "Muscogee" },
            { "mwl", "Mioraindéis" },
            { "mwr", "Marmhairis" },
            { "myv", "Éirsis" },
            { "mzn", "Mázandaráinis" },
            { "nan", "Sínis Min Nan" },
            { "nap", "Napóilis" },
            { "naq", "Nama" },
            { "nds", "Gearmáinis Íochtarach" },
            { "new", "Néamharais" },
            { "nia", "Niaisis" },
            { "niu", "Níobhais" },
            { "nmg", "Cuaiseois" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nógaeis" },
            { "non", "Sean-Lochlainnis" },
            { "nqo", metaValue_nqo },
            { "nso", "Sútúis an Tuaiscirt" },
            { "nus", "Nuairis" },
            { "nyn", "Niancóilis" },
            { "ojb", "Óisibis Iarthuiscirt" },
            { "ojc", "Óisibis Lárnach" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Óisibis an Iarthar" },
            { "oka", "Okanagan" },
            { "pag", "Pangasaíneánais" },
            { "pam", "Pampaingis" },
            { "pap", "Paipeamaintis" },
            { "pau", "Palabhais" },
            { "pcm", "Pidsean na Nigéire" },
            { "peo", "Sean-Pheirsis" },
            { "pis", "Pijin" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Prúisis" },
            { "quc", "Cuitséis" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanúis" },
            { "rar", "Raratongais" },
            { "rhg", "Róihinis" },
            { "rof", "Rombo" },
            { "rom", "Romainis" },
            { "rup", "Arómáinis" },
            { "rwk", "Rwa" },
            { "sad", "Sandabhais" },
            { "sah", "Sachais" },
            { "sam", "Aramais Shamárach" },
            { "saq", "Samburu" },
            { "sat", "Santáilis" },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sicilis" },
            { "sco", "Albainis" },
            { "seh", "Sena" },
            { "ses", "Songais Oirthearach" },
            { "sga", "Sean-Ghaeilge" },
            { "shi", "Tachelhit" },
            { "shn", "Seánais" },
            { "slh", "Lushootseed an Deiscirt" },
            { "sma", "Sáimis Theas" },
            { "smj", "Sáimis Lule" },
            { "smn", "Sáimis Inari" },
            { "sms", "Sáimis Skolt" },
            { "snk", "Soinincéis" },
            { "sog", "Sogdánais" },
            { "srn", "Suranaimis" },
            { "str", "Straits Salish" },
            { "suk", "Sucúimis" },
            { "sux", "Suiméiris" },
            { "swb", "teanga na gComórach" },
            { "syr", "Siricis" },
            { "szl", "Siléisis" },
            { "tce", "Tutchone an Deiscirt" },
            { "tem", "Teimnis" },
            { "teo", "Teso" },
            { "tet", "Teitimis" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigréis" },
            { "tlh", "Klingon" },
            { "tli", "Clincitis" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "ttm", "Northern Tutchone" },
            { "tum", "Tumbúicis" },
            { "tvl", "Tuvalu" },
            { "twq", "Tasawaq" },
            { "tyv", "Túvainis" },
            { "tzm", "Tamaisis Atlais Láir" },
            { "udm", "Udmairtis" },
            { "umb", "Umbundais" },
            { "und", "Teanga anaithnid" },
            { "vai", metaValue_vai },
            { "vec", "Veinéisis" },
            { "vls", "Pléimeannais Iartharach" },
            { "vmw", "Macuais" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Uailéitis" },
            { "war", "Uairéis" },
            { "wuu", "Sínis Wu" },
            { "xal", "Cailmícis" },
            { "xnr", "Kangri" },
            { "xog", "Soga" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Cantainis" },
            { "zea", "Séalainnis" },
            { "zgh", "Tamaisis Chaighdeánach Mharacó" },
            { "zun", "Zúinis" },
            { "zxx", "Gan ábhar teangeolaíoch" },
            { "zza", "Zázá" },
            { "Adlm", "Adlam" },
            { "Aghb", "Albánach Cugasach" },
            { "Arab", "Arabach" },
            { "Aran", "Nastaliq" },
            { "Armi", "Aramach Impiriúil" },
            { "Armn", "Airméanach" },
            { "Avst", "Aivéisteach" },
            { "Bali", "Bailíoch" },
            { "Bamu", "Bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batacach" },
            { "Beng", "Beangálach" },
            { "Bhks", "Bhaiksuki" },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brámais" },
            { "Brai", "Braille" },
            { "Bugi", "Buigineach" },
            { "Buhd", "Buthaideach" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Siollach Bundúchasach Ceanadach Aontaithe" },
            { "Cari", "Cló Cairiach" },
            { "Cher", "Seiricíoch" },
            { "Copt", "Coptach" },
            { "Cprt", "Cipireach" },
            { "Cyrl", "Coireallach" },
            { "Deva", "Déiveanágrach" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Gearrscríobh Duployan" },
            { "Egyd", "Éigipteach coiteann" },
            { "Egyh", "Éigipteach cliarúil" },
            { "Egyp", "Iairiglifí Éigipteacha" },
            { "Elba", "Elbasan" },
            { "Ethi", "Aetóipice" },
            { "Geor", "Seoirseach" },
            { "Glag", "Glagalach" },
            { "Gonm", "Masaram Gondi" },
            { "Goth", "Gotach" },
            { "Gran", "Grantha" },
            { "Grek", "Gréagach" },
            { "Gujr", "Gúisearátach" },
            { "Guru", "Gurmúcach" },
            { "Hanb", "Han agus Bopomofo" },
            { "Hang", "Hangalach" },
            { "Hani", "Han" },
            { "Hano", "Hananúis" },
            { "Hans", "Simplithe" },
            { "Hant", "Traidisiúnta" },
            { "Hatr", "Hatran" },
            { "Hebr", "Eabhrach" },
            { "Hira", "Hireagánach" },
            { "Hluw", "Iairiglifí Anatólacha" },
            { "Hmng", "Pahawh Hmong" },
            { "Hrkt", "Siollabraí Seapánacha" },
            { "Hung", "Sean-Ungárach" },
            { "Ital", "Sean-Iodáilic" },
            { "Jamo", "Seamó" },
            { "Java", "Iávach" },
            { "Jpan", "Seapánach" },
            { "Kali", "Kayah Li" },
            { "Kana", "Catacánach" },
            { "Khar", "Kharoshthi" },
            { "Khmr", "Ciméarach" },
            { "Khoj", "Khojki" },
            { "Knda", "Cannadach" },
            { "Kore", "Cóiréach" },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", "Laosach" },
            { "Latg", "Cló Gaelach" },
            { "Latn", "Laidineach" },
            { "Lepc", "Lepcha" },
            { "Limb", "Liombúch" },
            { "Lina", "Líneach A" },
            { "Linb", "Líneach B" },
            { "Lisu", "Fraser" },
            { "Lyci", "Liciach" },
            { "Lydi", "Lidiach" },
            { "Mahj", "Mahasánach" },
            { "Mand", "Mandaean" },
            { "Mani", "Mainicéasach" },
            { "Marc", "Marchen" },
            { "Maya", "Iairiglifí Máigheacha" },
            { "Mend", "Meindeach" },
            { "Merc", "Meroitic Cursive" },
            { "Mero", "Meroitic" },
            { "Mlym", "Mailéalamach" },
            { "Mong", "Mongólach" },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei Mayek" },
            { "Mult", "Multani" },
            { "Mymr", "Maenmarach" },
            { "Narb", "Sean-Arabach Thuaidh" },
            { "Nbat", "Nabataean" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "Nüshu" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orkhon" },
            { "Orya", "Oiríseach" },
            { "Osge", "Ósáis" },
            { "Osma", "Osmanya" },
            { "Palm", "Palmyrene" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Sean-Pheirmeach" },
            { "Phag", "Phags-pa" },
            { "Phli", "Pachlavais Inscríbhinne" },
            { "Phlp", "Pachlavais Saltrach" },
            { "Phnx", "Féiníceach" },
            { "Plrd", "Pollard Foghrach" },
            { "Prti", "Pairtiach Inscríbhinniúil" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi" },
            { "Runr", "Rúnach" },
            { "Samr", "Samárach" },
            { "Sarb", "Sean-Arabach Theas" },
            { "Saur", "Saurashtra" },
            { "Sgnw", "Litritheoireacht Comharthaí" },
            { "Shaw", "Shawach" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudawadi" },
            { "Sinh", "Siolónach" },
            { "Sora", "Sora Sompeng" },
            { "Soyo", "Soyombo" },
            { "Sund", "Sundainéis" },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", "Siriceach" },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Deiheoingis" },
            { "Talu", "Tai Lue Nua" },
            { "Taml", "Tamalach" },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Telu", "Teileagúch" },
            { "Tfng", "Tifinagh" },
            { "Tglg", "Tagálagach" },
            { "Thaa", "Tánach" },
            { "Thai", "Téalannach" },
            { "Tibt", "Tibéadach" },
            { "Tirh", "Tirhuta" },
            { "Ugar", "Úgairíteach" },
            { "Vaii", metaValue_vai },
            { "Wara", "Varang Kshiti" },
            { "Xpeo", "Sean-Pheirseach" },
            { "Xsux", "Dingchruthach Suiméar-Acádach" },
            { "Yiii", "Ís" },
            { "Zanb", "Zanabazar Square" },
            { "Zinh", "Oidhreacht" },
            { "Zmth", "Nodaireacht Mhatamaiticiúil" },
            { "Zsye", "Emoji" },
            { "Zsym", "Siombailí" },
            { "Zxxx", "Neamhscríofa" },
            { "Zyyy", "Coitianta" },
            { "Zzzz", "Script Anaithnid" },
            { "de_AT", "Gearmáinis na hOstaire" },
            { "de_CH", "Ard-Ghearmáinis Eilvéiseach" },
            { "en_AU", "Béarla na hAstráile" },
            { "en_CA", "Béarla Cheanada" },
            { "en_GB", "Béarla na Breataine" },
            { "en_US", "Béarla Mheiriceá" },
            { "es_ES", "Spáinnis Eorpach" },
            { "es_MX", "Spáinnis Mheicsiceach" },
            { "fa_AF", "Dairis" },
            { "fr_CA", "Fraincis Cheanada" },
            { "fr_CH", "Fraincis na hEilvéise" },
            { "nl_BE", "Pléimeannais" },
            { "pt_BR", "Portaingéilis Bhrasaíleach" },
            { "pt_PT", "Portaingéilis Ibéarach" },
            { "ro_MD", "Moldáivis" },
            { "sw_CD", "Svahaílis an Chongó" },
            { "%%1901", "Litriú Traidisiúnta na Gearmáinise" },
            { "%%1994", "Ortagrafaíocht Resian Chaighdeánaithe" },
            { "%%1996", "Ortagrafaíocht na Gearmáinise in 1996" },
            { "ar_001", "Araibis Chaighdeánach" },
            { "es_419", "Spáinnis Mheiriceá Laidinigh" },
            { "key.ca", "Féilire" },
            { "key.cf", "Formáid Airgeadra" },
            { "key.co", "Ord Sórtála" },
            { "key.cu", "Airgeadra" },
            { "key.em", "Léiriú mar Emoji" },
            { "key.hc", "Timthriall Uaire (12 vs 24)" },
            { "key.lb", "Déine Briste Líne" },
            { "key.lw", "Bristeacha Líne laistigh d’Fhocail" },
            { "key.ms", "Córas Tomhais" },
            { "key.nu", "Uimhreacha" },
            { "key.ss", "Briseadh Frása tar éis Giorrúcháin" },
            { "nds_NL", "Sacsainis Íochtarach" },
            { "%%ALUKU", "Canúint Aluku" },
            { "%%BARLA", "Grúpa canúna Barlavento de Kabuverdianu" },
            { "%%BISKE", "Canúint San Giorgo/Bila" },
            { "%%BOONT", "Boontling" },
            { "%%CORNU", "Béarla an Choirn" },
            { "%%JAUER", "Jauer" },
            { "%%KKCOR", "Gnáth-Litriú" },
            { "%%KSCOR", "Litriú Caighdeánach" },
            { "%%LIPAW", "Canúint Lipovaz de Resian" },
            { "%%NEDIS", "Canúint Natisone" },
            { "%%NJIVA", "Canúint Gniva/Njiva" },
            { "%%NULIK", "Volapük Nua-Aimseartha" },
            { "%%OSOJS", "Canúint Oseacco/Osojane" },
            { "%%POSIX", "Ríomhaire" },
            { "%%PUTER", "Puter" },
            { "%%RIGIK", "Volapük Clasaiceach" },
            { "%%ROZAJ", "Reisiach" },
            { "%%RUMGR", "Rumgr" },
            { "%%SAAHO", "Saho" },
            { "%%SOLBA", "Canúint Stolvizza/Solbica" },
            { "%%SOTAV", "Grúpa canúna Sotavento de Kabuverdianu" },
            { "%%UCCOR", "Litriú Comhaontaithe" },
            { "zh_Hans", "Sínis Shimplithe" },
            { "zh_Hant", "Sínis Thraidisiúnta" },
            { "%%AO1990", "Comhaontú Ortagrafaíochta Theanga na Portaingéilise, 1990" },
            { "%%DAJNKO", "Aibítir Dajnko" },
            { "%%EKAVSK", "Seirbis le fuaimniú Ekavian" },
            { "%%FONIPA", "Fogharscríobh IPA" },
            { "%%FONUPA", "Fogharscríobh UPA" },
            { "%%NDYUKA", "Canúint Ndyuka" },
            { "%%PAMAKA", "Canúint Pamaka" },
            { "%%PINYIN", "Rómhánú Pinyin" },
            { "%%SCOUSE", "Béarla Learphoill" },
            { "%%SIMPLE", "Simplí" },
            { "%%TARASK", "Ortografaíocht Taraskievica" },
            { "%%UCRCOR", "Litriú Comhaontaithe Athbhreithnithe" },
            { "%%ULSTER", "Cúige Uladh" },
            { "%%UNIFON", "Aibítir foghraíochta Unifon" },
            { "%%ABL1943", "Foirmiú ortagrafaíochta in 1943" },
            { "%%ALALC97", "Rómhánú ALA-LC, eagrán 1997" },
            { "%%AREVELA", "Airméinis an Oirthir" },
            { "%%AREVMDA", "Airméinis an Iarthair" },
            { "%%BALANKA", "Canúint Balanka de Anii" },
            { "%%BAUDDHA", "Bauddha" },
            { "%%BOHORIC", "Aibítir Bohorič" },
            { "%%EMODENG", "Nua-Bhéarla Moch" },
            { "%%FONNAPA", "Fonnapa" },
            { "%%HEPBURN", "Rómhánú Hepburn" },
            { "%%ITIHASA", "Itihasa" },
            { "%%LAUKIKA", "Laukika" },
            { "%%METELKO", "Aibítir Metelko" },
            { "%%MONOTON", "Aontonach" },
            { "%%PAHAWH2", "Pahawh2" },
            { "%%PAHAWH3", "Pahawh3" },
            { "%%PAHAWH4", "Pahawh4" },
            { "%%POLYTON", "Iltonach" },
            { "%%REVISED", "Litriú Athbhreithnithe" },
            { "%%SURSILV", "Sursilvan" },
            { "%%SUTSILV", "Sutsilv" },
            { "%%VAIDIKA", "Véideach" },
            { "%%1606NICT", "Fraincis Dhéanach Mheánach go 1606" },
            { "%%1694ACAD", "Nua-Fhraincis Mhoch" },
            { "%%1959ACAD", "Acadúil" },
            { "%%BAKU1926", "Abítir Laidine Tuircice Aontaithe" },
            { "%%BASICENG", "Bun-Bhéarla" },
            { "%%BISCAYAN", "BIOSCÁNACH" },
            { "%%COLB1945", "Coinbhinsiún Ortagrafaíochta na Portaingéilise na Brasaíle, 1945" },
            { "%%FONXSAMP", "Fonxsamp" },
            { "%%HOGNORSK", "Hognorsk" },
            { "%%HSISTEMO", "Hsistemo" },
            { "%%IJEKAVSK", "Seirbis le fuaimniú Ijekavach" },
            { "%%JYUTPING", "Jyutping" },
            { "%%KOCIEWIE", "Kociewie" },
            { "%%LUNA1918", "Luna1918" },
            { "%%NEWFOUND", "Talamh an Éisc" },
            { "%%OXENDICT", "Litriú OED" },
            { "%%PETR1708", "Petr1708" },
            { "%%SCOTLAND", "Béarla Caighdeánach na hAlban" },
            { "%%SPANGLIS", "Spainglis" },
            { "%%SURMIRAN", "Surmiran" },
            { "%%VALENCIA", "Vaileinsis" },
            { "%%VALLADER", "Vallader" },
            { "%%WADEGILE", "Rómhánú Wade-Giles" },
            { "%%XSISTEMO", "Xsistemo" },
            { "type.ca.roc", "Féilire Téavánach" },
            { "type.co.eor", "Rialacha Ordaithe Eorpacha" },
            { "type.hc.h11", "Córas 12 Uair (0–11)" },
            { "type.hc.h12", "Córas 12 Uair (1–12)" },
            { "type.hc.h23", "Córas 24 Uair (0–23)" },
            { "type.hc.h24", "Córas 24 Uair (1–24)" },
            { "type.nu.ahom", "Digití Ahom" },
            { "type.nu.arab", "Digití Ind-Arabacha" },
            { "type.nu.armn", "Uimhreacha Airméanacha" },
            { "type.nu.bali", "Digití Bailíocha" },
            { "type.nu.beng", "Digití Beangálacha" },
            { "type.nu.brah", "Digití Brahmi" },
            { "type.nu.cakm", "Digití Seácmacha" },
            { "type.nu.cham", "Digití Cham" },
            { "type.nu.cyrl", "Uimhreacha Coireallacha" },
            { "type.nu.deva", "Digití Déiveanágracha" },
            { "type.nu.ethi", "Uimhreacha Aetóipice" },
            { "type.nu.geor", "Uimhreacha Seoirseacha" },
            { "type.nu.gonm", "Digití Masaram Gondi" },
            { "type.nu.grek", "Uimhreacha Gréagacha" },
            { "type.nu.gujr", "Digití Gúisearátacha" },
            { "type.nu.guru", "Digití Gurmúcacha" },
            { "type.nu.hans", "Uimhreacha na Sínise Simplithe" },
            { "type.nu.hant", "Uimhreacha na Sínise Traidisiúnta" },
            { "type.nu.hebr", "Uimhreacha Eabhracha" },
            { "type.nu.hmng", "Digití Pahawh Hmong" },
            { "type.nu.java", "Digití Iávacha" },
            { "type.nu.jpan", "Uimhreacha Seapánacha" },
            { "type.nu.kali", "Digití Kayah Li" },
            { "type.nu.khmr", "Digití Ciméaracha" },
            { "type.nu.knda", "Digití Cannadacha" },
            { "type.nu.lana", "Digití Tai Tham Hora" },
            { "type.nu.laoo", "Digití Laosacha" },
            { "type.nu.latn", "Digití Iartharacha" },
            { "type.nu.lepc", "Digití Lepcha" },
            { "type.nu.limb", "Digití Limbu" },
            { "type.nu.mlym", "Digití Mailéalamacha" },
            { "type.nu.modi", "Digití Modi" },
            { "type.nu.mong", "Digití Mongólacha" },
            { "type.nu.mroo", "Digití Mro" },
            { "type.nu.mtei", "Digití Meetei Mayek" },
            { "type.nu.mymr", "Digití Maenmaracha" },
            { "type.nu.nkoo", "Digití N’ko" },
            { "type.nu.olck", "Digití Ol Chiki" },
            { "type.nu.orya", "Digití Oiríseacha" },
            { "type.nu.osma", "Digití Osmanya" },
            { "type.nu.saur", "Digití Saurashtra" },
            { "type.nu.shrd", "Digití Sharada" },
            { "type.nu.sind", "Digití Khudawadi" },
            { "type.nu.sinh", "Digití Sinhala Lith" },
            { "type.nu.sora", "Digití Sora Sompeng" },
            { "type.nu.sund", "Digití Sundainéise" },
            { "type.nu.takr", "Digití Takri" },
            { "type.nu.talu", "Digití Tai Lue Nua" },
            { "type.nu.taml", "Uimhreacha Tamalacha Traidisiúnta" },
            { "type.nu.telu", "Digití Teileagúcha" },
            { "type.nu.thai", "Digití Téalannacha" },
            { "type.nu.tibt", "Digití Tibéadacha" },
            { "type.nu.tirh", "Digití Tirhuta" },
            { "type.nu.vaii", "Digití Vadhacha" },
            { "type.nu.wara", "Digití Warang Citi" },
            { "type.ca.dangi", "Féilire Dangi" },
            { "type.co.ducet", "Ord Sórtála Réamhshocraithe Unicode" },
            { "type.co.emoji", "Ord Sórtála Emoji" },
            { "type.lb.loose", "Stíl Scaoilte Briste Líne" },
            { "type.nu.roman", "Uimhreacha Rómhánacha" },
            { "type.ca.coptic", "Féilire Coptach" },
            { "type.ca.hebrew", "Féilire na nEabhrach" },
            { "type.ca.indian", "Féilire Náisiúnta na hIndia" },
            { "type.co.compat", "Ord Sórtála Roimhe Seo, ar son na comhoiriúnachta" },
            { "type.co.pinyin", "Ord sórtála pinyin" },
            { "type.co.search", "Cuardach Ilfhóinteach" },
            { "type.co.stroke", "Ord sórtála stríce" },
            { "type.co.unihan", "Ord Sórtála Stríce Radacaí" },
            { "type.co.zhuyin", "Ord Sórtála Zhuyin" },
            { "type.lb.normal", "Gnáthstíl Briste Líne" },
            { "type.lb.strict", "Stíl Dhian Briste Líne" },
            { "type.ms.metric", "Córas Méadrach" },
            { "type.ca.chinese", "Féilire Síneach" },
            { "type.ca.islamic", "Féilire na Moslamach" },
            { "type.ca.iso8601", "Féilire Ghréagóra (an bhliain ag an tús)" },
            { "type.ca.persian", "Féilire Peirseach" },
            { "type.cf.account", "Formáid Airgeadra don Chuntasaíocht" },
            { "type.nu.arabext", "Digití Ind-Arabacha Breisithe" },
            { "type.nu.armnlow", "Uimhreacha Cáis Íochtair Airméanacha" },
            { "type.nu.greklow", "Uimhreacha Cáis Íochtair Gréagacha" },
            { "type.nu.hanidec", "Uimhreacha Deachúlacha Síneacha" },
            { "type.nu.hansfin", "Uimhreacha Airgeadais na Sínise Simplithe" },
            { "type.nu.hantfin", "Uimhreacha Airgeadais na Sínise Traidisiúnta" },
            { "type.nu.jpanfin", "Uimhreacha Airgeadais Seapánacha" },
            { "type.nu.mathdbl", "Digití Stríce Dúbailte Matamaiticiúla" },
            { "type.nu.tamldec", "Digití Tamalacha" },
            { "type.ca.buddhist", "Féilire Búdaíoch" },
            { "type.ca.ethiopic", "Féilire Aetóipice" },
            { "type.ca.japanese", "Féilire Seapánach" },
            { "type.cf.standard", "Formáid Airgeadra Caighdeánach" },
            { "type.co.searchjl", "Cuardach de réir Consan Tosaigh Hangul" },
            { "type.co.standard", "Ord Sórtála Caighdeánach" },
            { "type.ms.uksystem", "Córas Tomhais Reachtúil" },
            { "type.ms.ussystem", "Córas Tomhais SAM" },
            { "type.nu.fullwide", "Digití Lánleithid" },
            { "type.nu.lanatham", "Digití Tai Tham Tham" },
            { "type.nu.mathbold", "Digití Troma Matamaiticiúla" },
            { "type.nu.mathmono", "Digití Aonspáis Matamaiticiúla" },
            { "type.nu.mathsanb", "Digití Troma Sans-Serif Matamaiticiúla" },
            { "type.nu.mathsans", "Digití Sans-Serif Matamaiticiúla" },
            { "type.nu.mymrshan", "Digití Myanmar Shan" },
            { "type.nu.mymrtlng", "Digití Myanmar Tai Laing" },
            { "type.nu.romanlow", "Uimhreacha Cáis Íochtair Rómhánacha" },
            { "type.ca.gregorian", "Féilire Ghréagóra" },
            { "type.co.phonebook", "Ord sórtála an eolaire teileafóin" },
            { "type.co.dictionary", "Ord Sórtála Foclóirí" },
            { "type.co.traditional", "Ord sórtála traidisiúnta" },
            { "type.ca.islamic-civil", "Féilire na Moslamach (táblach, seanré shibhialta)" },
            { "type.ca.islamic-umalqura", "Féilire na Moslamach (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Féilire Aetóipice Amete Alem" },
        };
        return data;
    }
}
