/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_as extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "গ্ৰীণউইচ মান সময়",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "আপিয়াৰ মান সময়",
               "",
               "আপিয়াৰ ডেলাইট সময়",
               "",
               "আপিয়াৰ সময়",
               "",
            };
        final String[] Cook = new String[] {
               "কুক দ্বীপপুঞ্জৰ মান সময়",
               "",
               "কুক দ্বীপপুঞ্জৰ অৰ্ধ গ্ৰীষ্মকালীন সময়",
               "",
               "কুক দ্বীপপুঞ্জৰ সময়",
               "",
            };
        final String[] Cuba = new String[] {
               "কিউবাৰ মান সময়",
               "CST",
               "কিউবাৰ ডেলাইট সময়",
               "CDT",
               "কিউবাৰ সময়",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ফিজিৰ মান সময়",
               "",
               "ফিজিৰ গ্ৰীষ্মকালীন সময়",
               "",
               "ফিজিৰ সময়",
               "",
            };
        final String[] Gulf = new String[] {
               "উপসাগৰীয় মান সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "হোভ্‌ডৰ মান সময়",
               "",
               "হোভ্‌ডৰ গ্ৰীষ্মকালীন সময়",
               "",
               "হোভ্‌ডৰ সময়",
               "",
            };
        final String[] Iran = new String[] {
               "ইৰানৰ মান সময়",
               "",
               "ইৰানৰ ডেলাইট সময়",
               "",
               "ইৰানৰ সময়",
               "",
            };
        final String[] Niue = new String[] {
               "নিয়ুৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ওমস্কৰ মান সময়",
               "",
               "ওমস্কৰ গ্ৰীষ্মকালীন সময়",
               "",
               "ওমস্কৰ সময়",
               "",
            };
        final String[] Peru = new String[] {
               "পেৰুৰ মান সময়",
               "",
               "পেৰুৰ গ্ৰীষ্মকালীন সময়",
               "",
               "পেৰুৰ সময়",
               "",
            };
        final String[] Truk = new String[] {
               "চ্চুকৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ৱেক দ্বীপৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "চিলিৰ মান সময়",
               "",
               "চিলিৰ গ্ৰীষ্মকালীন সময়",
               "",
               "চিলিৰ সময়",
               "",
            };
        final String[] China = new String[] {
               "চীনৰ মান সময়",
               "CST",
               "চীনৰ ডেলাইট সময়",
               "CDT",
               "চীনৰ সময়",
               "CT",
            };
        final String[] Cocos = new String[] {
               "কোকোছ দ্বীপপুঞ্জৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ডেভিছৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ভাৰতীয় মান সময়",
               "ভা. স.",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "জাপানৰ মান সময়",
               "JST",
               "জাপানৰ ডেলাইট সময়",
               "JDT",
               "জাপানৰ সময়",
               "JT",
            };
        final String[] Korea = new String[] {
               "কোৰিয়াৰ মান সময়",
               "KST",
               "কোৰিয়াৰ ডেলাইট সময়",
               "KST",
               "কোৰিয়াৰ সময়",
               "KST",
            };
        final String[] Nauru = new String[] {
               "নাউৰুৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "নেপালৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "পালাউৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "ছামোৱাৰ মান সময়",
               "SST",
               "ছামোৱাৰ ডেলাইট সময়",
               "SST",
               "ছামোৱাৰ সময়",
               "SST",
            };
        final String[] Syowa = new String[] {
               "স্বোৱা সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "টংগাৰ মান সময়",
               "",
               "টংগাৰ গ্ৰীষ্মকালীন সময়",
               "",
               "টংগাৰ সময়",
               "",
            };
        final String[] Yukon = new String[] {
               "য়ুকোন সময়",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "আলাস্কাৰ মান সময়",
               "AKST",
               "আলাস্কাৰ ডেলাইট সময়",
               "AKDT",
               "আলাস্কাৰ সময়",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "আমাজনৰ মান সময়",
               "",
               "আমাজনৰ গ্ৰীষ্মকালীন সময়",
               "",
               "আমাজনৰ সময়",
               "",
            };
        final String[] Azores = new String[] {
               "আজোৰেছৰ মান সময়",
               "",
               "আজোৰেছৰ গ্ৰীষ্মকালীন সময়",
               "",
               "আজোৰেছ সময়",
               "",
            };
        final String[] Bhutan = new String[] {
               "ভুটানৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ব্ৰুনেই ডাৰুছালেমৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ইষ্টাৰ দ্বীপৰ মান সময়",
               "",
               "ইষ্টাৰ দ্বীপৰ গ্ৰীষ্মকালীন সময়",
               "",
               "ইষ্টাৰ দ্বীপৰ সময়",
               "",
            };
        final String[] Guyana = new String[] {
               "গায়ানাৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "হাৱাই-এলিউশ্বনৰ মান সময়",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ইজৰাইলৰ মান সময়",
               "IST",
               "ইজৰাইলৰ ডেলাইট সময়",
               "IDT",
               "ইজৰাইলৰ সময়",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "কোছৰায়ে সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "মাউছনৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "মস্কোৰ মান সময়",
               "MSK",
               "মস্কোৰ গ্ৰীষ্মকালীন সময়",
               "MSK",
               "মস্কোৰ সময়",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "পোনাপেৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "তাহিতিৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "টাইপেইৰ মান সময়",
               "CST",
               "টাইপেইৰ ডেলাইট সময়",
               "CDT",
               "টাইপেইৰ সময়",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "টুভালাউৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ভোষ্টকৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ৱালিছ আৰু ফুটুনাৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "আৰবীয় মান সময়",
               "",
               "আৰবীয় ডেলাইট সময়",
               "",
               "আৰবীয় সময়",
               "",
            };
        final String[] Armenia = new String[] {
               "আৰ্মেনিয়াৰ মান সময়",
               "",
               "আৰ্মেনিয়াৰ গ্ৰীষ্মকালীন সময়",
               "",
               "আৰ্মেনিয়াৰ সময়",
               "",
            };
        final String[] Bolivia = new String[] {
               "বলিভিয়াৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "চাথামৰ মান সময়",
               "",
               "চাথামৰ ডেলাইট সময়",
               "",
               "চাথামৰ সময়",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "সমন্বিত সাৰ্বজনীন সময়",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ইকুৱেডৰৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "গেম্বিয়াৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "জৰ্জিয়াৰ মান সময়",
               "",
               "জৰ্জিয়াৰ গ্ৰীষ্মকালীন সময়",
               "",
               "জৰ্জিয়াৰ সময়",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ইৰ্কুটস্কৰ মান সময়",
               "",
               "ইৰ্কুটস্কৰ গ্ৰীষ্মকালীন সময়",
               "",
               "ইৰ্কুটস্কৰ সময়",
               "",
            };
        final String[] Magadan = new String[] {
               "মাগাদানৰ মান সময়",
               "",
               "মাগাদানৰ গ্ৰীষ্মকালীন সময়",
               "",
               "মাগাদানৰ সময়",
               "",
            };
        final String[] Myanmar = new String[] {
               "ম্যানমাৰৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "ন’ৰফ’ক দ্বীপৰ মান্য সময়",
               "",
               "ন’ৰফ’ক দ্বীপৰ গ্ৰীষ্মকালীন সময়",
               "",
               "ন’ৰফ’ক দ্বীপৰ সময়",
               "",
            };
        final String[] Noronha = new String[] {
               "ফাৰ্নাণ্ডো ডে নোৰোন্‌হাৰ মান সময়",
               "",
               "ফাৰ্নাণ্ডো ডে নোৰোন্‌হাৰ গ্ৰীষ্মকালীন সময়",
               "",
               "ফাৰ্নাণ্ডো ডে নোৰোন্‌হাৰ সময়",
               "",
            };
        final String[] Reunion = new String[] {
               "ৰিইউনিয়নৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "ৰোথেৰাৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "চোলোমোন দ্বীপপুঞ্জৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "টোকেলাউৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "উৰুগুৱেৰ মান সময়",
               "",
               "উৰুগুৱেৰ গ্ৰীষ্মকালীন সময়",
               "",
               "উৰুগুৱেৰ সময়",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ভানাটুৰ মান সময়",
               "",
               "ভানাটুৰ গ্ৰীষ্মকালীন সময়",
               "",
               "ভানাটুৰ সময়",
               "",
            };
        final String[] Yakutsk = new String[] {
               "য়াকুত্স্কৰ মান সময়",
               "",
               "য়াকুত্স্কৰ গ্ৰীষ্মকালীন সময়",
               "",
               "য়াকুত্স্কৰ সময়",
               "",
            };
        final String[] Atlantic = new String[] {
               "আটলাণ্টিক মান সময়",
               "AST",
               "আটলাণ্টিক ডেলাইট সময়",
               "AST",
               "আটলাণ্টিক সময়",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ব্ৰাজিলিয়াৰ মান সময়",
               "",
               "ব্ৰাজিলিয়াৰ গ্ৰীষ্মকালীন সময়",
               "",
               "ব্ৰাজিলিয়াৰ সময়",
               "",
            };
        final String[] Chamorro = new String[] {
               "চামোৰোৰ মান সময়",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "কলম্বিয়াৰ মান সময়",
               "",
               "কলম্বিয়াৰ গ্ৰীষ্মকালীন সময়",
               "",
               "কলম্বিয়াৰ সময়",
               "",
            };
        final String[] Falkland = new String[] {
               "ফকলেণ্ড দ্বীপপুঞ্জৰ মান সময়",
               "",
               "ফকলেণ্ড দ্বীপপুঞ্জৰ গ্ৰীষ্মকালীন সময়",
               "",
               "ফকলেণ্ড দ্বীপপুঞ্জৰ সময়",
               "",
            };
        final String[] Malaysia = new String[] {
               "মালয়েচিয়াৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "মালদ্বীপৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "উলানবাটাৰৰ মান সময়",
               "",
               "উলানবাটাৰৰ গ্ৰীষ্মকালীন সময়",
               "",
               "উলানবাটাৰৰ সময়",
               "",
            };
        final String[] Pakistan = new String[] {
               "পাকিস্তানৰ মান সময়",
               "PKT",
               "পাকিস্তানৰ গ্ৰীষ্মকালীন সময়",
               "PKST",
               "পাকিস্তানৰ সময়",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "পাৰাগুৱেৰ মান সময়",
               "",
               "পাৰাগুৱেৰ গ্ৰীষ্মকালীন সময়",
               "",
               "পাৰাগুৱেৰ সময়",
               "",
            };
        final String[] Pitcairn = new String[] {
               "পিটকেইৰ্ণৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "ছুৰিনামৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "আৰ্জেণ্টিনাৰ মান সময়",
               "",
               "আৰ্জেণ্টিনাৰ গ্ৰীষ্মকালীন সময়",
               "",
               "আৰ্জেণ্টিনাৰ সময়",
               "",
            };
        final String[] Christmas = new String[] {
               "খ্ৰীষ্টমাছ দ্বীপৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "গালাপাগোছৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "হং কঙৰ মান সময়",
               "HKT",
               "হং কঙৰ গ্ৰীষ্মকালীন সময়",
               "HKST",
               "হং কঙৰ সময়",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ইণ্ডোচাইনাৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "কিৰ্গিজস্তানৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "লৰ্ড হাওৰ মান সময়",
               "",
               "লৰ্ড হাওৰ ডেলাইট সময়",
               "",
               "লৰ্ড হাওৰ সময়",
               "",
            };
        final String[] Marquesas = new String[] {
               "মাৰ্কছেছৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "মৰিছাছৰ মান সময়",
               "",
               "মৰিছাছৰ গ্ৰীষ্মকালীন সময়",
               "",
               "মৰিছাছৰ সময়",
               "",
            };
        final String[] Singapore = new String[] {
               "ছিংগাপুৰৰ মান সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ভেনিজুৱেলাৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "আজেৰবাইজানৰ মান সময়",
               "",
               "আজেৰবাইজানৰ গ্ৰীষ্মকালীন সময়",
               "",
               "আজেৰবাইজানৰ সময়",
               "",
            };
        final String[] Bangladesh = new String[] {
               "বাংলাদেশৰ মান সময়",
               "",
               "বাংলাদেশৰ গ্ৰীষ্মকালীন সময়",
               "",
               "বাংলাদেশৰ সময়",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "কেপ ভাৰ্দেৰ মান সময়",
               "",
               "কেপ ভাৰ্দেৰ গ্ৰীষ্মকালীন সময়",
               "",
               "কেপ ভাৰ্দেৰ সময়",
               "",
            };
        final String[] East_Timor = new String[] {
               "পূব তিমোৰৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "কাজাখস্তানৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "ছিচিলিছৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "তাজিকিস্তানৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "উজবেকিস্তানৰ মান সময়",
               "",
               "উজবেকিস্তানৰ গ্ৰীষ্মকালীন সময়",
               "",
               "উজবেকিস্তানৰ সময়",
               "",
            };
        final String[] Afghanistan = new String[] {
               "আফগানিস্তানৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "ক্ৰাছনোয়াৰ্স্কৰ মান সময়",
               "",
               "ক্ৰাছনোয়াৰ্স্ক গ্ৰীষ্মকালীন সময়",
               "",
               "ক্ৰাছনোয়াৰ্স্কৰ সময়",
               "",
            };
        final String[] New_Zealand = new String[] {
               "নিউজিলেণ্ডৰ মান সময়",
               "NZST",
               "নিউজিলেণ্ডৰ ডেলাইট সময়",
               "NZDT",
               "নিউজিলেণ্ডৰ সময়",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "ফিলিপাইনৰ মান সময়",
               "PST",
               "ফিলিপাইনৰ গ্ৰীষ্মকালীন সময়",
               "PDT",
               "ফিলিপাইনৰ সময়",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ভ্লাডিভোষ্টোকৰ মান সময়",
               "",
               "ভ্লাডিভোষ্টোকৰ গ্ৰীষ্মকালীন সময়",
               "",
               "ভ্লাডিভোষ্টোকৰ সময়",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ভাৰত মহাসাগৰীয় সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "লাইন দ্বীপপুঞ্জৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "নিউফাউণ্ডলেণ্ডৰ মান সময়",
               "NST",
               "নিউফাউণ্ডলেণ্ডৰ ডেলাইট সময়",
               "NDT",
               "নিউফাউণ্ডলেণ্ডৰ সময়",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "তুৰ্কমেনিস্তানৰ মান সময়",
               "",
               "তুৰ্কমেনিস্তানৰ গ্ৰীষ্মকালীন সময়",
               "",
               "তুৰ্কমেনিস্তানৰ সময়",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ফ্ৰান্স গয়ানাৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "নিউ কেলিডোনিয়াৰ মান সময়",
               "",
               "নিউ কেলিডোনিয়াৰ গ্ৰীষ্মকালীন সময়",
               "",
               "নিউ কেলিডোনিয়াৰ সময়",
               "",
            };
        final String[] South_Georgia = new String[] {
               "দক্ষিণ জৰ্জিয়াৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "য়েকাটেৰিণবাৰ্গৰ মান সময়",
               "",
               "য়েকাটেৰিণবাৰ্গৰ গ্ৰীষ্মকালীন সময়",
               "",
               "য়েকাটেৰিণবাৰ্গৰ সময়",
               "",
            };
        final String[] Africa_Central = new String[] {
               "মধ্য আফ্ৰিকাৰ সময়",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "পূব আফ্ৰিকাৰ সময়",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "পশ্চিম আফ্ৰিকাৰ সময়",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ডুমোণ্ট-ডি আৰ্ভিলৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "মধ্য ইউৰোপীয় মান সময়",
               "CET",
               "মধ্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়",
               "CEST",
               "মধ্য ইউৰোপীয় সময়",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "প্ৰাচ্য ইউৰোপীয় মান সময়",
               "EET",
               "প্ৰাচ্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়",
               "EEST",
               "প্ৰাচ্য ইউৰোপীয় সময়",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "পাশ্চাত্য ইউৰোপীয় মান সময়",
               "WET",
               "পাশ্চাত্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়",
               "WEST",
               "পাশ্চাত্য ইউৰোপীয় সময়",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "মেক্সিকোৰ প্ৰশান্ত মান সময়",
               "MST",
               "মেক্সিকোৰ প্ৰশান্ত ডেলাইট সময়",
               "MDT",
               "মেক্সিকোৰ প্ৰশান্ত সময়",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "দক্ষিণ আফ্ৰিকাৰ মান সময়",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "উত্তৰ আমেৰিকাৰ কেন্দ্ৰীয় মান সময়",
               "CST",
               "উত্তৰ আমেৰিকাৰ কেন্দ্ৰীয় ডেলাইট সময়",
               "CDT",
               "উত্তৰ আমেৰিকাৰ কেন্দ্ৰীয় সময়",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "উত্তৰ আমেৰিকাৰ প্ৰাচ্য মান সময়",
               "EST",
               "উত্তৰ আমেৰিকাৰ প্ৰাচ্য ডেলাইট সময়",
               "EST",
               "উত্তৰ আমেৰিকাৰ প্ৰাচ্য সময়",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "উত্তৰ আমেৰিকাৰ প্ৰশান্ত মান সময়",
               "PST",
               "উত্তৰ আমেৰিকাৰ ডেলাইট সময়",
               "PDT",
               "উত্তৰ আমেৰিকাৰ প্ৰশান্ত সময়",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "দক্ষিণ ফ্ৰান্স আৰু এণ্টাৰ্কটিক সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "গিলবাৰ্ট দ্বীপপুঞ্জৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "হাৱাই-এলিউশ্বনৰ মান সময়",
               "HST",
               "হাৱাই-এলিউশ্বনৰ ডেলাইট সময়",
               "HDT",
               "হাৱাই-এলিউশ্বনৰ সময়",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ফিনিক্স দ্বীপপুঞ্জৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলনৰ মান সময়",
               "",
               "ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলনৰ ডেলাইট সময়",
               "",
               "ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলনৰ সময়",
               "",
            };
        final String[] America_Mountain = new String[] {
               "উত্তৰ আমেৰিকাৰ পৰ্ব্বতীয় মান সময়",
               "MST",
               "উত্তৰ আমেৰিকাৰ পৰ্ব্বতীয় ডেলাইট সময়",
               "MST",
               "উত্তৰ আমেৰিকাৰ পৰ্ব্বতীয় সময়",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "মাৰ্শ্বাল দ্বীপপুঞ্জৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "পাপুৱা নিউ গিনিৰ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় মান সময়",
               "ACST",
               "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় ডেলাইট সময়",
               "ACDT",
               "মধ্য অষ্ট্ৰেলিয়াৰ সময়",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "অষ্ট্ৰেলিয়াৰ প্ৰাচ্য মান সময়",
               "AEST",
               "অষ্ট্ৰেলিয়াৰ প্ৰাচ্য ডেলাইট সময়",
               "AEDT",
               "প্ৰাচ্য অষ্ট্ৰেলিয়াৰ সময়",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "অষ্ট্ৰেলিয়াৰ পাশ্চাত্য মান সময়",
               "AWST",
               "অষ্ট্ৰেলিয়াৰ পাশ্চাত্য ডেলাইট সময়",
               "AWDT",
               "পাশ্চাত্য অষ্ট্ৰেলিয়াৰ সময়",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "মধ্য ইণ্ডোনেচিয়াৰ সময়",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "প্ৰাচ্য ইণ্ডোনেচিয়াৰ সময়",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "পাশ্চাত্য ইণ্ডোনেচিয়াৰ সময়",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় পাশ্চাত্য মান সময়",
               "",
               "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় পাশ্চাত্য ডেলাইট সময়",
               "",
               "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় পাশ্চাত্য সময়",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "গ্ৰীণউইচ মান সময়",
                    "GMT",
                    "ব্ৰিটিছ গ্ৰীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "সমন্বিত সাৰ্বজনীন সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "গ্ৰীণউইচ মান সময়",
                    "GMT",
                    "আইৰিচ মান সময়",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "সমন্বিত সাৰ্বজনীন সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "সমন্বিত সাৰ্বজনীন সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "গ্ৰীণউইচ মান সময়",
                    "GMT",
                    "ব্ৰিটিছ গ্ৰীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "সমন্বিত সাৰ্বজনীন সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "সমন্বিত সাৰ্বজনীন সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "সমন্বিত সাৰ্বজনীন সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "গ্ৰীণউইচ মান সময়",
                    "GMT",
                    "আইৰিচ মান সময়",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "গ্ৰীণউইচ মান সময়",
                    "GMT",
                    "ব্ৰিটিছ গ্ৰীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "গ্ৰীণউইচ মান সময়",
                    "GMT",
                    "ব্ৰিটিছ গ্ৰীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "গ্ৰীণউইচ মান সময়",
                    "GMT",
                    "ব্ৰিটিছ গ্ৰীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "গ্ৰীণউইচ মান সময়",
                    "GMT",
                    "ব্ৰিটিছ গ্ৰীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "গ্ৰীণউইচ মান সময়",
                    "GMT",
                    "ব্ৰিটিছ গ্ৰীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "আদেন" },
            { "timezone.excity.Asia/Baku", "বাকু" },
            { "timezone.excity.Asia/Dili", "ডিলি" },
            { "timezone.excity.Asia/Gaza", "গাজা" },
            { "timezone.excity.Asia/Hovd", "হোভ্‌ড" },
            { "timezone.excity.Asia/Omsk", "ওমস্ক" },
            { "timezone.excity.Asia/Oral", "অ’ৰেল" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "আম্মান" },
            { "timezone.excity.Asia/Aqtau", "এক্যোট্যাও" },
            { "timezone.excity.Asia/Chita", "চিটা" },
            { "timezone.excity.Asia/Dhaka", "ঢাকা" },
            { "timezone.excity.Asia/Dubai", "ডুবাই" },
            { "timezone.excity.Asia/Kabul", "কাবুল" },
            { "timezone.excity.Asia/Macau", "মাকাও" },
            { "timezone.excity.Asia/Qatar", "কাটাৰ" },
            { "timezone.excity.Asia/Seoul", "ছিউল" },
            { "timezone.excity.Asia/Tokyo", "টকিঅ’" },
            { "timezone.excity.Asia/Tomsk", "তোম্‌স্ক" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "জুবা" },
            { "timezone.excity.Africa/Lome", "লোম" },
            { "timezone.excity.Asia/Almaty", "আলমাটি" },
            { "timezone.excity.Asia/Anadyr", "আনাডিৰ" },
            { "timezone.excity.Asia/Aqtobe", "এক্যোটব" },
            { "timezone.excity.Asia/Atyrau", "এটৰাউ" },
            { "timezone.excity.Asia/Beirut", "বেইৰুট" },
            { "timezone.excity.Asia/Brunei", "ব্ৰুনেই" },
            { "timezone.excity.Asia/Hebron", "হেব্ৰোন" },
            { "timezone.excity.Asia/Kuwait", "কুৱেইট" },
            { "timezone.excity.Asia/Manila", "মানিলা" },
            { "timezone.excity.Asia/Muscat", "মুস্কেট" },
            { "timezone.excity.Asia/Riyadh", "ৰিয়াধ" },
            { "timezone.excity.Asia/Saigon", "হো চি মিন চিটী" },
            { "timezone.excity.Asia/Taipei", "টাইপেই" },
            { "timezone.excity.Asia/Tehran", "তেহৰান" },
            { "timezone.excity.Asia/Urumqi", "উৰুম্‌কি" },
            { "timezone.excity.Etc/Unknown", "অজ্ঞাত চহৰ" },
            { "timezone.excity.Europe/Kiev", "কিভ" },
            { "timezone.excity.Europe/Oslo", "ওস্লো" },
            { "timezone.excity.Europe/Riga", "ৰিগা" },
            { "timezone.excity.Europe/Rome", "ৰোম" },
            { "timezone.excity.Indian/Mahe", "মাহে" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "এক্ৰা" },
            { "timezone.excity.Africa/Cairo", "কাইৰো" },
            { "timezone.excity.Africa/Ceuta", "চেউটা" },
            { "timezone.excity.Africa/Dakar", "ডাকাৰ" },
            { "timezone.excity.Africa/Lagos", "লাগোছ" },
            { "timezone.excity.Africa/Tunis", "টুনিছ" },
            { "timezone.excity.America/Adak", "আডাক" },
            { "timezone.excity.America/Lima", "লিমা" },
            { "timezone.excity.America/Nome", "নোম" },
            { "timezone.excity.Asia/Baghdad", "বাগদাদ" },
            { "timezone.excity.Asia/Bahrain", "বাহৰেইন" },
            { "timezone.excity.Asia/Bangkok", "বেংকক" },
            { "timezone.excity.Asia/Barnaul", "বাৰ্নুল" },
            { "timezone.excity.Asia/Bishkek", "বিশ্ব্‌কেক" },
            { "timezone.excity.Asia/Colombo", "কলম্বো" },
            { "timezone.excity.Asia/Irkutsk", "ইৰ্কুত্স্ক" },
            { "timezone.excity.Asia/Jakarta", "জাকাৰ্টা" },
            { "timezone.excity.Asia/Karachi", "কৰাচী" },
            { "timezone.excity.Asia/Kuching", "কুচিং" },
            { "timezone.excity.Asia/Magadan", "মাগাদান" },
            { "timezone.excity.Asia/Nicosia", "নিকোছিয়া" },
            { "timezone.excity.Asia/Rangoon", "য়াঙোন" },
            { "timezone.excity.Asia/Tbilisi", "টিবলিচি" },
            { "timezone.excity.Asia/Thimphu", "থিম্ফু" },
            { "timezone.excity.Asia/Yakutsk", "য়াকুত্স্ক" },
            { "timezone.excity.Asia/Yerevan", "য়েৰেভান" },
            { "timezone.excity.Europe/Kirov", "কিৰোভ" },
            { "timezone.excity.Europe/Malta", "মাল্টা" },
            { "timezone.excity.Europe/Minsk", "মিংস্ক" },
            { "timezone.excity.Europe/Paris", "পেৰিছ" },
            { "timezone.excity.Europe/Sofia", "ছোফিয়া" },
            { "timezone.excity.Europe/Vaduz", "ভাদুজ" },
            { "timezone.excity.Indian/Cocos", "কোকোছ" },
            { "timezone.excity.Pacific/Apia", "আপিয়া" },
            { "timezone.excity.Pacific/Fiji", "ফিজি" },
            { "timezone.excity.Pacific/Guam", "গুৱাম" },
            { "timezone.excity.Pacific/Niue", "নিয়ো" },
            { "timezone.excity.Pacific/Truk", "চ্চুক" },
            { "timezone.excity.Pacific/Wake", "ৱেক" },
            { "timezone.excity.Africa/Asmera", "আস্মাৰা" },
            { "timezone.excity.Africa/Bamako", "বামাকো" },
            { "timezone.excity.Africa/Bangui", "বাংগুই" },
            { "timezone.excity.Africa/Banjul", "বেঞ্জুল" },
            { "timezone.excity.Africa/Bissau", "বিছাউ" },
            { "timezone.excity.Africa/Douala", "ডুৱালা" },
            { "timezone.excity.Africa/Harare", "হাৰাৰে" },
            { "timezone.excity.Africa/Kigali", "কিগালী" },
            { "timezone.excity.Africa/Luanda", "লুৱাণ্ডা" },
            { "timezone.excity.Africa/Lusaka", "লুছাকা" },
            { "timezone.excity.Africa/Malabo", "মালাবো" },
            { "timezone.excity.Africa/Maputo", "মাপুটো" },
            { "timezone.excity.Africa/Maseru", "মাছেৰু" },
            { "timezone.excity.Africa/Niamey", "নিয়ামী" },
            { "timezone.excity.America/Aruba", "আৰুবা" },
            { "timezone.excity.America/Bahia", "বাহিয়া" },
            { "timezone.excity.America/Belem", "বেলেম" },
            { "timezone.excity.America/Boise", "ব’ইজে" },
            { "timezone.excity.America/Jujuy", "জুজুই" },
            { "timezone.excity.America/Sitka", "ছিট্‌‌কা" },
            { "timezone.excity.America/Thule", "থ্যুলে" },
            { "timezone.excity.Asia/Ashgabat", "আশ্ব্গা‌বাট" },
            { "timezone.excity.Asia/Calcutta", "কলকাতা" },
            { "timezone.excity.Asia/Damascus", "ডামাস্কাছ" },
            { "timezone.excity.Asia/Dushanbe", "ডুছানবে" },
            { "timezone.excity.Asia/Jayapura", "জায়াপুৰা" },
            { "timezone.excity.Asia/Katmandu", "কাঠমাণ্ডু" },
            { "timezone.excity.Asia/Khandyga", "খাণ্ডিগা" },
            { "timezone.excity.Asia/Makassar", "মাকাছাৰ" },
            { "timezone.excity.Asia/Qostanay", "ক’ষ্টেনী" },
            { "timezone.excity.Asia/Sakhalin", "ছাখালিন" },
            { "timezone.excity.Asia/Shanghai", "ছাংহাই" },
            { "timezone.excity.Asia/Tashkent", "তাছকেণ্ট" },
            { "timezone.excity.Asia/Ust-Nera", "উষ্ট-নেৰা" },
            { "timezone.excity.Europe/Athens", "এথেন্স" },
            { "timezone.excity.Europe/Berlin", "বাৰ্লিন" },
            { "timezone.excity.Europe/Dublin", "ডাবলিন" },
            { "timezone.excity.Europe/Jersey", "জাৰ্চি" },
            { "timezone.excity.Europe/Lisbon", "লিছবন" },
            { "timezone.excity.Europe/London", "লণ্ডন" },
            { "timezone.excity.Europe/Madrid", "মাদ্ৰিদ" },
            { "timezone.excity.Europe/Monaco", "মোনাকো" },
            { "timezone.excity.Europe/Moscow", "মস্কো" },
            { "timezone.excity.Europe/Prague", "প্ৰাগ" },
            { "timezone.excity.Europe/Samara", "ছামাৰা" },
            { "timezone.excity.Europe/Skopje", "স্কোপ্জে" },
            { "timezone.excity.Europe/Tirane", "টাইৰেন" },
            { "timezone.excity.Europe/Vienna", "ভিয়েনা" },
            { "timezone.excity.Europe/Warsaw", "ৱাৰছাও" },
            { "timezone.excity.Europe/Zagreb", "জাগ্ৰেব" },
            { "timezone.excity.Europe/Zurich", "জুৰিখ" },
            { "timezone.excity.Indian/Chagos", "চাগোছ" },
            { "timezone.excity.Indian/Comoro", "কোমোৰো" },
            { "timezone.excity.Pacific/Efate", "এফেট" },
            { "timezone.excity.Pacific/Nauru", "নাৰু" },
            { "timezone.excity.Pacific/Palau", "পালাউ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "আবিডজান" },
            { "timezone.excity.Africa/Algiers", "আলজিয়াৰ্ছ" },
            { "timezone.excity.Africa/Conakry", "কোনাক্ৰী" },
            { "timezone.excity.Africa/Kampala", "কাম্পালা" },
            { "timezone.excity.Africa/Mbabane", "এম্বাবেন" },
            { "timezone.excity.Africa/Nairobi", "নাইৰোবি" },
            { "timezone.excity.Africa/Tripoli", "ত্ৰিপোলি" },
            { "timezone.excity.America/Belize", "বেলিজ" },
            { "timezone.excity.America/Bogota", "বোগোটা" },
            { "timezone.excity.America/Cancun", "কেনকুন" },
            { "timezone.excity.America/Cayman", "কেইমেন" },
            { "timezone.excity.America/Cuiaba", "কুইআবা" },
            { "timezone.excity.America/Dawson", "ডাওছন" },
            { "timezone.excity.America/Denver", "ডেনভাৰ" },
            { "timezone.excity.America/Guyana", "গায়ানা" },
            { "timezone.excity.America/Havana", "হাভানা" },
            { "timezone.excity.America/Inuvik", "ইনুভিক" },
            { "timezone.excity.America/Juneau", "জুনেউ" },
            { "timezone.excity.America/La_Paz", "লা পাজ" },
            { "timezone.excity.America/Maceio", "মেচিও" },
            { "timezone.excity.America/Manaus", "মানাছ" },
            { "timezone.excity.America/Merida", "মেৰিডা" },
            { "timezone.excity.America/Nassau", "নাছাউ" },
            { "timezone.excity.America/Panama", "পানামা" },
            { "timezone.excity.America/Recife", "ৰেচাইফ" },
            { "timezone.excity.America/Regina", "ৰেজিনা" },
            { "timezone.excity.Asia/Famagusta", "ফামাগুস্তা" },
            { "timezone.excity.Asia/Hong_Kong", "হং কং" },
            { "timezone.excity.Asia/Jerusalem", "জেৰুজালেম" },
            { "timezone.excity.Asia/Kamchatka", "কামচত্কা" },
            { "timezone.excity.Asia/Pontianak", "পোণ্টিয়াংক" },
            { "timezone.excity.Asia/Pyongyang", "প্যংয়াং" },
            { "timezone.excity.Asia/Qyzylorda", "কেজিলোৰ্ডা" },
            { "timezone.excity.Asia/Samarkand", "ছামাৰকাণ্ড" },
            { "timezone.excity.Asia/Singapore", "ছিংগাপুৰ" },
            { "timezone.excity.Asia/Vientiane", "ভিয়েণ্টিয়ান" },
            { "timezone.excity.Europe/Andorra", "আন্দোৰা" },
            { "timezone.excity.Europe/Saratov", "ছাৰাটোভ" },
            { "timezone.excity.Europe/Tallinn", "তেলিন" },
            { "timezone.excity.Europe/Vatican", "ভেটিকান" },
            { "timezone.excity.Europe/Vilnius", "ভিলনিয়াছ" },
            { "timezone.excity.Indian/Mayotte", "মায়োট্টে" },
            { "timezone.excity.Indian/Reunion", "ৰিইউনিয়ন" },
            { "timezone.excity.Pacific/Easter", "ইষ্টাৰ" },
            { "timezone.excity.Pacific/Kosrae", "কোছৰায়ে" },
            { "timezone.excity.Pacific/Majuro", "মাজুৰো" },
            { "timezone.excity.Pacific/Midway", "মিডৱে" },
            { "timezone.excity.Pacific/Noumea", "নউমিয়া" },
            { "timezone.excity.Pacific/Ponape", "পোনপেই" },
            { "timezone.excity.Pacific/Saipan", "ছাইপান" },
            { "timezone.excity.Pacific/Tahiti", "তাহিতি" },
            { "timezone.excity.Pacific/Tarawa", "তাৰাৱা" },
            { "timezone.excity.Pacific/Wallis", "ৱালিছ" },
            { "timezone.excity.Africa/Blantyre", "ব্লাণ্টায়াৰ" },
            { "timezone.excity.Africa/Djibouti", "জিবুটি" },
            { "timezone.excity.Africa/El_Aaiun", "এল আইয়ুন" },
            { "timezone.excity.Africa/Freetown", "ফ্ৰিটাউন" },
            { "timezone.excity.Africa/Gaborone", "গাবোৰোণ" },
            { "timezone.excity.Africa/Khartoum", "খাৰ্টুম" },
            { "timezone.excity.Africa/Kinshasa", "কিংচাছা" },
            { "timezone.excity.Africa/Monrovia", "মোনৰোভিয়া" },
            { "timezone.excity.Africa/Ndjamena", "নেদজামেনা" },
            { "timezone.excity.Africa/Sao_Tome", "চাও টোমে" },
            { "timezone.excity.Africa/Windhoek", "ৱিণ্ডহোক" },
            { "timezone.excity.America/Antigua", "এণ্টিগুৱা" },
            { "timezone.excity.America/Caracas", "কাৰাকাছ" },
            { "timezone.excity.America/Cayenne", "কেয়েন" },
            { "timezone.excity.America/Chicago", "চিকাগো" },
            { "timezone.excity.America/Cordoba", "কোৰ্ডোবা" },
            { "timezone.excity.America/Creston", "ক্ৰেষ্টন" },
            { "timezone.excity.America/Curacao", "কুৰাকাও" },
            { "timezone.excity.America/Detroit", "ডেট্ৰোইট" },
            { "timezone.excity.America/Godthab", "নুক" },
            { "timezone.excity.America/Grenada", "গ্ৰেনাডা" },
            { "timezone.excity.America/Halifax", "হেলিফেক্স" },
            { "timezone.excity.America/Iqaluit", "ইকালুইট" },
            { "timezone.excity.America/Jamaica", "জামাইকা" },
            { "timezone.excity.America/Managua", "মানাগুৱা" },
            { "timezone.excity.America/Marigot", "মেৰিগোট" },
            { "timezone.excity.America/Mendoza", "মেণ্ডোজা" },
            { "timezone.excity.America/Moncton", "মন্‌কটন" },
            { "timezone.excity.America/Noronha", "নোৰোন্‌হা" },
            { "timezone.excity.America/Ojinaga", "অ’জিনাগা" },
            { "timezone.excity.America/Phoenix", "ফিনিক্স" },
            { "timezone.excity.America/Tijuana", "তিজুৱানা" },
            { "timezone.excity.America/Toronto", "ট’ৰ’ণ্টো" },
            { "timezone.excity.America/Tortola", "টোৰ্টোলা" },
            { "timezone.excity.America/Yakutat", "য়াকুটাট" },
            { "timezone.excity.Asia/Phnom_Penh", "নোম পেন্‌হ" },
            { "timezone.excity.Atlantic/Azores", "এজোৰেছ" },
            { "timezone.excity.Atlantic/Canary", "কেনেৰী" },
            { "timezone.excity.Atlantic/Faeroe", "ফাৰো" },
            { "timezone.excity.Australia/Eucla", "ইউক্লা" },
            { "timezone.excity.Australia/Perth", "পাৰ্থ" },
            { "timezone.excity.Europe/Belgrade", "বেলগ্ৰেড" },
            { "timezone.excity.Europe/Brussels", "ব্ৰুছলেছ" },
            { "timezone.excity.Europe/Budapest", "বুডাপেষ্ট" },
            { "timezone.excity.Europe/Busingen", "বুছিনজেন" },
            { "timezone.excity.Europe/Chisinau", "চিছিনাউ" },
            { "timezone.excity.Europe/Guernsey", "গোৰেনচি" },
            { "timezone.excity.Europe/Helsinki", "হেলছিংকি" },
            { "timezone.excity.Europe/Istanbul", "ইস্তানবুল" },
            { "timezone.excity.Europe/Sarajevo", "ছাৰাজেভো" },
            { "timezone.excity.Indian/Maldives", "মালদ্বীপ" },
            { "timezone.excity.Pacific/Chatham", "চাথাম" },
            { "timezone.excity.Pacific/Fakaofo", "ফাকাওফো" },
            { "timezone.excity.Pacific/Gambier", "গেম্বিয়াৰ" },
            { "timezone.excity.Pacific/Norfolk", "ন’ৰফ’ক" },
            { "timezone.excity.Africa/Bujumbura", "বুজুম্বুৰা" },
            { "timezone.excity.Africa/Mogadishu", "মোগাদিচু" },
            { "timezone.excity.America/Anguilla", "এনগুইলা" },
            { "timezone.excity.America/Asuncion", "আছুনচিয়ন" },
            { "timezone.excity.America/Barbados", "বাৰ্বাডোচ" },
            { "timezone.excity.America/Dominica", "ডমিনিকা" },
            { "timezone.excity.America/Edmonton", "এডমণ্টন" },
            { "timezone.excity.America/Eirunepe", "ইৰুনেপে" },
            { "timezone.excity.America/Mazatlan", "মাজাট্‌লান" },
            { "timezone.excity.America/Miquelon", "মিকিউৱেলন" },
            { "timezone.excity.America/New_York", "নিউ ইয়ৰ্ক" },
            { "timezone.excity.America/Resolute", "ৰিজ’লিউট" },
            { "timezone.excity.America/Santarem", "ছেণ্টাৰেম" },
            { "timezone.excity.America/Santiago", "ছেণ্টিয়াগো" },
            { "timezone.excity.America/St_Johns", "ছেইণ্ট জনচ্" },
            { "timezone.excity.America/St_Kitts", "ছেইণ্ট কিটছ" },
            { "timezone.excity.America/St_Lucia", "ছেইণ্ট লুচিয়া" },
            { "timezone.excity.America/Winnipeg", "ৱিনিপেগ" },
            { "timezone.excity.Antarctica/Casey", "কেছী" },
            { "timezone.excity.Antarctica/Davis", "ডেভিছ" },
            { "timezone.excity.Antarctica/Syowa", "স্বোৱা" },
            { "timezone.excity.Antarctica/Troll", "ট্ৰোল" },
            { "timezone.excity.Asia/Krasnoyarsk", "ক্ৰাছনোয়াৰ্স্ক" },
            { "timezone.excity.Asia/Novosibirsk", "নোভোছিবিৰ্স্ক" },
            { "timezone.excity.Asia/Ulaanbaatar", "উলানবাটাৰ" },
            { "timezone.excity.Asia/Vladivostok", "ভ্লাডিভোষ্টক" },
            { "timezone.excity.Atlantic/Bermuda", "বাৰ্মুডা" },
            { "timezone.excity.Atlantic/Madeira", "মাডেৰা" },
            { "timezone.excity.Atlantic/Stanley", "ষ্টেন্‌লী" },
            { "timezone.excity.Australia/Darwin", "ডাৰউইন" },
            { "timezone.excity.Australia/Hobart", "হোবাৰ্ট" },
            { "timezone.excity.Australia/Sydney", "চিডনী" },
            { "timezone.excity.Europe/Amsterdam", "আমষ্টাৰডাম" },
            { "timezone.excity.Europe/Astrakhan", "আষ্ট্ৰাখান" },
            { "timezone.excity.Europe/Bucharest", "বুচাৰেষ্ট" },
            { "timezone.excity.Europe/Gibraltar", "জিব্ৰাল্টৰ" },
            { "timezone.excity.Europe/Ljubljana", "ল্যুবেলজানা" },
            { "timezone.excity.Europe/Mariehamn", "মাৰিয়াহেম" },
            { "timezone.excity.Europe/Podgorica", "পোডগোৰিকা" },
            { "timezone.excity.Europe/Stockholm", "ষ্টকহোম" },
            { "timezone.excity.Europe/Ulyanovsk", "উল্যানোভ্‌স্ক" },
            { "timezone.excity.Europe/Volgograd", "ভোল্গোগ্ৰাড" },
            { "timezone.excity.Indian/Christmas", "খ্ৰীষ্টমাছ" },
            { "timezone.excity.Indian/Kerguelen", "কেৰগুলেন" },
            { "timezone.excity.Indian/Mauritius", "মৰিছাছ" },
            { "timezone.excity.Pacific/Auckland", "অকলেণ্ড" },
            { "timezone.excity.Pacific/Funafuti", "ফুনাফুটি" },
            { "timezone.excity.Pacific/Pitcairn", "পিটকেইৰ্ণ" },
            { "timezone.excity.Africa/Casablanca", "কাছাব্লাংকা" },
            { "timezone.excity.Africa/Libreville", "লিব্ৰিভিলে" },
            { "timezone.excity.Africa/Lubumbashi", "লুবুম্বাচি" },
            { "timezone.excity.Africa/Nouakchott", "নৌআকচোট" },
            { "timezone.excity.Africa/Porto-Novo", "পোৰ্টো-নোভো" },
            { "timezone.excity.America/Anchorage", "এংকোৰেজ" },
            { "timezone.excity.America/Araguaina", "আৰাগায়েনা" },
            { "timezone.excity.America/Boa_Vista", "বোৱা ভিষ্টা" },
            { "timezone.excity.America/Catamarca", "কাটামাৰ্কা" },
            { "timezone.excity.America/Chihuahua", "চিহুআহুৱা" },
            { "timezone.excity.America/Coyhaique", "কোইহাইক" },
            { "timezone.excity.America/Fortaleza", "ফোৰ্টালেজা" },
            { "timezone.excity.America/Glace_Bay", "গ্লেচ উপসাগৰ" },
            { "timezone.excity.America/Goose_Bay", "গুছ উপসাগৰ" },
            { "timezone.excity.America/Guatemala", "গুৱাটেমালা" },
            { "timezone.excity.America/Guayaquil", "গায়াকুইল" },
            { "timezone.excity.America/Matamoros", "মাটামোৰোছ" },
            { "timezone.excity.America/Menominee", "মেনোমিনী" },
            { "timezone.excity.America/Monterrey", "মণ্টেৰেৰী" },
            { "timezone.excity.America/Sao_Paulo", "ছাও পাউলো" },
            { "timezone.excity.America/St_Thomas", "ছেইণ্ট থমাছ" },
            { "timezone.excity.America/Vancouver", "ভেনকুভেৰ" },
            { "timezone.excity.Antarctica/Mawson", "মাউছন" },
            { "timezone.excity.Antarctica/Palmer", "পামৰ" },
            { "timezone.excity.Antarctica/Vostok", "ভোষ্টক" },
            { "timezone.excity.Asia/Kuala_Lumpur", "কুৱালালুমপুৰ" },
            { "timezone.excity.Asia/Novokuznetsk", "নোভোকুজনেত্স্ক" },
            { "timezone.excity.Europe/Bratislava", "ব্ৰাটিছলাভা" },
            { "timezone.excity.Europe/Copenhagen", "কোপেনহাগেন" },
            { "timezone.excity.Europe/Luxembourg", "লাক্সেমবাৰ্গ" },
            { "timezone.excity.Europe/San_Marino", "চান মাৰিনো" },
            { "timezone.excity.Europe/Simferopol", "ছিম্ফেৰোপোল" },
            { "timezone.excity.Pacific/Enderbury", "কেণ্টন" },
            { "timezone.excity.Pacific/Galapagos", "গালাপাগোছ" },
            { "timezone.excity.Pacific/Kwajalein", "কোৱাজালিন" },
            { "timezone.excity.Pacific/Marquesas", "মাৰ্কছাছ" },
            { "timezone.excity.Pacific/Pago_Pago", "পাগো পাগো" },
            { "timezone.excity.Pacific/Rarotonga", "ৰাৰোটোঙ্গা" },
            { "timezone.excity.Pacific/Tongatapu", "টংগাটাপু" },
            { "timezone.excity.Africa/Addis_Ababa", "আদ্দিছ আবাবা" },
            { "timezone.excity.Africa/Brazzaville", "ব্ৰাজাভিলে" },
            { "timezone.excity.Africa/Ouagadougou", "ঔগাডোগো" },
            { "timezone.excity.America/Costa_Rica", "কোষ্টা ৰিকা" },
            { "timezone.excity.America/Grand_Turk", "গ্ৰেণ্ড টাৰ্ক" },
            { "timezone.excity.America/Guadeloupe", "গুৱাডেলুপ" },
            { "timezone.excity.America/Hermosillo", "হাৰ্মোছিল্লো" },
            { "timezone.excity.America/Kralendijk", "ক্ৰালেণ্ডিজিক" },
            { "timezone.excity.America/Louisville", "লুইছভিলে" },
            { "timezone.excity.America/Martinique", "মাৰ্টিনিক" },
            { "timezone.excity.America/Metlakatla", "মেটলাকাট্‌লা" },
            { "timezone.excity.America/Montevideo", "মণ্টেভিডিঅ’" },
            { "timezone.excity.America/Montserrat", "মণ্টছেৰাট" },
            { "timezone.excity.America/Paramaribo", "পাৰামাৰিবো" },
            { "timezone.excity.America/Rio_Branco", "ৰিঅ’ ব্ৰাংকো" },
            { "timezone.excity.America/St_Vincent", "ছেইণ্ট ভিনচেণ্ট" },
            { "timezone.excity.America/Whitehorse", "হোৱাইটহৰ্চ" },
            { "timezone.excity.Antarctica/McMurdo", "মেকমুৰ্ডু" },
            { "timezone.excity.Antarctica/Rothera", "ৰোথেৰা" },
            { "timezone.excity.Asia/Srednekolymsk", "স্ৰেডনিকোলিমস্ক" },
            { "timezone.excity.Asia/Yekaterinburg", "য়েকাটেৰিণবাৰ্গ" },
            { "timezone.excity.Atlantic/Reykjavik", "ৰেইকজাভিক" },
            { "timezone.excity.Atlantic/St_Helena", "ছেইণ্ট হেলেনা" },
            { "timezone.excity.Australia/Adelaide", "এডিলেইড" },
            { "timezone.excity.Australia/Brisbane", "ব্ৰিচবেন" },
            { "timezone.excity.Australia/Lindeman", "লিণ্ডমান" },
            { "timezone.excity.Europe/Isle_of_Man", "আইল অফ মেন" },
            { "timezone.excity.Europe/Kaliningrad", "কালিনিনগ্ৰাড" },
            { "timezone.excity.Pacific/Kiritimati", "কিৰিটিমাটি" },
            { "timezone.excity.Africa/Johannesburg", "জোহান্সবাৰ্গ" },
            { "timezone.excity.America/El_Salvador", "এল ছেলভেড’ৰ" },
            { "timezone.excity.America/Fort_Nelson", "ফ’ৰ্ট নেলছন" },
            { "timezone.excity.America/Los_Angeles", "লছ এঞ্জেলছ্" },
            { "timezone.excity.America/Mexico_City", "মেক্সিকো চিটী" },
            { "timezone.excity.America/Porto_Velho", "পোৰ্টো ভেল্‌হো" },
            { "timezone.excity.America/Puerto_Rico", "পুৱেৰ্টো ৰিকো" },
            { "timezone.excity.America/Tegucigalpa", "টেগুচিগাল্পা" },
            { "timezone.excity.Arctic/Longyearbyen", "লংগেইৰবায়েন" },
            { "timezone.excity.Atlantic/Cape_Verde", "কেপ ভাৰ্দে" },
            { "timezone.excity.Australia/Lord_Howe", "লৰ্ড হাও" },
            { "timezone.excity.Australia/Melbourne", "মেলব’ৰ্ণ" },
            { "timezone.excity.Indian/Antananarivo", "এণ্টানানাৰিভো" },
            { "timezone.excity.Pacific/Guadalcanal", "গুৱাডলকানাল" },
            { "timezone.excity.Africa/Dar_es_Salaam", "ডাৰ এছ ছালাম" },
            { "timezone.excity.America/Blanc-Sablon", "ব্লাংক-ছেবলোন" },
            { "timezone.excity.America/Buenos_Aires", "বুনছ আয়াৰ্ছ" },
            { "timezone.excity.America/Campo_Grande", "কেম্পো গ্ৰেণ্ডে" },
            { "timezone.excity.America/Danmarkshavn", "ডেনমাৰ্কশ্বন" },
            { "timezone.excity.America/Dawson_Creek", "ডাওছন ক্ৰীক" },
            { "timezone.excity.America/Indiana/Knox", "নক্স, ইণ্ডিয়ানা" },
            { "timezone.excity.America/Indianapolis", "ইণ্ডিয়ানাপ’লিছ" },
            { "timezone.excity.America/Punta_Arenas", "পুণ্টা এৰিনাছ" },
            { "timezone.excity.America/Rankin_Inlet", "ৰেংকিন ইনলেট" },
            { "timezone.excity.America/Scoresbysund", "ইটোকোৰ্টোৰমিট" },
            { "timezone.excity.Antarctica/Macquarie", "মেক্‌কুৱেৰী" },
            { "timezone.excity.Pacific/Bougainville", "বোগেইনভিলে" },
            { "timezone.excity.Pacific/Port_Moresby", "প’ৰ্ট মোৰেছ্‌বি" },
            { "timezone.excity.America/Cambridge_Bay", "কেমব্ৰিজ উপসাগৰ" },
            { "timezone.excity.America/Ciudad_Juarez", "চিউডে‘ড জৰেজ" },
            { "timezone.excity.America/Coral_Harbour", "আটিকোকান" },
            { "timezone.excity.America/Indiana/Vevay", "ভেভে, ইণ্ডিয়ানা" },
            { "timezone.excity.America/Lower_Princes", "ল’ৱাৰ প্ৰিন্সেছ কোৱাৰ্টাৰ" },
            { "timezone.excity.America/Port_of_Spain", "প’ৰ্ট অৱ স্পেইন" },
            { "timezone.excity.America/Santo_Domingo", "ছাণ্টো ডোমিংগো" },
            { "timezone.excity.America/St_Barthelemy", "ছেইণ্ট বাৰ্থলেমে" },
            { "timezone.excity.America/Swift_Current", "ছুইফ্ট কাৰেণ্ট" },
            { "timezone.excity.Australia/Broken_Hill", "ব্ৰোকেন হিল" },
            { "timezone.excity.America/Bahia_Banderas", "বাহিয়া বান্দেৰাছ" },
            { "timezone.excity.America/Port-au-Prince", "প’ৰ্ট-ঔ-প্ৰিন্স" },
            { "timezone.excity.Atlantic/South_Georgia", "দক্ষিণ জৰ্জিয়া" },
            { "timezone.excity.America/Argentina/Salta", "ছাল্টা" },
            { "timezone.excity.America/Indiana/Marengo", "মাৰেংগো, ইণ্ডিয়ানা" },
            { "timezone.excity.America/Indiana/Winamac", "উইনামেক, ইণ্ডিয়ানা" },
            { "timezone.excity.America/Argentina/Tucuman", "টুকুমন" },
            { "timezone.excity.America/Argentina/Ushuaia", "উচুআইয়া" },
            { "timezone.excity.America/Indiana/Tell_City", "টেল চিটী, ইণ্ডিয়ানা" },
            { "timezone.excity.America/Indiana/Vincennes", "ভিনচেনেছ, ইণ্ডিয়ানা" },
            { "timezone.excity.Antarctica/DumontDUrville", "ডুমোণ্ট ডি আৰ্ভিলৰ" },
            { "timezone.excity.America/Argentina/La_Rioja", "লা ৰিওজা" },
            { "timezone.excity.America/Argentina/San_Juan", "ছেন জুৱান" },
            { "timezone.excity.America/Argentina/San_Luis", "ছেন লুইচ" },
            { "timezone.excity.America/Indiana/Petersburg", "পিটাৰ্ছবাৰ্গ, ইণ্ডিয়ানা" },
            { "timezone.excity.America/Kentucky/Monticello", "মণ্টিচেলো, কেণ্টুকী" },
            { "timezone.excity.America/North_Dakota/Beulah", "বেউলাহ, উত্তৰ ডাকোটা" },
            { "timezone.excity.America/North_Dakota/Center", "চেণ্টাৰ, উত্তৰ ডাকোটা" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ৰিঅ’ গালেগোছ" },
            { "timezone.excity.America/North_Dakota/New_Salem", "নিউ ছালেম, উত্তৰ ডাকোটা" },
        };
        return data;
    }
}
