/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_vi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ssy = "Tiếng Saho";
        final String metaValue_key_nu = "Số";
        final Object[][] data = new Object[][] {
            { "001", "Thế giới" },
            { "002", "Châu Phi" },
            { "003", "Bắc Mỹ" },
            { "005", "Nam Mỹ" },
            { "009", "Châu Đại Dương" },
            { "011", "Tây Phi" },
            { "013", "Trung Mỹ" },
            { "014", "Đông Phi" },
            { "015", "Bắc Phi" },
            { "017", "Trung Phi" },
            { "018", "Miền Nam Châu Phi" },
            { "019", "Châu Mỹ" },
            { "021", "Miền Bắc Châu Mỹ" },
            { "029", "Ca-ri-bê" },
            { "030", "Đông Á" },
            { "034", "Nam Á" },
            { "035", "Đông Nam Á" },
            { "039", "Nam Âu" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Vùng Micronesia" },
            { "061", "Polynesia" },
            { "142", "Châu Á" },
            { "143", "Trung Á" },
            { "145", "Tây Á" },
            { "150", "Châu Âu" },
            { "151", "Đông Âu" },
            { "154", "Bắc Âu" },
            { "155", "Tây Âu" },
            { "202", "Châu Phi hạ Sahara" },
            { "419", "Châu Mỹ La-tinh" },
            { "AC", "Đảo Ascension" },
            { "AD", "Andorra" },
            { "AE", "Các Tiểu Vương quốc Ả Rập Thống nhất" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua và Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Nam Cực" },
            { "AR", "Argentina" },
            { "AS", "Samoa thuộc Mỹ" },
            { "AT", "Áo" },
            { "AU", "Úc" },
            { "AW", "Aruba" },
            { "AX", "Quần đảo Åland" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia và Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Bỉ" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Ca-ri-bê Hà Lan" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Đảo Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Quần đảo Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Cộng hòa Trung Phi" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Thụy Sĩ" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Quần đảo Cook" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "Trung Quốc" },
            { "CO", "Colombia" },
            { "CP", "Đảo Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Curaçao" },
            { "CX", "Đảo Giáng Sinh" },
            { "CY", "Síp" },
            { "CZ", "Séc" },
            { "DE", "Đức" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Đan Mạch" },
            { "DM", "Dominica" },
            { "DO", "Cộng hòa Dominica" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta và Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Ai Cập" },
            { "EH", "Tây Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Tây Ban Nha" },
            { "ET", "Ethiopia" },
            { "EU", "Liên Minh Châu Âu" },
            { "EZ", "Khu vực đồng Euro" },
            { "FI", "Phần Lan" },
            { "FJ", "Fiji" },
            { "FK", "Quần đảo Falkland" },
            { "FM", "Micronesia" },
            { "FO", "Quần đảo Faroe" },
            { "FR", "Pháp" },
            { "GA", "Gabon" },
            { "GB", "Vương quốc Anh" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guiana thuộc Pháp" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea Xích Đạo" },
            { "GR", "Hy Lạp" },
            { "GS", "Nam Georgia & Quần đảo Nam Sandwich" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Đặc khu Hành chính Hồng Kông, Trung Quốc" },
            { "HM", "Quần đảo Heard và McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "HT", "Haiti" },
            { "HU", "Hungary" },
            { "IC", "Quần đảo Canary" },
            { "ID", "Indonesia" },
            { "IE", "Ireland" },
            { "IL", "Israel" },
            { "IM", "Đảo Man" },
            { "IN", "Ấn Độ" },
            { "IO", "Lãnh thổ Ấn Độ Dương thuộc Anh" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "IT", "Italy" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Nhật Bản" },
            { "KE", "Kenya" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Campuchia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "St. Kitts và Nevis" },
            { "KP", "Triều Tiên" },
            { "KR", "Hàn Quốc" },
            { "KW", "Kuwait" },
            { "KY", "Quần đảo Cayman" },
            { "KZ", "Kazakhstan" },
            { "LA", "Lào" },
            { "LB", "Li-băng" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litva" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Ma-rốc" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagascar" },
            { "MH", "Quần đảo Marshall" },
            { "MK", "Bắc Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Miến Điện)" },
            { "MN", "Mông Cổ" },
            { "MO", "Đặc khu Hành chính Macao, Trung Quốc" },
            { "MP", "Quần đảo Bắc Mariana" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Đảo Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Hà Lan" },
            { "NO", "Na Uy" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polynesia thuộc Pháp" },
            { "PG", "Papua New Guinea" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Ba Lan" },
            { "PM", "Saint Pierre và Miquelon" },
            { "PN", "Quần đảo Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Lãnh thổ Palestine" },
            { "PT", "Bồ Đào Nha" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Vùng xa xôi thuộc Châu Đại Dương" },
            { "RE", "Réunion" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Nga" },
            { "RW", "Rwanda" },
            { "SA", "Ả Rập Xê-út" },
            { "SB", "Quần đảo Solomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Thụy Điển" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard và Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Nam Sudan" },
            { "ST", "São Tomé và Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Quần đảo Turks và Caicos" },
            { "TD", "Chad" },
            { "TF", "Lãnh thổ phía Nam Thuộc Pháp" },
            { "TG", "Togo" },
            { "TH", "Thái Lan" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Thổ Nhĩ Kỳ" },
            { "TT", "Trinidad và Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Đài Loan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Các tiểu đảo xa của Hoa Kỳ" },
            { "UN", "Liên hợp quốc" },
            { "US", "Hoa Kỳ" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Thành Vatican" },
            { "VC", "St. Vincent và Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Quần đảo Virgin thuộc Anh" },
            { "VI", "Quần đảo Virgin thuộc Hoa Kỳ" },
            { "VN", "Việt Nam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis và Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-Accents" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Nam Phi" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Vùng không xác định" },
            { "aa", "Tiếng Afar" },
            { "ab", "Tiếng Abkhazia" },
            { "ae", "Tiếng Avestan" },
            { "af", "Tiếng Hà Lan (Nam Phi)" },
            { "ak", "Tiếng Akan" },
            { "am", "Tiếng Amharic" },
            { "an", "Tiếng Aragon" },
            { "ar", "Tiếng Ả Rập" },
            { "as", "Tiếng Assam" },
            { "av", "Tiếng Avaric" },
            { "ay", "Tiếng Aymara" },
            { "az", "Tiếng Azerbaijan" },
            { "ba", "Tiếng Bashkir" },
            { "be", "Tiếng Belarus" },
            { "bg", "Tiếng Bulgaria" },
            { "bi", "Tiếng Bislama" },
            { "bm", "Tiếng Bambara" },
            { "bn", "Tiếng Bangla" },
            { "bo", "Tiếng Tây Tạng" },
            { "br", "Tiếng Breton" },
            { "bs", "Tiếng Bosnia" },
            { "ca", "Tiếng Catalan" },
            { "ce", "Tiếng Chechen" },
            { "ch", "Tiếng Chamorro" },
            { "co", "Tiếng Corsica" },
            { "cr", "Tiếng Cree" },
            { "cs", "Tiếng Séc" },
            { "cu", "Tiếng Slavơ Nhà thờ" },
            { "cv", "Tiếng Chuvash" },
            { "cy", "Tiếng Wales" },
            { "da", "Tiếng Đan Mạch" },
            { "de", "Tiếng Đức" },
            { "dv", "Tiếng Divehi" },
            { "dz", "Tiếng Dzongkha" },
            { "ee", "Tiếng Ewe" },
            { "el", "Tiếng Hy Lạp" },
            { "en", "Tiếng Anh" },
            { "eo", "Tiếng Quốc Tế Ngữ" },
            { "es", "Tiếng Tây Ban Nha" },
            { "et", "Tiếng Estonia" },
            { "eu", "Tiếng Basque" },
            { "fa", "Tiếng Ba Tư" },
            { "ff", "Tiếng Fulah" },
            { "fi", "Tiếng Phần Lan" },
            { "fj", "Tiếng Fiji" },
            { "fo", "Tiếng Faroe" },
            { "fr", "Tiếng Pháp" },
            { "fy", "Tiếng Frisia" },
            { "ga", "Tiếng Ireland" },
            { "gd", "Tiếng Gael Scotland" },
            { "gl", "Tiếng Galician" },
            { "gn", "Tiếng Guarani" },
            { "gu", "Tiếng Gujarati" },
            { "gv", "Tiếng Manx" },
            { "ha", "Tiếng Hausa" },
            { "he", "Tiếng Do Thái" },
            { "hi", "Tiếng Hindi" },
            { "ho", "Tiếng Hiri Motu" },
            { "hr", "Tiếng Croatia" },
            { "ht", "Tiếng Haiti" },
            { "hu", "Tiếng Hungary" },
            { "hy", "Tiếng Armenia" },
            { "hz", "Tiếng Herero" },
            { "ia", "Tiếng Khoa Học Quốc Tế" },
            { "id", "Tiếng Indonesia" },
            { "ie", "Tiếng Interlingue" },
            { "ig", "Tiếng Igbo" },
            { "ii", "Tiếng Di Tứ Xuyên" },
            { "ik", "Tiếng Inupiaq" },
            { "io", "Tiếng Ido" },
            { "is", "Tiếng Iceland" },
            { "it", "Tiếng Italy" },
            { "iu", "Tiếng Inuktitut" },
            { "ja", "Tiếng Nhật" },
            { "jv", "Tiếng Java" },
            { "ka", "Tiếng Georgia" },
            { "kg", "Tiếng Kongo" },
            { "ki", "Tiếng Kikuyu" },
            { "kj", "Tiếng Kuanyama" },
            { "kk", "Tiếng Kazakh" },
            { "kl", "Tiếng Kalaallisut" },
            { "km", "Tiếng Khmer" },
            { "kn", "Tiếng Kannada" },
            { "ko", "Tiếng Hàn" },
            { "kr", "Tiếng Kanuri" },
            { "ks", "Tiếng Kashmir" },
            { "ku", "Tiếng Kurmanji" },
            { "kv", "Tiếng Komi" },
            { "kw", "Tiếng Cornwall" },
            { "ky", "Tiếng Kyrgyz" },
            { "la", "Tiếng La-tinh" },
            { "lb", "Tiếng Luxembourg" },
            { "lg", "Tiếng Ganda" },
            { "li", "Tiếng Limburg" },
            { "ln", "Tiếng Lingala" },
            { "lo", "Tiếng Lào" },
            { "lt", "Tiếng Litva" },
            { "lu", "Tiếng Luba-Katanga" },
            { "lv", "Tiếng Latvia" },
            { "mg", "Tiếng Malagasy" },
            { "mh", "Tiếng Marshall" },
            { "mi", "Tiếng Māori" },
            { "mk", "Tiếng Macedonia" },
            { "ml", "Tiếng Malayalam" },
            { "mn", "Tiếng Mông Cổ" },
            { "mr", "Tiếng Marathi" },
            { "ms", "Tiếng Mã Lai" },
            { "mt", "Tiếng Malta" },
            { "my", "Tiếng Miến Điện" },
            { "na", "Tiếng Nauru" },
            { "nb", "Tiếng Na Uy (Bokmål)" },
            { "nd", "Tiếng Ndebele Miền Bắc" },
            { "ne", "Tiếng Nepal" },
            { "ng", "Tiếng Ndonga" },
            { "nl", "Tiếng Hà Lan" },
            { "nn", "Tiếng Na Uy (Nynorsk)" },
            { "no", "Tiếng Na Uy" },
            { "nr", "Tiếng Ndebele Miền Nam" },
            { "nv", "Tiếng Navajo" },
            { "ny", "Tiếng Nyanja" },
            { "oc", "Tiếng Occitan" },
            { "oj", "Tiếng Ojibwa" },
            { "om", "Tiếng Oromo" },
            { "or", "Tiếng Odia" },
            { "os", "Tiếng Ossetic" },
            { "pa", "Tiếng Punjab" },
            { "pi", "Tiếng Pali" },
            { "pl", "Tiếng Ba Lan" },
            { "ps", "Tiếng Pashto" },
            { "pt", "Tiếng Bồ Đào Nha" },
            { "qu", "Tiếng Quechua" },
            { "rm", "Tiếng Romansh" },
            { "rn", "Tiếng Rundi" },
            { "ro", "Tiếng Romania" },
            { "ru", "Tiếng Nga" },
            { "rw", "Tiếng Kinyarwanda" },
            { "sa", "Tiếng Phạn" },
            { "sc", "Tiếng Sardinia" },
            { "sd", "Tiếng Sindhi" },
            { "se", "Tiếng Sami Miền Bắc" },
            { "sg", "Tiếng Sango" },
            { "sh", "Tiếng Serbo-Croatia" },
            { "si", "Tiếng Sinhala" },
            { "sk", "Tiếng Slovak" },
            { "sl", "Tiếng Slovenia" },
            { "sm", "Tiếng Samoa" },
            { "sn", "Tiếng Shona" },
            { "so", "Tiếng Somali" },
            { "sq", "Tiếng Albania" },
            { "sr", "Tiếng Serbia" },
            { "ss", "Tiếng Swati" },
            { "st", "Tiếng Nam Sotho" },
            { "su", "Tiếng Sunda" },
            { "sv", "Tiếng Thụy Điển" },
            { "sw", "Tiếng Swahili" },
            { "ta", "Tiếng Tamil" },
            { "te", "Tiếng Telugu" },
            { "tg", "Tiếng Tajik" },
            { "th", "Tiếng Thái" },
            { "ti", "Tiếng Tigrinya" },
            { "tk", "Tiếng Turkmen" },
            { "tl", "Tiếng Tagalog" },
            { "tn", "Tiếng Tswana" },
            { "to", "Tiếng Tonga" },
            { "tr", "Tiếng Thổ Nhĩ Kỳ" },
            { "ts", "Tiếng Tsonga" },
            { "tt", "Tiếng Tatar" },
            { "tw", "Tiếng Twi" },
            { "ty", "Tiếng Tahiti" },
            { "ug", "Tiếng Uyghur" },
            { "uk", "Tiếng Ukraina" },
            { "ur", "Tiếng Urdu" },
            { "uz", "Tiếng Uzbek" },
            { "ve", "Tiếng Venda" },
            { "vi", "Tiếng Việt" },
            { "vo", "Tiếng Volapük" },
            { "wa", "Tiếng Walloon" },
            { "wo", "Tiếng Wolof" },
            { "xh", "Tiếng Xhosa" },
            { "yi", "Tiếng Yiddish" },
            { "yo", "Tiếng Yoruba" },
            { "za", "Tiếng Choang" },
            { "zh", "Tiếng Trung" },
            { "zu", "Tiếng Zulu" },
            { "ace", "Tiếng Achinese" },
            { "ach", "Tiếng Acoli" },
            { "ada", "Tiếng Adangme" },
            { "ady", "Tiếng Adyghe" },
            { "afh", "Tiếng Afrihili" },
            { "agq", "Tiếng Aghem" },
            { "ain", "Tiếng Ainu" },
            { "akk", "Tiếng Akkadia" },
            { "akz", "Tiếng Alabama" },
            { "ale", "Tiếng Aleut" },
            { "aln", "Tiếng Gheg Albani" },
            { "alt", "Tiếng Altai Miền Nam" },
            { "ang", "Tiếng Anh cổ" },
            { "ann", "Tiếng Obolo" },
            { "anp", "Tiếng Angika" },
            { "arc", "Tiếng Aramaic" },
            { "arn", "Tiếng Mapuche" },
            { "aro", "Tiếng Araona" },
            { "arp", "Tiếng Arapaho" },
            { "arq", "Tiếng Ả Rập Algeria" },
            { "ars", "Tiếng Ả Rập Najdi" },
            { "arw", "Tiếng Arawak" },
            { "arz", "Tiếng Ả Rập Ai Cập" },
            { "asa", "Tiếng Asu" },
            { "ase", "Ngôn ngữ Ký hiệu Mỹ" },
            { "ast", "Tiếng Asturias" },
            { "atj", "Tiếng Atikamekw" },
            { "awa", "Tiếng Awadhi" },
            { "bal", "Tiếng Baloch" },
            { "ban", "Tiếng Bali" },
            { "bar", "Tiếng Bavaria" },
            { "bas", "Tiếng Basaa" },
            { "bax", "Tiếng Bamun" },
            { "bbc", "Tiếng Batak Toba" },
            { "bbj", "Tiếng Ghomala" },
            { "bej", "Tiếng Beja" },
            { "bem", "Tiếng Bemba" },
            { "bew", "Tiếng Betawi" },
            { "bez", "Tiếng Bena" },
            { "bfd", "Tiếng Bafut" },
            { "bfq", "Tiếng Badaga" },
            { "bgc", "Tiếng Haryana" },
            { "bgn", "Tiếng Tây Balochi" },
            { "bho", "Tiếng Bhojpuri" },
            { "bik", "Tiếng Bikol" },
            { "bin", "Tiếng Bini" },
            { "bjn", "Tiếng Banjar" },
            { "bkm", "Tiếng Kom" },
            { "bla", "Tiếng Siksika" },
            { "blo", "Anii" },
            { "bpy", "Tiếng Bishnupriya" },
            { "bqi", "Tiếng Bakhtiari" },
            { "bra", "Tiếng Braj" },
            { "brh", "Tiếng Brahui" },
            { "brx", "Tiếng Bodo" },
            { "bss", "Tiếng Akoose" },
            { "bua", "Tiếng Buriat" },
            { "bug", "Tiếng Bugin" },
            { "bum", "Tiếng Bulu" },
            { "byn", "Tiếng Blin" },
            { "byv", "Tiếng Medumba" },
            { "cad", "Tiếng Caddo" },
            { "car", "Tiếng Carib" },
            { "cay", "Tiếng Cayuga" },
            { "cch", "Tiếng Atsam" },
            { "ccp", "Tiếng Chakma" },
            { "ceb", "Tiếng Cebuano" },
            { "cgg", "Tiếng Chiga" },
            { "chb", "Tiếng Chibcha" },
            { "chg", "Tiếng Chagatai" },
            { "chk", "Tiếng Chuuk" },
            { "chm", "Tiếng Mari" },
            { "chn", "Biệt ngữ Chinook" },
            { "cho", "Tiếng Choctaw" },
            { "chp", "Tiếng Chipewyan" },
            { "chr", "Tiếng Cherokee" },
            { "chy", "Tiếng Cheyenne" },
            { "ckb", "Tiếng Kurd Miền Trung" },
            { "clc", "Tiếng Chilcotin" },
            { "cop", "Tiếng Coptic" },
            { "cps", "Tiếng Capiznon" },
            { "crg", "Tiếng Michif" },
            { "crh", "Tiếng Thổ Nhĩ Kỳ Crimean" },
            { "crj", "Tiếng Cree Đông Nam" },
            { "crk", "Tiếng Plains Cree" },
            { "crl", "Tiếng Cree Đông Bắc" },
            { "crm", "Tiếng Moose Cree" },
            { "crr", "Tiếng Carolina Algonquian" },
            { "crs", "Tiếng Pháp Seselwa Creole" },
            { "csb", "Tiếng Kashubia" },
            { "csw", "Tiếng Swampy Cree" },
            { "dak", "Tiếng Dakota" },
            { "dar", "Tiếng Dargwa" },
            { "dav", "Tiếng Taita" },
            { "del", "Tiếng Delaware" },
            { "den", "Tiếng Slave" },
            { "dgr", "Tiếng Dogrib" },
            { "din", "Tiếng Dinka" },
            { "dje", "Tiếng Zarma" },
            { "doi", "Tiếng Dogri" },
            { "dsb", "Tiếng Hạ Sorbia" },
            { "dtp", "Tiếng Dusun Miền Trung" },
            { "dua", "Tiếng Duala" },
            { "dum", "Tiếng Hà Lan Trung cổ" },
            { "dyo", "Tiếng Jola-Fonyi" },
            { "dyu", "Tiếng Dyula" },
            { "dzg", "Tiếng Dazaga" },
            { "ebu", "Tiếng Embu" },
            { "efi", "Tiếng Efik" },
            { "egl", "Tiếng Emilia" },
            { "egy", "Tiếng Ai Cập cổ" },
            { "eka", "Tiếng Ekajuk" },
            { "elx", "Tiếng Elamite" },
            { "enm", "Tiếng Anh Trung cổ" },
            { "esu", "Tiếng Yupik Miền Trung" },
            { "ewo", "Tiếng Ewondo" },
            { "ext", "Tiếng Extremadura" },
            { "fan", "Tiếng Fang" },
            { "fat", "Tiếng Fanti" },
            { "fil", "Tiếng Philippines" },
            { "fon", "Tiếng Fon" },
            { "frc", "Tiếng Pháp Cajun" },
            { "frm", "Tiếng Pháp Trung cổ" },
            { "fro", "Tiếng Pháp cổ" },
            { "frp", "Tiếng Arpitan" },
            { "frr", "Tiếng Frisia Miền Bắc" },
            { "frs", "Tiếng Frisian Miền Đông" },
            { "fur", "Tiếng Friulian" },
            { "gaa", "Tiếng Ga" },
            { "gag", "Tiếng Gagauz" },
            { "gan", "Tiếng Cám" },
            { "gay", "Tiếng Gayo" },
            { "gba", "Tiếng Gbaya" },
            { "gez", "Tiếng Geez" },
            { "gil", "Tiếng Gilbert" },
            { "glk", "Tiếng Gilaki" },
            { "gmh", "Tiếng Thượng Giéc-man Trung cổ" },
            { "goh", "Tiếng Thượng Giéc-man cổ" },
            { "gon", "Tiếng Gondi" },
            { "gor", "Tiếng Gorontalo" },
            { "got", "Tiếng Gô-tích" },
            { "grb", "Tiếng Grebo" },
            { "grc", "Tiếng Hy Lạp cổ" },
            { "gsw", "Tiếng Đức (Thụy Sĩ)" },
            { "gur", "Tiếng Frafra" },
            { "guz", "Tiếng Gusii" },
            { "gwi", "Tiếng Gwichʼin" },
            { "hai", "Tiếng Haida" },
            { "hak", "Tiếng Khách Gia" },
            { "haw", "Tiếng Hawaii" },
            { "hax", "Tiếng Haida miền Nam" },
            { "hif", "Tiếng Fiji Hindi" },
            { "hil", "Tiếng Hiligaynon" },
            { "hit", "Tiếng Hittite" },
            { "hmn", "Tiếng H’Mông" },
            { "hsb", "Tiếng Thượng Sorbia" },
            { "hsn", "Tiếng Tương" },
            { "hup", "Tiếng Hupa" },
            { "hur", "Tiếng Halkomelem" },
            { "iba", "Tiếng Iban" },
            { "ibb", "Tiếng Ibibio" },
            { "ikt", "Tiếng Inuktitut miền Tây Canada" },
            { "ilo", "Tiếng Iloko" },
            { "inh", "Tiếng Ingush" },
            { "izh", "Tiếng Ingria" },
            { "jam", "Tiếng Anh Jamaica Creole" },
            { "jbo", "Tiếng Lojban" },
            { "jgo", "Tiếng Ngomba" },
            { "jmc", "Tiếng Machame" },
            { "jpr", "Tiếng Judeo-Ba Tư" },
            { "jrb", "Tiếng Judeo-Ả Rập" },
            { "jut", "Tiếng Jutish" },
            { "kaa", "Tiếng Kara-Kalpak" },
            { "kab", "Tiếng Kabyle" },
            { "kac", "Tiếng Kachin" },
            { "kaj", "Tiếng Jju" },
            { "kam", "Tiếng Kamba" },
            { "kaw", "Tiếng Kawi" },
            { "kbd", "Tiếng Kabardian" },
            { "kbl", "Tiếng Kanembu" },
            { "kcg", "Tiếng Tyap" },
            { "kde", "Tiếng Makonde" },
            { "kea", "Tiếng Kabuverdianu" },
            { "kfo", "Tiếng Koro" },
            { "kgp", "Tiếng Kaingang" },
            { "kha", "Tiếng Khasi" },
            { "kho", "Tiếng Khotan" },
            { "khq", "Tiếng Koyra Chiini" },
            { "kkj", "Tiếng Kako" },
            { "kln", "Tiếng Kalenjin" },
            { "kmb", "Tiếng Kimbundu" },
            { "koi", "Tiếng Komi-Permyak" },
            { "kok", "Tiếng Konkani" },
            { "kos", "Tiếng Kosrae" },
            { "kpe", "Tiếng Kpelle" },
            { "krc", "Tiếng Karachay-Balkar" },
            { "krl", "Tiếng Karelian" },
            { "kru", "Tiếng Kurukh" },
            { "ksb", "Tiếng Shambala" },
            { "ksf", "Tiếng Bafia" },
            { "ksh", "Tiếng Cologne" },
            { "kum", "Tiếng Kumyk" },
            { "kut", "Tiếng Kutenai" },
            { "kwk", "Tiếng Kwakʼwala" },
            { "kxv", "Tiếng Kuvi" },
            { "lad", "Tiếng Ladino" },
            { "lag", "Tiếng Langi" },
            { "lah", "Tiếng Lahnda" },
            { "lam", "Tiếng Lamba" },
            { "lez", "Tiếng Lezghian" },
            { "lij", "Tiếng Liguria" },
            { "lil", "Tiếng Lillooet" },
            { "lkt", "Tiếng Lakota" },
            { "lmo", "Tiếng Lombard" },
            { "lol", "Tiếng Mongo" },
            { "lou", "Tiếng Creole Louisiana" },
            { "loz", "Tiếng Lozi" },
            { "lrc", "Tiếng Bắc Luri" },
            { "lsm", "Tiếng Saamia" },
            { "lua", "Tiếng Luba-Lulua" },
            { "lui", "Tiếng Luiseno" },
            { "lun", "Tiếng Lunda" },
            { "luo", "Tiếng Luo" },
            { "lus", "Tiếng Lushai" },
            { "luy", "Tiếng Luyia" },
            { "mad", "Tiếng Madura" },
            { "maf", "Tiếng Mafa" },
            { "mag", "Tiếng Magahi" },
            { "mai", "Tiếng Maithili" },
            { "mak", "Tiếng Makasar" },
            { "man", "Tiếng Mandingo" },
            { "mas", "Tiếng Masai" },
            { "mde", "Tiếng Maba" },
            { "mdf", "Tiếng Moksha" },
            { "mdr", "Tiếng Mandar" },
            { "men", "Tiếng Mende" },
            { "mer", "Tiếng Meru" },
            { "mfe", "Tiếng Morisyen" },
            { "mga", "Tiếng Ai-len Trung cổ" },
            { "mgh", "Tiếng Makhuwa-Meetto" },
            { "mgo", "Tiếng Meta’" },
            { "mic", "Tiếng Micmac" },
            { "min", "Tiếng Minangkabau" },
            { "mnc", "Tiếng Mãn Châu" },
            { "mni", "Tiếng Manipuri" },
            { "moe", "Tiếng Innu-aimun" },
            { "moh", "Tiếng Mohawk" },
            { "mos", "Tiếng Mossi" },
            { "mua", "Tiếng Mundang" },
            { "mul", "Nhiều ngôn ngữ" },
            { "mus", "Tiếng Creek" },
            { "mwl", "Tiếng Miranda" },
            { "mwr", "Tiếng Marwari" },
            { "mye", "Tiếng Myene" },
            { "myv", "Tiếng Erzya" },
            { "mzn", "Tiếng Mazanderani" },
            { "nan", "Tiếng Mân Nam" },
            { "nap", "Tiếng Napoli" },
            { "naq", "Tiếng Nama" },
            { "nds", "Tiếng Hạ Đức" },
            { "new", "Tiếng Newari" },
            { "nia", "Tiếng Nias" },
            { "niu", "Tiếng Niuean" },
            { "njo", "Tiếng Ao Naga" },
            { "nmg", "Tiếng Kwasio" },
            { "nnh", "Tiếng Ngiemboon" },
            { "nog", "Tiếng Nogai" },
            { "non", "Tiếng Na Uy cổ" },
            { "nqo", "Tiếng N’Ko" },
            { "nso", "Tiếng Bắc Sotho" },
            { "nus", "Tiếng Nuer" },
            { "nwc", "Tiếng Newari cổ" },
            { "nym", "Tiếng Nyamwezi" },
            { "nyn", "Tiếng Nyankole" },
            { "nyo", "Tiếng Nyoro" },
            { "nzi", "Tiếng Nzima" },
            { "ojb", "Tiếng Ojibwe Tây Bắc" },
            { "ojc", "Tiếng Ojibwe miền Trung" },
            { "ojs", "Tiếng Oji-Cree" },
            { "ojw", "Tiếng Ojibwe miền Tây" },
            { "oka", "Tiếng Okanagan" },
            { "osa", "Tiếng Osage" },
            { "ota", "Tiếng Thổ Nhĩ Kỳ Ottoman" },
            { "pag", "Tiếng Pangasinan" },
            { "pal", "Tiếng Pahlavi" },
            { "pam", "Tiếng Pampanga" },
            { "pap", "Tiếng Papiamento" },
            { "pau", "Tiếng Palauan" },
            { "pcm", "Pidgin Nigeria" },
            { "peo", "Tiếng Ba Tư cổ" },
            { "phn", "Tiếng Phoenicia" },
            { "pis", "Tiếng Pijin" },
            { "pon", "Tiếng Pohnpeian" },
            { "pqm", "Tiếng Maliseet-Passamaquoddy" },
            { "prg", "Tiếng Prussia" },
            { "pro", "Tiếng Provençal cổ" },
            { "quc", "Tiếng Kʼicheʼ" },
            { "qug", "Tiếng Quechua ở Cao nguyên Chimborazo" },
            { "raj", "Tiếng Rajasthani" },
            { "rap", "Tiếng Rapanui" },
            { "rar", "Tiếng Rarotongan" },
            { "rhg", "Tiếng Rohingya" },
            { "rof", "Tiếng Rombo" },
            { "rom", "Tiếng Romany" },
            { "rup", "Tiếng Aromania" },
            { "rwk", "Tiếng Rwa" },
            { "sad", "Tiếng Sandawe" },
            { "sah", "Tiếng Sakha" },
            { "sam", "Tiếng Samaritan Aramaic" },
            { "saq", "Tiếng Samburu" },
            { "sas", "Tiếng Sasak" },
            { "sat", "Tiếng Santali" },
            { "sba", "Tiếng Ngambay" },
            { "sbp", "Tiếng Sangu" },
            { "scn", "Tiếng Sicilia" },
            { "sco", "Tiếng Scots" },
            { "sdh", "Tiếng Kurd Miền Nam" },
            { "see", "Tiếng Seneca" },
            { "seh", "Tiếng Sena" },
            { "sel", "Tiếng Selkup" },
            { "ses", "Tiếng Koyraboro Senni" },
            { "sga", "Tiếng Ai-len cổ" },
            { "shi", "Tiếng Tachelhit" },
            { "shn", "Tiếng Shan" },
            { "shu", "Tiếng Ả-Rập Chad" },
            { "sid", "Tiếng Sidamo" },
            { "slh", "Tiếng Lushootseed miền Nam" },
            { "sma", "Tiếng Sami Miền Nam" },
            { "smj", "Tiếng Lule Sami" },
            { "smn", "Tiếng Inari Sami" },
            { "sms", "Tiếng Skolt Sami" },
            { "snk", "Tiếng Soninke" },
            { "sog", "Tiếng Sogdien" },
            { "srn", "Tiếng Sranan Tongo" },
            { "srr", "Tiếng Serer" },
            { "ssy", metaValue_ssy },
            { "str", "Tiếng Straits Salish" },
            { "suk", "Tiếng Sukuma" },
            { "sus", "Tiếng Susu" },
            { "sux", "Tiếng Sumeria" },
            { "swb", "Tiếng Cômo" },
            { "syc", "Tiếng Syriac cổ" },
            { "syr", "Tiếng Syriac" },
            { "szl", "Tiếng Silesia" },
            { "tce", "Tiếng Tutchone miền Nam" },
            { "tem", "Tiếng Timne" },
            { "teo", "Tiếng Teso" },
            { "ter", "Tiếng Tereno" },
            { "tet", "Tiếng Tetum" },
            { "tgx", "Tiếng Tagish" },
            { "tht", "Tiếng Tahltan" },
            { "tig", "Tiếng Tigre" },
            { "tiv", "Tiếng Tiv" },
            { "tkl", "Tiếng Tokelau" },
            { "tlh", "Tiếng Klingon" },
            { "tli", "Tiếng Tlingit" },
            { "tmh", "Tiếng Tamashek" },
            { "tog", "Tiếng Nyasa Tonga" },
            { "tok", "Tiếng Toki Pona" },
            { "tpi", "Tiếng Tok Pisin" },
            { "trv", "Tiếng Taroko" },
            { "tsi", "Tiếng Tsimshian" },
            { "ttm", "Tiếng Tutchone miền Bắc" },
            { "tum", "Tiếng Tumbuka" },
            { "tvl", "Tiếng Tuvalu" },
            { "twq", "Tiếng Tasawaq" },
            { "tyv", "Tiếng Tuvinian" },
            { "tzm", "Tiếng Tamazight Miền Trung Ma-rốc" },
            { "udm", "Tiếng Udmurt" },
            { "uga", "Tiếng Ugaritic" },
            { "umb", "Tiếng Umbundu" },
            { "und", "Ngôn ngữ không xác định" },
            { "vai", "Tiếng Vai" },
            { "vec", "Tiếng Veneto" },
            { "vmw", "Tiếng Makhuwa" },
            { "vot", "Tiếng Votic" },
            { "vun", "Tiếng Vunjo" },
            { "wae", "Tiếng Walser" },
            { "wal", "Tiếng Walamo" },
            { "war", "Tiếng Waray" },
            { "was", "Tiếng Washo" },
            { "wbp", "Tiếng Warlpiri" },
            { "wuu", "Tiếng Ngô" },
            { "xal", "Tiếng Kalmyk" },
            { "xnr", "Tiếng Kangri" },
            { "xog", "Tiếng Soga" },
            { "yao", "Tiếng Yao" },
            { "yap", "Tiếng Yap" },
            { "yav", "Tiếng Yangben" },
            { "ybb", "Tiếng Yemba" },
            { "yrl", "Tiếng Nheengatu" },
            { "yue", "Tiếng Quảng Đông" },
            { "zap", "Tiếng Zapotec" },
            { "zbl", "Ký hiệu Blissymbols" },
            { "zen", "Tiếng Zenaga" },
            { "zgh", "Tiếng Tamazight Chuẩn của Ma-rốc" },
            { "zun", "Tiếng Zuni" },
            { "zxx", "Không có nội dung ngôn ngữ" },
            { "zza", "Tiếng Zaza" },
            { "Adlm", "Chữ Adlam" },
            { "Afak", "Chữ Afaka" },
            { "Arab", "Chữ Ả Rập" },
            { "Aran", "Chữ Nastaliq" },
            { "Armi", "Chữ Imperial Aramaic" },
            { "Armn", "Chữ Armenia" },
            { "Avst", "Chữ Avestan" },
            { "Bali", "Chữ Bali" },
            { "Bamu", "Chữ Bamum" },
            { "Bass", "Chữ Bassa Vah" },
            { "Batk", "Chữ Batak" },
            { "Beng", "Chữ Bangla" },
            { "Blis", "Chữ Blissymbols" },
            { "Bopo", "Chữ Bopomofo" },
            { "Brah", "Chữ Brahmi" },
            { "Brai", "Chữ nổi Braille" },
            { "Bugi", "Chữ Bugin" },
            { "Buhd", "Chữ Buhid" },
            { "Cakm", "Chữ Chakma" },
            { "Cans", "Âm tiết Thổ dân Canada Hợp nhất" },
            { "Cari", "Chữ Caria" },
            { "Cham", "Chữ Chăm" },
            { "Cher", "Chữ Cherokee" },
            { "Cirt", "Chữ Cirth" },
            { "Copt", "Chữ Coptic" },
            { "Cprt", "Chứ Síp" },
            { "Cyrl", "Chữ Kirin" },
            { "Cyrs", "Chữ Kirin Slavơ Nhà thờ cổ" },
            { "Deva", "Chữ Devanagari" },
            { "Dsrt", "Chữ Deseret" },
            { "Dupl", "Chữ tốc ký Duployan" },
            { "Egyd", "Chữ Ai Cập bình dân" },
            { "Egyh", "Chữ Ai Cập thày tu" },
            { "Egyp", "Chữ tượng hình Ai Cập" },
            { "Ethi", "Chữ Ethiopia" },
            { "Geok", "Chữ Khutsuri Georgia" },
            { "Geor", "Chữ Georgia" },
            { "Glag", "Chữ Glagolitic" },
            { "Goth", "Chữ Gô-tích" },
            { "Gran", "Chữ Grantha" },
            { "Grek", "Chữ Hy Lạp" },
            { "Gujr", "Chữ Gujarati" },
            { "Guru", "Chữ Gurmukhi" },
            { "Hanb", "Chữ Hán có chú âm" },
            { "Hang", "Chữ Hàn" },
            { "Hani", "Chữ Hán" },
            { "Hano", "Chữ Hanunoo" },
            { "Hans", "Giản thể" },
            { "Hant", "Phồn thể" },
            { "Hebr", "Chữ Do Thái" },
            { "Hira", "Chữ Hiragana" },
            { "Hluw", "Chữ tượng hình Anatolia" },
            { "Hmng", "Chữ Pahawh Hmong" },
            { "Hrkt", "Bảng ký hiệu âm tiết Tiếng Nhật" },
            { "Hung", "Chữ Hungary cổ" },
            { "Inds", "Chữ Indus" },
            { "Ital", "Chữ Italic cổ" },
            { "Jamo", "Chữ Jamo" },
            { "Java", "Chữ Java" },
            { "Jpan", "Chữ Nhật Bản" },
            { "Jurc", "Chữ Jurchen" },
            { "Kali", "Chữ Kayah Li" },
            { "Kana", "Chữ Katakana" },
            { "Khar", "Chữ Kharoshthi" },
            { "Khmr", "Chữ Khơ-me" },
            { "Khoj", "Chữ Khojki" },
            { "Knda", "Chữ Kannada" },
            { "Kore", "Chữ Hàn Quốc" },
            { "Kpel", "Chữ Kpelle" },
            { "Kthi", "Chữ Kaithi" },
            { "Lana", "Chữ Lanna" },
            { "Laoo", "Chữ Lào" },
            { "Latf", "Chữ La-tinh Fraktur" },
            { "Latg", "Chữ La-tinh Xcốt-len" },
            { "Latn", "Chữ La tinh" },
            { "Lepc", "Chữ Lepcha" },
            { "Limb", "Chữ Limbu" },
            { "Lina", "Chữ Linear A" },
            { "Linb", "Chữ Linear B" },
            { "Lisu", "Chữ Fraser" },
            { "Loma", "Chữ Loma" },
            { "Lyci", "Chữ Lycia" },
            { "Lydi", "Chữ Lydia" },
            { "Mand", "Chữ Mandaean" },
            { "Mani", "Chữ Manichaean" },
            { "Maya", "Chữ tượng hình Maya" },
            { "Mend", "Chữ Mende" },
            { "Merc", "Chữ Meroitic Nét thảo" },
            { "Mero", "Chữ Meroitic" },
            { "Mlym", "Chữ Malayalam" },
            { "Mong", "Chữ Mông Cổ" },
            { "Moon", "Chữ nổi Moon" },
            { "Mroo", "Chữ Mro" },
            { "Mtei", "Chữ Meitei Mayek" },
            { "Mymr", "Chữ Myanmar" },
            { "Narb", "Chữ Bắc Ả Rập cổ" },
            { "Nbat", "Chữ Nabataean" },
            { "Nkgb", "Chữ Naxi Geba" },
            { "Nkoo", "Chữ N’Ko" },
            { "Nshu", "Chữ Nüshu" },
            { "Ogam", "Chữ Ogham" },
            { "Olck", "Chữ Ol Chiki" },
            { "Orkh", "Chữ Orkhon" },
            { "Orya", "Chữ Odia" },
            { "Osma", "Chữ Osmanya" },
            { "Palm", "Chữ Palmyrene" },
            { "Perm", "Chữ Permic cổ" },
            { "Phag", "Chữ Phags-pa" },
            { "Phli", "Chữ Pahlavi Văn bia" },
            { "Phlp", "Chữ Pahlavi Thánh ca" },
            { "Phlv", "Chữ Pahlavi Sách" },
            { "Phnx", "Chữ Phoenicia" },
            { "Plrd", "Ngữ âm Pollard" },
            { "Prti", "Chữ Parthia Văn bia" },
            { "Qaag", "Chữ Zawgyi" },
            { "Rjng", "Chữ Rejang" },
            { "Rohg", "Chữ Hanifi" },
            { "Roro", "Chữ Rongorongo" },
            { "Runr", "Chữ Runic" },
            { "Samr", "Chữ Samaritan" },
            { "Sara", "Chữ Sarati" },
            { "Sarb", "Chữ Nam Ả Rập cổ" },
            { "Saur", "Chữ Saurashtra" },
            { "Sgnw", "Chữ viết Ký hiệu" },
            { "Shaw", "Chữ Shavian" },
            { "Shrd", "Chữ Sharada" },
            { "Sind", "Chữ Khudawadi" },
            { "Sinh", "Chữ Sinhala" },
            { "Sora", "Chữ Sora Sompeng" },
            { "Sund", "Chữ Xu-đăng" },
            { "Sylo", "Chữ Syloti Nagri" },
            { "Syrc", "Chữ Syria" },
            { "Syre", "Chữ Estrangelo Syriac" },
            { "Syrj", "Chữ Tây Syria" },
            { "Syrn", "Chữ Đông Syria" },
            { "Tagb", "Chữ Tagbanwa" },
            { "Takr", "Chữ Takri" },
            { "Tale", "Chữ Thái Na" },
            { "Talu", "Chữ Thái Lặc mới" },
            { "Taml", "Chữ Tamil" },
            { "Tang", "Chữ Tangut" },
            { "Tavt", "Chữ Thái Việt" },
            { "Telu", "Chữ Telugu" },
            { "Teng", "Chữ Tengwar" },
            { "Tfng", "Chữ Tifinagh" },
            { "Tglg", "Chữ Tagalog" },
            { "Thaa", "Chữ Thaana" },
            { "Thai", "Chữ Thái" },
            { "Tibt", "Chữ Tây Tạng" },
            { "Tirh", "Chữ Tirhuta" },
            { "Ugar", "Chữ Ugarit" },
            { "Vaii", "Chữ Vai" },
            { "Visp", "Tiếng nói Nhìn thấy được" },
            { "Wara", "Chữ Varang Kshiti" },
            { "Wole", "Chữ Woleai" },
            { "Xpeo", "Chữ Ba Tư cổ" },
            { "Xsux", "Chữ hình nêm Sumero-Akkadian" },
            { "Yiii", "Chữ Di" },
            { "Zinh", "Chữ Kế thừa" },
            { "Zmth", "Ký hiệu Toán học" },
            { "Zsye", "Biểu tượng cảm xúc" },
            { "Zsym", "Biểu tượng | Ký hiệu" },
            { "Zxxx", "Chưa có chữ viết" },
            { "Zyyy", "Chung" },
            { "Zzzz", "Chữ viết không xác định" },
            { "de_CH", "Tiếng Thượng Giéc-man (Thụy Sĩ)" },
            { "en_GB", "Tiếng Anh (Anh)" },
            { "en_US", "Tiếng Anh (Mỹ)" },
            { "es_ES", "Tiếng Tây Ban Nha (Châu Âu)" },
            { "fa_AF", "Tiếng Dari" },
            { "pt_PT", "Tiếng Bồ Đào Nha (Châu Âu)" },
            { "ro_MD", "Tiếng Moldova" },
            { "sw_CD", "Tiếng Swahili Congo" },
            { "%%1901", "Phép chính tả Tiếng Đức Truyền thống" },
            { "%%1994", "Phép chính tả Resian Chuẩn hóa" },
            { "%%1996", "Phép chính tả Tiếng Đức năm 1996" },
            { "ar_001", "Tiếng Ả Rập Hiện đại" },
            { "es_419", "Tiếng Tây Ban Nha (Mỹ La tinh)" },
            { "key.ca", "Lịch" },
            { "key.cf", "Định dạng tiền tệ" },
            { "key.co", "Thứ tự sắp xếp" },
            { "key.cu", "Tiền tệ" },
            { "key.em", "Trình bày emoji" },
            { "key.hc", "Chu kỳ giờ (12 với 24)" },
            { "key.lb", "Kiểu xuống dòng" },
            { "key.lw", "Ngắt dòng trong từ" },
            { "key.ms", "Hệ thống đo lường" },
            { "key.nu", metaValue_key_nu },
            { "key.ss", "Ngắt câu sau khi viết tắt." },
            { "key.tz", "Múi giờ" },
            { "key.va", "Biến thể ngôn ngữ" },
            { "nds_NL", "Tiếng Hạ Saxon" },
            { "%%ALUKU", "Phương ngữ Aluku" },
            { "%%BISKE", "Phương ngữ San Giorgio/Bila" },
            { "%%BOONT", "Tiếng Boontling" },
            { "%%KKCOR", "Phép chính tả Chung" },
            { "%%KSCOR", "Phép chính tả Chuẩn" },
            { "%%LIPAW", "Phương ngữ Lipovaz của người Resian" },
            { "%%NEDIS", "Phương ngữ Natisone" },
            { "%%NJIVA", "Phương ngữ Gniva/Njiva" },
            { "%%NULIK", "Tiếng Volapük Hiện đại" },
            { "%%OSOJS", "Phương ngữ Oseacco/Osojane" },
            { "%%POSIX", "Máy tính" },
            { "%%RIGIK", "Tiếng Volapük Cổ điển" },
            { "%%ROZAJ", "Tiếng Resian" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Phương ngữ Stolvizza/Solbica" },
            { "%%UCCOR", "Phép chính tả Hợp nhất" },
            { "%%DAJNKO", "Bảng chữ cái Dajnko" },
            { "%%FONIPA", "Ngữ âm học IPA" },
            { "%%FONUPA", "Ngữ âm học UPA" },
            { "%%NDYUKA", "Phương ngữ Ndyuka" },
            { "%%PAMAKA", "Phương ngữ Pamaka" },
            { "%%PINYIN", "La Mã hóa Bính âm" },
            { "%%SCOUSE", "Phương ngữ Liverpool" },
            { "%%TARASK", "Phép chính tả Taraskievica" },
            { "%%UCRCOR", "Phép chính tả Sửa đổi Hợp nhất" },
            { "%%ABL1943", "Orthographic formulation of 1943" },
            { "%%AKUAPEM", "TIẾNG AKUAPEM" },
            { "%%ALALC97", "La Mã hóa ALA-LC, ấn bản năm 1997" },
            { "%%AREVELA", "Tiếng Armenia Miền Đông" },
            { "%%AREVMDA", "Tiếng Armenia Miền Tây" },
            { "%%BOHORIC", "Bảng chữ cái Bohorič" },
            { "%%EMODENG", "Tiếng Anh Hiện đại Thời kỳ đầu" },
            { "%%HEPBURN", "La mã hóa Hepburn" },
            { "%%METELKO", "Bảng chữ cái Metelko" },
            { "%%MONOTON", "Đơn âm" },
            { "%%POLYTON", "Đa âm" },
            { "%%REVISED", "Phép chính tả Sửa đổi" },
            { "%%1606NICT", "Tiếng Pháp từ Cuối thời Trung cổ đến 1606" },
            { "%%1694ACAD", "Tiếng Pháp Hiện đại Thời kỳ đầu" },
            { "%%1959ACAD", "Hàn lâm" },
            { "%%BAKU1926", "Bảng chữ cái La-tinh Tiếng Turk Hợp nhất" },
            { "%%SCOTLAND", "Tiếng Anh chuẩn tại Scotland" },
            { "%%VALENCIA", "Tiếng Valencia" },
            { "%%WADEGILE", "La Mã hóa Wade-Giles" },
            { "type.ca.roc", "Lịch Trung Hoa Dân Quốc" },
            { "type.co.eor", "Quy tắc sắp xếp Châu Âu" },
            { "type.hc.h11", "Hệ thống 12 giờ (0–11)" },
            { "type.hc.h12", "Hệ thống 12 giờ (1–12)" },
            { "type.hc.h23", "Hệ thống 24 giờ (0–23)" },
            { "type.hc.h24", "Hệ thống 24 giờ (1–24)" },
            { "type.m0.bgn", "Chuyển tự US BGN" },
            { "type.nu.ahom", "Chữ số Ahom" },
            { "type.nu.arab", "Chữ số Ả Rập - Ấn Độ" },
            { "type.nu.armn", "Chữ số Armenia" },
            { "type.nu.bali", "Chữ số Bali" },
            { "type.nu.beng", "Chữ số Bangladesh" },
            { "type.nu.brah", "Chữ số Brahmi" },
            { "type.nu.cakm", "Chữ số Chakma" },
            { "type.nu.cham", "Chữ số Chăm" },
            { "type.nu.cyrl", "Số Kirin" },
            { "type.nu.deva", "Chữ số Devanagari" },
            { "type.nu.ethi", "Chữ số Ethiopia" },
            { "type.nu.geor", "Chữ số Georgia" },
            { "type.nu.gong", "Chữ số Gong" },
            { "type.nu.gonm", "Chữ số Gonm" },
            { "type.nu.grek", "Chữ số Hy Lạp" },
            { "type.nu.gujr", "Chữ số Gujarati" },
            { "type.nu.guru", "Chữ số Gurmukhi" },
            { "type.nu.hans", "Chữ số của tiếng Trung giản thể" },
            { "type.nu.hant", "Chữ số tiếng Trung phồn thể" },
            { "type.nu.hebr", "Chữ số Do Thái" },
            { "type.nu.hmng", "Chữ số Hmng" },
            { "type.nu.hmnp", "Chữ số Hmnp" },
            { "type.nu.java", "Chữ số Java" },
            { "type.nu.jpan", "Chữ số Nhật Bản" },
            { "type.nu.kali", "Chữ số Kayah Li" },
            { "type.nu.khmr", "Chữ số Khơ-me" },
            { "type.nu.knda", "Chữ số Kannada" },
            { "type.nu.lana", "Chữ số Hora Thái Đam" },
            { "type.nu.laoo", "Chữ số Lào" },
            { "type.nu.latn", "Chữ số phương Tây" },
            { "type.nu.lepc", "Chữ số Lepcha" },
            { "type.nu.limb", "Chữ số Limbu" },
            { "type.nu.mlym", "Chữ số Malayalam" },
            { "type.nu.modi", "Chữ số Modi" },
            { "type.nu.mong", "Chữ số Mông Cổ" },
            { "type.nu.mroo", "Chữ số Mroo" },
            { "type.nu.mtei", "Chữ số Meetei Mayek" },
            { "type.nu.mymr", "Chữ số Myanma" },
            { "type.nu.nkoo", "Chữ số N’Ko" },
            { "type.nu.olck", "Chữ số Ol Chiki" },
            { "type.nu.orya", "Chữ số Odia" },
            { "type.nu.osma", "Chữ số Osmanya" },
            { "type.nu.rohg", "Chữ số Rohg" },
            { "type.nu.saur", "Chữ số Saurashtra" },
            { "type.nu.shrd", "Chữ số Sharada" },
            { "type.nu.sind", "Chữ số Sind" },
            { "type.nu.sinh", "Chữ số Sinh" },
            { "type.nu.sora", "Chữ số Sora Sompeng" },
            { "type.nu.sund", "Chữ số Sudan" },
            { "type.nu.takr", "Chữ số Takri" },
            { "type.nu.talu", "Chữ số Thái Lặc mới" },
            { "type.nu.taml", "Chữ số Tamil Truyền thống" },
            { "type.nu.telu", "Chữ số Telugu" },
            { "type.nu.thai", "Chữ số Thái" },
            { "type.nu.tibt", "Chữ số Tây Tạng" },
            { "type.nu.tirh", "Chữ số Tirh" },
            { "type.nu.vaii", "Chữ số Vai" },
            { "type.nu.wara", "Chữ số Wara" },
            { "type.nu.wcho", "Chữ số Wancho" },
            { "type.ca.dangi", "Lịch Dangi" },
            { "type.co.ducet", "Thứ tự sắp xếp unicode mặc định" },
            { "type.co.emoji", "Thứ tự sắp xếp biểu tượng" },
            { "type.lb.loose", "Kiểu xuống dòng thoáng" },
            { "type.nu.roman", "Chữ số La mã" },
            { "type.ca.coptic", "Lịch Copts" },
            { "type.ca.hebrew", "Lịch Do Thái" },
            { "type.ca.indian", "Lịch Quốc gia Ấn Độ" },
            { "type.co.compat", "Thứ tự sắp xếp trước đây, để tương thích" },
            { "type.co.pinyin", "Thứ tự sắp xếp theo bính âm" },
            { "type.co.search", "Tìm kiếm mục đích chung" },
            { "type.co.stroke", "Thứ tự sắp xếp theo nét chữ" },
            { "type.co.unihan", "Trình tự sắp xếp theo bộ-nét" },
            { "type.co.zhuyin", "Thứ tự sắp xếp theo chú âm phù hiệu" },
            { "type.d0.fwidth", "Độ rộng tối đa" },
            { "type.d0.hwidth", "Nửa độ rộng" },
            { "type.lb.normal", "Kiểu xuống dòng thường" },
            { "type.lb.strict", "Kiểu xuống dòng hẹp" },
            { "type.m0.ungegn", "Chuyển tự UN GEGN" },
            { "type.ms.metric", "Hệ mét" },
            { "type.nu.native", "Chữ số tự nhiên" },
            { "type.ca.chinese", "Lịch Trung Quốc" },
            { "type.ca.islamic", "Lịch Hồi Giáo" },
            { "type.ca.iso8601", "Lịch ISO-8601" },
            { "type.ca.persian", "Lịch Ba Tư" },
            { "type.cf.account", "Định dạng tiền tệ kế toán" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "type.nu.arabext", "Chữ số Ả Rập - Ấn Độ mở rộng" },
            { "type.nu.armnlow", "Chữ số Armenia viết thường" },
            { "type.nu.finance", "Chữ số dùng trong tài chính" },
            { "type.nu.greklow", "Chữ số Hy Lạp viết thường" },
            { "type.nu.hanidec", "Chữ số thập phân Trung Quốc" },
            { "type.nu.hansfin", "Chữ số dùng trong tài chính của tiếng Trung giản thể" },
            { "type.nu.hantfin", "Chữ số dùng trong tài chính của tiếng Trung phồn thể" },
            { "type.nu.jpanfin", "Chữ số dùng trong tài chính của tiếng Nhật" },
            { "type.nu.mathdbl", "Chữ số Mathdbl" },
            { "type.nu.tamldec", "Chữ số Tamil" },
            { "type.ca.buddhist", "Lịch Phật Giáo" },
            { "type.ca.ethiopic", "Lịch Ethiopia" },
            { "type.ca.japanese", "Lịch Nhật Bản" },
            { "type.cf.standard", "Định dạng tiền tệ chuẩn" },
            { "type.co.phonetic", "Thứ tự sắp xếp theo ngữ âm" },
            { "type.co.searchjl", "Tìm kiếm theo Phụ âm Đầu Hangul" },
            { "type.co.standard", "Thứ tự sắp xếp chuẩn" },
            { "type.ms.uksystem", "Hệ đo lường Anh" },
            { "type.ms.ussystem", "Hệ đo lường Mỹ" },
            { "type.nu.fullwide", "Chữ số có độ rộng đầy đủ" },
            { "type.nu.lanatham", "Chữ số Tham Thái Đam" },
            { "type.nu.mathbold", "Chữ số Mathbold" },
            { "type.nu.mathmono", "Chữ số Mathmono" },
            { "type.nu.mathsanb", "Chữ số Mathsanb" },
            { "type.nu.mathsans", "Chữ số Mathsans" },
            { "type.nu.mymrshan", "Chữ số Myanmar Shan" },
            { "type.nu.mymrtlng", "Chữ số Mymrtlng" },
            { "type.nu.romanlow", "Chữ số La Mã viết thường" },
            { "type.ca.gregorian", "Lịch Gregory" },
            { "type.co.phonebook", "Thứ tự sắp xếp theo danh bạ điện thoại" },
            { "type.co.dictionary", "Thứ tự sắp xếp theo từ điển" },
            { "type.co.traditional", "Thứ tự sắp xếp truyền thống" },
            { "type.nu.traditional", "Số truyền thống" },
            { "type.ca.islamic-civil", "Lịch Hồi Giáo (dạng bảng, kỷ nguyên dân sự)" },
            { "type.ca.islamic-umalqura", "Lịch Hồi Giáo (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Lịch Ethiopic Amete Alem" },
        };
        return data;
    }
}
