/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sd extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "گرين وچ مين ٽائيم",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "اپيا جو معياري وقت",
               "",
               "اپيا جي ڏينهن جو وقت",
               "",
               "اپيا جو وقت",
               "",
            };
        final String[] Cook = new String[] {
               "ڪوڪ آئي لينڊ جو معياري وقت",
               "",
               "ڪوڪ آئي لينڊ جي اڌ اونهاري جو وقت",
               "",
               "ڪوڪ آئي لينڊ جو وقت",
               "",
            };
        final String[] Cuba = new String[] {
               "ڪيوبا جو معياري وقت",
               "CST",
               "ڪيوبا جي ڏينهن جو وقت",
               "CDT",
               "ڪيوبا جو وقت",
               "CT",
            };
        final String[] Fiji = new String[] {
               "فجي جو معياري وقت",
               "",
               "فجي جي اونهاري جو وقت",
               "",
               "فجي جو وقت",
               "",
            };
        final String[] Gulf = new String[] {
               "خليجي معياري وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "هووڊ جو معياري وقت",
               "",
               "هووڊ جي اونهاري جو وقت",
               "",
               "هووڊ جو وقت",
               "",
            };
        final String[] Iran = new String[] {
               "ايران جو معياري وقت",
               "",
               "ايران جي ڏينهن جو وقت",
               "",
               "ايران جو وقت",
               "",
            };
        final String[] Niue = new String[] {
               "نيووي جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "اومسڪ جو معياري وقت",
               "",
               "اومسڪ جي ڏينهن جو وقت",
               "",
               "اومسڪ جو وقت",
               "",
            };
        final String[] Peru = new String[] {
               "پيرو جو معياري وقت",
               "",
               "پيرو جي اونهاري جو وقت",
               "",
               "پيرو جو وقت",
               "",
            };
        final String[] Truk = new String[] {
               "چيوڪ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ويڪ آئي لينڊ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "چلي جو معياري وقت",
               "",
               "چلي جي اونهاري جو وقت",
               "",
               "چلي جو وقت",
               "",
            };
        final String[] China = new String[] {
               "چائنا جو معياري وقت",
               "CST",
               "چائنا جي ڏينهن جو وقت",
               "CDT",
               "چين جو وقت",
               "CT",
            };
        final String[] Cocos = new String[] {
               "ڪوڪوس آئي لينڊ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ڊيوس جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ڀارت جو معياري وقت",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "جاپان جو معياري وقت",
               "JST",
               "جاپان جي ڏينهن جو وقت",
               "JDT",
               "جاپان جو وقت",
               "JT",
            };
        final String[] Korea = new String[] {
               "ڪوريا جو معياري وقت",
               "KST",
               "ڪوريا جي ڏينهن جو وقت",
               "KST",
               "ڪوريا جو وقت",
               "KST",
            };
        final String[] Nauru = new String[] {
               "نائورو جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "نيپال جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "پلائو جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "ساموا جو معياري وقت",
               "SST",
               "ساموا جي ڏينهن جو وقت",
               "SST",
               "ساموا جو وقت",
               "SST",
            };
        final String[] Syowa = new String[] {
               "سائيوا جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ٽونگا جو معياري وقت",
               "",
               "ٽونگا جي اونهاري جو وقت",
               "",
               "ٽونگا جو وقت",
               "",
            };
        final String[] Yukon = new String[] {
               "يڪون جو وقت",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "الاسڪا جو معياري وقت",
               "AKST",
               "الاسڪا جي ڏينهن جو وقت",
               "AKDT",
               "الاسڪا جو وقت",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ايميزون جو معياري وقت",
               "",
               "ايميزون جي اونهاري جو وقت",
               "",
               "ايميزون جو وقت",
               "",
            };
        final String[] Azores = new String[] {
               "ازورز جو معياري وقت",
               "",
               "ازورز جي اونهاري جو وقت",
               "",
               "ازورز جو وقت",
               "",
            };
        final String[] Bhutan = new String[] {
               "ڀوٽان جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "برونائي دارالسلام جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ايسٽر آئي لينڊ جو معياري وقت",
               "",
               "ايسٽر آئي لينڊ جي اونهاري جو وقت",
               "",
               "ايسٽر آئي لينڊ جو وقت",
               "",
            };
        final String[] Guyana = new String[] {
               "گيانائي وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "هوائي اليوٽين جو معياري وقت",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "اسرائيل جو معياري وقت",
               "IST",
               "اسرائيل جي ڏينهن جو وقت",
               "IDT",
               "اسرائيل جو وقت",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "ڪوسرائي جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "مائوسن جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "ماسڪو جو معياري وقت",
               "MSK",
               "ماسڪو جي ڏينهن جي وقت",
               "MSK",
               "ماسڪو جو وقت",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "پوناپي جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "تاهيٽي جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "تائپي جو معياري وقت",
               "CST",
               "تائپي جي ڏينهن جو وقت",
               "CDT",
               "تائپي جو وقت",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "تووالو جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ووسٽوڪ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ويلس ۽ فتونا جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "عربين جو معياري وقت",
               "",
               "عربين جي ڏينهن جو وقت",
               "",
               "عربين جو وقت",
               "",
            };
        final String[] Armenia = new String[] {
               "آرمينيا جو معياري وقت",
               "",
               "آرمينيا جي اونهاري جو وقت",
               "",
               "آرمينيا جو وقت",
               "",
            };
        final String[] Bolivia = new String[] {
               "بولويائي وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "چئٿم جو معياري وقت",
               "",
               "چئٿم جي ڏينهن جو وقت",
               "",
               "چئٿم جو وقت",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "گڏيل دنياوي وقت",
               "م ع و",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ايڪواڊور جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "گيمبيئر جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "جارجيا جو معياري وقت",
               "",
               "جارجيا جي اونهاري جو وقت",
               "",
               "جارجيا جو وقت",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ارڪتسڪ جو معياري وقت",
               "",
               "ارڪتسڪ جي ڏينهن جو وقت",
               "",
               "ارڪتسڪ جو وقت",
               "",
            };
        final String[] Magadan = new String[] {
               "مگادان جو معياري وقت",
               "",
               "مگادان جي ڏينهن جي وقت",
               "",
               "مگادان جو وقت",
               "",
            };
        final String[] Myanmar = new String[] {
               "ميانمار جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "نار فوڪ آئي لينڊ جو معياري وقت",
               "",
               "نار فوڪ آئي لينڊ جي ڏينهن جو وقت",
               "",
               "نار فوڪ آئي لينڊ جو وقت",
               "",
            };
        final String[] Noronha = new String[] {
               "فرنانڊو دي نورونها جو معياري وقت",
               "",
               "فرنانڊو دي نورونها جي اونهاري وقت",
               "",
               "فرنانڊو دي نورونها جو وقت",
               "",
            };
        final String[] Reunion = new String[] {
               "ري يونين جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "روٿيرا جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "سولومن آئي لينڊ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ٽوڪيلائو جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "يوروگائي جو معياري وقت",
               "",
               "يوروگائي جي اونهاري جو وقت",
               "",
               "يوروگائي جو وقت",
               "",
            };
        final String[] Vanuatu = new String[] {
               "وانواتو جو معياري وقت",
               "",
               "وانواتو جي ڏينهن جو وقت",
               "",
               "وانواتو جو وقت",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ياڪتسڪ جو معياري وقت",
               "",
               "ياڪتسڪ جي ڏينهن جو وقت",
               "",
               "ياڪتسڪ جو وقت",
               "",
            };
        final String[] Atlantic = new String[] {
               "ايٽلانٽڪ جو معياري وقت",
               "AST",
               "ايٽلانٽڪ جي ڏينهن جو وقت",
               "AST",
               "ايٽلانٽڪ جو وقت",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "براسيليا جو معياري وقت",
               "",
               "براسيليا جي اونهاري جو وقت",
               "",
               "بريسيليائي وقت",
               "",
            };
        final String[] Chamorro = new String[] {
               "چمورو جو معياري وقت",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "ڪولمبيا جو معياري وقت",
               "",
               "ڪولمبيا جي اونهاري جو وقت",
               "",
               "ڪولمبيا جو وقت",
               "",
            };
        final String[] Falkland = new String[] {
               "فاڪ لينڊ آئي لينڊ جو معياري وقت",
               "",
               "فاڪ لينڊ آئي لينڊ جي اونهاري جو وقت",
               "",
               "فاڪ لينڊ آئي لينڊ جو وقت",
               "",
            };
        final String[] Malaysia = new String[] {
               "ملائيشيا جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "مالديپ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "اولان باتر جو معياري وقت",
               "",
               "اولان باتر جي اونهاري جو وقت",
               "",
               "اولان باتر جو وقت",
               "",
            };
        final String[] Pakistan = new String[] {
               "پاڪستان جو معياري وقت",
               "PKT",
               "پاڪستان جي اونهاري جو وقت",
               "PKST",
               "پاڪستان جو وقت",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "پيراگوئي جو معياري وقت",
               "",
               "پيراگوئي جي اونهاري جو وقت",
               "",
               "پيراگوئي جو وقت",
               "",
            };
        final String[] Pitcairn = new String[] {
               "پٽڪيرن جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "سوري نام جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ارجنٽائن معياري وقت",
               "",
               "ارجنٽائن جي اونهاري جو وقت",
               "",
               "ارجنٽينا جو وقت",
               "",
            };
        final String[] Christmas = new String[] {
               "ڪرسمس آئي لينڊ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "گالاپاگوز جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "هانگ ڪانگ جو معياري وقت",
               "HKT",
               "هانگ ڪانگ جي اونهاري جو وقت",
               "HKST",
               "هانگ ڪانگ جو وقت",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "انڊو چائنا جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "ڪرغزستان جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "لورڊ هووي جو معياري وقت",
               "",
               "لورڊ هووي جي ڏينهن جو وقت",
               "",
               "لورڊ هووي جو وقت",
               "",
            };
        final String[] Marquesas = new String[] {
               "مرڪيوسس جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "موريشيس جو معياري وقت",
               "",
               "موريشيس جي اونهاري جو وقت",
               "",
               "موريشيس جو وقت",
               "",
            };
        final String[] Singapore = new String[] {
               "سنگاپور جو معياري وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "وينزويلا جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "آذربائيجان جو معياري وقت",
               "",
               "آذربائيجان جي اونهاري جو وقت",
               "",
               "آذربائيجان جو وقت",
               "",
            };
        final String[] Bangladesh = new String[] {
               "بنگلاديش جو معياري وقت",
               "",
               "بنگلاديش جي اونهاري جو وقت",
               "",
               "بنگلاديش جو وقت",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "ڪيپ ورڊ جو معياري وقت",
               "",
               "ڪيپ ورڊ جي اونهاري جو وقت",
               "",
               "ڪيپ ورڊ جو وقت",
               "",
            };
        final String[] East_Timor = new String[] {
               "اوڀر تيمور جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "قزاقستان وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "شي شلز جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "تاجڪستان جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ازبڪستان جو معياري وقت",
               "",
               "ازبڪستان جي اونهاري جو وقت",
               "",
               "ازبڪستان جو وقت",
               "",
            };
        final String[] Afghanistan = new String[] {
               "افغانستان جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "ڪریسنویارسڪ جو معياري وقت",
               "",
               "ڪریسنویارسڪ جي ڏينهن جو وقت",
               "",
               "ڪریسنویارسڪ جو وقت",
               "",
            };
        final String[] New_Zealand = new String[] {
               "نيوزيلينڊ جو معياري وقت",
               "NZST",
               "نيوزيلينڊ جي ڏينهن جو وقت",
               "NZDT",
               "نيوزيلينڊ جو وقت",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "فلپائن جو معياري وقت",
               "PST",
               "فلپائن جي اونهاري جو وقت",
               "PDT",
               "فلپائن جو وقت",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ولادووستوڪ جو معياري وقت",
               "",
               "اولادووستوڪ جي ڏينهن جو وقت",
               "",
               "ولادووستوڪ جو وقت",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "هند سمنڊ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "لائن آئي لينڊ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "نيو فائونڊ لينڊ جو معياري وقت",
               "NST",
               "نيو فائونڊ لينڊ جي ڏينهن جو وقت",
               "NDT",
               "نيو فائونڊ لينڊ جو وقت",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "ترڪمانستان جو معياري وقت",
               "",
               "ترڪمانستان جي اونهاري جو وقت",
               "",
               "ترڪمانستان جو وقت",
               "",
            };
        final String[] French_Guiana = new String[] {
               "فرانسيسي گيانا جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "نيو ڪيليڊونيا جو معياري وقت",
               "",
               "نيو ڪيليڊونيا جي اونهاري جو وقت",
               "",
               "نيو ڪيليڊونيا جو وقت",
               "",
            };
        final String[] South_Georgia = new String[] {
               "ڏکڻ جارجيا جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "يڪاٽيرنبرگ جو معياري وقت",
               "",
               "يڪاٽيرنبرگ جي ڏينهن جو وقت",
               "",
               "يڪاٽيرنبرگ جو وقت",
               "",
            };
        final String[] Africa_Central = new String[] {
               "مرڪزي آفريقا جو وقت",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "اوڀر آفريڪا جو وقت",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "اولهه آفريقا جو وقت",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ڊومانٽ درويئل جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "مرڪزي يورپي معياري وقت",
               "CET",
               "مرڪزي يورپي اونهاري جو وقت",
               "CEST",
               "مرڪزي يورپي وقت",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "مشرقي يورپي معياري وقت",
               "EET",
               "مشرقي يورپي اونهاري جو وقت",
               "EEST",
               "مشرقي يورپي وقت",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "اولهه يورپي معياري وقت",
               "WET",
               "اولهه يورپي ڏينهن جو وقت",
               "WEST",
               "اولهه يورپي وقت",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "ميڪسيڪن پيسيفڪ جو معياري وقت",
               "MST",
               "ميڪسيڪن پيسيفڪ جي ڏينهن جو وقت",
               "MDT",
               "ميڪسيڪن پيسيفڪ وقت",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "ڏکڻ آفريڪا جو معياري وقت",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "مرڪزي معياري وقت",
               "CST",
               "مرڪزي ڏينهن جو وقت",
               "CDT",
               "مرڪزي وقت",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "مشرقي معياري وقت",
               "EST",
               "مشرقي ڏينهن جو وقت",
               "EST",
               "مشرقي وقت",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "پيسيفڪ معياري وقت",
               "PST",
               "پيسيفڪ ڏينهن جو وقت",
               "PDT",
               "پيسيفڪ وقت",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "فرانسيسي ڏاکڻيو ۽ انٽارڪٽڪ وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "گلبرٽ آئي لينڊ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "هوائي اليوٽين جو معياري وقت",
               "HST",
               "هوائي اليوٽين جي ڏينهن جو وقت",
               "HDT",
               "هوائي اليوٽين جو وقت",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "فونيڪس آئي لينڊ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "سينٽ پيئر ۽ ميڪلون جو معياري وقت",
               "",
               "سينٽ پيئر ۽ ميڪلون جي ڏينهن جو وقت",
               "",
               "سينٽ پيئر ۽ ميڪلون جو وقت",
               "",
            };
        final String[] America_Mountain = new String[] {
               "پهاڙي معياري وقت",
               "MST",
               "پهاڙي ڏينهن جو وقت",
               "MST",
               "پهاڙي وقت",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "مارشل آئي لينڊ جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "پاپوا نيو گني جو وقت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "آسٽريليا جو مرڪزي معياري وقت",
               "ACST",
               "آسٽريليا جو مرڪزي ڏينهن جو وقت",
               "ACDT",
               "مرڪزي آسٽريليا جو وقت",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "آسٽريليا جو مشرقي معياري وقت",
               "AEST",
               "آسٽريليا جو مشرقي ڏينهن جو وقت",
               "AEDT",
               "اوڀر آسٽريليا جو وقت",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "آسٽريليا جو مغربي معياري وقت",
               "AWST",
               "آسٽريليا جو مغربي ڏينهن جو وقت",
               "AWDT",
               "مغربي آسٽريليا جو وقت",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "مرڪزي انڊونيشيا جو وقت",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "اوڀر انڊونيشيا جو وقت",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "اولهه انڊونيشيا جو وقت",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "آسٽريليا جو مرڪزي مغربي معياري وقت",
               "",
               "آسٽريليا جو مرڪزي مغربي ڏينهن جو وقت",
               "",
               "آسٽريليا جو مرڪزي مغربي وقت",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "گرين وچ مين ٽائيم",
                    "GMT",
                    "برطانيا جي اونهاري جو وقت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "گڏيل دنياوي وقت",
                    "م ع و",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "گرين وچ مين ٽائيم",
                    "GMT",
                    "آئرش جو معياري وقت",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "گڏيل دنياوي وقت",
                    "م ع و",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "گڏيل دنياوي وقت",
                    "م ع و",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "گرين وچ مين ٽائيم",
                    "GMT",
                    "برطانيا جي اونهاري جو وقت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "گڏيل دنياوي وقت",
                    "م ع و",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "گڏيل دنياوي وقت",
                    "م ع و",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "گڏيل دنياوي وقت",
                    "م ع و",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "گرين وچ مين ٽائيم",
                    "GMT",
                    "آئرش جو معياري وقت",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "گرين وچ مين ٽائيم",
                    "GMT",
                    "برطانيا جي اونهاري جو وقت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "گرين وچ مين ٽائيم",
                    "GMT",
                    "برطانيا جي اونهاري جو وقت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "گرين وچ مين ٽائيم",
                    "GMT",
                    "برطانيا جي اونهاري جو وقت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "گرين وچ مين ٽائيم",
                    "GMT",
                    "برطانيا جي اونهاري جو وقت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "گرين وچ مين ٽائيم",
                    "GMT",
                    "برطانيا جي اونهاري جو وقت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "عدن" },
            { "timezone.excity.Asia/Baku", "باڪو" },
            { "timezone.excity.Asia/Dili", "دلي" },
            { "timezone.excity.Asia/Gaza", "غزه" },
            { "timezone.excity.Asia/Hovd", "هووڊ" },
            { "timezone.excity.Asia/Omsk", "اومسڪ" },
            { "timezone.excity.Asia/Oral", "زباني" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "امان" },
            { "timezone.excity.Asia/Aqtau", "اڪٽائو" },
            { "timezone.excity.Asia/Chita", "چيتا" },
            { "timezone.excity.Asia/Dhaka", "ڍاڪا" },
            { "timezone.excity.Asia/Dubai", "دبئي" },
            { "timezone.excity.Asia/Kabul", "ڪابل" },
            { "timezone.excity.Asia/Macau", "مڪائو" },
            { "timezone.excity.Asia/Qatar", "قطر" },
            { "timezone.excity.Asia/Seoul", "سيول" },
            { "timezone.excity.Asia/Tokyo", "ٽوڪيو" },
            { "timezone.excity.Asia/Tomsk", "تمسڪ" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "جوبا" },
            { "timezone.excity.Africa/Lome", "لوم" },
            { "timezone.excity.Asia/Almaty", "الماتي" },
            { "timezone.excity.Asia/Anadyr", "انيدر" },
            { "timezone.excity.Asia/Aqtobe", "ايڪٽوب" },
            { "timezone.excity.Asia/Atyrau", "آتيرائو" },
            { "timezone.excity.Asia/Beirut", "بيروت" },
            { "timezone.excity.Asia/Brunei", "برونائي" },
            { "timezone.excity.Asia/Hebron", "هيبرون" },
            { "timezone.excity.Asia/Kuwait", "ڪويت" },
            { "timezone.excity.Asia/Manila", "منيلا" },
            { "timezone.excity.Asia/Muscat", "مسقط" },
            { "timezone.excity.Asia/Riyadh", "رياض" },
            { "timezone.excity.Asia/Saigon", "هوچي من" },
            { "timezone.excity.Asia/Taipei", "تائپي" },
            { "timezone.excity.Asia/Tehran", "تهران" },
            { "timezone.excity.Asia/Urumqi", "يورمڪي" },
            { "timezone.excity.Etc/Unknown", "اڻڄاتل شهر" },
            { "timezone.excity.Europe/Kiev", "ڪِيو" },
            { "timezone.excity.Europe/Oslo", "اوسلو" },
            { "timezone.excity.Europe/Riga", "رگا" },
            { "timezone.excity.Europe/Rome", "روم" },
            { "timezone.excity.Indian/Mahe", "ماهي" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "ايڪرا" },
            { "timezone.excity.Africa/Cairo", "قائرا" },
            { "timezone.excity.Africa/Ceuta", "سيوٽا" },
            { "timezone.excity.Africa/Dakar", "ڊاڪار" },
            { "timezone.excity.Africa/Lagos", "لاگوس" },
            { "timezone.excity.Africa/Tunis", "تيونس" },
            { "timezone.excity.America/Adak", "ادڪ" },
            { "timezone.excity.America/Lima", "ليما" },
            { "timezone.excity.America/Nome", "نوم" },
            { "timezone.excity.Asia/Baghdad", "بغداد" },
            { "timezone.excity.Asia/Bahrain", "بحرين" },
            { "timezone.excity.Asia/Bangkok", "بئنڪاڪ" },
            { "timezone.excity.Asia/Barnaul", "برنل" },
            { "timezone.excity.Asia/Bishkek", "بشڪيڪ" },
            { "timezone.excity.Asia/Colombo", "ڪولمبو" },
            { "timezone.excity.Asia/Irkutsk", "ارڪتسڪ" },
            { "timezone.excity.Asia/Jakarta", "جڪارتا" },
            { "timezone.excity.Asia/Karachi", "ڪراچي" },
            { "timezone.excity.Asia/Kuching", "کوچنگ" },
            { "timezone.excity.Asia/Magadan", "مگادان" },
            { "timezone.excity.Asia/Nicosia", "نيڪوسيا" },
            { "timezone.excity.Asia/Rangoon", "رنگون" },
            { "timezone.excity.Asia/Tbilisi", "تبليسي" },
            { "timezone.excity.Asia/Thimphu", "ٿمفو" },
            { "timezone.excity.Asia/Yakutsk", "ياڪتسڪ" },
            { "timezone.excity.Asia/Yerevan", "يريوان" },
            { "timezone.excity.Europe/Kirov", "ڪيروف" },
            { "timezone.excity.Europe/Malta", "مالٽا" },
            { "timezone.excity.Europe/Minsk", "منسڪ" },
            { "timezone.excity.Europe/Paris", "پئرس" },
            { "timezone.excity.Europe/Sofia", "سوفيا" },
            { "timezone.excity.Europe/Vaduz", "وڊوز" },
            { "timezone.excity.Indian/Cocos", "ڪوڪوس" },
            { "timezone.excity.Pacific/Apia", "اپيا" },
            { "timezone.excity.Pacific/Fiji", "فجي" },
            { "timezone.excity.Pacific/Guam", "گوام" },
            { "timezone.excity.Pacific/Niue", "نيووي" },
            { "timezone.excity.Pacific/Truk", "چيوڪ" },
            { "timezone.excity.Pacific/Wake", "ويڪ" },
            { "timezone.excity.Africa/Asmera", "ازمارا" },
            { "timezone.excity.Africa/Bamako", "باماڪو" },
            { "timezone.excity.Africa/Bangui", "بنگي" },
            { "timezone.excity.Africa/Banjul", "بينجال" },
            { "timezone.excity.Africa/Bissau", "بسائو" },
            { "timezone.excity.Africa/Douala", "دوالا" },
            { "timezone.excity.Africa/Harare", "هراري" },
            { "timezone.excity.Africa/Kigali", "ڪيگالي" },
            { "timezone.excity.Africa/Luanda", "لوانڊا" },
            { "timezone.excity.Africa/Lusaka", "لوساڪا" },
            { "timezone.excity.Africa/Malabo", "ملابو" },
            { "timezone.excity.Africa/Maputo", "ماپوتو" },
            { "timezone.excity.Africa/Maseru", "ماسيرو" },
            { "timezone.excity.Africa/Niamey", "نيامي" },
            { "timezone.excity.America/Aruba", "اروبا" },
            { "timezone.excity.America/Bahia", "باحيه" },
            { "timezone.excity.America/Belem", "بیلم" },
            { "timezone.excity.America/Boise", "بوئس" },
            { "timezone.excity.America/Jujuy", "ڪوڪوئي" },
            { "timezone.excity.America/Sitka", "سٽڪا" },
            { "timezone.excity.America/Thule", "ٿولي" },
            { "timezone.excity.Asia/Ashgabat", "آشگاباد" },
            { "timezone.excity.Asia/Calcutta", "ڪلڪتا" },
            { "timezone.excity.Asia/Damascus", "دمشق" },
            { "timezone.excity.Asia/Dushanbe", "دوشانبي" },
            { "timezone.excity.Asia/Jayapura", "جياپورا" },
            { "timezone.excity.Asia/Katmandu", "کٽمنڊو" },
            { "timezone.excity.Asia/Khandyga", "کندياگا" },
            { "timezone.excity.Asia/Makassar", "ميڪاسر" },
            { "timezone.excity.Asia/Qostanay", "ڪوٽانسي" },
            { "timezone.excity.Asia/Sakhalin", "شخالين" },
            { "timezone.excity.Asia/Shanghai", "شنگهائي" },
            { "timezone.excity.Asia/Tashkent", "تاشقنت" },
            { "timezone.excity.Asia/Ust-Nera", "اسٽ نيرا" },
            { "timezone.excity.Europe/Athens", "ايٿنز" },
            { "timezone.excity.Europe/Berlin", "برلن" },
            { "timezone.excity.Europe/Dublin", "ڊبلن" },
            { "timezone.excity.Europe/Jersey", "جرسي" },
            { "timezone.excity.Europe/Lisbon", "لسبن" },
            { "timezone.excity.Europe/London", "لنڊن" },
            { "timezone.excity.Europe/Madrid", "ميڊرڊ" },
            { "timezone.excity.Europe/Monaco", "موناڪو" },
            { "timezone.excity.Europe/Moscow", "ماسڪو" },
            { "timezone.excity.Europe/Prague", "پراگ" },
            { "timezone.excity.Europe/Samara", "سمارا" },
            { "timezone.excity.Europe/Skopje", "اسڪوپي" },
            { "timezone.excity.Europe/Tirane", "تراني" },
            { "timezone.excity.Europe/Vienna", "ويئينا" },
            { "timezone.excity.Europe/Warsaw", "وارسا" },
            { "timezone.excity.Europe/Zagreb", "زغرب" },
            { "timezone.excity.Europe/Zurich", "زيورخ" },
            { "timezone.excity.Indian/Chagos", "چاگوس" },
            { "timezone.excity.Indian/Comoro", "ڪومورو" },
            { "timezone.excity.Pacific/Efate", "افاتي" },
            { "timezone.excity.Pacific/Nauru", "نائرو" },
            { "timezone.excity.Pacific/Palau", "پلائو" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "ابي جان" },
            { "timezone.excity.Africa/Algiers", "الجيرز" },
            { "timezone.excity.Africa/Conakry", "ڪوناڪري" },
            { "timezone.excity.Africa/Kampala", "ڪمپالا" },
            { "timezone.excity.Africa/Mbabane", "مبابين" },
            { "timezone.excity.Africa/Nairobi", "نيروبي" },
            { "timezone.excity.Africa/Tripoli", "ٽرپولي" },
            { "timezone.excity.America/Belize", "بیلیز" },
            { "timezone.excity.America/Bogota", "بگوٽا" },
            { "timezone.excity.America/Cancun", "ڪانڪون" },
            { "timezone.excity.America/Cayman", "سيامن" },
            { "timezone.excity.America/Cuiaba", "ڪوئيابا" },
            { "timezone.excity.America/Dawson", "ڊاوسن" },
            { "timezone.excity.America/Denver", "ڊينور" },
            { "timezone.excity.America/Guyana", "گيانا" },
            { "timezone.excity.America/Havana", "هوانا" },
            { "timezone.excity.America/Inuvik", "انووڪ" },
            { "timezone.excity.America/Juneau", "جونئو" },
            { "timezone.excity.America/La_Paz", "لا پز" },
            { "timezone.excity.America/Maceio", "میسیئو" },
            { "timezone.excity.America/Manaus", "منائوس" },
            { "timezone.excity.America/Merida", "ميريڊا" },
            { "timezone.excity.America/Nassau", "ناسائو" },
            { "timezone.excity.America/Panama", "پناما" },
            { "timezone.excity.America/Recife", "هيسيفي" },
            { "timezone.excity.America/Regina", "ریجینا" },
            { "timezone.excity.Asia/Famagusta", "فاماگوستا" },
            { "timezone.excity.Asia/Hong_Kong", "هانگ ڪانگ" },
            { "timezone.excity.Asia/Jerusalem", "يوروشلم" },
            { "timezone.excity.Asia/Kamchatka", "ڪمچاسڪي" },
            { "timezone.excity.Asia/Pontianak", "پونٽيانڪ" },
            { "timezone.excity.Asia/Pyongyang", "شيانگ يانگ" },
            { "timezone.excity.Asia/Qyzylorda", "ڪيزلورڊا" },
            { "timezone.excity.Asia/Samarkand", "سمرقند" },
            { "timezone.excity.Asia/Singapore", "سنگاپور" },
            { "timezone.excity.Asia/Vientiane", "وينٽيان" },
            { "timezone.excity.Europe/Andorra", "اندورا" },
            { "timezone.excity.Europe/Saratov", "سراتو" },
            { "timezone.excity.Europe/Tallinn", "ٽالن" },
            { "timezone.excity.Europe/Vatican", "وئٽيڪن" },
            { "timezone.excity.Europe/Vilnius", "ويلنيس" },
            { "timezone.excity.Indian/Mayotte", "مياٽي" },
            { "timezone.excity.Indian/Reunion", "ري يونين" },
            { "timezone.excity.Pacific/Easter", "ايسٽر" },
            { "timezone.excity.Pacific/Kosrae", "ڪوسرائي" },
            { "timezone.excity.Pacific/Majuro", "مجورو" },
            { "timezone.excity.Pacific/Midway", "مڊوي" },
            { "timezone.excity.Pacific/Noumea", "نائوميا" },
            { "timezone.excity.Pacific/Ponape", "پونپیئي" },
            { "timezone.excity.Pacific/Saipan", "سيپن" },
            { "timezone.excity.Pacific/Tahiti", "تاهٽي" },
            { "timezone.excity.Pacific/Tarawa", "تراوا" },
            { "timezone.excity.Pacific/Wallis", "ويلس" },
            { "timezone.excity.Africa/Blantyre", "بلنٽائر" },
            { "timezone.excity.Africa/Djibouti", "جبوتي" },
            { "timezone.excity.Africa/El_Aaiun", "ال ايون" },
            { "timezone.excity.Africa/Freetown", "فري ٽائون" },
            { "timezone.excity.Africa/Gaborone", "گيبورون" },
            { "timezone.excity.Africa/Khartoum", "خرطوم" },
            { "timezone.excity.Africa/Kinshasa", "ڪنشاسا" },
            { "timezone.excity.Africa/Monrovia", "مونروویا" },
            { "timezone.excity.Africa/Ndjamena", "نجامينا" },
            { "timezone.excity.Africa/Sao_Tome", "سائو ٽوم" },
            { "timezone.excity.Africa/Windhoek", "ونڊهوڪ" },
            { "timezone.excity.America/Antigua", "اينٽيگوا" },
            { "timezone.excity.America/Caracas", "ڪراڪس" },
            { "timezone.excity.America/Cayenne", "ڪائين" },
            { "timezone.excity.America/Chicago", "شڪاگو" },
            { "timezone.excity.America/Cordoba", "ڪارڊوبا" },
            { "timezone.excity.America/Creston", "ڪريسٽن" },
            { "timezone.excity.America/Curacao", "ڪيوراسائو" },
            { "timezone.excity.America/Detroit", "ڊيٽرائيٽ" },
            { "timezone.excity.America/Godthab", "نيوڪ" },
            { "timezone.excity.America/Grenada", "گريناڊا" },
            { "timezone.excity.America/Halifax", "هيلي فيڪس" },
            { "timezone.excity.America/Iqaluit", "اڪالوئٽ" },
            { "timezone.excity.America/Jamaica", "جمائڪا" },
            { "timezone.excity.America/Managua", "ماناگوا" },
            { "timezone.excity.America/Marigot", "ميريگوٽ" },
            { "timezone.excity.America/Mendoza", "مينڊوزا" },
            { "timezone.excity.America/Moncton", "مانڪٽن" },
            { "timezone.excity.America/Noronha", "نورانهيا" },
            { "timezone.excity.America/Ojinaga", "اوڪيناگا" },
            { "timezone.excity.America/Phoenix", "فونيڪس" },
            { "timezone.excity.America/Tijuana", "تيجوانا" },
            { "timezone.excity.America/Toronto", "ٽورنٽو" },
            { "timezone.excity.America/Tortola", "ٽورٽولا" },
            { "timezone.excity.America/Yakutat", "ياڪوتات" },
            { "timezone.excity.Asia/Phnom_Penh", "فنام پينه" },
            { "timezone.excity.Atlantic/Azores", "ازورز" },
            { "timezone.excity.Atlantic/Canary", "ڪينري" },
            { "timezone.excity.Atlantic/Faeroe", "فيرو" },
            { "timezone.excity.Australia/Eucla", "يوڪلا" },
            { "timezone.excity.Australia/Perth", "پرٿ" },
            { "timezone.excity.Europe/Belgrade", "بلغراد" },
            { "timezone.excity.Europe/Brussels", "برسلز" },
            { "timezone.excity.Europe/Budapest", "بداپيسٽ" },
            { "timezone.excity.Europe/Busingen", "بزيجين" },
            { "timezone.excity.Europe/Chisinau", "چسينائو" },
            { "timezone.excity.Europe/Guernsey", "گرنزي" },
            { "timezone.excity.Europe/Helsinki", "هيلسنڪي" },
            { "timezone.excity.Europe/Istanbul", "استنبول" },
            { "timezone.excity.Europe/Sarajevo", "سراجیوو" },
            { "timezone.excity.Indian/Maldives", "مالديپ" },
            { "timezone.excity.Pacific/Chatham", "چئٿم" },
            { "timezone.excity.Pacific/Fakaofo", "فڪائوفو" },
            { "timezone.excity.Pacific/Gambier", "گيمبيئر" },
            { "timezone.excity.Pacific/Norfolk", "نار فوڪ" },
            { "timezone.excity.Africa/Bujumbura", "بوجمبورا" },
            { "timezone.excity.Africa/Mogadishu", "موغادیشو" },
            { "timezone.excity.America/Anguilla", "انگويلا" },
            { "timezone.excity.America/Asuncion", "اسانسیون" },
            { "timezone.excity.America/Barbados", "بارباڊوس" },
            { "timezone.excity.America/Dominica", "ڊومينيڪا" },
            { "timezone.excity.America/Edmonton", "ايڊمونٽن" },
            { "timezone.excity.America/Eirunepe", "ايرونيپ" },
            { "timezone.excity.America/Mazatlan", "مزاٽلان" },
            { "timezone.excity.America/Miquelon", "میڪوئیلون" },
            { "timezone.excity.America/New_York", "نيويارڪ" },
            { "timezone.excity.America/Resolute", "ريزوليوٽ" },
            { "timezone.excity.America/Santarem", "سنٽاريم" },
            { "timezone.excity.America/Santiago", "سينٽياگو" },
            { "timezone.excity.America/St_Johns", "سينٽ جانز" },
            { "timezone.excity.America/St_Kitts", "سينٽ ڪٽس" },
            { "timezone.excity.America/St_Lucia", "سينٽ لوسيا" },
            { "timezone.excity.America/Winnipeg", "وني پيگ" },
            { "timezone.excity.Antarctica/Casey", "ڪيسي" },
            { "timezone.excity.Antarctica/Davis", "ڊيوس" },
            { "timezone.excity.Antarctica/Syowa", "سيووا" },
            { "timezone.excity.Antarctica/Troll", "ٽرول" },
            { "timezone.excity.Asia/Krasnoyarsk", "ڪريسنويارسڪ" },
            { "timezone.excity.Asia/Novosibirsk", "نوواسبئيرسڪ" },
            { "timezone.excity.Asia/Ulaanbaatar", "اولان باتر" },
            { "timezone.excity.Asia/Vladivostok", "ولادووستوڪ" },
            { "timezone.excity.Atlantic/Bermuda", "برمودا" },
            { "timezone.excity.Atlantic/Madeira", "ماڊيرا" },
            { "timezone.excity.Atlantic/Stanley", "اسٽينلي" },
            { "timezone.excity.Australia/Darwin", "ڊارون" },
            { "timezone.excity.Australia/Hobart", "هوبارٽ" },
            { "timezone.excity.Australia/Sydney", "سڊني" },
            { "timezone.excity.Europe/Amsterdam", "ايمسٽرڊيم" },
            { "timezone.excity.Europe/Astrakhan", "آستراخان" },
            { "timezone.excity.Europe/Bucharest", "بخاريسٽ" },
            { "timezone.excity.Europe/Gibraltar", "جبرالٽر" },
            { "timezone.excity.Europe/Ljubljana", "لبليانا" },
            { "timezone.excity.Europe/Mariehamn", "ميريهام" },
            { "timezone.excity.Europe/Podgorica", "پوڊگورسيا" },
            { "timezone.excity.Europe/Stockholm", "اسٽاڪ هوم" },
            { "timezone.excity.Europe/Ulyanovsk", "اليانوسڪ" },
            { "timezone.excity.Europe/Volgograd", "وولگوگراد" },
            { "timezone.excity.Indian/Christmas", "ڪرسمس" },
            { "timezone.excity.Indian/Kerguelen", "ڪرگيولين" },
            { "timezone.excity.Indian/Mauritius", "موريشس" },
            { "timezone.excity.Pacific/Auckland", "آڪلينڊ" },
            { "timezone.excity.Pacific/Funafuti", "فنافوٽي" },
            { "timezone.excity.Pacific/Honolulu", "هونو لولو" },
            { "timezone.excity.Pacific/Pitcairn", "پٽڪيرن" },
            { "timezone.excity.Africa/Casablanca", "ڪاسابلانڪا" },
            { "timezone.excity.Africa/Libreville", "لیبرویلی" },
            { "timezone.excity.Africa/Lubumbashi", "لوبمباشی" },
            { "timezone.excity.Africa/Nouakchott", "نواڪشوط" },
            { "timezone.excity.Africa/Porto-Novo", "پورٽو نوو" },
            { "timezone.excity.America/Anchorage", "اينڪريج" },
            { "timezone.excity.America/Araguaina", "اراگویانا" },
            { "timezone.excity.America/Boa_Vista", "بائو وستا" },
            { "timezone.excity.America/Catamarca", "ڪيٽا مارڪا" },
            { "timezone.excity.America/Chihuahua", "چي هوا هوا" },
            { "timezone.excity.America/Coyhaique", "ڪوئيئيڪي" },
            { "timezone.excity.America/Fortaleza", "فورٽاليزا" },
            { "timezone.excity.America/Glace_Bay", "گليس بي" },
            { "timezone.excity.America/Goose_Bay", "گوز بي" },
            { "timezone.excity.America/Guatemala", "گوئٽي مالا" },
            { "timezone.excity.America/Guayaquil", "گواياڪيل" },
            { "timezone.excity.America/Matamoros", "متاموروس" },
            { "timezone.excity.America/Menominee", "مینومیني" },
            { "timezone.excity.America/Monterrey", "مانٽيري" },
            { "timezone.excity.America/Sao_Paulo", "سائو پولو" },
            { "timezone.excity.America/St_Thomas", "سينٽ ٿامس" },
            { "timezone.excity.America/Vancouver", "وينڪوور" },
            { "timezone.excity.Antarctica/Mawson", "موسن" },
            { "timezone.excity.Antarctica/Palmer", "پامر" },
            { "timezone.excity.Antarctica/Vostok", "ووستوڪ" },
            { "timezone.excity.Asia/Kuala_Lumpur", "ڪوالالمپور" },
            { "timezone.excity.Asia/Novokuznetsk", "نووڪزنيتسڪ" },
            { "timezone.excity.Europe/Bratislava", "براتيسلوا" },
            { "timezone.excity.Europe/Copenhagen", "ڪوپن هيگن" },
            { "timezone.excity.Europe/Luxembourg", "لگزمبرگ" },
            { "timezone.excity.Europe/San_Marino", "سين مرينو" },
            { "timezone.excity.Europe/Simferopol", "سمفروپول" },
            { "timezone.excity.Pacific/Enderbury", "ڪانٽن ٻيٽ" },
            { "timezone.excity.Pacific/Galapagos", "گالاپاگوز" },
            { "timezone.excity.Pacific/Kwajalein", "ڪواجلين" },
            { "timezone.excity.Pacific/Marquesas", "مرڪيوسس" },
            { "timezone.excity.Pacific/Pago_Pago", "پاگو پاگو" },
            { "timezone.excity.Pacific/Rarotonga", "راروٽونگا" },
            { "timezone.excity.Pacific/Tongatapu", "ٽونگاٽاپو" },
            { "timezone.excity.Africa/Addis_Ababa", "ايڊيس اببا" },
            { "timezone.excity.Africa/Brazzaville", "برازاويل" },
            { "timezone.excity.Africa/Ouagadougou", "آئوگو ڊائوگو" },
            { "timezone.excity.America/Costa_Rica", "ڪوسٽا ريڪا" },
            { "timezone.excity.America/Grand_Turk", "گرانڊ ترڪ" },
            { "timezone.excity.America/Guadeloupe", "گواڊيلوپ" },
            { "timezone.excity.America/Hermosillo", "هرموسلو" },
            { "timezone.excity.America/Kralendijk", "ڪرالينڊڪ" },
            { "timezone.excity.America/Louisville", "لوئي ويل" },
            { "timezone.excity.America/Martinique", "مارٽينڪ" },
            { "timezone.excity.America/Metlakatla", "ميٽلاڪاٽالا" },
            { "timezone.excity.America/Montevideo", "مونٽي ويڊيو" },
            { "timezone.excity.America/Montserrat", "مانٽسريٽ" },
            { "timezone.excity.America/Paramaribo", "پيراميريبو" },
            { "timezone.excity.America/Rio_Branco", "ريو برانڪو" },
            { "timezone.excity.America/St_Vincent", "سينٽ ونسينٽ" },
            { "timezone.excity.America/Whitehorse", "وائيٽ هائوس" },
            { "timezone.excity.Antarctica/McMurdo", "ميڪ مرڊو" },
            { "timezone.excity.Antarctica/Rothera", "روڌرا" },
            { "timezone.excity.Asia/Srednekolymsk", "سريديڪوليمسڪ" },
            { "timezone.excity.Asia/Yekaterinburg", "یڪاٽرنبرگ" },
            { "timezone.excity.Atlantic/Reykjavik", "ريڪيوڪ" },
            { "timezone.excity.Atlantic/St_Helena", "سينٽ هيلينا" },
            { "timezone.excity.Australia/Adelaide", "ايڊيليڊ" },
            { "timezone.excity.Australia/Brisbane", "برسبين" },
            { "timezone.excity.Australia/Lindeman", "لنڊمين" },
            { "timezone.excity.Europe/Isle_of_Man", "آئيزل آف مين" },
            { "timezone.excity.Europe/Kaliningrad", "ڪلينن گراڊ" },
            { "timezone.excity.Pacific/Kiritimati", "ڪريٽمٽي" },
            { "timezone.excity.Africa/Johannesburg", "جوهانسبرگ" },
            { "timezone.excity.America/El_Salvador", "ايل سلواڊور" },
            { "timezone.excity.America/Fort_Nelson", "فورٽ نيلسن" },
            { "timezone.excity.America/Los_Angeles", "لاس اينجلس" },
            { "timezone.excity.America/Mexico_City", "ميڪسيڪو شهر" },
            { "timezone.excity.America/Porto_Velho", "پورٽو ويلهو" },
            { "timezone.excity.America/Puerto_Rico", "پورٽو ريڪو" },
            { "timezone.excity.America/Tegucigalpa", "ٽيگوسيگلپا" },
            { "timezone.excity.Arctic/Longyearbyen", "لانگ ائيربن" },
            { "timezone.excity.Atlantic/Cape_Verde", "ڪيپ ورڊي" },
            { "timezone.excity.Australia/Lord_Howe", "لارڊ هائو" },
            { "timezone.excity.Australia/Melbourne", "ميلبورن" },
            { "timezone.excity.Indian/Antananarivo", "انتاناناريوو" },
            { "timezone.excity.Pacific/Guadalcanal", "گواڊل ڪينال" },
            { "timezone.excity.Africa/Dar_es_Salaam", "دارالسلام" },
            { "timezone.excity.America/Blanc-Sablon", "بلانڪ سبلون" },
            { "timezone.excity.America/Buenos_Aires", "بيونوس ايئرس" },
            { "timezone.excity.America/Campo_Grande", "ڪيمپو گرانڊي" },
            { "timezone.excity.America/Danmarkshavn", "ڊينمارڪ شون" },
            { "timezone.excity.America/Dawson_Creek", "ڊاوسن ڪريڪ" },
            { "timezone.excity.America/Indiana/Knox", "ناڪس، انڊيانا" },
            { "timezone.excity.America/Indianapolis", "انڊيانا پولس" },
            { "timezone.excity.America/Punta_Arenas", "پنٽا اريناس" },
            { "timezone.excity.America/Rankin_Inlet", "رينڪن انليٽ" },
            { "timezone.excity.America/Scoresbysund", "اٽوڪورٽومائٽ" },
            { "timezone.excity.Antarctica/Macquarie", "مڪوائري" },
            { "timezone.excity.Pacific/Bougainville", "بوگين ويليا" },
            { "timezone.excity.Pacific/Port_Moresby", "پورٽ مورسبي" },
            { "timezone.excity.America/Cambridge_Bay", "ڪيمبرج بي" },
            { "timezone.excity.America/Ciudad_Juarez", "سوڊيڊ جوريز" },
            { "timezone.excity.America/Coral_Harbour", "اٽيڪوڪن" },
            { "timezone.excity.America/Indiana/Vevay", "ويوي، انڊيانا" },
            { "timezone.excity.America/Lower_Princes", "لوئر پرنسز ڪوارٽر" },
            { "timezone.excity.America/Port_of_Spain", "اسپين جو ٻيٽ" },
            { "timezone.excity.America/Santo_Domingo", "سينٽو ڊومينگو" },
            { "timezone.excity.America/St_Barthelemy", "سينٽ برٿليمي" },
            { "timezone.excity.America/Swift_Current", "سوئفٽ ڪرنٽ" },
            { "timezone.excity.Australia/Broken_Hill", "بروڪن هل" },
            { "timezone.excity.America/Bahia_Banderas", "باهیا بیندراس" },
            { "timezone.excity.America/Port-au-Prince", "پورٽ او پرنس" },
            { "timezone.excity.Atlantic/South_Georgia", "ڏکڻ جورجيا" },
            { "timezone.excity.America/Argentina/Salta", "سالٽا" },
            { "timezone.excity.America/Indiana/Marengo", "مرينگو، انڊيانا" },
            { "timezone.excity.America/Indiana/Winamac", "ويناميڪ، انڊيانا" },
            { "timezone.excity.America/Argentina/Tucuman", "ٽوڪومين" },
            { "timezone.excity.America/Argentina/Ushuaia", "اوشوآئیا" },
            { "timezone.excity.America/Indiana/Tell_City", "ٽيل سٽي، انڊيانا" },
            { "timezone.excity.America/Indiana/Vincennes", "ونسینیز، انڊیانا" },
            { "timezone.excity.Antarctica/DumontDUrville", "ڊومانٽ درويئل" },
            { "timezone.excity.America/Argentina/La_Rioja", "لا ریئوجا" },
            { "timezone.excity.America/Argentina/San_Juan", "سان جوآن" },
            { "timezone.excity.America/Argentina/San_Luis", "سان لوئیس" },
            { "timezone.excity.America/Indiana/Petersburg", "پيٽرسبرگ، انڊيانا" },
            { "timezone.excity.America/Kentucky/Monticello", "مونٽيسيلو، ڪينٽڪي" },
            { "timezone.excity.America/North_Dakota/Beulah", "بيولاه، اتر ڊڪوٽا" },
            { "timezone.excity.America/North_Dakota/Center", "سينٽر، اتر ڊڪوٽا" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ریو گالیگوس" },
            { "timezone.excity.America/North_Dakota/New_Salem", "نيو سيلم، اتر ڊڪوٽا" },
        };
        return data;
    }
}
