/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ug extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_BD = "بېنگال";
        final String metaValue_zbl = "بىلىس بەلگىلىرى";
        final String metaValue_CY = "سىپرۇس";
        final String metaValue_got = "گوتچە";
        final String metaValue_el = "گىرېكچە";
        final String metaValue_gu = "گۇجاراتچە";
        final String metaValue_hmn = "مۆڭچە";
        final String metaValue_jv = "ياۋاچە";
        final String metaValue_ja = "ياپونچە";
        final String metaValue_kn = "كانناداچە";
        final String metaValue_ko = "كورېيەچە";
        final String metaValue_lo = "لائوسچە";
        final String metaValue_la = "لاتىنچە";
        final String metaValue_men = "مېندېچە";
        final String metaValue_mn = "موڭغۇلچە";
        final String metaValue_my = "بىرماچە";
        final String metaValue_nqo = "نىكوچە";
        final String metaValue_su = "سۇنداچە";
        final String metaValue_ta = "تامىلچە";
        final String metaValue_te = "تېلۇگۇچە";
        final String metaValue_tl = "تاگالوگچە";
        final String metaValue_th = "تايلاندچە";
        final String metaValue_bo = "تىبەتچە";
        final String metaValue_uga = "ئۇگارىتىكچە";
        final String metaValue_vai = "ۋايچە";
        final String metaValue_peo = "قەدىمكى پارىسچە";
        final String metaValue_ssy = "ساخوچە";
        final String metaValue_Hans = "ئاددىي خەنچە";
        final String metaValue_Hant = "مۇرەككەپ خەنچە";
        final Object[][] data = new Object[][] {
            { "001", "دۇنيا" },
            { "002", "ئافرىقا" },
            { "003", "شىمالىي ئامېرىكا" },
            { "005", "جەنۇبىي ئامېرىكا" },
            { "009", "ئوكيانىيە" },
            { "011", "غەربىي ئافرىقا" },
            { "013", "ئوتتۇرا ئامېرىكا" },
            { "014", "شەرقىي ئافرىقا" },
            { "015", "شىمالىي ئافرىقا" },
            { "017", "ئوتتۇرا ئافرىقا" },
            { "018", "جەنۇبىي ئافرىقا رايونى" },
            { "019", "ئامېرىكا" },
            { "021", "شىمالىي ئامېرىكا رايونى" },
            { "029", "كارىب دېڭىزى" },
            { "030", "شەرقىي ئاسىيا" },
            { "034", "جەنۇبىي ئاسىيا" },
            { "035", "شەرقىي جەنۇبىي ئاسىيا" },
            { "039", "جەنۇبىي ياۋروپا" },
            { "053", "ئاۋسترالئاسىيا" },
            { "054", "مېلانېسىيە" },
            { "057", "مىكرونېزىيە رايونى" },
            { "061", "پولىنىزىيە" },
            { "142", "ئاسىيا" },
            { "143", "ئوتتۇرا ئاسىيا" },
            { "145", "غەربىي ئاسىيا" },
            { "150", "ياۋروپا" },
            { "151", "شەرقىي ياۋروپا" },
            { "154", "شىمالىي ياۋروپا" },
            { "155", "غەربىي ياۋروپا" },
            { "419", "لاتىن ئامېرىكا" },
            { "AC", "ئاسسېنسىيون ئارىلى" },
            { "AD", "ئاندوررا" },
            { "AE", "ئەرەب بىرلەشمە خەلىپىلىكى" },
            { "AF", "ئافغانىستان" },
            { "AG", "ئانتىگۇئا ۋە باربۇدا" },
            { "AI", "ئانگۋىللا" },
            { "AL", "ئالبانىيە" },
            { "AM", "ئەرمېنىيە" },
            { "AO", "ئانگولا" },
            { "AQ", "ئانتاركتىكا" },
            { "AR", "ئارگېنتىنا" },
            { "AS", "ئامېرىكا ساموئا" },
            { "AT", "ئاۋىستىرىيە" },
            { "AU", "ئاۋسترالىيە" },
            { "AW", "ئارۇبا" },
            { "AX", "ئالاند ئاراللىرى" },
            { "AZ", "ئەزەربەيجان" },
            { "BA", "بوسىنىيە ۋە گېرتسېگوۋىنا" },
            { "BB", "باربادوس" },
            { "BD", metaValue_BD },
            { "BE", "بېلگىيە" },
            { "BF", "بۇركىنا فاسو" },
            { "BG", "بۇلغارىيە" },
            { "BH", "بەھرەين" },
            { "BI", "بۇرۇندى" },
            { "BJ", "بېنىن" },
            { "BL", "ساينت بارتېلېمى" },
            { "BM", "بېرمۇدا" },
            { "BN", "بىرۇنېي" },
            { "BO", "بولىۋىيە" },
            { "BQ", "كارىب دېڭىزى گوللاندىيە" },
            { "BR", "بىرازىلىيە" },
            { "BS", "باھاما" },
            { "BT", "بۇتان" },
            { "BV", "بوۋېت ئارىلى" },
            { "BW", "بوتسۋانا" },
            { "BY", "بېلارۇسىيە" },
            { "BZ", "بېلىز" },
            { "CA", "كانادا" },
            { "CC", "كوكوس (كىلىڭ) ئاراللىرى" },
            { "CD", "كونگو - كىنشاسا" },
            { "CF", "ئوتتۇرا ئافرىقا جۇمھۇرىيىتى" },
            { "CG", "كونگو - بىراززاۋىل" },
            { "CH", "شىۋېتسارىيە" },
            { "CI", "كوتې دې ئىۋوئىر" },
            { "CK", "كۇك ئاراللىرى" },
            { "CL", "چىلى" },
            { "CM", "كامېرون" },
            { "CN", "جۇڭگو" },
            { "CO", "كولومبىيە" },
            { "CP", "كىلىپپېرتون ئاراللىرى" },
            { "CR", "كوستارىكا" },
            { "CU", "كۇبا" },
            { "CV", "يېشىل تۇمشۇق" },
            { "CW", "كۇراچاۋ" },
            { "CX", "مىلاد ئارىلى" },
            { "CY", metaValue_CY },
            { "CZ", "چېخ جۇمھۇرىيىتى" },
            { "DE", "گېرمانىيە" },
            { "DG", "دېگو-گارشىيا" },
            { "DJ", "جىبۇتى" },
            { "DK", "دانىيە" },
            { "DM", "دومىنىكا" },
            { "DO", "دومىنىكا جۇمھۇرىيىتى" },
            { "DZ", "ئالجىرىيە" },
            { "EA", "سېيتا ۋە مېلىلا" },
            { "EC", "ئېكۋاتور" },
            { "EE", "ئېستونىيە" },
            { "EG", "مىسىر" },
            { "EH", "غەربىي ساخارا" },
            { "ER", "ئېرىترىيە" },
            { "ES", "ئىسپانىيە" },
            { "ET", "ئېفىيوپىيە" },
            { "EU", "ياۋروپا ئىتتىپاقى" },
            { "FI", "فىنلاندىيە" },
            { "FJ", "فىجى" },
            { "FK", "فالكلاند ئاراللىرى" },
            { "FM", "مىكرونېزىيە" },
            { "FO", "فارو ئاراللىرى" },
            { "FR", "فىرانسىيە" },
            { "GA", "گابون" },
            { "GB", "بىرلەشمە پادىشاھلىق" },
            { "GD", "گىرېنادا" },
            { "GE", "گىرۇزىيە" },
            { "GF", "فىرانسىيەگە قاراشلىق گىۋىيانا" },
            { "GG", "گۇرنسېي" },
            { "GH", "گانا" },
            { "GI", "جەبىلتارىق" },
            { "GL", "گىرېنلاندىيە" },
            { "GM", "گامبىيە" },
            { "GN", "گىۋىنىيە" },
            { "GP", "گىۋادېلۇپ" },
            { "GQ", "ئېكۋاتور گىۋىنىيەسى" },
            { "GR", "گىرېتسىيە" },
            { "GS", "جەنۇبىي جورجىيە ۋە جەنۇبىي ساندۋىچ ئاراللىرى" },
            { "GT", "گىۋاتېمالا" },
            { "GU", "گۇئام" },
            { "GW", "گىۋىنىيە بىسسائۇ" },
            { "GY", "گىۋىيانا" },
            { "HK", "شياڭگاڭ ئالاھىدە مەمۇرىي رايونى (جۇڭگو)" },
            { "HM", "ھېرد ئارىلى ۋە ماكدونالد ئاراللىرى" },
            { "HN", "ھوندۇراس" },
            { "HR", "كىرودىيە" },
            { "HT", "ھايتى" },
            { "HU", "ۋېنگىرىيە" },
            { "IC", "كانارى ئاراللىرى" },
            { "ID", "ھىندونېزىيە" },
            { "IE", "ئىرېلاندىيە" },
            { "IL", "ئىسرائىلىيە" },
            { "IM", "مان ئارىلى" },
            { "IN", "ھىندىستان" },
            { "IQ", "ئىراق" },
            { "IR", "ئىران" },
            { "IS", "ئىسلاندىيە" },
            { "IT", "ئىتالىيە" },
            { "JE", "جېرسېي" },
            { "JM", "يامايكا" },
            { "JO", "ئىيوردانىيە" },
            { "JP", "ياپونىيە" },
            { "KE", "كېنىيە" },
            { "KG", "قىرغىزىستان" },
            { "KH", "كامبودژا" },
            { "KI", "كىرىباتى" },
            { "KM", "كومورو" },
            { "KN", "ساينت كىتىس ۋە نېۋىس" },
            { "KP", "چاۋشيەن" },
            { "KR", "كورېيە" },
            { "KW", "كۇۋەيت" },
            { "KY", "كايمان ئاراللىرى" },
            { "KZ", "قازاقىستان" },
            { "LA", "لائوس" },
            { "LB", "لىۋان" },
            { "LC", "ساينت لۇسىيە" },
            { "LI", "لىكتېنستېين" },
            { "LK", "سىرىلانكا" },
            { "LR", "لىبېرىيە" },
            { "LS", "لېسوتو" },
            { "LT", "لىتۋانىيە" },
            { "LU", "لىيۇكسېمبۇرگ" },
            { "LV", "لاتۋىيە" },
            { "LY", "لىۋىيە" },
            { "MA", "ماراكەش" },
            { "MC", "موناكو" },
            { "MD", "مولدوۋا" },
            { "ME", "قارا تاغ" },
            { "MF", "ساينت مارتىن" },
            { "MG", "ماداغاسقار" },
            { "MH", "مارشال ئاراللىرى" },
            { "MK", "شىمالىي ماكېدونىيە" },
            { "ML", "مالى" },
            { "MM", "بىرما" },
            { "MN", "موڭغۇلىيە" },
            { "MO", "ئاۋمېن ئالاھىدە مەمۇرىي رايونى" },
            { "MP", "شىمالىي مارىيانا ئاراللىرى" },
            { "MQ", "مارتىنىكا" },
            { "MR", "ماۋرىتانىيە" },
            { "MS", "مونتسېررات" },
            { "MT", "مالتا" },
            { "MU", "ماۋرىتىيۇس" },
            { "MV", "مالدىۋې" },
            { "MW", "مالاۋى" },
            { "MX", "مېكسىكا" },
            { "MY", "مالايسىيا" },
            { "MZ", "موزامبىك" },
            { "NA", "نامىبىيە" },
            { "NC", "يېڭى كالېدونىيە" },
            { "NE", "نىگېر" },
            { "NF", "نورفولك ئارىلى" },
            { "NG", "نىگېرىيە" },
            { "NI", "نىكاراگۇئا" },
            { "NL", "گوللاندىيە" },
            { "NO", "نورۋېگىيە" },
            { "NP", "نېپال" },
            { "NR", "ناۋرۇ" },
            { "NU", "نيۇئې" },
            { "NZ", "يېڭى زېلاندىيە" },
            { "OM", "ئومان" },
            { "PA", "پاناما" },
            { "PE", "پېرۇ" },
            { "PF", "فىرانسىيەگە قاراشلىق پولىنېزىيە" },
            { "PG", "پاپۇئا يېڭى گىۋىنىيەسى" },
            { "PH", "فىلىپپىن" },
            { "PK", "پاكىستان" },
            { "PL", "پولشا" },
            { "PM", "ساينت پىيېر ۋە مىكېلون ئاراللىرى" },
            { "PN", "پىتكايرن ئاراللىرى" },
            { "PR", "پۇئېرتو رىكو" },
            { "PS", "پەلەستىن زېمىنى" },
            { "PT", "پورتۇگالىيە" },
            { "PW", "پالائۇ" },
            { "PY", "پاراگۋاي" },
            { "QA", "قاتار" },
            { "QO", "ئوكيانىيە ئەتراپىدىكى ئاراللار" },
            { "RE", "رېيۇنىيون" },
            { "RO", "رومىنىيە" },
            { "RS", "سېربىيە" },
            { "RU", "رۇسىيە" },
            { "RW", "رىۋاندا" },
            { "SA", "سەئۇدىي ئەرەبىستان" },
            { "SB", "سولومون ئاراللىرى" },
            { "SC", "سېيشېل" },
            { "SD", "سۇدان" },
            { "SE", "شىۋېتسىيە" },
            { "SG", "سىنگاپور" },
            { "SH", "ساينىت ھېلېنا" },
            { "SI", "سىلوۋېنىيە" },
            { "SJ", "سىۋالبارد ۋە يان مايېن" },
            { "SK", "سىلوۋاكىيە" },
            { "SL", "سېررالېئون" },
            { "SM", "سان مارىنو" },
            { "SN", "سېنېگال" },
            { "SO", "سومالى" },
            { "SR", "سۇرىنام" },
            { "SS", "جەنۇبىي سۇدان" },
            { "ST", "سان تومې ۋە پرىنسىپې" },
            { "SV", "سالۋادور" },
            { "SX", "سىنت مارتېن" },
            { "SY", "سۇرىيە" },
            { "SZ", "سىۋېزىلاند" },
            { "TA", "ترىستان داكۇنھا" },
            { "TC", "تۇركس ۋە كايكوس ئاراللىرى" },
            { "TD", "چاد" },
            { "TF", "فىرانسىيەنىڭ جەنۇبىي زېمىنى" },
            { "TG", "توگو" },
            { "TH", "تايلاند" },
            { "TJ", "تاجىكىستان" },
            { "TK", "توكېلاۋ" },
            { "TL", "شەرقىي تىمور" },
            { "TM", "تۈركمەنىستان" },
            { "TN", "تۇنىس" },
            { "TO", "تونگا" },
            { "TR", "تۈركىيە" },
            { "TT", "تىرىنىداد ۋە توباگو" },
            { "TV", "تۇۋالۇ" },
            { "TW", "تەيۋەن" },
            { "TZ", "تانزانىيە" },
            { "UA", "ئۇكرائىنا" },
            { "UG", "ئۇگاندا" },
            { "UM", "ئا ق ش تاشقى ئاراللىرى" },
            { "US", "ئامېرىكا قوشما ئىشتاتلىرى" },
            { "UY", "ئۇرۇگۋاي" },
            { "UZ", "ئۆزبېكىستان" },
            { "VA", "ۋاتىكان" },
            { "VC", "ساينت ۋىنسېنت ۋە گىرېنادىنېس" },
            { "VE", "ۋېنېسۇئېلا" },
            { "VG", "ئەنگلىيە ۋىرگىن ئاراللىرى" },
            { "VI", "ئا ق ش ۋىرگىن ئاراللىرى" },
            { "VN", "ۋىيېتنام" },
            { "VU", "ۋانۇئاتۇ" },
            { "WF", "ۋاللىس ۋە فۇتۇنا" },
            { "WS", "ساموئا" },
            { "XK", "كوسوۋو" },
            { "YE", "يەمەن" },
            { "YT", "مايوتى" },
            { "ZA", "جەنۇبىي ئافرىقا" },
            { "ZM", "زامبىيە" },
            { "ZW", "زىمبابۋې" },
            { "ZZ", "يوچۇن جاي" },
            { "aa", "ئافارچە" },
            { "ab", "ئابخازچە" },
            { "ae", "ئاۋېستاچە" },
            { "af", "ئافرىكانچە" },
            { "ak", "ئاكانچە" },
            { "am", "ئامھارچە" },
            { "an", "ئاراگونچە" },
            { "ar", "ئەرەبچە" },
            { "as", "ئاسامچە" },
            { "av", "ئاۋارچە" },
            { "ay", "ئايماراچە" },
            { "az", "ئەزەربەيجانچە" },
            { "ba", "باشقىرتچە" },
            { "be", "بېلارۇسچە" },
            { "bg", "بۇلغارچە" },
            { "bi", "بىسلاماچە" },
            { "bm", "بامباراچە" },
            { "bn", "بېنگالچە" },
            { "bo", metaValue_bo },
            { "br", "بىرېتونچە" },
            { "bs", "بوسىنچە" },
            { "ca", "كاتالانچە" },
            { "ce", "چېچىنچە" },
            { "ch", "چامورروچە" },
            { "co", "كورسۇچە" },
            { "cr", "كرىچە" },
            { "cs", "چېخچە" },
            { "cu", "قەدىمكى سلاۋيانچە" },
            { "cv", "چۇۋاشچە" },
            { "cy", "ۋېلشچە" },
            { "da", "دانىشچە" },
            { "de", "گېرمانچە" },
            { "dv", "دىۋېخچە" },
            { "dz", "زوڭخاچە" },
            { "ee", "ئېۋېچە" },
            { "el", metaValue_el },
            { "en", "ئىنگلىزچە" },
            { "eo", "ئېسپرانتوچە" },
            { "es", "ئىسپانچە" },
            { "et", "ئېستونچە" },
            { "eu", "باسكىچە" },
            { "fa", "پارسچە" },
            { "ff", "فۇلاھچە" },
            { "fi", "فىنچە" },
            { "fj", "فىجىچە" },
            { "fo", "فائېروچە" },
            { "fr", "فىرانسۇزچە" },
            { "fy", "غەربىي فىرسچە" },
            { "ga", "ئىرېلاندچە" },
            { "gd", "شوتلاندىيە گايلچىسى" },
            { "gl", "گالىچە" },
            { "gn", "گۇئارانىچە" },
            { "gu", metaValue_gu },
            { "gv", "مانچە" },
            { "ha", "خائۇساچە" },
            { "he", "ئىبرانىيچە" },
            { "hi", "ھىندىچە" },
            { "ho", "ھىرى موتۇچە" },
            { "hr", "كىرودىچە" },
            { "ht", "ھايتىچە" },
            { "hu", "ۋېنگىرچە" },
            { "hy", "ئەرمېنچە" },
            { "hz", "خېرېروچە" },
            { "ia", "ئارىلىق تىل" },
            { "id", "ھىندونېزچە" },
            { "ie", "ئىنتىرلىڭچە" },
            { "ig", "ئىگبوچە" },
            { "ii", "يىچە (سىچۈەن)" },
            { "ik", "ئىنۇپىكچە" },
            { "io", "ئىدوچە" },
            { "is", "ئىسلاندچە" },
            { "it", "ئىتالىيانچە" },
            { "iu", "ئىنۇكتىتۇتچە" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", "گىرۇزچە" },
            { "kg", "كونگوچە" },
            { "ki", "كىكۇيۇچە" },
            { "kj", "كىۋانياماچە" },
            { "kk", "قازاقچە" },
            { "kl", "گىرېنلاندچە" },
            { "km", "كىمېرچە" },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "كانۇرچە" },
            { "ks", "كەشمىرچە" },
            { "ku", "كۇردچە" },
            { "kv", "كومىچە" },
            { "kw", "كورنىشچە" },
            { "ky", "قىرغىزچە" },
            { "la", metaValue_la },
            { "lb", "لىيۇكسېمبۇرگچە" },
            { "lg", "گانداچە" },
            { "li", "لىمبۇرگچە" },
            { "ln", "لىنگالاچە" },
            { "lo", metaValue_lo },
            { "lt", "لىتۋانىچە" },
            { "lu", "لۇبا-كاتانگاچە" },
            { "lv", "لاتچە" },
            { "mg", "مالاگاسچە" },
            { "mh", "مارشالچە" },
            { "mi", "ماۋرىچە" },
            { "mk", "ماكېدونچە" },
            { "ml", "مالايالامچە" },
            { "mn", metaValue_mn },
            { "mr", "ماراتىچە" },
            { "ms", "مالايچە" },
            { "mt", "مالتاچە" },
            { "my", metaValue_my },
            { "na", "ناۋرۇچە" },
            { "nb", "نورۋىگىيە بوكمالچە" },
            { "nd", "شىمالى ندەبەلەچە" },
            { "ne", "نېپالچە" },
            { "ng", "ندونگاچە" },
            { "nl", "گوللاندچە" },
            { "nn", "يېڭى نورۋېگچە" },
            { "no", "نورۋېگچە" },
            { "nr", "جەنۇبى ندەبەلەچە" },
            { "nv", "ناۋاخوچە" },
            { "ny", "نىيانجاچە" },
            { "oc", "ئوكسىتچە" },
            { "oj", "ئوجىبۋاچە" },
            { "om", "ئوروموچە" },
            { "or", "ئودىياچە" },
            { "os", "ئوسسېتچەچە" },
            { "pa", "پەنجابچە" },
            { "pi", "پالىچە" },
            { "pl", "پولەكچە" },
            { "ps", "پۇشتۇچە" },
            { "pt", "پورتۇگالچە" },
            { "qu", "كېچىۋاچە" },
            { "rm", "رومانسچە" },
            { "rn", "رۇندىچە" },
            { "ro", "رومىنچە" },
            { "ru", "رۇسچە" },
            { "rw", "كېنىيەرىۋانداچە" },
            { "sa", "سانسكرىتچە" },
            { "sc", "ساردىنىيەچە" },
            { "sd", "سىندىچە" },
            { "se", "شىمالىي سامىچە" },
            { "sg", "سانگوچە" },
            { "sh", "سېرب-كرودىيەچە" },
            { "si", "سىنگالچە" },
            { "sk", "سىلوۋاكچە" },
            { "sl", "سىلوۋېنچە" },
            { "sm", "ساموئاچە" },
            { "sn", "شوناچە" },
            { "so", "سومالىچە" },
            { "sq", "ئالبانچە" },
            { "sr", "سېربچە" },
            { "ss", "سىۋاتىچە" },
            { "st", "سوتوچە" },
            { "su", metaValue_su },
            { "sv", "شىۋېدچە" },
            { "sw", "سىۋاھىلچە" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "تاجىكچە" },
            { "th", metaValue_th },
            { "ti", "تىگرىنياچە" },
            { "tk", "تۈركمەنچە" },
            { "tl", metaValue_tl },
            { "tn", "سىۋاناچە" },
            { "to", "تونگانچە" },
            { "tr", "تۈركچە" },
            { "ts", "سونگاچە" },
            { "tt", "تاتارچە" },
            { "tw", "تىۋىچە" },
            { "ty", "تاختىچە" },
            { "ug", "ئۇيغۇرچە" },
            { "uk", "ئۇكرائىنچە" },
            { "ur", "ئوردۇچە" },
            { "uz", "ئۆزبېكچە" },
            { "ve", "ۋېنداچە" },
            { "vi", "ۋىيېتنامچە" },
            { "vo", "ۋولاپۇكچە" },
            { "wa", "ۋاللۇنچە" },
            { "wo", "ۋولوفچە" },
            { "xh", "خوساچە" },
            { "yi", "يىددىشچە" },
            { "yo", "يورۇباچە" },
            { "za", "جۇاڭچە" },
            { "zh", "خەنزۇچە" },
            { "zu", "زۇلۇچە" },
            { "ace", "ئاتجېچە" },
            { "ach", "ئاچولىچە" },
            { "ada", "ئاداڭمېچە" },
            { "ady", "ئادىگېيچە" },
            { "afh", "ئافرىخىلىچە" },
            { "agq", "ئاگەمچە" },
            { "ain", "ئاينۇچە" },
            { "akk", "ئاككادچە" },
            { "ale", "ئالېيۇتچە" },
            { "alt", "جەنۇبى ئالتاي تىللىرى" },
            { "ang", "قەدىمكى ئىنگلىزچە" },
            { "anp", "ئانگىكاچە" },
            { "arc", "ئارامۇچە" },
            { "arn", "ماپۇدۇنگۇنچە" },
            { "arp", "ئاراپاخوچە" },
            { "arw", "ئاراۋاكچە" },
            { "asa", "ئاسۇچە" },
            { "ast", "ئاستۇرىيەچە" },
            { "awa", "ئاۋادىچە" },
            { "bal", "بېلۇجىچە" },
            { "ban", "بالىچە" },
            { "bas", "باساچە" },
            { "bax", "بامۇنچە" },
            { "bbj", "گومالاچە" },
            { "bej", "بېجاچە" },
            { "bem", "بېمباچە" },
            { "bez", "بېناچە" },
            { "bfd", "بافۇتچە" },
            { "bho", "بوجپۇرىچە" },
            { "bik", "بىكولچە" },
            { "bin", "بىنىچە" },
            { "bkm", "كومچە" },
            { "bla", "سىكسىكاچە" },
            { "bra", "بىراجچە" },
            { "brx", "بودوچە" },
            { "bss", "ئاكۇسچە" },
            { "bua", "بۇرىياتچە" },
            { "bug", "بۇگىچە" },
            { "bum", "بۇلۇچە" },
            { "byn", "بىلىنچە" },
            { "byv", "مېدۇمباچە" },
            { "cad", "كاددوچە" },
            { "car", "كارىبچە" },
            { "cay", "كايۇگاچە" },
            { "cch", "ئاتسامچە" },
            { "ceb", "سېبۇچە" },
            { "cgg", "چىگاچە" },
            { "chb", "چىبچاچە" },
            { "chg", "چاغاتايچە" },
            { "chk", "چۇكچە" },
            { "chm", "مارىچە" },
            { "chn", "چىنۇك-ژارگونچە" },
            { "cho", "چوكتاۋچە" },
            { "chp", "چىپېۋيانچە" },
            { "chr", "چېروكىچە" },
            { "chy", "چېيېنچە" },
            { "ckb", "مەركىزىي كۇردچە" },
            { "cop", "كوپتىكچە" },
            { "crh", "قىرىم تۈركچە" },
            { "csb", "كاسزۇبىچە" },
            { "dak", "داكوتاچە" },
            { "dar", "دارگىۋاچە" },
            { "dav", "تايتاچە" },
            { "del", "دېلاۋارېچە" },
            { "den", "سلاۋچە" },
            { "dgr", "دوگرىبچە" },
            { "din", "دىنكاچە" },
            { "dje", "زارماچە" },
            { "doi", "دوگرىچە" },
            { "dsb", "تۆۋەن سوربچە" },
            { "dua", "دۇئالاچە" },
            { "dum", "ئوتتۇرا گوللاندىيەچە" },
            { "dyo", "جولاچە" },
            { "dyu", "دىيۇلاچە" },
            { "dzg", "دازاگاچە" },
            { "ebu", "ئېمبۇچە" },
            { "efi", "ئېفىكچە" },
            { "egy", "قەدىمكى مىسىرچە" },
            { "eka", "ئېكاجۇكچە" },
            { "elx", "ئېلامىتچە" },
            { "enm", "ئوتتۇرا ئەسىر ئىنگلىزچە" },
            { "ewo", "ئېۋوندوچە" },
            { "fan", "فاڭچە" },
            { "fat", "فانتىچە" },
            { "fil", "فىلىپپىنچە" },
            { "fon", "فونچە" },
            { "frm", "ئوتتۇرا ئەسىر فىرانسۇزچە" },
            { "fro", "قەدىمكى فىرانسۇزچە" },
            { "frr", "شىمالى فىرىزيەچە" },
            { "frs", "شەرقى فىرىزيەچە" },
            { "fur", "فىرىئۇلىچە" },
            { "gaa", "گاچە" },
            { "gay", "گايوچە" },
            { "gba", "گىباياچە" },
            { "gez", "گىزچە" },
            { "gil", "گىلبېرتچە" },
            { "gmh", "ئوتتۇرا ئەسىر ئېگىزلىك گېرمانچە" },
            { "goh", "قەدىمكى ئېگىزلىك گېرمانچە" },
            { "gon", "گوندىچە" },
            { "gor", "گورونتالوچە" },
            { "got", metaValue_got },
            { "grb", "گرېبوچە" },
            { "grc", "قەدىمكى گىرېكچە" },
            { "gsw", "گېرمانچە شىۋىتسارىيە" },
            { "guz", "گۇسىچە" },
            { "gwi", "گىۋىچىنچە" },
            { "hai", "ھەيدەچە" },
            { "haw", "ھاۋايچە" },
            { "hil", "خىلىگاينونچە" },
            { "hit", "خىتتىتچە" },
            { "hmn", metaValue_hmn },
            { "hsb", "ئۈستۈن سوربچە" },
            { "hup", "خۇپاچە" },
            { "iba", "ئىبانچە" },
            { "ibb", "ئىبىبىئوچە" },
            { "ilo", "ئىلوكانوچە" },
            { "inh", "ئىنگۇشچە" },
            { "jbo", "لوجبانچە" },
            { "jgo", "نگومباچە" },
            { "jmc", "ماچامچە" },
            { "jpr", "ئىبرانى پارسچە" },
            { "jrb", "ئىبرانى ئەرەبچە" },
            { "kaa", "قارا-قالپاقچە" },
            { "kab", "كابىلېچە" },
            { "kac", "كاچىنچە" },
            { "kaj", "جۇچە" },
            { "kam", "كامباچە" },
            { "kaw", "كاۋىچە" },
            { "kbd", "كاباردەيچە" },
            { "kbl", "كانېمبۇچە" },
            { "kcg", "تياپچە" },
            { "kde", "ماكوندېچە" },
            { "kea", "كابۇۋېردىيانچە" },
            { "kfo", "كوروچە" },
            { "kha", "كاسىچە" },
            { "kho", "خوتەنچە" },
            { "khq", "كويرا چىنىچە" },
            { "kkj", "كاكوچە" },
            { "kln", "كالېنجىنچە" },
            { "kmb", "كىمبۇندۇچە" },
            { "kok", "كونكانچە" },
            { "kos", "كوسرايېچە" },
            { "kpe", "كىپەللېچە" },
            { "krc", "قاراچاي-بالقارچە" },
            { "krl", "كارەلچە" },
            { "kru", "كۇرۇخچە" },
            { "ksb", "شامبالاچە" },
            { "ksf", "بافىياچە" },
            { "ksh", "كولىشچە" },
            { "kum", "قۇمۇقچە" },
            { "kut", "كۇتەنايچە" },
            { "lad", "لادىنوچە" },
            { "lag", "لانگىچە" },
            { "lah", "لانداچە" },
            { "lam", "لامباچە" },
            { "lez", "لېزگىنچە" },
            { "lol", "مونگوچە" },
            { "loz", "لوزىچە" },
            { "lua", "لۇبا-لۇئاچە" },
            { "lui", "لۇيسېنگوچە" },
            { "lun", "لۇنداچە" },
            { "luo", "لۇئوچە" },
            { "lus", "مىزوچە" },
            { "luy", "لۇياچە" },
            { "mad", "مادۇرېسچە" },
            { "maf", "مافاچە" },
            { "mag", "ماگاخىچە" },
            { "mai", "مايتىلىچە" },
            { "mak", "ماكاسارچە" },
            { "man", "ماندىنگوچە" },
            { "mas", "ماسايچە" },
            { "mde", "ماباچە" },
            { "mdf", "موكشاچە" },
            { "mdr", "ماندارچە" },
            { "men", metaValue_men },
            { "mer", "مېرۇچە" },
            { "mfe", "مورىسيېنچە" },
            { "mga", "ئوتتۇرا ئەسىر ئىرېلاندچە" },
            { "mgh", "ماكۇۋاچە" },
            { "mgo", "مېتاچە’" },
            { "mic", "مىكماكچە" },
            { "min", "مىناڭكابائۇچە" },
            { "mnc", "مانجۇچە" },
            { "mni", "مانىپۇرچە" },
            { "moh", "موخاۋكچە" },
            { "mos", "موسسىچە" },
            { "mua", "مۇنداڭچە" },
            { "mul", "كۆپ تىللار" },
            { "mus", "كىرىكچە" },
            { "mwl", "مىراندېسچە" },
            { "mwr", "مارۋارىچە" },
            { "mye", "ميېنېچە" },
            { "myv", "ئېرزاچە" },
            { "nap", "ناپولىچە" },
            { "naq", "ناماچە" },
            { "nds", "تۆۋەن گېرمانچە" },
            { "new", "نېۋارىچە" },
            { "nia", "نىئاسچە" },
            { "niu", "نيۇئېچە" },
            { "nmg", "كۋاسىيوچە" },
            { "nnh", "نگېمبۇنچە" },
            { "nog", "نوغايچە" },
            { "non", "قەدىمكى نورۋېگچە" },
            { "nqo", metaValue_nqo },
            { "nso", "شىمالىي سوتوچە" },
            { "nus", "مۇئېرچە" },
            { "nwc", "نېۋارچە" },
            { "nym", "نيامۋېزىچە" },
            { "nyn", "نىيانكولېچە" },
            { "nyo", "نىئوروچە" },
            { "nzi", "نىزەماچە" },
            { "osa", "ئوساگېلارچە" },
            { "ota", "ئوسمان تۈركچە" },
            { "pag", "پانگاسىنانچە" },
            { "pal", "پەھلەۋىچە" },
            { "pam", "پامپانگاچە" },
            { "pap", "پاپىيامېنتوچە" },
            { "pau", "پالاۋچە" },
            { "peo", metaValue_peo },
            { "phn", "فىنىكىيەچە" },
            { "pon", "پوناپېئانچە" },
            { "pro", "قەدىمكى پروۋېنچالچە" },
            { "raj", "راجاستانچە" },
            { "rap", "راپانىيچە" },
            { "rof", "رومبوچە" },
            { "rom", "سىگانچە" },
            { "rup", "ئارومانچە" },
            { "rwk", "رىۋاچە" },
            { "sad", "سانداۋېچە" },
            { "sah", "ساخاچە" },
            { "sam", "سامارىتانچە" },
            { "saq", "سامبۇرۇچە" },
            { "sas", "ساساكچە" },
            { "sat", "سانتالچە" },
            { "sba", "نگامبايچە" },
            { "sbp", "سانگۇچە" },
            { "scn", "سىتسىلىيەچە" },
            { "sco", "شوتلاندىيەچە" },
            { "see", "سېكنېكاچە" },
            { "seh", "سېناچە" },
            { "sel", "سېلكاپچە" },
            { "ses", "شەرقىي سوڭخايچە" },
            { "sga", "قەدىمكى ئىرېلاندچە" },
            { "shi", "شىلخاچە" },
            { "shn", "شانچە" },
            { "shu", "چاد ئەرەبچە" },
            { "sid", "سىداموچە" },
            { "sma", "جەنۇبىي سامىچە" },
            { "smj", "لۇلې سامىچە" },
            { "smn", "ئىنارى سامىچە" },
            { "sms", "سكولت سامىچە" },
            { "snk", "سونىنكەچە" },
            { "sog", "سوغدىچە" },
            { "srn", "سىرانان-توڭوچە" },
            { "srr", "سېرېرچە" },
            { "ssy", metaValue_ssy },
            { "suk", "سۇكۇماچە" },
            { "sus", "سۇسۇچە" },
            { "sux", "سۈمەرچە" },
            { "swb", "كومورىچە" },
            { "syc", "قەدىمىي سۇرىيەچە" },
            { "syr", "سۇرىيەچە" },
            { "tem", "تېمنېچە" },
            { "teo", "تېسوچە" },
            { "ter", "تېرېناچە" },
            { "tet", "تېتۇمچە" },
            { "tig", "تىگرېچە" },
            { "tiv", "تىۋچە" },
            { "tkl", "توكېلاۋچە" },
            { "tlh", "كىلىنگونچە" },
            { "tli", "تىلىنگىتچە" },
            { "tmh", "تاماشېكچە" },
            { "tog", "نياسا توڭانچە" },
            { "tpi", "توك-پىسىنچە" },
            { "trv", "توروكوچە" },
            { "tsi", "سىمشيانچە" },
            { "tum", "تۇمبۇكاچە" },
            { "tvl", "تۇۋالۇچە" },
            { "twq", "شىمالىي سوڭخايچە" },
            { "tyv", "توۋاچە" },
            { "tzm", "مەركىزىي ئاتلاس تامازايتچە" },
            { "udm", "ئۇدمۇرتچە" },
            { "uga", metaValue_uga },
            { "umb", "ئۇمبۇندۇچە" },
            { "und", "يوچۇن تىل" },
            { "vai", metaValue_vai },
            { "vot", "ۋوتېچە" },
            { "vun", "ۋۇنجوچە" },
            { "wae", "ۋالسېرچە" },
            { "wal", "ۋولايتاچە" },
            { "war", "ۋارايچە" },
            { "was", "ۋاشوچە" },
            { "xal", "قالماقچە" },
            { "xog", "سوگاچە" },
            { "yao", "ياۋچە" },
            { "yap", "ياپچە" },
            { "yav", "ياڭبەنچە" },
            { "ybb", "يېمباچە" },
            { "yue", "گۇاڭدوڭچە" },
            { "zap", "زاپوتېكچە" },
            { "zbl", metaValue_zbl },
            { "zen", "زېناگاچە" },
            { "zgh", "ئۆلچەملىك ماراكەش تامازىتچە" },
            { "zun", "زۇنىچە" },
            { "zxx", "تىل مەزمۇنى يوق" },
            { "zza", "زازاچە" },
            { "Afak", "ئافاكا" },
            { "Arab", "ئەرەب" },
            { "Armi", "خان جەمەتى ئارامۇ" },
            { "Armn", "ئەرمەن" },
            { "Avst", "ئاۋېستا" },
            { "Bali", "بالى" },
            { "Bamu", "بامۇم" },
            { "Bass", "باسسا" },
            { "Batk", "باتاك" },
            { "Beng", metaValue_BD },
            { "Blis", metaValue_zbl },
            { "Bopo", "خەنچە پىنيىن" },
            { "Brah", "براخمى" },
            { "Brai", "برائىل ئەمالار يېزىقى" },
            { "Bugi", "بۇگى" },
            { "Buhd", "بۇخىت" },
            { "Cakm", "چاكما" },
            { "Cans", "بىرلىككە كەلگەن كانادا يەرلىك بوغۇم جەدۋىلى" },
            { "Cari", "كارىيا" },
            { "Cham", "چام" },
            { "Cher", "چېروكى" },
            { "Cirt", "كىرسچە" },
            { "Copt", "كوپتىك" },
            { "Cprt", metaValue_CY },
            { "Cyrl", "كىرىل" },
            { "Cyrs", "قەدىمكى چىركاۋ سىلاۋيانچە كىرىل" },
            { "Deva", "دېۋاناگارى" },
            { "Dsrt", "دېزېرېت" },
            { "Dupl", "دۇپلويان تېز خاتىرىلەش" },
            { "Egyd", "دېموتىكچە مىسىر" },
            { "Egyh", "خىيەراتىكچە مىسىر" },
            { "Egyp", "تەسۋىرىي يېزىق مىسىر" },
            { "Ethi", "ئېفىيوپىيەچە" },
            { "Geok", "خۇتسۇرى گىرۇزىنچە" },
            { "Geor", "گىرۇزىنچە" },
            { "Glag", "گىلاگوتچە" },
            { "Goth", metaValue_got },
            { "Gran", "گىرانتاچە" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "گۇرمۇكىچە" },
            { "Hani", "خەنچە" },
            { "Hano", "خانۇنۇچە" },
            { "Hans", metaValue_Hans },
            { "Hant", metaValue_Hant },
            { "Hebr", "ئىبرانىچە" },
            { "Hira", "خىراگانا" },
            { "Hluw", "ئاناتولىيە تەسۋىرىي يېزىق" },
            { "Hmng", metaValue_hmn },
            { "Hrkt", "ياپونچە خىراگانا ياكى كاتاكانا" },
            { "Hung", "قەدىمكى ماجارچە" },
            { "Inds", "ئىندۇسچە" },
            { "Ital", "قەدىمكى ئىتاليانچە" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "جۇرچېنچە" },
            { "Kali", "كاياھچە" },
            { "Kana", "كاتاكانا" },
            { "Khar", "كاروشتىچە" },
            { "Khmr", "كېخمېرچە" },
            { "Khoj", "خوجكىچە" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", "كپېللېچە" },
            { "Kthi", "كاياتىچە" },
            { "Lana", "لانناچە" },
            { "Laoo", metaValue_lo },
            { "Latf", "فىراكتۇر لاتىنچە" },
            { "Latg", "سىكوت لاتىنچە" },
            { "Latn", metaValue_la },
            { "Lepc", "لەپچاچە" },
            { "Limb", "لىمبۇچە" },
            { "Lina", "سىزىقلىق A" },
            { "Linb", "سىزىقلىق B" },
            { "Lisu", "فراسېرچە" },
            { "Loma", "لوماچە" },
            { "Lyci", "لىسىيانچە" },
            { "Lydi", "لىدىيەچە" },
            { "Mand", "ماندائىكچە" },
            { "Mani", "مانەكېزەمچە" },
            { "Maya", "ماياچە تەسۋىرىي يېزىق" },
            { "Mend", metaValue_men },
            { "Merc", "مېتروئىت يازمىچە" },
            { "Mero", "مېتروئىت" },
            { "Mlym", "مالايامچە" },
            { "Mong", metaValue_mn },
            { "Moon", "كورىيە" },
            { "Mroo", "مروچە" },
            { "Mtei", "مانىپۇرىچە" },
            { "Mymr", metaValue_my },
            { "Narb", "قەدىمكى شىمالىي ئەرەبچە" },
            { "Nbat", "ئانباتچە" },
            { "Nkgb", "ناشىچە" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "نۈشۇچە" },
            { "Ogam", "ئوگەمچە" },
            { "Olck", "ئول-چىكىچە" },
            { "Orkh", "ئورخۇنچە" },
            { "Orya", "ئورىياچە" },
            { "Osma", "ئوسمانيە" },
            { "Palm", "پالمىراچە" },
            { "Perm", "قەدىمكى پېرمىكچە" },
            { "Phag", "پاسپاچە" },
            { "Phli", "پەھلىۋىچە ئويما خەت" },
            { "Phlp", "پەھلىۋىچە شېئىرىي تىل" },
            { "Phlv", "پەھلىۋىچە كىتابى تىل" },
            { "Phnx", "فىنىكچە" },
            { "Plrd", "پوللارد تاۋۇشلىرى" },
            { "Prti", "پارتىئانچە ئويما خەت" },
            { "Rjng", "رېجاڭچە" },
            { "Roro", "روڭگوروڭگو" },
            { "Runr", "رۇنىكچە" },
            { "Samr", "سامارىچە" },
            { "Sara", "ساراتىچە" },
            { "Sarb", "قەدىمكى جەنۇبى ئەرەبچە" },
            { "Saur", "سائۇراشتىراچە" },
            { "Sgnw", "ئىشارەت تىلى" },
            { "Shaw", "شاۋىيانچە" },
            { "Shrd", "شاراداچە" },
            { "Sind", "كۇداۋادچە" },
            { "Sinh", "سىنخالاچە" },
            { "Sora", "سورا سامپىڭ" },
            { "Sund", metaValue_su },
            { "Sylo", "سىيولوتى-ناگرىچە" },
            { "Syrc", "سۈرىيەچە" },
            { "Syre", "سۈرىيەچە ئەبجەت" },
            { "Syrj", "غەربىي سۈرىيەچە" },
            { "Syrn", "شەرقىي سۈرىيەچە" },
            { "Tagb", "تاگبانۋاچە" },
            { "Takr", "تاكرىچە" },
            { "Tale", "تاي-لەچە" },
            { "Talu", "يېڭى تاي-لەچە" },
            { "Taml", metaValue_ta },
            { "Tang", "تاڭغۇتچە" },
            { "Tavt", "تايلاندچە-ۋىيېتنامچە" },
            { "Telu", metaValue_te },
            { "Teng", "تېڭۋارچە" },
            { "Tfng", "تىفىناغچە" },
            { "Tglg", metaValue_tl },
            { "Thaa", "تاناچە" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "تىرخۇتاچە" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "كۆرۈنۈشچان تاۋۇش" },
            { "Wara", "ۋاراڭ كىشىتى" },
            { "Wole", "ۋولىئاي" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "سۇمېر-ئاككادىيان مىخ خەت" },
            { "Yiii", "يىچە" },
            { "Zinh", "ئىرسىيەت ئاتالغۇ" },
            { "Zmth", "ماتېماتىكىلىق بەلگە" },
            { "Zsym", "بەلگە" },
            { "Zxxx", "يېزىلمىغان" },
            { "Zyyy", "ئورتاق" },
            { "Zzzz", "يوچۇن يېزىق" },
            { "de_AT", "ئاۋستىرىيە گېرمانچە" },
            { "de_CH", "شىۋىتسارىيە ئېگىزلىك گېرمانچە" },
            { "en_AU", "ئاۋسترالىيە ئىنگلىزچە" },
            { "en_CA", "كانادا ئىنگلىزچە" },
            { "en_GB", "ئەنگلىيە ئىنگلىزچە" },
            { "en_US", "ئامېرىكا ئىنگلىزچە" },
            { "es_ES", "ياۋروپا ئىسپانچە" },
            { "es_MX", "مېكسىكا ئىسپانچە" },
            { "fr_CA", "كانادا فىرانسۇزچە" },
            { "fr_CH", "شىۋىتسارىيە فىرانسۇزچە" },
            { "pt_BR", "بىرازىلىيە پورتۇگالچە" },
            { "pt_PT", "ياۋروپا پورتۇگالچە" },
            { "sw_CD", "كونگو سىۋالىچە" },
            { "%%1901", "ئەنئەنىۋى گېرمانچە ئىملا قائىدىسى" },
            { "%%1994", "ئۆلچەملەشتۈرۈلگەن رېسىيان ئىملا قائىدىسى" },
            { "%%1996", "گېرمانچە ئىملا قائىدىسى 1996" },
            { "ar_001", "ھازىرقى زامان ئۆلچەملىك ئەرەبچە" },
            { "es_419", "لاتىن ئامېرىكا ئىسپانچە" },
            { "key.ca", "يىلنامە" },
            { "key.co", "تەرتىپلەش تەرتىپى" },
            { "key.cu", "پۇل" },
            { "key.nu", "سان" },
            { "%%ALUKU", "ئالۇكۇ شىۋەسى" },
            { "%%BISKE", "سان گىيورگىيو/بىلا شىۋەسى" },
            { "%%BOONT", "بۇنتلىڭچە" },
            { "%%KKCOR", "ئورتاق ئىملا قائىدىسى" },
            { "%%KSCOR", "ئۆلچەملىك ئىملا قائىدىسى" },
            { "%%LIPAW", "رېسىياننىڭ لىپوۋاز شىۋەسى" },
            { "%%NEDIS", "ناتىسون شىۋەسى" },
            { "%%NJIVA", "گىنىۋا/نىجىۋا شىۋەسى" },
            { "%%NULIK", "زامانىۋى ۋولاپۇكچە" },
            { "%%OSOJS", "ئوسېئاككو/ئوسوجەن شىۋەسى" },
            { "%%POSIX", "كومپيۇتېر" },
            { "%%RIGIK", "ئەنئەنىۋى ۋولاپۇكچە" },
            { "%%ROZAJ", "رېسىيان" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "سىتولۋىززا/سولبىكا شىۋەسى" },
            { "%%UCCOR", "بىرلىككە كەلگەن ئىملا قائىدىسى" },
            { "zh_Hans", metaValue_Hans },
            { "zh_Hant", metaValue_Hant },
            { "%%DAJNKO", "داژىنكو ئېلىپبەسى" },
            { "%%FONIPA", "IPA تاۋۇشلىرى" },
            { "%%FONUPA", "UPA تاۋۇشلىرى" },
            { "%%NDYUKA", "نىديۇكا شىۋەسى" },
            { "%%PAMAKA", "پاماكا شىۋەسى" },
            { "%%PINYIN", "پىنيىن لاتىنلاشتۇرۇش" },
            { "%%SCOUSE", "سىكاۋۇز" },
            { "%%TARASK", "تاراسكىۋىتسا ئىملا قائىدىسى" },
            { "%%UCRCOR", "بىرلىككە كەلگەن تۈزىتىلگەن ئىملا قائىدىسى" },
            { "%%ALALC97", "ALA-LC لاتىنلاشتۇرۇش، 1997 نەشرى" },
            { "%%AREVELA", "شەرقىي ئەرمەنچە" },
            { "%%AREVMDA", "غەربىي ئەرمەنچە" },
            { "%%BOHORIC", "بوخورىچ ئېلىپبەسى" },
            { "%%EMODENG", "دەسلەپكى مەزگىلدىكى زامانىۋى ئىنگلىزچە" },
            { "%%HEPBURN", "خېپبۇرن لاتىنلاشتۇرۇش" },
            { "%%METELKO", "مېتېلكو ئېلىپبەسى" },
            { "%%MONOTON", "ئاددىي" },
            { "%%POLYTON", "پولىتونىك" },
            { "%%REVISED", "تۈزىتىلگەن ئىملا قائىدىسى" },
            { "%%1606NICT", "ئوتتۇرا ئاخىرقى دەۋردىكى فىرانسۇزچە 1606" },
            { "%%1694ACAD", "دەسلەپكى مەزگىلدىكى زامانىۋى فىرانسۇزچە" },
            { "%%1959ACAD", "ئاكادېمىك" },
            { "%%BAKU1926", "بىرلىككە كەلگەن تۈرك لاتىن ئېلىپبەسى" },
            { "%%SCOTLAND", "شوتلاندىيە ئۆلچەملىك ئىنگلىزچە" },
            { "%%VALENCIA", "ۋالېنسىيە" },
            { "%%WADEGILE", "ۋېي ئائىلىسى پىنيىن لاتىنلاشتۇرۇش" },
            { "type.ca.roc", "مىنگو يىلنامەسى" },
            { "type.co.eor", "ياۋروپا تەرتىپلەش قائىدىسى" },
            { "type.nu.arab", "ئەرەبچە-ھىندىچە رەقەملەر" },
            { "type.nu.armn", "ئەرمەنچە رەقەملەر" },
            { "type.nu.bali", "بالىچە رەقەملەر" },
            { "type.nu.beng", "بېنگالچە رەقەملەر" },
            { "type.nu.brah", "بىراخمىچە رەقەملەر" },
            { "type.nu.cakm", "چاكماچە رەقەملەر" },
            { "type.nu.cham", "چامچە رەقەملەر" },
            { "type.nu.deva", "دېۋاناگارىچە رەقەملەر" },
            { "type.nu.ethi", "ئېفىيوپىيەچە رەقەملەر" },
            { "type.nu.geor", "گىرۇزىنچە رەقەملەر" },
            { "type.nu.grek", "گىرېكچە رەقەملەر" },
            { "type.nu.gujr", "گۇجاراتچە رەقەملەر" },
            { "type.nu.guru", "گۇرمۇكىچە رەقەملەر" },
            { "type.nu.hans", "ئاددىي خەنچە رەقەملەر" },
            { "type.nu.hant", "مۇرەككەپ خەنچە رەقەملەر" },
            { "type.nu.hebr", "ئىبرانىچە رەقەملەر" },
            { "type.nu.java", "ياۋاچە رەقەملەر" },
            { "type.nu.jpan", "ياپونچە رەقەملەر" },
            { "type.nu.kali", "كاياھچە رەقەملەر" },
            { "type.nu.khmr", "كېخمېرچە رەقەملەر" },
            { "type.nu.knda", "كانناداچە رەقەملەر" },
            { "type.nu.lana", "تاي تامچە خورا رەقەملەر" },
            { "type.nu.laoo", "لائوسچە رەقەملەر" },
            { "type.nu.latn", "غەربچە رەقەملەر" },
            { "type.nu.lepc", "لەپچاچە رەقەملەر" },
            { "type.nu.limb", "لىمبۇچە رەقەملەر" },
            { "type.nu.mlym", "مالايالامچە رەقەملەر" },
            { "type.nu.mong", "موڭغۇلچە رەقەملەر" },
            { "type.nu.mtei", "مانىپۇرىچە رەقەملەر" },
            { "type.nu.mymr", "بېرماچە رەقەملەر" },
            { "type.nu.nkoo", "نىكوچە رەقەملەر" },
            { "type.nu.olck", "ئول-چىكىچە رەقەملەر" },
            { "type.nu.orya", "ئورىياچە رەقەملەر" },
            { "type.nu.osma", "ئوسمانىيە رەقەملەر" },
            { "type.nu.saur", "سائۇراشتىراچە رەقەملەر" },
            { "type.nu.shrd", "شاراداچە رەقەملەر" },
            { "type.nu.sora", "سورا سومپېڭ رەقەملەر" },
            { "type.nu.sund", "سۇنداچە رەقەملەر" },
            { "type.nu.takr", "تاكرىچە رەقەملەر" },
            { "type.nu.talu", "يېڭى تاي-لەچە رەقەملەر" },
            { "type.nu.taml", "ئەنئەنىۋى تامىلچە رەقەملەر" },
            { "type.nu.telu", "تېلۇگۇچە رەقەملەر" },
            { "type.nu.thai", "تايلاندچە رەقەملەر" },
            { "type.nu.tibt", "تىبەتچە رەقەملەر" },
            { "type.nu.vaii", "ۋايچە رەقەملەر" },
            { "type.ca.dangi", "دانگى يىلنامەسى" },
            { "type.co.ducet", "كۆڭۈلدىكى يۇنىكود تىزىش تەرتىپى" },
            { "type.nu.roman", "رىم رەقەملەر" },
            { "type.ca.coptic", "كوپتىك يىلنامەسى" },
            { "type.ca.hebrew", "يەھۇدى يىلنامەسى" },
            { "type.ca.indian", "ھىندىستان دۆلەت يىلنامەسى" },
            { "type.co.pinyin", "پىنيىن تىزىش تەرتىپى" },
            { "type.co.search", "ئادەتتىكى ئىزدەش" },
            { "type.co.stroke", "سىزىق بويىچە تەرتىپلەش" },
            { "type.co.unihan", "يان بۆلەك سىزىق بويچە تەرتىپلەش تەرتىپى" },
            { "type.co.zhuyin", "ترانسكرىپسىيە تەرتىپلەش تەرتىپى" },
            { "type.ca.chinese", "دېھقانلار يىلنامەسى" },
            { "type.ca.iso8601", "ISO-8601 يىلنامەسى" },
            { "type.ca.persian", "پارىس يىلنامەسى" },
            { "type.co.big5han", "مۇرەككەپ خەنچە تىزىش تەرتىپى - Big5" },
            { "type.nu.arabext", "كېڭەيتىلگەن ئەرەبچە-ھىندىچە رەقەملەر" },
            { "type.nu.armnlow", "ئەرەبچە رەقەملەر (كىچىك ھەرپ)" },
            { "type.nu.greklow", "گىرېكچە رەقەملەر (كىچىك ھەرپ)" },
            { "type.nu.hanidec", "خەنچە ئونلۇق رەقەملەر" },
            { "type.nu.hansfin", "ئاددىي خەنچە پۇل-مۇئامىلە رەقەملەر" },
            { "type.nu.hantfin", "مۇرەككەپ خەنچە پۇل-مۇئامىلە رەقەملەر" },
            { "type.nu.jpanfin", "ياپونچە پۇل-مۇئامىلە رەقەملەر" },
            { "type.nu.tamldec", "تامىلچە رەقەملەر" },
            { "type.ca.buddhist", "بۇددا يىلنامەسى" },
            { "type.ca.ethiopic", "ئېفىيوپىيە يىلنامەسى" },
            { "type.ca.japanese", "ياپونىيە يىلنامەسى" },
            { "type.co.reformed", "ياخشىلانغان تەرتىپلەش تەرتىپى" },
            { "type.co.searchjl", "كورىيەچە ئۈزۈك تاۋۇش بويىچە ئىزدەش" },
            { "type.co.standard", "ئۆلچەملىك تەرتىپلەش تەرتىپى" },
            { "type.nu.fullwide", "تولۇق كەڭلىكتىكى رەقەملەر" },
            { "type.nu.lanatham", "تاي تامچە تام رەقەملەر" },
            { "type.nu.mymrshan", "بېرما شانچە رەقەملەر" },
            { "type.nu.romanlow", "رىم رەقەملەر (كىچىك ھەرپ)" },
            { "type.ca.gregorian", "مىلادىيە يىلنامەسى" },
            { "type.co.gb2312han", "ئاددىي خەنچە تىزىش تەرتىپى - GB2312" },
            { "type.co.phonebook", "تېلېفون نومۇر تىزىش تەرتىپى" },
            { "type.co.dictionary", "لۇغەت تىزىش تەرتىپى" },
            { "type.co.traditional", "ئەنئەنىۋى تەرتىپلەش تەرتىپى" },
            { "ListCompositionPattern", "{0}، {1}" },
            { "type.ca.ethiopic-amete-alem", "ئېفىيوپىيە ئامېتې ئالېم يىلنامەسى" },
        };
        return data;
    }
}
