/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ug extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "گىرىنۋىچ ۋاقتى",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "ئاكرې ئۆلچەملىك ۋاقتى",
               "",
               "ئاكرى يازلىق ۋاقتى",
               "",
               "ئاكرې ۋاقتى",
               "",
            };
        final String[] Cook = new String[] {
               "كۇك ئاراللىرى ئۆلچەملىك ۋاقتى",
               "",
               "كۇك ئاراللىرى يېرىم يازلىق ۋاقتى",
               "",
               "كۇك ئاراللىرى ۋاقتى",
               "",
            };
        final String[] Cuba = new String[] {
               "كۇبا ئۆلچەملىك ۋاقتى",
               "CST",
               "كۇبا يازلىق ۋاقتى",
               "CDT",
               "كۇبا ۋاقتى",
               "CT",
            };
        final String[] Fiji = new String[] {
               "فىجى ئۆلچەملىك ۋاقتى",
               "",
               "فىجى يازلىق ۋاقتى",
               "",
               "فىجى ۋاقتى",
               "",
            };
        final String[] Gulf = new String[] {
               "گۇلف ئۆلچەملىك ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "خوۋد ئۆلچەملىك ۋاقتى",
               "",
               "خوۋد يازلىق ۋاقتى",
               "",
               "خوۋد ۋاقتى",
               "",
            };
        final String[] Iran = new String[] {
               "ئىران ئۆلچەملىك ۋاقتى",
               "",
               "ئىران يازلىق ۋاقتى",
               "",
               "ئىران ۋاقتى",
               "",
            };
        final String[] Niue = new String[] {
               "نىيۇئې ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ئومسك ئۆلچەملىك ۋاقتى",
               "",
               "ئومسك يازلىق ۋاقتى",
               "",
               "ئومسك ۋاقتى",
               "",
            };
        final String[] Peru = new String[] {
               "پېرۇ ئۆلچەملىك ۋاقتى",
               "",
               "پېرۇ يازلىق ۋاقتى",
               "",
               "پېرۇ ۋاقتى",
               "",
            };
        final String[] Truk = new String[] {
               "چۇك ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ۋېيك ئارىلى ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "چىلى ئۆلچەملىك ۋاقتى",
               "",
               "چىلى يازلىق ۋاقتى",
               "",
               "چىلى ۋاقتى",
               "",
            };
        final String[] China = new String[] {
               "جۇڭگو ئۆلچەملىك ۋاقتى",
               "CST",
               "جۇڭگو يازلىق ۋاقتى",
               "CDT",
               "جۇڭگو ۋاقتى",
               "CT",
            };
        final String[] Cocos = new String[] {
               "كوكۇس ئارىلى ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "داۋىس ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ھىندىستان ئۆلچەملىك ۋاقتى",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "ياپونىيە ئۆلچەملىك ۋاقتى",
               "JST",
               "ياپونىيە يازلىق ۋاقتى",
               "JDT",
               "ياپونىيە ۋاقتى",
               "JT",
            };
        final String[] Korea = new String[] {
               "كورىيە ئۆلچەملىك ۋاقتى",
               "KST",
               "كورىيە يازلىق ۋاقتى",
               "KST",
               "كورىيە ۋاقتى",
               "KST",
            };
        final String[] Nauru = new String[] {
               "ناۋرۇ ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "نېپال ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "پالاۋ ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "ساموئا ئۆلچەملىك ۋاقتى",
               "SST",
               "سەمەرقەنت يازلىق ۋاقتى",
               "SST",
               "ساموئا ۋاقتى",
               "SST",
            };
        final String[] Syowa = new String[] {
               "شوۋا ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "تونگا ئۆلچەملىك ۋاقتى",
               "",
               "تونگا يازلىق ۋاقتى",
               "",
               "تونگا ۋاقتى",
               "",
            };
        final String[] Alaska = new String[] {
               "ئالياسكا ئۆلچەملىك ۋاقتى",
               "AKST",
               "ئالياسكا يازلىق ۋاقتى",
               "AKDT",
               "ئالياسكا ۋاقتى",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ئامازون ئۆلچەملىك ۋاقتى",
               "",
               "ئامازون يازلىق ۋاقتى",
               "",
               "ئامازون ۋاقتى",
               "",
            };
        final String[] Anadyr = new String[] {
               "ئانادىر ئۆلچەملىك ۋاقتى",
               "",
               "ئانادىر يازلىق ۋاقتى",
               "",
               "ئانادىر ۋاقتى",
               "",
            };
        final String[] Azores = new String[] {
               "ئازور ئۆلچەملىك ۋاقتى",
               "",
               "ئازور يازلىق ۋاقتى",
               "",
               "ئازور ۋاقتى",
               "",
            };
        final String[] Bhutan = new String[] {
               "بۇتان ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "بىرۇنىي دارۇسسالام ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "پاسكاليا ئارىلى ئۆلچەملىك ۋاقتى",
               "",
               "ئېستېر ئارىلى يازلىق ۋاقتى",
               "",
               "ئېستېر ئارىلى ۋاقتى",
               "",
            };
        final String[] Guyana = new String[] {
               "گىۋىيانا ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "ئىسرائىلىيە ئۆلچەملىك ۋاقتى",
               "IST",
               "ئىسرائىلىيە يازلىق ۋاقتى",
               "IDT",
               "ئىسرائىلىيە ۋاقتى",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "كوسرائې ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "ماۋسون ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "موسكۋا ئۆلچەملىك ۋاقتى",
               "MSK",
               "موسكۋا يازلىق ۋاقتى",
               "MSK",
               "موسكۋا ۋاقتى",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "پونپېي ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "سامارا ئۆلچەملىك ۋاقتى",
               "",
               "سامارا يازلىق ۋاقتى",
               "",
               "سامارا ۋاقتى",
               "",
            };
        final String[] Tahiti = new String[] {
               "تايتى ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "تەيبېي ئۆلچەملىك ۋاقتى",
               "CST",
               "تەيبېي يازلىق ۋاقتى",
               "CDT",
               "تەيبېي ۋاقتى",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "تۇۋالۇ ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ۋوستوك ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ۋاللىس ۋە فۇتۇنا ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "ئەرەب ئۆلچەملىك ۋاقتى",
               "",
               "ئەرەب يازلىق ۋاقتى",
               "",
               "ئەرەب ۋاقتى",
               "",
            };
        final String[] Armenia = new String[] {
               "ئەرمېنىيە ئۆلچەملىك ۋاقتى",
               "",
               "ئەرمېنىيە يازلىق ۋاقتى",
               "",
               "ئەرمېنىيە ۋاقتى",
               "",
            };
        final String[] Bolivia = new String[] {
               "بولىۋىيە ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "چاتام ئۆلچەملىك ۋاقتى",
               "",
               "چاتام يازلىق ۋاقتى",
               "",
               "چاتام ۋاقتى",
               "",
            };
        final String[] Ecuador = new String[] {
               "ئېكۋادور ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "گامبىيېر ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "گىرۇزىيە ئۆلچەملىك ۋاقتى",
               "",
               "گىرۇزىيە يازلىق ۋاقتى",
               "",
               "گىرۇزىيە ۋاقتى",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ئىركۇتسك ئۆلچەملىك ۋاقتى",
               "",
               "ئىركۇتسك يازلىق ۋاقتى",
               "",
               "ئىركۇتسك ۋاقتى",
               "",
            };
        final String[] Magadan = new String[] {
               "ماگادان ئۆلچەملىك ۋاقتى",
               "",
               "ماگادان يازلىق ۋاقتى",
               "",
               "ماگادان ۋاقتى",
               "",
            };
        final String[] Myanmar = new String[] {
               "بىرما ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "نورفولك ئاراللىرى ئۆلچەملىك ۋاقتى",
               "",
               "نورفولك ئاراللىرى يازلىق ۋاقتى",
               "",
               "نورفولك ئاراللىرى ۋاقتى",
               "",
            };
        final String[] Noronha = new String[] {
               "فېرناندو-نورونخا ئۆلچەملىك ۋاقتى",
               "",
               "فېرناندو-نورونخا يازلىق ۋاقتى",
               "",
               "فېرناندو-نورونخا ۋاقتى",
               "",
            };
        final String[] Reunion = new String[] {
               "رېئونىيون ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "روتېرا ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "سولومون ئاراللىرى ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "توكېلاۋ ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ئۇرۇگۋاي ئۆلچەملىك ۋاقتى",
               "",
               "ئۇرۇگۋاي يازلىق ۋاقتى",
               "",
               "ئۇرۇگۋاي ۋاقتى",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ۋانۇئاتۇ ئۆلچەملىك ۋاقتى",
               "",
               "ۋانۇئاتۇ يازلىق ۋاقتى",
               "",
               "ۋانۇئاتۇ ۋاقتى",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ياكۇتسك ئۆلچەملىك ۋاقتى",
               "",
               "ياكۇتسك يازلىق ۋاقتى",
               "",
               "ياكۇتسك ۋاقتى",
               "",
            };
        final String[] Atlantic = new String[] {
               "ئاتلانتىك ئوكيان ئۆلچەملىك ۋاقتى",
               "AST",
               "ئاتلانتىك ئوكيان يازلىق ۋاقتى",
               "AST",
               "ئاتلانتىك ئوكيان ۋاقتى",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "بىرازىلىيە ئۆلچەملىك ۋاقتى",
               "",
               "بىرازىلىيە يازلىق ۋاقتى",
               "",
               "بىرازىلىيە ۋاقتى",
               "",
            };
        final String[] Chamorro = new String[] {
               "چاموررو ئۆلچەملىك ۋاقتى",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "كولومبىيە ئۆلچەملىك ۋاقتى",
               "",
               "كولومبىيە يازلىق ۋاقتى",
               "",
               "كولومبىيە ۋاقتى",
               "",
            };
        final String[] Falkland = new String[] {
               "فالكلاند ئاراللىرى ئۆلچەملىك ۋاقتى",
               "",
               "فالكلاند ئاراللىرى يازلىق ۋاقتى",
               "",
               "فالكلاند ئاراللىرى ۋاقتى",
               "",
            };
        final String[] Malaysia = new String[] {
               "مالايشىيا ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "مالدىۋې ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ئۇلانباتور ئۆلچەملىك ۋاقتى",
               "",
               "ئۇلانباتور يازلىق ۋاقتى",
               "",
               "ئۇلانباتور ۋاقتى",
               "",
            };
        final String[] Pakistan = new String[] {
               "پاكىستان ئۆلچەملىك ۋاقتى",
               "PKT",
               "پاكىستان يازلىق ۋاقتى",
               "PKST",
               "پاكىستان ۋاقتى",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "پاراگۋاي ئۆلچەملىك ۋاقتى",
               "",
               "پاراگۋاي يازلىق ۋاقتى",
               "",
               "پاراگۋاي ۋاقتى",
               "",
            };
        final String[] Pitcairn = new String[] {
               "پىتكاير ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "ساخارىن ئۆلچەملىك ۋاقتى",
               "",
               "ساخارىن يازلىق ۋاقتى",
               "",
               "ساخارىن ۋاقتى",
               "",
            };
        final String[] Suriname = new String[] {
               "سۇرىنام ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ئارگېنتىنا ئۆلچەملىك ۋاقتى",
               "",
               "ئارگېنتىنا يازلىق ۋاقتى",
               "",
               "ئارگېنتىنا ۋاقتى",
               "",
            };
        final String[] Christmas = new String[] {
               "روژدېستۋو ئارىلى ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "گالاپاگوس ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "شياڭگاڭ ئۆلچەملىك ۋاقتى",
               "HKT",
               "شياڭگاڭ يازلىق ۋاقتى",
               "HKST",
               "شياڭگاڭ ۋاقتى",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ھىندى چىنى ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "پېتروپاۋلوۋسك-كامچاتكسكى ئۆلچەملىك ۋاقتى",
               "",
               "پېتروپاۋلوۋسك-كامچاتكسكى يازلىق ۋاقتى",
               "",
               "پېتروپاۋلوۋسك-كامچاتكسكى ۋاقتى",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "قىرغىزىستان ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "لورد-خاي ئۆلچەملىك ۋاقتى",
               "",
               "لورد-خاي يازلىق ۋاقتى",
               "",
               "لورد-خاي ۋاقتى",
               "",
            };
        final String[] Marquesas = new String[] {
               "ماركىز ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "ماۋرىتىئۇس ئۆلچەملىك ۋاقتى",
               "",
               "ماۋرىتىئۇس يازلىق ۋاقتى",
               "",
               "ماۋرىتىئۇس ۋاقتى",
               "",
            };
        final String[] Singapore = new String[] {
               "سىنگاپور ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ۋېنېزۇئېلا ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "ۋولگاگراد ئۆلچەملىك ۋاقتى",
               "MSK",
               "ۋولگاگراد يازلىق ۋاقتى",
               "MSK",
               "ۋولگاگراد ۋاقتى",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "ئەزەربەيجان ئۆلچەملىك ۋاقتى",
               "",
               "ئەزەربەيجان يازلىق ۋاقتى",
               "",
               "ئەزەربەيجان ۋاقتى",
               "",
            };
        final String[] Bangladesh = new String[] {
               "باڭلادىش ئۆلچەملىك ۋاقتى",
               "",
               "باڭلادىش يازلىق ۋاقتى",
               "",
               "باڭلادىش ۋاقتى",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "يېشىل تۇمشۇق ئۆلچەملىك ۋاقتى",
               "",
               "يېشىل تۇمشۇق يازلىق ۋاقتى",
               "",
               "يېشىل تۇمشۇق ۋاقتى",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "شەرقىي تىمور ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "سېيشېل ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "تاجىكىستان ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ئۆزبېكىستان ئۆلچەملىك ۋاقتى",
               "",
               "ئۆزبېكىستان يازلىق ۋاقتى",
               "",
               "ئۆزبېكىستان ۋاقتى",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ئافغانىستان ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "كىراسنويارسك ئۆلچەملىك ۋاقتى",
               "",
               "كىراسنويارسك يازلىق ۋاقتى",
               "",
               "كىراسنويارسك ۋاقتى",
               "",
            };
        final String[] New_Zealand = new String[] {
               "يېڭى زېلاندىيە ئۆلچەملىك ۋاقتى",
               "NZST",
               "يېڭى زېلاندىيە يازلىق ۋاقتى",
               "NZDT",
               "يېڭى زېلاندىيە ۋاقتى",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "نوۋوسىبىرسك ئۆلچەملىك ۋاقتى",
               "",
               "نوۋوسىبىرسك يازلىق ۋاقتى",
               "",
               "نوۋوسىبىرسك ۋاقتى",
               "",
            };
        final String[] Philippines = new String[] {
               "فىلىپپىن ئۆلچەملىك ۋاقتى",
               "PST",
               "فىلىپپىن يازلىق ۋاقتى",
               "PDT",
               "فىلىپپىن ۋاقتى",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ۋىلادىۋوستوك ئۆلچەملىك ۋاقتى",
               "",
               "ۋىلادىۋوستوك يازلىق ۋاقتى",
               "",
               "ۋىلادىۋوستوك ۋاقتى",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ھىندى ئوكيان ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "لاين ئاراللىرى ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "نىۋفوئۇنلاند ئۆلچەملىك ۋاقتى",
               "NST",
               "نىۋفوئۇنلاند يازلىق ۋاقتى",
               "NDT",
               "نىۋفوئۇنلاند ۋاقتى",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "تۈركمەنىستان ئۆلچەملىك ۋاقتى",
               "",
               "تۈركمەنىستان يازلىق ۋاقتى",
               "",
               "تۈركمەنىستان ۋاقتى",
               "",
            };
        final String[] French_Guiana = new String[] {
               "فىرانسىيەگە قاراشلىق گىۋىيانا ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "يېڭى كالېدونىيە ئۆلچەملىك ۋاقتى",
               "",
               "يېڭى كالېدونىيە يازلىق ۋاقتى",
               "",
               "يېڭى كالېدونىيە ۋاقتى",
               "",
            };
        final String[] South_Georgia = new String[] {
               "جەنۇبىي جورجىيە ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "يېكاتېرىنبۇرگ ئۆلچەملىك ۋاقتى",
               "",
               "يېكاتېرىنبۇرگ يازلىق ۋاقتى",
               "",
               "يېكاتېرىنبۇرگ ۋاقتى",
               "",
            };
        final String[] Africa_Central = new String[] {
               "ئوتتۇرا ئافرىقا ۋاقتى",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "شەرقىي ئافرىقا ۋاقتى",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "غەربىي ئافرىقا ئۆلچەملىك ۋاقتى",
               "WAT",
               "غەربىي ئافرىقا يازلىق ۋاقتى",
               "WAT",
               "غەربىي ئافرىقا ۋاقتى",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "دۇمونت-دۇرۋىل ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "ئوتتۇرا ياۋروپا ئۆلچەملىك ۋاقتى",
               "CET",
               "ئوتتۇرا ياۋروپا يازلىق ۋاقتى",
               "CEST",
               "ئوتتۇرا ياۋروپا ۋاقتى",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "شەرقىي ياۋروپا ئۆلچەملىك ۋاقتى",
               "EET",
               "شەرقىي ياۋروپا يازلىق ۋاقتى",
               "EEST",
               "شەرقىي ياۋروپا ۋاقتى",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "غەربىي ياۋروپا ئۆلچەملىك ۋاقتى",
               "WET",
               "غەربىي ياۋروپا يازلىق ۋاقتى",
               "WEST",
               "غەربىي ياۋروپا ۋاقتى",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "مېكسىكا تىنچ ئوكيان ئۆلچەملىك ۋاقتى",
               "MST",
               "مېكسىكا تىنچ ئوكيان يازلىق ۋاقتى",
               "MDT",
               "مېكسىكا تىنچ ئوكيان ۋاقتى",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "جەنۇبىي ئافرىقا ئۆلچەملىك ۋاقتى",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "ئوتتۇرا قىسىم ئۆلچەملىك ۋاقتى",
               "CST",
               "ئوتتۇرا قىسىم يازلىق ۋاقتى",
               "CDT",
               "ئوتتۇرا قىسىم ۋاقتى",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "شەرقىي قىسىم ئۆلچەملىك ۋاقتى",
               "EST",
               "شەرقىي قىسىم يازلىق ۋاقتى",
               "EST",
               "شەرقىي قىسىم ۋاقتى",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "تىنچ ئوكيان ئۆلچەملىك ۋاقتى",
               "PST",
               "تىنچ ئوكيان يازلىق ۋاقتى",
               "PDT",
               "تىنچ ئوكيان ۋاقتى",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "فىرانسىيەگە قاراشلىق جەنۇبىي ۋە ئانتاركتىكا ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "گىلبېرت ئاراللىرى ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ھاۋاي-ئالېيۇت ئۆلچەملىك ۋاقتى",
               "HST",
               "ھاۋاي-ئالېيۇت يازلىق ۋاقتى",
               "HST",
               "ھاۋاي-ئالېيۇت ۋاقتى",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "فېنىكس ئاراللىرى ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "ساينىت پىئېر ۋە مىكېلون ئۆلچەملىك ۋاقتى",
               "",
               "ساينىت پىئېر ۋە مىكېلون يازلىق ۋاقتى",
               "",
               "ساينىت پىئېر ۋە مىكېلون ۋاقتى",
               "",
            };
        final String[] America_Mountain = new String[] {
               "تاغ ئۆلچەملىك ۋاقتى",
               "MST",
               "تاغ يازلىق ۋاقتى",
               "MST",
               "تاغ ۋاقتى",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "مارشال ئاراللىرى ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "پاپۇئا يېڭى گىۋىنېيەسى ۋاقتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ئاۋسترالىيە ئوتتۇرا قىسىم ئۆلچەملىك ۋاقتى",
               "ACST",
               "ئاۋسترالىيە ئوتتۇرا قىسىم يازلىق ۋاقتى",
               "ACDT",
               "ئاۋسترالىيە ئوتتۇرا قىسىم ۋاقتى",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ئاۋسترالىيە شەرقىي قىسىم ئۆلچەملىك ۋاقتى",
               "AEST",
               "ئاۋسترالىيە شەرقىي قىسىم يازلىق ۋاقتى",
               "AEDT",
               "ئاۋسترالىيە شەرقىي قىسىم ۋاقتى",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ئاۋسترالىيە غەربىي قىسىم ئۆلچەملىك ۋاقتى",
               "AWST",
               "ئاۋسترالىيە غەربىي قىسىم يازلىق ۋاقتى",
               "AWDT",
               "ئاۋسترالىيە غەربىي قىسىم ۋاقتى",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "ئوتتۇرا ھىندونېزىيە ۋاقتى",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "شەرقىي ھىندونېزىيە ۋاقتى",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "غەربىي ھىندونېزىيە ۋاقتى",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ئاۋستىرالىيە ئوتتۇرا غەربىي قىسىم ئۆلچەملىك ۋاقتى",
               "",
               "ئاۋسترالىيە ئوتتۇرا غەربىي قىسىم يازلىق ۋاقتى",
               "",
               "ئاۋسترالىيە ئوتتۇرا غەربىي قىسىم ۋاقتى",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "GB",
                new String[] {
                    "گىرىنۋىچ ۋاقتى",
                    "GMT",
                    "ئەنگلىيە يازلىق ۋاقتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "گىرىنۋىچ ۋاقتى",
                    "GMT",
                    "ئىرېلاند يازلىق ۋاقتى",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "GB-Eire",
                new String[] {
                    "گىرىنۋىچ ۋاقتى",
                    "GMT",
                    "ئەنگلىيە يازلىق ۋاقتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "گىرىنۋىچ ۋاقتى",
                    "GMT",
                    "ئىرېلاند يازلىق ۋاقتى",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "گىرىنۋىچ ۋاقتى",
                    "GMT",
                    "ئەنگلىيە يازلىق ۋاقتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "گىرىنۋىچ ۋاقتى",
                    "GMT",
                    "ئەنگلىيە يازلىق ۋاقتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "گىرىنۋىچ ۋاقتى",
                    "GMT",
                    "ئەنگلىيە يازلىق ۋاقتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "گىرىنۋىچ ۋاقتى",
                    "GMT",
                    "ئەنگلىيە يازلىق ۋاقتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "گىرىنۋىچ ۋاقتى",
                    "GMT",
                    "ئەنگلىيە يازلىق ۋاقتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Saigon", "خوچىمىن شەھىرى" },
            { "timezone.excity.Etc/Unknown", "يوچۇن شەھەر" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Indian/Reunion", "رېئونىيون" },
            { "timezone.excity.Africa/Sao_Tome", "سان-تومې" },
            { "timezone.excity.America/Curacao", "كۇراسو" },
            { "timezone.excity.America/Asuncion", "ئاسۇنسىيون" },
            { "timezone.excity.America/St_Barthelemy", "ساينىت-بارتھېلەمىي" },
            { "timezone.excity.Antarctica/DumontDUrville", "دۇمونت دۇرۋىللې" },
        };
        return data;
    }
}
