/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ku extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "erebî";
        final String metaValue_hy = "ermenî";
        final String metaValue_bn = "bengalî";
        final String metaValue_ka = "gurcî";
        final String metaValue_el = "yûnanî";
        final String metaValue_he = "îbranî";
        final String metaValue_ja = "japonî";
        final String metaValue_km = "ximêrî";
        final String metaValue_kn = "kannadayî";
        final String metaValue_ko = "koreyî";
        final String metaValue_la = "latînî";
        final String metaValue_mn = "moxolî";
        final String metaValue_ta = "tamîlî";
        final String metaValue_th = "tayî";
        final String metaValue_bo = "tîbetî";
        final Object[][] data = new Object[][] {
            { "001", "dinya" },
            { "002", "Afrîka" },
            { "003", "Amerîkaya Bakur" },
            { "005", "Amerîkaya Başûr" },
            { "009", "Okyanûsya" },
            { "011", "Rojavayê Afrîkayê" },
            { "013", "Amerîkaya Navîn" },
            { "014", "Rojhilatê Afrîkayê" },
            { "015", "Bakurê Afrîkayê" },
            { "017", "Afrîkaya Navîn" },
            { "018", "Başûrê Afrîkayê" },
            { "019", "Amerîka" },
            { "021", "Bakurê Amerîkayê" },
            { "029", "Karayîb" },
            { "030", "Rojhilatê Asyayê" },
            { "034", "Başûrê Asyayê" },
            { "035", "Başûrrojhilatê Asyayê" },
            { "039", "Başûrê Ewropayê" },
            { "053", "Awistralasya" },
            { "054", "Melanezya" },
            { "057", "Herêma Mîkronezyayê" },
            { "061", "Polînezya" },
            { "142", "Asya" },
            { "143", "Asyaya Navîn" },
            { "145", "Rojavayê Asyayê" },
            { "150", "Ewropa" },
            { "151", "Rojhilatê Ewropayê" },
            { "154", "Bakurê Ewropayê" },
            { "155", "Rojavayê Ewropayê" },
            { "202", "Afrîkaya Jêra Sahrayê" },
            { "419", "Amerîkaya Latîn" },
            { "AC", "Girava Ascensionê" },
            { "AD", "Andorra" },
            { "AE", "Mîrgehên Erebî yên Yekbûyî" },
            { "AF", "Efxanistan" },
            { "AG", "Antîgua û Berbûda" },
            { "AI", "Anguîla" },
            { "AL", "Albanya" },
            { "AM", "Ermenistan" },
            { "AO", "Angola" },
            { "AQ", "Antarktîka" },
            { "AR", "Arjantîn" },
            { "AS", "Samoaya Amerîkanî" },
            { "AT", "Awistirya" },
            { "AU", "Awistralya" },
            { "AW", "Arûba" },
            { "AX", "Giravên Alandê" },
            { "AZ", "Azerbeycan" },
            { "BA", "Bosna û Hersek" },
            { "BB", "Barbados" },
            { "BD", "Bengladeş" },
            { "BE", "Belçîka" },
            { "BF", "Burkîna Faso" },
            { "BG", "Bulgaristan" },
            { "BH", "Behreyn" },
            { "BI", "Bûrûndî" },
            { "BJ", "Bênîn" },
            { "BL", "Saint Barthelemy" },
            { "BM", "Bermûda" },
            { "BN", "Brûney" },
            { "BO", "Bolîvya" },
            { "BQ", "Holendaya Karayîbê" },
            { "BR", "Brezîlya" },
            { "BS", "Bahama" },
            { "BT", "Bûtan" },
            { "BV", "Girava Bouvetê" },
            { "BW", "Botswana" },
            { "BY", "Belarûs" },
            { "BZ", "Belîze" },
            { "CA", "Kanada" },
            { "CC", "Giravên Kokosê (Keeling)" },
            { "CD", "Kongo - Kînşasa" },
            { "CF", "Komara Afrîkaya Navîn" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Swîsre" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Giravên Cookê" },
            { "CL", "Şîle" },
            { "CM", "Kamerûn" },
            { "CN", "Çîn" },
            { "CO", "Kolombîya" },
            { "CP", "Girava Clippertonê" },
            { "CQ", "Sark" },
            { "CR", "Kosta Rîka" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Curaçao" },
            { "CX", "Girava Christmasê" },
            { "CY", "Qibris" },
            { "CZ", "Çekya" },
            { "DE", "Almanya" },
            { "DG", "Diego Garcia" },
            { "DJ", "Cîbûtî" },
            { "DK", "Danîmarka" },
            { "DM", "Domînîka" },
            { "DO", "Komara Domînîkê" },
            { "DZ", "Cezayîr" },
            { "EA", "Ceuta û Melîla" },
            { "EC", "Ekwador" },
            { "EE", "Estonya" },
            { "EG", "Misir" },
            { "EH", "Sahraya Rojava" },
            { "ER", "Erître" },
            { "ES", "Spanya" },
            { "ET", "Etîyopya" },
            { "EU", "Yekîtîya Ewropayê" },
            { "EZ", "Herêma Ewroyê" },
            { "FI", "Fînlenda" },
            { "FJ", "Fîjî" },
            { "FK", "Giravên Falklandê" },
            { "FM", "Mîkronezya" },
            { "FO", "Giravên Faroeyê" },
            { "FR", "Fransa" },
            { "GA", "Gabon" },
            { "GB", "Qiralîyeta Yekbûyî" },
            { "GD", "Grenada" },
            { "GE", "Gurcistan" },
            { "GF", "Guyanaya Fransî" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Cebelîtariq" },
            { "GL", "Grînlanda" },
            { "GM", "Gambîya" },
            { "GN", "Gîne" },
            { "GP", "Guadeloupe" },
            { "GQ", "Gîneya Ekwadorê" },
            { "GR", "Yûnanistan" },
            { "GS", "Giravên Georgîyaya Başûr û Sandwicha Başûr" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Gîne-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Konga HîT ya Çînê" },
            { "HM", "Giravên Heard û MacDonaldê" },
            { "HN", "Hondûras" },
            { "HR", "Xirwatistan" },
            { "HT", "Haîtî" },
            { "HU", "Macaristan" },
            { "IC", "Giravên Kanaryayê" },
            { "ID", "Endonezya" },
            { "IE", "Îrlanda" },
            { "IL", "Îsraîl" },
            { "IM", "Girava Manê" },
            { "IN", "Hindistan" },
            { "IO", "Herêma Okyanûsa Hindî ya Brîtanyayê" },
            { "IQ", "Îraq" },
            { "IR", "Îran" },
            { "IS", "Îslanda" },
            { "IT", "Îtalya" },
            { "JE", "Jersey" },
            { "JM", "Jamaîka" },
            { "JO", "Urdun" },
            { "JP", "Japonya" },
            { "KE", "Kenya" },
            { "KG", "Qirgizistan" },
            { "KH", "Kamboçya" },
            { "KI", "Kirîbatî" },
            { "KM", "Komor" },
            { "KN", "Saint Kitts û Nevîs" },
            { "KP", "Koreya Bakur" },
            { "KR", "Koreya Başûr" },
            { "KW", "Kuweyt" },
            { "KY", "Giravên Kaymanê" },
            { "KZ", "Qazaxistan" },
            { "LA", "Laos" },
            { "LB", "Libnan" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Srî Lanka" },
            { "LR", "Lîberya" },
            { "LS", "Lesoto" },
            { "LT", "Lîtvanya" },
            { "LU", "Luksembûrg" },
            { "LV", "Letonya" },
            { "LY", "Lîbya" },
            { "MA", "Fas" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Giravên Marşalê" },
            { "MK", "Makendonyaya Bakur" },
            { "ML", "Malî" },
            { "MM", "Myanmar (Bûrma)" },
            { "MN", "Moxolistan" },
            { "MO", "Makaoya Hît ya Çînê" },
            { "MP", "Giravên Bakurê Marianan" },
            { "MQ", "Martînîk" },
            { "MR", "Morîtanya" },
            { "MS", "Montserat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldîva" },
            { "MW", "Malawî" },
            { "MX", "Meksîka" },
            { "MY", "Malezya" },
            { "MZ", "Mozambîk" },
            { "NA", "Namîbya" },
            { "NC", "Kaledonyaya Nû" },
            { "NE", "Nîjer" },
            { "NF", "Girava Norfolkê" },
            { "NG", "Nîjerya" },
            { "NI", "Nîkaragua" },
            { "NL", "Holanda" },
            { "NO", "Norwêc" },
            { "NP", "Nepal" },
            { "NR", "Naûrû" },
            { "NU", "Niûe" },
            { "NZ", "Zelandaya Nû" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Perû" },
            { "PF", "Polînezyaya Fransizî" },
            { "PG", "Papua Gîneya Nû" },
            { "PH", "Fîlîpîn" },
            { "PK", "Pakistan" },
            { "PL", "Polonya" },
            { "PM", "Saint-Pierre û Miquelon" },
            { "PN", "Giravên Pitcairnê" },
            { "PR", "Porto Rîko" },
            { "PS", "Herêmên Filîstînî" },
            { "PT", "Portûgal" },
            { "PW", "Palau" },
            { "PY", "Paragûay" },
            { "QA", "Qeter" },
            { "QO", "Okyanûsyaya Dûr" },
            { "RE", "Réunion" },
            { "RO", "Romanya" },
            { "RS", "Sirbistan" },
            { "RU", "Rûsya" },
            { "RW", "Rwanda" },
            { "SA", "Erebistana Siûdî" },
            { "SB", "Giravên Solomonê" },
            { "SC", "Seyşel" },
            { "SD", "Sûdan" },
            { "SE", "Swêd" },
            { "SG", "Sîngapûr" },
            { "SH", "Saint Helena" },
            { "SI", "Slovenya" },
            { "SJ", "Svalbard û Jan Mayen" },
            { "SK", "Slovakya" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marîno" },
            { "SN", "Senegal" },
            { "SO", "Somalya" },
            { "SR", "Surînam" },
            { "SS", "Sûdana Başûr" },
            { "ST", "Sao Tome û Prînsîpe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Marteen" },
            { "SY", "Sûrîye" },
            { "SZ", "Eswatînî" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Giravên Turks û Kaîkosê" },
            { "TD", "Çad" },
            { "TF", "Herêmên Başûr ên Fransayê" },
            { "TG", "Togo" },
            { "TH", "Tayland" },
            { "TJ", "Tacîkistan" },
            { "TK", "Tokelau" },
            { "TL", "Tîmor-Leste" },
            { "TM", "Tirkmenistan" },
            { "TN", "Tûnis" },
            { "TO", "Tonga" },
            { "TR", "Tirkîye" },
            { "TT", "Trînîdad û Tobago" },
            { "TV", "Tûvalû" },
            { "TW", "Taywan" },
            { "TZ", "Tanzanya" },
            { "UA", "Ûkrayna" },
            { "UG", "Ûganda" },
            { "UM", "Giravên Biçûk ên Derveyî DYAyê" },
            { "UN", "Miletên Yekbûyî" },
            { "US", "Dewletên Yekbûyî yên Amerîkayê" },
            { "UY", "Ûrûguay" },
            { "UZ", "Ozbekistan" },
            { "VA", "Vatîkan" },
            { "VC", "Saint Vincent û Giravên Grenadînê" },
            { "VE", "Venezuela" },
            { "VG", "Giravên Vîrjînê yên Brîtanyayê" },
            { "VI", "Giravên Vîrjînê yên Amerîkayê" },
            { "VN", "Vîetnam" },
            { "VU", "Vanûatû" },
            { "WF", "Wallis û Futuna" },
            { "WS", "Samoa" },
            { "XA", "Aksanên Psodoyê" },
            { "XB", "Psodo Bidî" },
            { "XK", "Kosova" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Afrîkaya Başûr" },
            { "ZM", "Zambîya" },
            { "ZW", "Zîmbabwe" },
            { "ZZ", "Herêma Nenas" },
            { "aa", "afarî" },
            { "ab", "abxazî" },
            { "af", "afrîkansî" },
            { "ak", "akanî" },
            { "am", "amharî" },
            { "an", "aragonî" },
            { "ar", metaValue_ar },
            { "as", "asamî" },
            { "av", "avarî" },
            { "ay", "aymarayî" },
            { "az", "azerî" },
            { "ba", "başkîrî" },
            { "be", "belarûsî" },
            { "bg", "bulgarî" },
            { "bi", "bîslamayî" },
            { "bm", "bambarayî" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretonî" },
            { "bs", "bosnî" },
            { "ca", "katalanî" },
            { "ce", "çeçenî" },
            { "ch", "çamoroyî" },
            { "co", "korsîkayî" },
            { "cs", "çekî" },
            { "cu", "slavîya kenîseyî" },
            { "cv", "çuvaşî" },
            { "cy", "weylsî" },
            { "da", "danmarkî" },
            { "de", "almanî" },
            { "dv", "divehî" },
            { "dz", "conxayî" },
            { "ee", "eweyî" },
            { "el", metaValue_el },
            { "en", "îngilîzî" },
            { "eo", "esperantoyî" },
            { "es", "spanî" },
            { "et", "estonî" },
            { "eu", "baskî" },
            { "fa", "farisî" },
            { "ff", "fulahî" },
            { "fi", "fînî" },
            { "fj", "fîjî" },
            { "fo", "ferî" },
            { "fr", "fransizî" },
            { "fy", "frîsî" },
            { "ga", "îrlendî" },
            { "gd", "gaelîka skotî" },
            { "gl", "galîsî" },
            { "gn", "guwaranî" },
            { "gu", "gujaratî" },
            { "gv", "manksî" },
            { "ha", "hawsayî" },
            { "he", metaValue_he },
            { "hi", "hindî" },
            { "hr", "xirwatî" },
            { "ht", "haîtî" },
            { "hu", "mecarî" },
            { "hy", metaValue_hy },
            { "hz", "hereroyî" },
            { "ia", "înterlîngua" },
            { "id", "endonezyayî" },
            { "ie", "înterlîngue" },
            { "ig", "îgboyî" },
            { "ii", "yîyîya siçuwayî" },
            { "io", "îdoyî" },
            { "is", "îzlendî" },
            { "it", "îtalî" },
            { "iu", "înuîtî" },
            { "ja", metaValue_ja },
            { "jv", "javayî" },
            { "ka", metaValue_ka },
            { "ki", "kîkûyûyî" },
            { "kj", "kwanyamayî" },
            { "kk", "qazaxî" },
            { "kl", "kalalîsûtî" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanurîyî" },
            { "ks", "keşmîrî" },
            { "ku", "kurdî (kurmancî)" },
            { "kv", "komî" },
            { "kw", "kornî" },
            { "ky", "kirgizî" },
            { "la", metaValue_la },
            { "lb", "luksembûrgî" },
            { "lg", "lugandayî" },
            { "li", "lîmbûrgî" },
            { "ln", "lingalayî" },
            { "lo", "lawsî" },
            { "lt", "lîtwanî" },
            { "lu", "luba-katangayî" },
            { "lv", "latvîyayî" },
            { "mg", "malagasî" },
            { "mh", "marşalî" },
            { "mi", "maorî" },
            { "mk", "makedonî" },
            { "ml", "malayalamî" },
            { "mn", metaValue_mn },
            { "mr", "maratî" },
            { "ms", "malezî" },
            { "mt", "maltayî" },
            { "my", "burmayî" },
            { "na", "nawrûyî" },
            { "nb", "norwecî (bokmål)" },
            { "nd", "ndebelîya bakurî" },
            { "ne", "nepalî" },
            { "ng", "ndongayî" },
            { "nl", "holendî" },
            { "nn", "norwecî (nynorsk)" },
            { "no", "norwecî" },
            { "nr", "ndebelîya başûrî" },
            { "nv", "navajoyî" },
            { "ny", "çîçewayî" },
            { "oc", "oksîtanî" },
            { "om", "oromoyî" },
            { "or", "oriyayî" },
            { "os", "osetî" },
            { "pa", "puncabî" },
            { "pl", "polonî" },
            { "ps", "peştûyî" },
            { "pt", "portugalî" },
            { "qu", "keçwayî" },
            { "rm", "romancî" },
            { "rn", "rundî" },
            { "ro", "romanî" },
            { "ru", "rûsî" },
            { "rw", "kînyariwandayî" },
            { "sa", "sanskrîtî" },
            { "sc", "sardînî" },
            { "sd", "sindhî" },
            { "se", "samîya bakur" },
            { "sg", "sangoyî" },
            { "si", "kîngalî" },
            { "sk", "slovakî" },
            { "sl", "slovenî" },
            { "sm", "samoayî" },
            { "sn", "şonayî" },
            { "so", "somalî" },
            { "sq", "arnawidî" },
            { "sr", "sirbî" },
            { "ss", "swazî" },
            { "st", "sotoyîya başûr" },
            { "su", "sundanî" },
            { "sv", "swêdî" },
            { "sw", "swahîlî" },
            { "ta", metaValue_ta },
            { "te", "telûgûyî" },
            { "tg", "tacikî" },
            { "th", metaValue_th },
            { "ti", "tigrînî" },
            { "tk", "tirkmenî" },
            { "tn", "tswanayî" },
            { "to", "tongî" },
            { "tr", "tirkî" },
            { "ts", "tsongayî" },
            { "tt", "teterî" },
            { "ty", "tahîtî" },
            { "ug", "oygurî" },
            { "uk", "ukraynî" },
            { "ur", "urdûyî" },
            { "uz", "ozbekî" },
            { "vi", "vîetnamî" },
            { "vo", "volapûkî" },
            { "wa", "walonî" },
            { "wo", "wolofî" },
            { "xh", "xosayî" },
            { "yi", "yidîşî" },
            { "yo", "yorubayî" },
            { "za", "zhuangî" },
            { "zh", "çînî" },
            { "zu", "zuluyî" },
            { "ace", "açehî" },
            { "ada", "adangmeyî" },
            { "ady", "adîgeyî" },
            { "agq", "aghemî" },
            { "ain", "aynuyî" },
            { "ale", "alêwîtî" },
            { "alt", "altayîya başûrî" },
            { "ann", "obolo" },
            { "anp", "angîkayî" },
            { "apc", "erebîya bakurê şamê" },
            { "arn", "mapuçî" },
            { "arp", "arapahoyî" },
            { "ars", "erebîya necdî" },
            { "asa", "asûyî" },
            { "ast", "astûrî" },
            { "atj", "atîkamekî" },
            { "awa", "awadhî" },
            { "bal", "belûcî" },
            { "ban", "balînî" },
            { "bas", "basayî" },
            { "bem", "bembayî" },
            { "bew", "betawî" },
            { "bez", "benayî" },
            { "bgc", "haryanvîyî" },
            { "bgn", "belucîya rojavayî" },
            { "bho", "bojpûrî" },
            { "bin", "bînîyî" },
            { "bla", "blakfotî" },
            { "blo", "bloyî" },
            { "blt", "tay dam" },
            { "brx", "bodoyî" },
            { "bss", "akooseyî" },
            { "bug", "bugî" },
            { "byn", "blînî" },
            { "cad", "kadoyî" },
            { "cay", "kayugayî" },
            { "cch", "atsamî" },
            { "ccp", "çakmayî" },
            { "ceb", "sebwanoyî" },
            { "cgg", "kîgayî" },
            { "chk", "çûkî" },
            { "chm", "marî" },
            { "cho", "çoktavî" },
            { "chp", "çîpevyayî" },
            { "chr", "çerokî" },
            { "chy", "çeyenî" },
            { "cic", "çîkasawî" },
            { "ckb", "kurdî (soranî)" },
            { "clc", "çilkotînî" },
            { "crg", "mîçîfî" },
            { "crj", "krîya rojhilat ya başûrî" },
            { "crk", "kriya bejayî" },
            { "crl", "krîya rojhilat ya bakurî" },
            { "crm", "krîya mûsî" },
            { "crr", "zimanê karolina algonquianî" },
            { "csw", "krîya swampî" },
            { "dak", "dakotayî" },
            { "dar", "dargînî" },
            { "dav", "tayîtayî" },
            { "dgr", "dogrîbî" },
            { "dje", "zarma" },
            { "doi", "dogrîyî" },
            { "dsb", "sorbîya jêrîn" },
            { "dua", "diwalayî" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazagayî" },
            { "ebu", "embuyî" },
            { "efi", "efîkî" },
            { "eka", "ekajukî" },
            { "ewo", "ewondoyî" },
            { "fil", "fîlîpînoyî" },
            { "fon", "fonî" },
            { "frc", "fransizîya kajûnê" },
            { "frr", "frîsîya bakur" },
            { "fur", "frîyolî" },
            { "gaa", "gayî" },
            { "gez", "geez" },
            { "gil", "kîrîbatî" },
            { "gor", "gorontaloyî" },
            { "gsw", "elmanîşî" },
            { "guz", "gusîî" },
            { "gwi", "gwichʼin" },
            { "hai", "haydayî" },
            { "haw", "hawayî" },
            { "hax", "haîdaya başûrî" },
            { "hil", "hîlîgaynonî" },
            { "hmn", "hmongî" },
            { "hnj", "hmongîya njuayî" },
            { "hsb", "sorbîya jorîn" },
            { "hup", "hupayî" },
            { "hur", "halkomelemî" },
            { "iba", "iban" },
            { "ibb", "îbîbîoyî" },
            { "ikt", "inuvialuktun" },
            { "ilo", "îlokanoyî" },
            { "inh", "îngûşî" },
            { "jbo", "lojbanî" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kaa", "kara-kalpakî" },
            { "kab", "kabîlî" },
            { "kac", "cingphoyî" },
            { "kaj", "jju" },
            { "kam", "kambayî" },
            { "kbd", "kabardî" },
            { "kcg", "tyap" },
            { "kde", "makondeyî" },
            { "kea", "kapverdî" },
            { "ken", "kenyangî" },
            { "kfo", "koro" },
            { "kgp", "kayingangî" },
            { "kha", "khasi" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalencînî" },
            { "kmb", "kîmbunduyî" },
            { "kok", "konkanî" },
            { "kpe", "kpelleyî" },
            { "krc", "karaçay-balkarî" },
            { "krl", "karelî" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafyayî" },
            { "ksh", "rîpwarî" },
            { "kum", "kumikî" },
            { "kwk", "kwak’walayî" },
            { "kxv", "kuvî" },
            { "lad", "ladînoyî" },
            { "lag", "langî" },
            { "lez", "lezgînî" },
            { "lij", "lîgûrî" },
            { "lil", "lillooet" },
            { "lkt", "lakotayî" },
            { "lmo", "lombardî" },
            { "lou", "kreyolîya louisianayê" },
            { "loz", "lozî" },
            { "lrc", "lurîya bakur" },
            { "lsm", "saamia" },
            { "ltg", "latgalî" },
            { "lua", "luba-kasayî" },
            { "lun", "lunda" },
            { "luo", "luoyî" },
            { "lus", "mizoyî" },
            { "luy", "luhyayî" },
            { "mad", "madurayî" },
            { "mag", "magahî" },
            { "mai", "maithili" },
            { "mak", "makasarî" },
            { "mas", "masayî" },
            { "mdf", "mokşayî" },
            { "men", "mende" },
            { "mer", "meruyî" },
            { "mfe", "morisyenî" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "mîkmakî" },
            { "min", "mînangkabawî" },
            { "mni", "manipuri" },
            { "moe", "înûyîya rojhilatî" },
            { "moh", "mohawkî" },
            { "mos", "moreyî" },
            { "mua", "mundangî" },
            { "mul", "pirzimanî" },
            { "mus", "krîkî" },
            { "mwl", "mîrandî" },
            { "myv", "erzayî" },
            { "mzn", "mazenderanî" },
            { "nap", "napolîtanî" },
            { "naq", "namayî" },
            { "nds", "nedersaksî" },
            { "new", "newarî" },
            { "nia", "nîasî" },
            { "niu", "nîwî" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogayî" },
            { "nqo", "n’Ko" },
            { "nso", "sotoyîya bakur" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "ojibweyîya bakurî" },
            { "ojc", "ojibwayîya navîn" },
            { "ojs", "oji-cree" },
            { "ojw", "ojîbweyîya rojavayî" },
            { "oka", "okanagan" },
            { "osa", "osageyî" },
            { "pag", "pangasînanî" },
            { "pam", "kapampanganî" },
            { "pap", "papyamentoyî" },
            { "pau", "palawî" },
            { "pcm", "pîdgînîya nîjeryayî" },
            { "pis", "pijînî" },
            { "pqm", "malecite-passamaquoddy" },
            { "prg", "prûsyayî" },
            { "quc", "k’iche’" },
            { "raj", "rajasthanî" },
            { "rap", "rapanuyî" },
            { "rar", "rarotongî" },
            { "rhg", "rohingyayî" },
            { "rif", "tarifit" },
            { "rof", "rombo" },
            { "rup", "aromanî" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "yakutî" },
            { "saq", "samburuyî" },
            { "sat", "santalî" },
            { "sba", "ngambay" },
            { "sbp", "sanguyî" },
            { "scn", "sicîlî" },
            { "sco", "skotî" },
            { "sdh", "kurdîya başûrî" },
            { "seh", "sena" },
            { "ses", "sonxayî" },
            { "shi", "taşelhîtî" },
            { "shn", "şanî" },
            { "sid", "sîdamo" },
            { "skr", "seraîkî" },
            { "slh", "lushootseeda başûrî" },
            { "sma", "samîya başûr" },
            { "smj", "samiya lule" },
            { "smn", "samîya înarî" },
            { "sms", "samîya skoltî" },
            { "snk", "soninke" },
            { "srn", "sirananî" },
            { "ssy", "sahoyî" },
            { "str", "saanîçî" },
            { "suk", "sukuma" },
            { "swb", "komorî" },
            { "syr", "siryanî" },
            { "szl", "silesî" },
            { "tce", "totuçena başûrî" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "tet", "tetûmî" },
            { "tgx", "tagîşî" },
            { "tht", "tahltan" },
            { "tig", "tigre" },
            { "tlh", "klîngonî" },
            { "tli", "tlingit" },
            { "tok", "toki pona" },
            { "tpi", "tokpisinî" },
            { "trv", "tarokoyî" },
            { "trw", "torwalî" },
            { "ttm", "tutoçenîya bakur" },
            { "tum", "tumbukayî" },
            { "tvl", "tuvalûyî" },
            { "twq", "tasawaq" },
            { "tyv", "tuvanî" },
            { "tzm", "temazîxtî" },
            { "udm", "udmurtî" },
            { "umb", "umbunduyî" },
            { "und", "zimanê nenas" },
            { "vec", "venîsî" },
            { "vmw", "makhuwayî" },
            { "vun", "vunjo" },
            { "wae", "walserî" },
            { "wal", "wolaytta" },
            { "war", "warayî" },
            { "wbp", "warlpiri" },
            { "wuu", "çînîya wuyî" },
            { "xal", "kalmîkî" },
            { "xnr", "kangrî" },
            { "xog", "sogayî" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nhêngatûyî" },
            { "yue", "kantonî" },
            { "zgh", "amazîxîya fasî" },
            { "zun", "zunîyî" },
            { "zxx", "bê naveroka zimanî" },
            { "zza", "zazakî (kirdkî, kirmanckî)" },
            { "Arab", metaValue_ar },
            { "Aran", "nestalîq" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "braille" },
            { "Copt", "qiptî" },
            { "Cprt", "qibrisî" },
            { "Cyrl", "kirîlî" },
            { "Deva", "devanagarî" },
            { "Egyp", "hîyeroglîfên misirî" },
            { "Ethi", "etîyopîk" },
            { "Geor", metaValue_ka },
            { "Goth", "gotîk" },
            { "Grek", metaValue_el },
            { "Gujr", "gujeratî" },
            { "Hanb", "hanîya bi bopomofoyê" },
            { "Hang", "hangulî" },
            { "Hani", "hanî" },
            { "Hans", "sadekirî" },
            { "Hant", "kevneşopî" },
            { "Hebr", metaValue_he },
            { "Hira", "hîraganayî" },
            { "Hrkt", "nivîsên heceyî yên japonî" },
            { "Jamo", "jamoyî" },
            { "Jpan", metaValue_ja },
            { "Kana", "katakanayî" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", "laoyî" },
            { "Latn", metaValue_la },
            { "Mlym", "malayamî" },
            { "Mong", metaValue_mn },
            { "Mymr", "myanmarî" },
            { "Qaag", "zawgyi" },
            { "Sinh", "sînhalayî" },
            { "Taml", metaValue_ta },
            { "Telu", "teluguyî" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Yezi", "êzidî" },
            { "Zmth", "nîşandana matematîkî" },
            { "Zsye", "emojî" },
            { "Zsym", "sembol" },
            { "Zxxx", "nenivîskî" },
            { "Zyyy", "hevpar" },
            { "Zzzz", "alfabeya nenas" },
            { "en_GB", "îngilîzî (Qiralîyeta Yekbûyî)" },
            { "es_ES", "spanî (Ewropa)" },
            { "fa_AF", "derî" },
            { "fr_CA", "fransizî (Kanada)" },
            { "fr_CH", "fransizî (Swîsre)" },
            { "nl_BE", "flamî" },
            { "pt_PT", "portugalî (Ewropa)" },
            { "sw_CD", "swahîlîya kongoyî" },
            { "ar_001", "erebîya modern a standard" },
            { "key.ca", "Salname" },
            { "key.co", "Rêzkirin" },
            { "key.cu", "diwîz" },
            { "zh_Hans", "çînîya sadekirî" },
            { "zh_Hant", "çînîya kevneşopî" },
            { "%%1959ACAD", "Akademîk" },
            { "type.ca.roc", "Salnameya Komara Çînê" },
            { "type.nu.arab", "Reqemên hindo-erebî" },
            { "type.nu.latn", "Reqemên Rojavayî" },
            { "type.ca.dangi", "Salnameya Dangî" },
            { "type.nu.roman", "Reqemên Romayî" },
            { "type.ca.coptic", "Salnameya Qiptî" },
            { "type.ca.hebrew", "salnameya îbranî" },
            { "type.ca.indian", "Salnameya Milî ya Hindî" },
            { "type.ca.chinese", "Salnameya Çînî" },
            { "type.ca.islamic", "Salnameya Hicrî" },
            { "type.ca.iso8601", "Salnameya ISO-8601ê" },
            { "type.ca.persian", "Salnameya Îranî" },
            { "type.ca.buddhist", "Salnameya Budîst" },
            { "type.ca.ethiopic", "Salnameya Etîyopîk" },
            { "type.ca.japanese", "Salnameya Japonî" },
            { "type.co.standard", "Awayê Rêzkirina Standard" },
            { "type.ca.gregorian", "Salnameya Mîladî" },
            { "type.ca.islamic-rgsa", "Salnameya Hicrî (Siudî)" },
            { "type.ca.islamic-tbla", "Salnameya Hicrî (15ê tîrmeha 622yan)" },
            { "type.ca.islamic-civil", "Salnameya Hicrî (16ê tîrmeha 622yan)" },
            { "type.ca.islamic-umalqura", "Salnameya Hicrî (Um el-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Salnameya Amete Alem ya Etîyopîk" },
        };
        return data;
    }
}
