/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ak extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_IQD = "Irak dinaa";
        final Object[][] data = new Object[][] {
            { "GHS", "GH₵" },
            { "IQD", metaValue_IQD },
            { "XOF", "AAS" },
            { "aed", "Ɛmirete Arab Nkabɔmu Deram" },
            { "afn", "Afghanfoɔ Afghani" },
            { "all", "Albania Lek" },
            { "amd", "Amɛnia dram" },
            { "ang", "Nɛdɛlande Antɛlia guuda" },
            { "aoa", "Angola Kwanza" },
            { "ars", "Agɛntina peso" },
            { "aud", "Ɔstrelia Dɔla" },
            { "awg", "Aruba flɔrin" },
            { "azn", "Azɛbagyan manat" },
            { "bam", "Bɔsnia-Hɛzegɔvina nsesa maake" },
            { "bbd", "Babadɔso dɔla" },
            { "bdt", "Bangladehye taka" },
            { "bgn", "Bɔɔgaria lɛv" },
            { "bhd", "Baren Dina" },
            { "bif", "Burundi Frank" },
            { "bmd", "Bɛɛmuda dɔla" },
            { "bnd", "Brunei dɔla" },
            { "bob", "Bolivia boliviano" },
            { "brl", "Brazil reale" },
            { "bsd", "Bahama dɔla" },
            { "btn", "Butanfoɔ ngutrum" },
            { "bwp", "Botswana Pula" },
            { "byn", "Bɛlaruhyia ruble" },
            { "bzd", "Belize Dɔla" },
            { "cad", "Kanada Dɔla" },
            { "cdf", "Kongo Frank" },
            { "chf", "Swiss Franc" },
            { "clp", "Kyili Peso" },
            { "cnh", "kyaena yuan (offshore)" },
            { "cny", "kyaena yuan" },
            { "cop", "Kolombia peso" },
            { "crc", "Kɔsta Rika kɔlɔn" },
            { "cuc", "Kuba nsesa peso" },
            { "cup", "Kuba peso" },
            { "cve", "Ɛskudo" },
            { "czk", "Kyɛk koruna" },
            { "djf", "Gyebuti Frank" },
            { "dkk", "Danefoɔ krone" },
            { "dop", "Dɔmenika peso" },
            { "dzd", "Ɔlgyeria Dina" },
            { "egp", "Egypt Pɔn" },
            { "ern", "Ɛretereya Nakfa" },
            { "etb", "Itiopia Bir" },
            { "eur", "Iro" },
            { "fjd", "Figyi Dɔla" },
            { "fkp", "Fɔkland Aelande Pɔn" },
            { "gbp", "Breten Pɔn" },
            { "gel", "Gyɔɔgyia lari" },
            { "ghc", "Ghana Sidi (1979–2007)" },
            { "ghs", "Ghana Sidi" },
            { "gip", "Gyebrotaa pɔn" },
            { "gmd", "Gambia Dalasi" },
            { "gnf", "Gini franke" },
            { "gns", "Gini Frank" },
            { "gtq", "Guatemala kwɛtsaa" },
            { "gyd", "Gayana dɔla" },
            { "hkd", "Hɔnkɔn Dɔla" },
            { "hnl", "Hɔndura lɛmpira" },
            { "hrk", "Krohyia kuna" },
            { "htg", "Haiti gɔɔde" },
            { "huf", "Hangari fɔrint" },
            { "idr", "Indɔnihyia rupia" },
            { "ils", "Israel hyekel foforɔ" },
            { "inr", "India Rupi" },
            { "iqd", metaValue_IQD },
            { "irr", "Yiranfoɔ rial" },
            { "isk", "Icelandfoɔ Króna" },
            { "jmd", "Gyameka dɔla" },
            { "jod", "Gyɔɔdan dinaa" },
            { "jpy", "Gyapan Yɛn" },
            { "kes", "Kenya Hyelen" },
            { "kgs", "Kagyɛstan som" },
            { "khr", "Kambodia riel" },
            { "kmf", "Komoro Frank" },
            { "kpw", "Korea Atifi won" },
            { "krw", "Korea Anaafoɔ won" },
            { "kwd", "Kuwait dinaa" },
            { "kyd", "Kayemanfo Aelande dɔla" },
            { "kzt", "Kagyastan tenge" },
            { "lak", "Laohyia kip" },
            { "lbp", "Lɛbanon pɔn" },
            { "lkr", "Sri Lankafoɔ rupee" },
            { "lrd", "Laeberia Dɔla" },
            { "lsl", "Lesoto Loti" },
            { "lyd", "Libya Dina" },
            { "mad", "Moroko Diram" },
            { "mdl", "Moldova Leu" },
            { "mga", "Madagasi Frank" },
            { "mkd", "Masidonia denaa" },
            { "mmk", "Mayamaa kyat" },
            { "mnt", "Mongoliafoɔ tugrike" },
            { "mop", "Makaw pataka" },
            { "mro", "Mɔretenia Ouguiya (1973–2017)" },
            { "mru", "Mɔretenia Ouguiya" },
            { "mur", "Mɔrehyeɔs Rupi" },
            { "mvr", "Maldivefoɔ rufiyaa" },
            { "mwk", "Malawi Kwakya" },
            { "mxn", "Mɛksiko pɛso" },
            { "myr", "Malaahyia ringgit" },
            { "mzm", "Mozambik Metical" },
            { "mzn", "Mozambik mɛtikaa" },
            { "nad", "Namibia Dɔla" },
            { "ngn", "Naegyeria Naira" },
            { "nio", "Nikaragua kɔɔdɔba" },
            { "nok", "Nɔɔwee Krone" },
            { "npr", "Nepalfoɔ rupee" },
            { "nzd", "New Zealand Dɔla" },
            { "omr", "Oman rial" },
            { "pab", "Panama baaboa" },
            { "pen", "Pɛruvia sol" },
            { "pgk", "Papua New Gini kina" },
            { "php", "Filipine peso" },
            { "pkr", "Pakistanfoɔ rupee" },
            { "pln", "Pɔlihye zloty" },
            { "pyg", "Paragayana guarani" },
            { "qar", "Kata riyaa" },
            { "ron", "Romania Leu" },
            { "rsd", "Sɛɛbia dinaa" },
            { "rub", "Rɔhyia rubuu" },
            { "rwf", "Rewanda Frank" },
            { "sar", "Saudi Riyal" },
            { "sbd", "Solomon Aeland Dɔla" },
            { "scr", "Seyhyɛls Rupi" },
            { "sdg", "Sudan Dina" },
            { "sdp", "Sudan Pɔn" },
            { "sek", "Sweden Krona" },
            { "sgd", "Singapɔɔ dɔla" },
            { "shp", "St Helena Pɔn" },
            { "sle", "Leone" },
            { "sll", "Leone (1964—2022)" },
            { "sos", "Somailia Hyelen" },
            { "srd", "Suriname dɔla" },
            { "ssp", "Sudan Anaafoɔ Pɔn" },
            { "std", "Sao Tome ne Principe Dobra (1977–2017)" },
            { "stn", "Sao Tome ne Principe Dobra" },
            { "syp", "Siria pɔn" },
            { "szl", "Lilangeni" },
            { "thb", "Tai bat" },
            { "tjs", "Tagyikistan somoni" },
            { "tmt", "Tɛkmɛstan manat" },
            { "tnd", "Tunisia Dina" },
            { "top", "Tonga Paʻanga" },
            { "try", "Tɛki lira" },
            { "ttd", "Trinidad ne Tobago dɔla" },
            { "twd", "Taewanfoɔ dɔla foforɔ" },
            { "tzs", "Tanzania Hyelen" },
            { "uah", "Yukren hryvnia" },
            { "ugx", "Uganda Hyelen" },
            { "usd", "Amɛrika Dɔla" },
            { "uyu", "Yurugueɛ peso" },
            { "uzs", "Yusbɛkistan som" },
            { "ves", "Venezuelan bolívar" },
            { "vnd", "Viɛtnamfoɔ dɔn" },
            { "vuv", "Vanuatu vatu" },
            { "wst", "Samoa Tala" },
            { "xaf", "Afrika Mfinimfini Sefa" },
            { "xcd", "Karibine Apueeɛ dɔla" },
            { "xof", "Afrika Atɔeɛ Sefa" },
            { "xpf", "CFP Franc" },
            { "xxx", "sika a yɛnnim" },
            { "yer", "Yɛmɛn rial" },
            { "zar", "Afrika Anaafo Rand" },
            { "zmk", "Zambia Kwacha (1968–2012)" },
            { "zmw", "Zambia Kwakya" },
            { "zwd", "Zimbabwe Dɔla" },
        };
        return data;
    }
}
