/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jkube.kit.build.api.model.Container;

public class ContainersListElement
implements Container {
    static final String CREATED = "Created";
    static final String ID = "Id";
    static final String IMAGE = "Image";
    static final String IP = "IP";
    static final String LABELS = "Labels";
    static final String PORTS = "Ports";
    static final String PUBLIC_PORT = "PublicPort";
    static final String STATUS = "Status";
    static final String TYPE = "Type";
    private static final String NAMES = "Names";
    private static final String PRIVATE_PORT = "PrivatePort";
    private static final String SLASH = "/";
    private static final String UP = "up";
    private final JsonObject json;

    public ContainersListElement(JsonObject json) {
        this.json = json;
    }

    @Override
    public long getCreated() {
        return this.json.get(CREATED).getAsLong();
    }

    @Override
    public String getId() {
        return this.json.get(ID).getAsString().substring(0, 12);
    }

    @Override
    public String getImage() {
        return this.json.get(IMAGE).getAsString();
    }

    @Override
    public Map<String, String> getLabels() {
        if (!this.json.has(LABELS) || this.json.get(LABELS).isJsonNull()) {
            return Collections.emptyMap();
        }
        return this.mapLabels(this.json.getAsJsonObject(LABELS));
    }

    @Override
    public String getName() {
        if (this.json.has(NAMES)) {
            JsonArray names = this.json.getAsJsonArray(NAMES);
            for (int i = 0; i < names.size(); ++i) {
                String name = names.get(i).getAsString();
                if (name.startsWith(SLASH)) {
                    name = name.substring(1);
                }
                if (name.contains(SLASH)) continue;
                return name;
            }
            throw new IllegalStateException("Unable to determine container name from 'Names' " + names);
        }
        throw new UnsupportedOperationException("Missing 'Names' attribute from a container list element " + this.json);
    }

    @Override
    public String getNetworkMode() {
        return null;
    }

    @Override
    public Map<String, Container.PortBinding> getPortBindings() {
        if (this.json.get(PORTS).isJsonNull()) {
            return Collections.emptyMap();
        }
        return this.mapPortBindings(this.json.getAsJsonArray(PORTS));
    }

    @Override
    public String getIPAddress() {
        return null;
    }

    @Override
    public Map<String, String> getCustomNetworkIpAddresses() {
        return null;
    }

    @Override
    public boolean isRunning() {
        String status = this.json.get(STATUS).getAsString();
        return status.toLowerCase().contains(UP);
    }

    @Override
    public Integer getExitCode() {
        return null;
    }

    private Container.PortBinding createPortBinding(JsonObject object) {
        Container.PortBinding binding = null;
        if (object.has(PUBLIC_PORT) && object.has(IP)) {
            binding = new Container.PortBinding(object.get(PUBLIC_PORT).getAsInt(), object.get(IP).getAsString());
        }
        return binding;
    }

    private String createPortKey(JsonObject object) {
        return String.format("%s/%s", object.get(PRIVATE_PORT).getAsInt(), object.get(TYPE).getAsString());
    }

    private Map<String, String> mapLabels(JsonObject labels) {
        int length = labels.size();
        HashMap<String, String> mapped = new HashMap<String, String>(length);
        for (String key : labels.keySet()) {
            mapped.put(key, labels.get(key).getAsString());
        }
        return mapped;
    }

    private Map<String, Container.PortBinding> mapPortBindings(JsonArray ports) {
        int length = ports.size();
        HashMap<String, Container.PortBinding> portBindings = new HashMap<String, Container.PortBinding>(length);
        for (int i = 0; i < length; ++i) {
            JsonObject object = ports.get(i).getAsJsonObject();
            portBindings.put(this.createPortKey(object), this.createPortBinding(object));
        }
        return portBindings;
    }
}

