/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.auth.handler;

import java.util.Properties;
import java.util.function.UnaryOperator;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthConfig;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthHandler;
import org.eclipse.jkube.kit.common.KitLogger;

public class SystemPropertyRegistryAuthHandler
implements RegistryAuthHandler {
    private final RegistryAuthConfig registryAuthConfig;
    private final KitLogger log;

    public SystemPropertyRegistryAuthHandler(RegistryAuthConfig registryAuthConfig, KitLogger log) {
        this.log = log;
        this.registryAuthConfig = registryAuthConfig;
    }

    @Override
    public String getId() {
        return "sysprops";
    }

    @Override
    public AuthConfig create(RegistryAuthConfig.Kind kind, String user, String registry, UnaryOperator<String> decryptor) {
        Properties props = System.getProperties();
        String username = this.registryAuthConfig.extractFromProperties(props, kind, "username");
        String password = this.registryAuthConfig.extractFromProperties(props, kind, "password");
        if (username == null) {
            return null;
        }
        if (password == null) {
            throw new IllegalArgumentException("No password provided for username " + username);
        }
        this.log.debug("AuthConfig: credentials from system properties", new Object[0]);
        return AuthConfig.builder().username(username).password(AuthConfig.decryptPassword(password, decryptor)).email(this.registryAuthConfig.extractFromProperties(props, kind, "email")).auth(this.registryAuthConfig.extractFromProperties(props, kind, "authToken")).build();
    }
}

