/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundByteDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundFloatDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.CompoundLongDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.InterfaceUtils;
import org.eclipse.january.dataset.LinearAlgebra;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.dataset.SliceNDIterator;
import org.eclipse.january.metadata.Dirtiable;
import org.eclipse.january.metadata.MetadataType;

public class Stats {
    private static QStatisticsImpl<?> calcQuartileStats(Dataset a) {
        Dataset s = null;
        int is = a.getElementsPerItem();
        if (is == 1) {
            s = DatasetUtils.sort(a);
            QStatisticsImpl<Double> qstats = new QStatisticsImpl<Double>();
            qstats.setQuantile(QStatisticsImpl.Q1, Stats.pQuantile(s, QStatisticsImpl.Q1));
            qstats.setQuantile(QStatisticsImpl.Q2, Stats.pQuantile(s, QStatisticsImpl.Q2));
            qstats.setQuantile(QStatisticsImpl.Q3, Stats.pQuantile(s, QStatisticsImpl.Q3));
            qstats.s = new ReferencedDataset(s);
            return qstats;
        }
        QStatisticsImpl<double[]> qstats = new QStatisticsImpl<double[]>();
        Object w = DatasetFactory.zeros(1, a.getClass(), a.getShapeRef());
        double[] q1 = new double[is];
        double[] q2 = new double[is];
        double[] q3 = new double[is];
        qstats.setQuantile(QStatisticsImpl.Q1, q1);
        qstats.setQuantile(QStatisticsImpl.Q2, q2);
        qstats.setQuantile(QStatisticsImpl.Q3, q3);
        int j = 0;
        while (j < is) {
            ((CompoundDataset)a).copyElements((Dataset)w, j);
            w.sort(null);
            q1[j] = Stats.pQuantile(w, QStatisticsImpl.Q1);
            q2[j] = Stats.pQuantile(w, QStatisticsImpl.Q2);
            q3[j] = Stats.pQuantile(w, QStatisticsImpl.Q3);
            if (j == 0) {
                s = w.clone();
            }
            ++j;
        }
        qstats.s = new ReferencedDataset(s);
        return qstats;
    }

    private static QStatisticsImpl<?> getQStatistics(Dataset a) {
        QStatisticsImpl<?> m = a.getFirstMetadata(QStatisticsImpl.class);
        if (m == null || ((QStatisticsImpl)m).isDirty) {
            m = Stats.calcQuartileStats(a);
            a.setMetadata(m);
        }
        return m;
    }

    private static QStatisticsImpl<?> getQStatistics(Dataset a, int axis) {
        int is = a.getElementsPerItem();
        QStatisticsImpl qstats = a.getFirstMetadata(QStatisticsImpl.class);
        if (qstats == null || qstats.isDirty) {
            qstats = is == 1 ? new QStatisticsImpl() : new QStatisticsImpl();
            a.setMetadata(qstats);
        }
        if (qstats.getQuantile(axis, QStatisticsImpl.Q2) == null) {
            if (is == 1) {
                Dataset s = DatasetUtils.sort(a, axis);
                qstats.setQuantile(axis, QStatisticsImpl.Q1, Stats.pQuantile(s, axis, QStatisticsImpl.Q1));
                qstats.setQuantile(axis, QStatisticsImpl.Q2, Stats.pQuantile(s, axis, QStatisticsImpl.Q2));
                qstats.setQuantile(axis, QStatisticsImpl.Q3, Stats.pQuantile(s, axis, QStatisticsImpl.Q3));
                qstats.setSortedDataset(axis, s);
            } else {
                Object w = DatasetFactory.zeros(1, a.getClass(), a.getShapeRef());
                CompoundDoubleDataset q1 = null;
                CompoundDoubleDataset q2 = null;
                CompoundDoubleDataset q3 = null;
                int j = 0;
                while (j < is) {
                    ((CompoundDataset)a).copyElements((Dataset)w, j);
                    w.sort(axis);
                    Dataset c = Stats.pQuantile(w, axis, QStatisticsImpl.Q1);
                    if (j == 0) {
                        q1 = DatasetFactory.zeros(is, CompoundDoubleDataset.class, c.getShapeRef());
                        q2 = DatasetFactory.zeros(is, CompoundDoubleDataset.class, c.getShapeRef());
                        q3 = DatasetFactory.zeros(is, CompoundDoubleDataset.class, c.getShapeRef());
                    }
                    q1.setElements(c, j);
                    q2.setElements(Stats.pQuantile(w, axis, QStatisticsImpl.Q2), j);
                    q3.setElements(Stats.pQuantile(w, axis, QStatisticsImpl.Q3), j);
                    ++j;
                }
                qstats.setQuantile(axis, QStatisticsImpl.Q1, q1);
                qstats.setQuantile(axis, QStatisticsImpl.Q2, q2);
                qstats.setQuantile(axis, QStatisticsImpl.Q3, q3);
            }
        }
        return qstats;
    }

    private static double pQuantile(Dataset s, double q) {
        double f = (double)(s.getSize() - 1) * q;
        if (f < 0.0) {
            return Double.NaN;
        }
        int qpt = (int)Math.floor(f);
        f -= (double)qpt;
        double quantile = s.getElementDoubleAbs(qpt);
        if (f > 0.0) {
            quantile = (1.0 - f) * quantile + f * s.getElementDoubleAbs(qpt + 1);
        }
        return quantile;
    }

    private static Dataset zeros(int is, int[] shape) {
        return is == 1 ? (AbstractDataset)DatasetFactory.zeros(DoubleDataset.class, shape) : (AbstractDataset)DatasetFactory.zeros(is, CompoundDoubleDataset.class, shape);
    }

    private static Dataset pQuantile(Dataset s, int axis, double q) {
        int rank = s.getRank();
        int is = s.getElementsPerItem();
        int[] oshape = s.getShape();
        double f = (double)(oshape[axis] - 1) * q;
        int qpt = (int)Math.floor(f);
        f -= (double)qpt;
        oshape[axis] = 1;
        int[] qshape = ShapeUtils.squeezeShape(oshape, false);
        Dataset qds = Stats.zeros(is, qshape);
        IndexIterator qiter = qds.getIterator(true);
        int[] qpos = qiter.getPos();
        int[] spos = oshape;
        while (qiter.hasNext()) {
            int i = 0;
            while (i < axis) {
                spos[i] = qpos[i];
                ++i;
            }
            spos[i++] = qpt;
            while (i < rank) {
                spos[i] = qpos[i - 1];
                ++i;
            }
            Object obj = s.getObject(spos);
            qds.set(obj, qpos);
        }
        if (f > 0.0) {
            qiter = qds.getIterator(true);
            qpos = qiter.getPos();
            ++qpt;
            Dataset rds = Stats.zeros(is, qshape);
            while (qiter.hasNext()) {
                int i = 0;
                while (i < axis) {
                    spos[i] = qpos[i];
                    ++i;
                }
                spos[i++] = qpt;
                while (i < rank) {
                    spos[i] = qpos[i - 1];
                    ++i;
                }
                Object obj = s.getObject(spos);
                rds.set(obj, qpos);
            }
            rds.imultiply(f);
            qds.imultiply(1.0 - f);
            qds.iadd(rds);
        }
        return qds;
    }

    public static double quantile(Dataset a, double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("Quantile requested is outside [0,1]");
        }
        QStatisticsImpl<?> qs = Stats.getQStatistics(a);
        Double qv = (Double)qs.getQuantile(q);
        if (qv == null) {
            qv = Stats.pQuantile((Dataset)qs.s.get(), q);
            qs.setQuantile(q, qv);
        }
        return qv;
    }

    public static double[] quantile(Dataset a, double ... values) {
        double[] points = new double[values.length];
        QStatisticsImpl<?> qs = Stats.getQStatistics(a);
        int i = 0;
        while (i < points.length) {
            double q = values[i];
            if (q < 0.0 || q > 1.0) {
                throw new IllegalArgumentException("Quantile requested is outside [0,1]");
            }
            Double qv = (Double)qs.getQuantile(q);
            if (qv == null) {
                qv = Stats.pQuantile((Dataset)qs.s.get(), q);
                qs.setQuantile(q, qv);
            }
            points[i] = qv;
            ++i;
        }
        return points;
    }

    public static Dataset[] quantile(Dataset a, int axis, double ... values) {
        Dataset[] points = new Dataset[values.length];
        int is = a.getElementsPerItem();
        axis = a.checkAxis(axis);
        if (is == 1) {
            QStatisticsImpl<?> qs = Stats.getQStatistics(a, axis);
            int i = 0;
            while (i < points.length) {
                double q = values[i];
                if (q < 0.0 || q > 1.0) {
                    throw new IllegalArgumentException("Quantile requested is outside [0,1]");
                }
                Dataset qv = qs.getQuantile(axis, q);
                if (qv == null) {
                    qv = Stats.pQuantile(qs.getSortedDataset(axis), axis, q);
                    qs.setQuantile(axis, q, qv);
                }
                points[i] = qv;
                ++i;
            }
        } else {
            QStatisticsImpl<?> qs = Stats.getQStatistics(a);
            Object w = DatasetFactory.zeros(1, a.getClass(), a.getShapeRef());
            int j = 0;
            while (j < is) {
                boolean copied = false;
                int i = 0;
                while (i < points.length) {
                    double q = values[i];
                    if (q < 0.0 || q > 1.0) {
                        throw new IllegalArgumentException("Quantile requested is outside [0,1]");
                    }
                    Dataset qv = qs.getQuantile(axis, q);
                    if (qv == null) {
                        if (!copied) {
                            copied = true;
                            ((CompoundDataset)a).copyElements((Dataset)w, j);
                            w.sort(axis);
                        }
                        qv = Stats.pQuantile(w, axis, q);
                        qs.setQuantile(axis, q, qv);
                        if (j == 0) {
                            points[i] = DatasetFactory.zeros(is, qv.getClass(), qv.getShapeRef());
                        }
                        ((CompoundDoubleDataset)points[i]).setElements(qv, j);
                    }
                    ++i;
                }
                ++j;
            }
        }
        return points;
    }

    public static Dataset median(Dataset a, int axis) {
        axis = a.checkAxis(axis);
        return Stats.getQStatistics(a, axis).getQuantile(axis, QStatisticsImpl.Q2);
    }

    public static Object median(Dataset a) {
        return Stats.getQStatistics(a).getQuantile(QStatisticsImpl.Q2);
    }

    public static Object iqr(Dataset a) {
        int is = a.getElementsPerItem();
        if (is == 1) {
            QStatisticsImpl<?> qs = Stats.getQStatistics(a);
            return (Double)qs.getQuantile(QStatisticsImpl.Q3) - (Double)qs.getQuantile(QStatisticsImpl.Q1);
        }
        QStatisticsImpl<?> qs = Stats.getQStatistics(a);
        double[] q1 = (double[])qs.getQuantile(QStatisticsImpl.Q1);
        double[] q3 = (double[])((double[])qs.getQuantile(QStatisticsImpl.Q3)).clone();
        int j = 0;
        while (j < is) {
            int n = j;
            q3[n] = q3[n] - q1[j];
            ++j;
        }
        return q3;
    }

    public static Dataset iqr(Dataset a, int axis) {
        axis = a.checkAxis(axis);
        QStatisticsImpl<?> qs = Stats.getQStatistics(a, axis);
        Dataset q3 = qs.getQuantile(axis, QStatisticsImpl.Q3);
        return Maths.subtract(q3, qs.getQuantile(axis, QStatisticsImpl.Q1));
    }

    private static HigherStatisticsImpl<?> getHigherStatistic(Dataset a, boolean[] ignoreInvalids) {
        HigherStatisticsImpl<?> stats;
        boolean ignoreNaNs = false;
        boolean ignoreInfs = false;
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            boolean bl = ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        }
        if ((stats = a.getFirstMetadata(HigherStatisticsImpl.class)) == null || ((HigherStatisticsImpl)stats).isDirty) {
            stats = Stats.calculateHigherMoments(a, ignoreNaNs, ignoreInfs);
            a.setMetadata(stats);
        }
        return stats;
    }

    private static HigherStatisticsImpl<?> getHigherStatistic(Dataset a, boolean[] ignoreInvalids, int axis) {
        HigherStatisticsImpl<?> stats;
        boolean ignoreNaNs = false;
        boolean ignoreInfs = false;
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            boolean bl = ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        }
        if ((stats = a.getFirstMetadata(HigherStatisticsImpl.class)) == null || stats.getSkewness(axis) == null || ((HigherStatisticsImpl)stats).isDirty) {
            stats = Stats.calculateHigherMoments(a, ignoreNaNs, ignoreInfs, axis);
            a.setMetadata(stats);
        }
        return stats;
    }

    /*
     * Unable to fully structure code
     */
    private static HigherStatisticsImpl<?> calculateHigherMoments(Dataset a, boolean ignoreNaNs, boolean ignoreInfs) {
        block12: {
            block10: {
                block11: {
                    is = a.getElementsPerItem();
                    iter = a.getIterator();
                    if (is != 1) break block10;
                    s = new Skewness();
                    k = new Kurtosis();
                    if (!ignoreNaNs) ** GOTO lbl17
                    while (iter.hasNext()) {
                        x = a.getElementDoubleAbs(iter.index);
                        if (Double.isNaN(x)) continue;
                        s.increment(x);
                        k.increment(x);
                    }
                    break block11;
lbl-1000:
                    // 1 sources

                    {
                        x = a.getElementDoubleAbs(iter.index);
                        s.increment(x);
                        k.increment(x);
lbl17:
                        // 2 sources

                        ** while (iter.hasNext())
                    }
                }
                stats = new HigherStatisticsImpl<T>();
                stats.skewness = s.getResult();
                stats.kurtosis = k.getResult();
                return stats;
            }
            s = new Skewness[is];
            k = new Kurtosis[is];
            j = 0;
            while (j < is) {
                s[j] = new Skewness();
                k[j] = new Kurtosis();
                ++j;
            }
            if (!ignoreNaNs) ** GOTO lbl59
            while (iter.hasNext()) {
                skip = false;
                j = 0;
                while (j < is) {
                    if (Double.isNaN(a.getElementDoubleAbs(iter.index + j))) {
                        skip = true;
                        break;
                    }
                    ++j;
                }
                if (skip) continue;
                j = 0;
                while (j < is) {
                    val = a.getElementDoubleAbs(iter.index + j);
                    s[j].increment(val);
                    k[j].increment(val);
                    ++j;
                }
            }
            break block12;
lbl-1000:
            // 1 sources

            {
                j = 0;
                while (j < is) {
                    val = a.getElementDoubleAbs(iter.index + j);
                    s[j].increment(val);
                    k[j].increment(val);
                    ++j;
                }
lbl59:
                // 2 sources

                ** while (iter.hasNext())
            }
        }
        ts = new double[is];
        tk = new double[is];
        j = 0;
        while (j < is) {
            ts[j] = s[j].getResult();
            tk[j] = k[j].getResult();
            ++j;
        }
        stats = new HigherStatisticsImpl<T>();
        stats.skewness = (T)ts;
        stats.kurtosis = (T)tk;
        return stats;
    }

    private static HigherStatisticsImpl<?> calculateHigherMoments(Dataset a, boolean ignoreNaNs, boolean ignoreInfs, int axis) {
        Dataset ku;
        Dataset sk;
        int rank = a.getRank();
        int is = a.getElementsPerItem();
        int[] oshape = a.getShape();
        int alen = oshape[axis];
        oshape[axis] = 1;
        int[] nshape = ShapeUtils.squeezeShape(oshape, false);
        HigherStatisticsImpl stats = null;
        if (is == 1) {
            if (stats == null) {
                stats = new HigherStatisticsImpl();
                a.setMetadata(stats);
            }
            sk = DatasetFactory.zeros(DoubleDataset.class, nshape);
            ku = DatasetFactory.zeros(DoubleDataset.class, nshape);
            IndexIterator qiter = sk.getIterator(true);
            int[] qpos = qiter.getPos();
            int[] spos = oshape;
            while (qiter.hasNext()) {
                double val;
                int j;
                int i = 0;
                while (i < axis) {
                    spos[i] = qpos[i];
                    ++i;
                }
                spos[i++] = 0;
                while (i < rank) {
                    spos[i] = qpos[i - 1];
                    ++i;
                }
                Skewness s = new Skewness();
                Kurtosis k = new Kurtosis();
                if (ignoreNaNs) {
                    j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        val = a.getDouble(spos);
                        if (!Double.isNaN(val)) {
                            s.increment(val);
                            k.increment(val);
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < alen) {
                        spos[axis] = j++;
                        val = a.getDouble(spos);
                        s.increment(val);
                        k.increment(val);
                    }
                }
                sk.set((Object)s.getResult(), qpos);
                ku.set((Object)k.getResult(), qpos);
            }
        } else {
            if (stats == null) {
                stats = new HigherStatisticsImpl();
                a.setMetadata(stats);
            }
            sk = Stats.zeros(is, nshape);
            ku = Stats.zeros(is, nshape);
            IndexIterator qiter = sk.getIterator(true);
            int[] qpos = qiter.getPos();
            int[] spos = oshape;
            Skewness[] s = new Skewness[is];
            Kurtosis[] k = new Kurtosis[is];
            double[] ts = new double[is];
            double[] tk = new double[is];
            int j = 0;
            while (j < is) {
                s[j] = new Skewness();
                k[j] = new Kurtosis();
                ++j;
            }
            while (qiter.hasNext()) {
                int j2;
                int i = 0;
                while (i < axis) {
                    spos[i] = qpos[i];
                    ++i;
                }
                spos[i++] = 0;
                while (i < rank) {
                    spos[i] = qpos[i - 1];
                    ++i;
                }
                int j3 = 0;
                while (j3 < is) {
                    s[j3].clear();
                    k[j3].clear();
                    ++j3;
                }
                int index = a.get1DIndex(spos);
                if (ignoreNaNs) {
                    boolean skip = false;
                    int j4 = 0;
                    while (j4 < is) {
                        if (Double.isNaN(a.getElementDoubleAbs(index + j4))) {
                            skip = true;
                            break;
                        }
                        ++j4;
                    }
                    if (!skip) {
                        j4 = 0;
                        while (j4 < is) {
                            double val = a.getElementDoubleAbs(index + j4);
                            s[j4].increment(val);
                            k[j4].increment(val);
                            ++j4;
                        }
                    }
                } else {
                    j2 = 0;
                    while (j2 < is) {
                        double val = a.getElementDoubleAbs(index + j2);
                        s[j2].increment(val);
                        k[j2].increment(val);
                        ++j2;
                    }
                }
                j2 = 0;
                while (j2 < is) {
                    ts[j2] = s[j2].getResult();
                    tk[j2] = k[j2].getResult();
                    ++j2;
                }
                sk.set((Object)ts, qpos);
                ku.set((Object)tk, qpos);
            }
        }
        stats.setSkewness(axis, sk);
        stats.setKurtosis(axis, ku);
        return stats;
    }

    public static Object skewness(Dataset a, boolean ... ignoreInvalids) {
        return Stats.getHigherStatistic((Dataset)a, (boolean[])ignoreInvalids).skewness;
    }

    public static Object kurtosis(Dataset a, boolean ... ignoreInvalids) {
        return Stats.getHigherStatistic((Dataset)a, (boolean[])ignoreInvalids).kurtosis;
    }

    public static Dataset skewness(Dataset a, int axis, boolean ... ignoreInvalids) {
        axis = a.checkAxis(axis);
        return Stats.getHigherStatistic(a, ignoreInvalids, axis).getSkewness(axis);
    }

    public static Dataset kurtosis(Dataset a, int axis, boolean ... ignoreInvalids) {
        axis = a.checkAxis(axis);
        return Stats.getHigherStatistic(a, ignoreInvalids, axis).getKurtosis(axis);
    }

    public static Object sum(Dataset a, boolean ... ignoreInvalids) {
        return a.sum(ignoreInvalids);
    }

    public static Object typedSum(Class<? extends Dataset> clazz, Dataset a, boolean ... ignoreInvalids) {
        if (a.isComplex()) {
            Complex m = (Complex)a.sum(ignoreInvalids);
            return m;
        }
        if (a instanceof CompoundDataset) {
            return InterfaceUtils.fromDoublesToBiggestPrimitives(clazz, (double[])a.sum(ignoreInvalids));
        }
        return InterfaceUtils.fromDoubleToBiggestNumber(clazz, DTypeUtils.toReal(a.sum(ignoreInvalids)));
    }

    @Deprecated
    public static Object typedSum(Dataset a, int dtype, boolean ... ignoreInvalids) {
        return Stats.typedSum(DTypeUtils.getInterface(dtype), a, ignoreInvalids);
    }

    public static <T extends Dataset> T typedSum(Class<T> clazz, Dataset a, int axis, boolean ... ignoreInvalids) {
        return a.sum(axis, ignoreInvalids).cast(clazz);
    }

    public static <T extends Dataset> T typedSum(Class<T> clazz, Dataset a, int[] axes, boolean ... ignoreInvalids) {
        return a.sum(axes, ignoreInvalids).cast(clazz);
    }

    @Deprecated
    public static Dataset typedSum(Dataset a, int dtype, int axis, boolean ... ignoreInvalids) {
        return DatasetUtils.cast(a.sum(axis, ignoreInvalids), dtype);
    }

    public static Object product(Dataset a, boolean ... ignoreInvalids) {
        return Stats.typedProduct(a.getClass(), a, ignoreInvalids);
    }

    public static Dataset product(Dataset a, int axis, boolean ... ignoreInvalids) {
        return Stats.typedProduct(a.getClass(), a, axis, ignoreInvalids);
    }

    public static Dataset product(Dataset a, int[] axes, boolean ... ignoreInvalids) {
        return Stats.typedProduct(a.getClass(), a, axes, ignoreInvalids);
    }

    @Deprecated
    public static Object typedProduct(Dataset a, int dtype, boolean ... ignoreInvalids) {
        return Stats.typedProduct(DTypeUtils.getInterface(dtype), a, ignoreInvalids);
    }

    public static Object typedProduct(Class<? extends Dataset> clazz, Dataset a, boolean ... ignoreInvalids) {
        boolean ignoreInfs;
        boolean ignoreNaNs;
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        } else {
            ignoreNaNs = false;
            ignoreInfs = false;
        }
        if (a.isComplex()) {
            IndexIterator it = a.getIterator();
            double rv = 1.0;
            double iv = 0.0;
            while (it.hasNext()) {
                double r1 = a.getElementDoubleAbs(it.index);
                double i1 = a.getElementDoubleAbs(it.index + 1);
                if (ignoreNaNs && (Double.isNaN(r1) || Double.isNaN(i1)) || ignoreInfs && (Double.isInfinite(r1) || Double.isInfinite(i1))) continue;
                double tv = r1 * rv - i1 * iv;
                iv = r1 * iv + i1 * rv;
                rv = tv;
                if (Double.isNaN(rv) && Double.isNaN(iv)) break;
            }
            return new Complex(rv, iv);
        }
        IndexIterator it = a.getIterator();
        if (BooleanDataset.class.isAssignableFrom(clazz) || ByteDataset.class.isAssignableFrom(clazz) || ShortDataset.class.isAssignableFrom(clazz) || IntegerDataset.class.isAssignableFrom(clazz) || LongDataset.class.isAssignableFrom(clazz)) {
            long lresult = 1L;
            while (it.hasNext()) {
                lresult *= a.getElementLongAbs(it.index);
            }
            return lresult;
        }
        if (CompoundByteDataset.class.isAssignableFrom(clazz) || ShortDataset.class.isAssignableFrom(clazz) || CompoundIntegerDataset.class.isAssignableFrom(clazz) || CompoundLongDataset.class.isAssignableFrom(clazz)) {
            int is = a.getElementsPerItem();
            long[] lresults = new long[is];
            int j = 0;
            while (j < is) {
                lresults[j] = 1L;
                ++j;
            }
            while (it.hasNext()) {
                j = 0;
                while (j < is) {
                    int n = j;
                    lresults[n] = lresults[n] * a.getElementLongAbs(it.index + j);
                    ++j;
                }
            }
            return lresults;
        }
        if (FloatDataset.class.isAssignableFrom(clazz) || DoubleDataset.class.isAssignableFrom(clazz)) {
            double dresult = 1.0;
            while (it.hasNext()) {
                double x = a.getElementDoubleAbs(it.index);
                if (!(ignoreNaNs && Double.isNaN(x) || ignoreInfs && Double.isInfinite(x)) && Double.isNaN(dresult *= x)) break;
            }
            return dresult;
        }
        if (CompoundFloatDataset.class.isAssignableFrom(clazz) || CompoundDoubleDataset.class.isAssignableFrom(clazz)) {
            int is = a.getElementsPerItem();
            double[] vals = new double[is];
            double[] dresults = new double[is];
            int j = 0;
            while (j < is) {
                dresults[j] = 1.0;
                ++j;
            }
            while (it.hasNext()) {
                double val;
                boolean okay = true;
                int j2 = 0;
                while (j2 < is) {
                    val = a.getElementDoubleAbs(it.index + j2);
                    if (ignoreNaNs && Double.isNaN(val)) {
                        okay = false;
                        break;
                    }
                    if (ignoreInfs && Double.isInfinite(val)) {
                        okay = false;
                        break;
                    }
                    vals[j2] = val;
                    ++j2;
                }
                if (!okay) continue;
                j2 = 0;
                while (j2 < is) {
                    val = vals[j2];
                    int n = j2++;
                    dresults[n] = dresults[n] * val;
                }
            }
            return dresults;
        }
        return null;
    }

    @Deprecated
    public static Dataset typedProduct(Dataset a, int dtype, int[] axes, boolean ... ignoreInvalids) {
        return Stats.typedProduct(DTypeUtils.getInterface(dtype), a, axes, ignoreInvalids);
    }

    @Deprecated
    public static Dataset typedProduct(Dataset a, int dtype, int axis, boolean ... ignoreInvalids) {
        return Stats.typedProduct(DTypeUtils.getInterface(dtype), a, new int[]{axis}, ignoreInvalids);
    }

    public static <T extends Dataset> T typedProduct(Class<T> clazz, Dataset a, int axis, boolean ... ignoreInvalids) {
        return Stats.typedProduct(clazz, a, new int[]{axis}, ignoreInvalids);
    }

    public static <T extends Dataset> T typedProduct(Class<T> clazz, Dataset a, int[] axes, boolean ... ignoreInvalids) {
        boolean ignoreInfs;
        boolean ignoreNaNs;
        axes = ShapeUtils.checkAxes(a.getRank(), axes);
        SliceNDIterator siter = new SliceNDIterator(new SliceND(a.getShapeRef()), axes);
        int[] nshape = siter.getUsedSlice().getSourceShape();
        int is = a.getElementsPerItem();
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        } else {
            ignoreNaNs = false;
            ignoreInfs = false;
        }
        T result = DatasetFactory.zeros(is, clazz, nshape);
        int[] spos = siter.getUsedPos();
        boolean isComplex = a.isComplex();
        while (siter.hasNext()) {
            IndexIterator iter = a.getSliceIterator(siter.getCurrentSlice());
            int[] pos = iter.getPos();
            if (isComplex) {
                double rv = 1.0;
                double iv = 0.0;
                if (a instanceof ComplexFloatDataset) {
                    ComplexFloatDataset af = (ComplexFloatDataset)a;
                    while (iter.hasNext()) {
                        float r1 = af.getReal(pos);
                        float i1 = af.getImag(pos);
                        if (ignoreNaNs && (Float.isNaN(r1) || Float.isNaN(i1)) || ignoreInfs && (Float.isInfinite(r1) || Float.isInfinite(i1))) continue;
                        double tv = (double)r1 * rv - (double)i1 * iv;
                        iv = (double)r1 * iv + (double)i1 * rv;
                        rv = tv;
                        if (!Double.isNaN(rv) || !Double.isNaN(iv)) {
                            continue;
                        }
                        break;
                    }
                } else if (a instanceof ComplexDoubleDataset) {
                    ComplexDoubleDataset ad = (ComplexDoubleDataset)a;
                    while (iter.hasNext()) {
                        double r1 = ad.getReal(pos);
                        double i1 = ad.getImag(pos);
                        if (ignoreNaNs && (Double.isNaN(r1) || Double.isNaN(i1)) || ignoreInfs && (Double.isInfinite(r1) || Double.isInfinite(i1))) continue;
                        double tv = r1 * rv - i1 * iv;
                        iv = r1 * iv + i1 * rv;
                        rv = tv;
                        if (!Double.isNaN(rv) || !Double.isNaN(iv)) {
                            continue;
                        }
                        break;
                    }
                }
                result.set(new Complex(rv, iv), spos);
                continue;
            }
            if (a instanceof BooleanDataset || a instanceof ByteDataset || a instanceof ShortDataset || a instanceof IntegerDataset || a instanceof LongDataset) {
                long lresult = 1L;
                while (iter.hasNext()) {
                    lresult *= a.getLong(pos);
                }
                result.set(lresult, spos);
                continue;
            }
            if (a instanceof CompoundByteDataset || a instanceof CompoundShortDataset || a instanceof CompoundIntegerDataset || a instanceof CompoundLongDataset) {
                CompoundDataset ca = (CompoundDataset)a;
                long[] lresults = new long[is];
                int k = 0;
                while (k < is) {
                    lresults[k] = 1L;
                    ++k;
                }
                while (iter.hasNext()) {
                    int l = iter.index;
                    int k2 = 0;
                    while (k2 < is) {
                        int n = k2++;
                        lresults[n] = lresults[n] * ca.getElementLongAbs(l++);
                    }
                }
                result.set(lresults, spos);
                continue;
            }
            if (a instanceof FloatDataset || a instanceof DoubleDataset) {
                double dresult = 1.0;
                while (iter.hasNext()) {
                    double x = a.getElementDoubleAbs(iter.index);
                    if (!(ignoreNaNs && Double.isNaN(x) || ignoreInfs && Double.isInfinite(x)) && Double.isNaN(dresult *= x)) break;
                }
                result.set(dresult, spos);
                continue;
            }
            if (!(a instanceof CompoundFloatDataset) && !(a instanceof CompoundDoubleDataset)) continue;
            CompoundDataset da = (CompoundDataset)a;
            double[] dvalues = new double[is];
            double[] dresults = new double[is];
            int k = 0;
            while (k < is) {
                dresults[k] = 1.0;
                ++k;
            }
            while (iter.hasNext()) {
                da.getDoubleArrayAbs(iter.index, dvalues);
                boolean okay = true;
                int k3 = 0;
                while (k3 < is) {
                    double val = dvalues[k3];
                    if (ignoreNaNs && Double.isNaN(val)) {
                        okay = false;
                        break;
                    }
                    if (ignoreInfs && Double.isInfinite(val)) {
                        okay = false;
                        break;
                    }
                    ++k3;
                }
                if (!okay) continue;
                k3 = 0;
                while (k3 < is) {
                    int n = k3;
                    dresults[n] = dresults[n] * dvalues[k3];
                    ++k3;
                }
            }
            result.set(dresults, spos);
        }
        return result;
    }

    public static Dataset cumulativeProduct(Dataset a, boolean ... ignoreInvalids) {
        return Stats.cumulativeProduct(a.flatten(), 0, ignoreInvalids);
    }

    public static Dataset cumulativeProduct(Dataset a, int axis, boolean ... ignoreInvalids) {
        boolean ignoreInfs;
        boolean ignoreNaNs;
        axis = a.checkAxis(axis);
        int[] oshape = a.getShape();
        int alen = oshape[axis];
        oshape[axis] = 1;
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        } else {
            ignoreNaNs = false;
            ignoreInfs = false;
        }
        Dataset result = DatasetFactory.zeros(a);
        PositionIterator pi = result.getPositionIterator(axis);
        int[] pos = pi.getPos();
        while (pi.hasNext()) {
            block37: {
                block31: {
                    double iv;
                    double rv;
                    block32: {
                        if (!a.isComplex()) break block31;
                        rv = 1.0;
                        iv = 0.0;
                        if (!(a instanceof ComplexFloatDataset)) break block32;
                        ComplexFloatDataset af = (ComplexFloatDataset)a;
                        ComplexFloatDataset rf = (ComplexFloatDataset)result;
                        int j = 0;
                        while (j < alen) {
                            block34: {
                                block33: {
                                    if (Double.isNaN(rv) && Double.isNaN(iv)) break block33;
                                    pos[axis] = j;
                                    float r1 = af.getReal(pos);
                                    float i1 = af.getImag(pos);
                                    if (ignoreNaNs && (Float.isNaN(r1) || Float.isNaN(i1)) || ignoreInfs && (Float.isInfinite(r1) || Float.isInfinite(i1))) break block34;
                                    double tv = (double)r1 * rv - (double)i1 * iv;
                                    iv = (double)r1 * iv + (double)i1 * rv;
                                    rv = tv;
                                }
                                rf.set((float)rv, (float)iv, pos);
                            }
                            ++j;
                        }
                        continue;
                    }
                    if (!(a instanceof ComplexDoubleDataset)) continue;
                    ComplexDoubleDataset ad = (ComplexDoubleDataset)a;
                    ComplexDoubleDataset rd = (ComplexDoubleDataset)result;
                    int j = 0;
                    while (j < alen) {
                        block36: {
                            block35: {
                                if (Double.isNaN(rv) && Double.isNaN(iv)) break block35;
                                pos[axis] = j;
                                double r1 = ad.getReal(pos);
                                double i1 = ad.getImag(pos);
                                if (ignoreNaNs && (Double.isNaN(r1) || Double.isNaN(i1)) || ignoreInfs && (Double.isInfinite(r1) || Double.isInfinite(i1))) break block36;
                                double tv = r1 * rv - i1 * iv;
                                iv = r1 * iv + i1 * rv;
                                rv = tv;
                            }
                            rd.set(rv, iv, pos);
                        }
                        ++j;
                    }
                    continue;
                }
                if (a instanceof BooleanDataset || a instanceof ByteDataset || a instanceof ShortDataset || a instanceof IntegerDataset) {
                    long lresult = 1L;
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j++;
                        result.set((Object)(lresult *= a.getLong(pos)), pos);
                    }
                    continue;
                }
                if (a instanceof CompoundByteDataset || a instanceof CompoundShortDataset || a instanceof CompoundIntegerDataset || a instanceof CompoundLongDataset) {
                    int is = a.getElementsPerItem();
                    CompoundDataset ca = (CompoundDataset)a;
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        int l = a.get1DIndex(pos);
                        int k2 = 0;
                        while (k2 < is) {
                            int n = k2++;
                            lresults[n] = lresults[n] * ca.getElementLongAbs(l++);
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue;
                }
                if (!(a instanceof FloatDataset) && !(a instanceof DoubleDataset)) break block37;
                double dresult = 1.0;
                int j = 0;
                while (j < alen) {
                    block39: {
                        block38: {
                            if (Double.isNaN(dresult)) break block38;
                            pos[axis] = j;
                            double x = a.getDouble(pos);
                            if (ignoreNaNs && Double.isNaN(x) || ignoreInfs && Double.isInfinite(x)) break block39;
                            dresult *= x;
                        }
                        result.set((Object)dresult, pos);
                    }
                    ++j;
                }
                continue;
            }
            if (!(a instanceof CompoundFloatDataset) && !(a instanceof CompoundDoubleDataset)) continue;
            int is = a.getElementsPerItem();
            CompoundDataset da = (CompoundDataset)a;
            double[] dvalues = new double[is];
            double[] dresults = new double[is];
            int k = 0;
            while (k < is) {
                dresults[k] = 1.0;
                ++k;
            }
            int j = 0;
            while (j < alen) {
                pos[axis] = j;
                da.getDoubleArray(dvalues, pos);
                boolean okay = true;
                int k3 = 0;
                while (k3 < is) {
                    double val = dvalues[k3];
                    if (ignoreNaNs && Double.isNaN(val)) {
                        okay = false;
                        break;
                    }
                    if (ignoreInfs && Double.isInfinite(val)) {
                        okay = false;
                        break;
                    }
                    ++k3;
                }
                if (okay) {
                    k3 = 0;
                    while (k3 < is) {
                        int n = k3;
                        dresults[n] = dresults[n] * dvalues[k3];
                        ++k3;
                    }
                }
                result.set((Object)dresults, pos);
                ++j;
            }
        }
        return result;
    }

    public static Dataset cumulativeSum(Dataset a, boolean ... ignoreInvalids) {
        return Stats.cumulativeSum(a.flatten(), 0, ignoreInvalids);
    }

    public static Dataset cumulativeSum(Dataset a, int axis, boolean ... ignoreInvalids) {
        boolean ignoreInfs;
        boolean ignoreNaNs;
        axis = a.checkAxis(axis);
        int[] oshape = a.getShape();
        int alen = oshape[axis];
        oshape[axis] = 1;
        if (a.hasFloatingPointElements()) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        } else {
            ignoreNaNs = false;
            ignoreInfs = false;
        }
        Dataset result = DatasetFactory.zeros(a);
        PositionIterator pi = result.getPositionIterator(axis);
        int[] pos = pi.getPos();
        while (pi.hasNext()) {
            block44: {
                Object[] va;
                long[] lresults;
                block38: {
                    double iv;
                    double rv;
                    block39: {
                        if (!a.isComplex()) break block38;
                        rv = 0.0;
                        iv = 0.0;
                        if (!(a instanceof ComplexFloatDataset)) break block39;
                        ComplexFloatDataset af = (ComplexFloatDataset)a;
                        ComplexFloatDataset rf = (ComplexFloatDataset)result;
                        int j = 0;
                        while (j < alen) {
                            block41: {
                                block40: {
                                    if (Double.isNaN(rv) && Double.isNaN(iv)) break block40;
                                    pos[axis] = j;
                                    float r1 = af.getReal(pos);
                                    float i1 = af.getImag(pos);
                                    if (ignoreNaNs && (Float.isNaN(r1) || Float.isNaN(i1)) || ignoreInfs && (Float.isInfinite(r1) || Float.isInfinite(i1))) break block41;
                                    rv += (double)r1;
                                    iv += (double)i1;
                                }
                                rf.set((float)rv, (float)iv, pos);
                            }
                            ++j;
                        }
                        continue;
                    }
                    if (!(a instanceof ComplexDoubleDataset)) continue;
                    ComplexDoubleDataset ad = (ComplexDoubleDataset)a;
                    ComplexDoubleDataset rd = (ComplexDoubleDataset)result;
                    int j = 0;
                    while (j < alen) {
                        block43: {
                            block42: {
                                if (Double.isNaN(rv) && Double.isNaN(iv)) break block42;
                                pos[axis] = j;
                                double r1 = ad.getReal(pos);
                                double i1 = ad.getImag(pos);
                                if (ignoreNaNs && (Double.isNaN(r1) || Double.isNaN(i1)) || ignoreInfs && (Double.isInfinite(r1) || Double.isInfinite(i1))) break block43;
                                rv += r1;
                                iv += i1;
                            }
                            rd.set(rv, iv, pos);
                        }
                        ++j;
                    }
                    continue;
                }
                if (a instanceof BooleanDataset || a instanceof ByteDataset || a instanceof ShortDataset || a instanceof IntegerDataset || a instanceof LongDataset) {
                    long lresult = 0L;
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j++;
                        result.set((Object)(lresult += a.getLong(pos)), pos);
                    }
                    continue;
                }
                if (a instanceof CompoundByteDataset) {
                    int is = a.getElementsPerItem();
                    lresults = new long[is];
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (byte[])a.getObject(pos);
                        int k = 0;
                        while (k < is) {
                            int n = k;
                            lresults[n] = lresults[n] + (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue;
                }
                if (a instanceof CompoundShortDataset) {
                    int is = a.getElementsPerItem();
                    lresults = new long[is];
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (short[])a.getObject(pos);
                        int k = 0;
                        while (k < is) {
                            int n = k;
                            lresults[n] = lresults[n] + (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue;
                }
                if (a instanceof CompoundIntegerDataset) {
                    int is = a.getElementsPerItem();
                    lresults = new long[is];
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (int[])a.getObject(pos);
                        int k = 0;
                        while (k < is) {
                            int n = k;
                            lresults[n] = lresults[n] + (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue;
                }
                if (a instanceof CompoundLongDataset) {
                    int is = a.getElementsPerItem();
                    lresults = new long[is];
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        va = (long[])a.getObject(pos);
                        int k = 0;
                        while (k < is) {
                            int n = k;
                            lresults[n] = lresults[n] + va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue;
                }
                if (!(a instanceof FloatDataset) && !(a instanceof DoubleDataset)) break block44;
                double dresult = 0.0;
                int j = 0;
                while (j < alen) {
                    block46: {
                        block45: {
                            if (Double.isNaN(dresult)) break block45;
                            pos[axis] = j;
                            double x = a.getDouble(pos);
                            if (ignoreNaNs && Double.isNaN(x) || ignoreInfs && Double.isInfinite(x)) break block46;
                            dresult += x;
                        }
                        result.set((Object)dresult, pos);
                    }
                    ++j;
                }
                continue;
            }
            if (!(a instanceof CompoundFloatDataset) && !(a instanceof CompoundDoubleDataset)) continue;
            int is = a.getElementsPerItem();
            CompoundDataset da = (CompoundDataset)a;
            double[] dvalues = new double[is];
            double[] dresults = new double[is];
            int j = 0;
            while (j < alen) {
                pos[axis] = j;
                da.getDoubleArray(dvalues, pos);
                boolean okay = true;
                int k = 0;
                while (k < is) {
                    double val = dvalues[k];
                    if (ignoreNaNs && Double.isNaN(val)) {
                        okay = false;
                        break;
                    }
                    if (ignoreInfs && Double.isInfinite(val)) {
                        okay = false;
                        break;
                    }
                    ++k;
                }
                if (okay) {
                    k = 0;
                    while (k < is) {
                        int n = k;
                        dresults[n] = dresults[n] + dvalues[k];
                        ++k;
                    }
                }
                result.set((Object)dresults, pos);
                ++j;
            }
        }
        return result;
    }

    public static Object averageDeviation(Dataset a) {
        IndexIterator it = a.getIterator();
        int is = a.getElementsPerItem();
        if (is == 1) {
            double mean = (Double)a.mean(new boolean[0]);
            double sum = 0.0;
            while (it.hasNext()) {
                sum += Math.abs(a.getElementDoubleAbs(it.index) - mean);
            }
            return sum / (double)a.getSize();
        }
        double[] means = (double[])a.mean(new boolean[0]);
        double[] sums = new double[is];
        while (it.hasNext()) {
            int j = 0;
            while (j < is) {
                int n = j;
                sums[n] = sums[n] + Math.abs(a.getElementDoubleAbs(it.index + j) - means[j]);
                ++j;
            }
        }
        double n = a.getSize();
        int j = 0;
        while (j < is) {
            int n2 = j++;
            sums[n2] = sums[n2] / n;
        }
        return sums;
    }

    public static double residual(Dataset a, Dataset b) {
        return a.residual(b);
    }

    public static double weightedResidual(Dataset a, Dataset b, Dataset w) {
        return a.residual(b, w, false);
    }

    public static double[] outlierValues(Dataset a, double lo, double hi, int length) {
        return Stats.outlierValues(a, null, true, lo, hi, length);
    }

    public static double[] outlierValues(Dataset a, Dataset mask, boolean value, double lo, double hi, int length) {
        if (lo <= 0.0 || hi <= 0.0 || lo >= hi || hi >= 100.0 || Double.isNaN(lo) || Double.isNaN(hi)) {
            throw new IllegalArgumentException("Thresholds must be between (0,100) and in order");
        }
        int size = a.getSize();
        int nl = Math.max((int)(lo * (double)size / 100.0), 1);
        if (length > 0 && nl > length) {
            nl = length;
        }
        int nh = Math.max((int)((100.0 - hi) * (double)size / 100.0), 1);
        if (length > 0 && nh > length) {
            nh = length;
        }
        IndexIterator it = mask == null ? a.getIterator() : a.getBooleanIterator(mask, value);
        double[] results = Math.max(nl, nh) > 640 ? Stats.outlierValuesMap(a, it, nl, nh) : Stats.outlierValuesList(a, it, nl, nh);
        results[2] = results[2] * 100.0 / (double)size;
        results[3] = 100.0 - results[3] * 100.0 / (double)size;
        return results;
    }

    static double[] outlierValuesMap(Dataset a, IndexIterator it, int nl, int nh) {
        double hx;
        TreeMap<Double, Integer> lMap = new TreeMap<Double, Integer>();
        TreeMap<Double, Integer> hMap = new TreeMap<Double, Integer>();
        int ml = 0;
        int mh = 0;
        while (it.hasNext()) {
            Integer i;
            Double k;
            Double x = a.getElementDoubleAbs(it.index);
            if (Double.isNaN(x)) continue;
            if (ml == nl) {
                k = (Double)lMap.lastKey();
                if (x < k) {
                    i = (Integer)lMap.get(k) - 1;
                    if (i == 0) {
                        lMap.remove(k);
                    } else {
                        lMap.put(k, i);
                    }
                    i = (Integer)lMap.get(x);
                    if (i == null) {
                        lMap.put(x, 1);
                    } else {
                        lMap.put(x, i + 1);
                    }
                }
            } else {
                i = (Integer)lMap.get(x);
                if (i == null) {
                    lMap.put(x, 1);
                } else {
                    lMap.put(x, i + 1);
                }
                ++ml;
            }
            if (mh == nh) {
                k = (Double)hMap.firstKey();
                if (!(x > k)) continue;
                i = (Integer)hMap.get(k) - 1;
                if (i == 0) {
                    hMap.remove(k);
                } else {
                    hMap.put(k, i);
                }
                i = (Integer)hMap.get(x);
                if (i == null) {
                    hMap.put(x, 1);
                    continue;
                }
                hMap.put(x, i + 1);
                continue;
            }
            i = (Integer)hMap.get(x);
            if (i == null) {
                hMap.put(x, 1);
            } else {
                hMap.put(x, i + 1);
            }
            ++mh;
        }
        double lx = (Double)lMap.lastKey();
        if (lx >= (hx = ((Double)hMap.firstKey()).doubleValue())) {
            Double h = hMap.higherKey(lx);
            if (h != null) {
                hx = h;
                --mh;
            } else {
                Double l = lMap.lowerKey(hx);
                if (l != null) {
                    lx = l;
                    --ml;
                }
            }
        }
        return new double[]{(Double)lMap.lastKey(), (Double)hMap.firstKey(), ml, mh};
    }

    static double[] outlierValuesList(Dataset a, IndexIterator it, int nl, int nh) {
        ArrayList<Double> lList = new ArrayList<Double>(nl);
        ArrayList<Double> hList = new ArrayList<Double>(nh);
        double lx = Double.POSITIVE_INFINITY;
        double hx = Double.NEGATIVE_INFINITY;
        while (it.hasNext()) {
            double x = a.getElementDoubleAbs(it.index);
            if (Double.isNaN(x)) continue;
            if (x < lx) {
                if (lList.size() == nl) {
                    lList.remove(lx);
                }
                lList.add(x);
                lx = (Double)Collections.max(lList);
            } else if (x == lx && lList.size() < nl) {
                lList.add(x);
            }
            if (x > hx) {
                if (hList.size() == nh) {
                    hList.remove(hx);
                }
                hList.add(x);
                hx = (Double)Collections.min(hList);
                continue;
            }
            if (x != hx || hList.size() >= nh) continue;
            hList.add(x);
        }
        nl = lList.size();
        nh = hList.size();
        if (lx >= hx) {
            Collections.sort(hList);
            Iterator iterator = hList.iterator();
            while (iterator.hasNext()) {
                double h = (Double)iterator.next();
                if (h > hx) {
                    hx = h;
                    break;
                }
                --nh;
            }
            if (lx >= hx) {
                Collections.sort(lList);
                Collections.reverse(lList);
                iterator = lList.iterator();
                while (iterator.hasNext()) {
                    double l = (Double)iterator.next();
                    if (l < lx) {
                        lx = l;
                        break;
                    }
                    --nl;
                }
            }
        }
        return new double[]{lx, hx, nl, nh};
    }

    public static Dataset covariance(Dataset a) {
        return Stats.covariance(a, true, false, null);
    }

    public static Dataset covariance(Dataset a, boolean rowvar, boolean bias, Integer ddof) {
        return Stats.covariance(a, null, rowvar, bias, ddof);
    }

    public static Dataset covariance(Dataset a, Dataset b) {
        return Stats.covariance(a, b, true, false, null);
    }

    public static Dataset covariance(Dataset a, Dataset b, boolean rowvar, boolean bias, Integer ddof) {
        double norm_fact;
        int axis;
        int nr;
        Dataset vars = a.clone();
        if (a.getRank() == 1) {
            vars.setShape(1, a.getShapeRef()[0]);
        }
        if (vars.getShapeRef()[0] == 1) {
            rowvar = true;
        }
        if (rowvar) {
            nr = vars.getShapeRef()[1];
            axis = 0;
        } else {
            nr = vars.getShapeRef()[0];
            axis = 1;
        }
        if (ddof == null) {
            ddof = !bias ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        if ((norm_fact = (double)(nr - ddof)) <= 0.0) {
            norm_fact = 0.0;
        }
        if (b != null) {
            Dataset extraVars = b.clone();
            if (b.getRank() == 1) {
                extraVars.setShape(1, a.getShapeRef()[0]);
            }
            vars = DatasetUtils.concatenate(new Dataset[]{vars, extraVars}, axis);
        }
        Dataset varsMean = vars.mean(1 - axis, false);
        int[] meanShape = vars.getShape();
        meanShape[1 - axis] = 1;
        varsMean.setShape(meanShape);
        vars.isubtract(varsMean);
        Dataset cov = rowvar ? Maths.divide(LinearAlgebra.dotProduct(vars, Maths.conjugate(vars.transpose(new int[0]))), norm_fact).squeeze() : Maths.divide(LinearAlgebra.dotProduct(vars.transpose(new int[0]), Maths.conjugate(vars)), norm_fact).squeeze();
        return cov;
    }

    private static class HigherStatisticsImpl<T>
    implements MetadataType {
        private static final long serialVersionUID = -6587974784104116792L;
        T skewness;
        T kurtosis;
        transient Map<Integer, ReferencedDataset> smap = new HashMap<Integer, ReferencedDataset>();
        transient Map<Integer, ReferencedDataset> kmap = new HashMap<Integer, ReferencedDataset>();
        @Dirtiable
        private boolean isDirty = true;

        @Override
        public HigherStatisticsImpl<T> clone() {
            return new HigherStatisticsImpl<T>(this);
        }

        public HigherStatisticsImpl() {
        }

        private HigherStatisticsImpl(HigherStatisticsImpl<T> hstats) {
            this.skewness = hstats.skewness;
            this.kurtosis = hstats.kurtosis;
            this.smap.putAll(hstats.smap);
            this.kmap.putAll(hstats.kmap);
            this.isDirty = hstats.isDirty;
        }

        public Dataset getSkewness(int axis) {
            ReferencedDataset rd = this.smap.get(axis);
            return rd == null ? null : (Dataset)rd.get();
        }

        public Dataset getKurtosis(int axis) {
            ReferencedDataset rd = this.kmap.get(axis);
            return rd == null ? null : (Dataset)rd.get();
        }

        public void setSkewness(int axis, Dataset s) {
            this.smap.put(axis, new ReferencedDataset(s));
        }

        public void setKurtosis(int axis, Dataset k) {
            this.kmap.put(axis, new ReferencedDataset(k));
        }
    }

    private static class QStatisticsImpl<T>
    implements MetadataType {
        private static final long serialVersionUID = -3296671666463190388L;
        static final Double Q1 = 0.25;
        static final Double Q2 = 0.5;
        static final Double Q3 = 0.75;
        Map<Double, T> qmap = new HashMap<Double, T>();
        transient Map<Integer, Map<Double, ReferencedDataset>> aqmap = new HashMap<Integer, Map<Double, ReferencedDataset>>();
        transient ReferencedDataset s;
        transient Map<Integer, ReferencedDataset> smap = new HashMap<Integer, ReferencedDataset>();
        @Dirtiable
        private boolean isDirty = true;

        @Override
        public QStatisticsImpl<T> clone() {
            return new QStatisticsImpl<T>(this);
        }

        public QStatisticsImpl() {
        }

        private QStatisticsImpl(QStatisticsImpl<T> qstats) {
            if (qstats.s != null && qstats.s.get() != null) {
                this.s = new ReferencedDataset(((Dataset)qstats.s.get()).getView(false));
            }
            this.qmap.putAll(qstats.qmap);
            for (Integer i : qstats.aqmap.keySet()) {
                this.aqmap.put(i, new HashMap<Double, ReferencedDataset>(qstats.aqmap.get(i)));
            }
            this.smap.putAll(qstats.smap);
            this.isDirty = qstats.isDirty;
        }

        public void setQuantile(double q, T v) {
            this.qmap.put(q, v);
        }

        public T getQuantile(double q) {
            return this.qmap.get(q);
        }

        private Map<Double, ReferencedDataset> getMap(int axis) {
            Map<Double, ReferencedDataset> qm = this.aqmap.get(axis);
            if (qm == null) {
                qm = new HashMap<Double, ReferencedDataset>();
                this.aqmap.put(axis, qm);
            }
            return qm;
        }

        public void setQuantile(int axis, double q, Dataset v) {
            Map<Double, ReferencedDataset> qm = this.getMap(axis);
            qm.put(q, new ReferencedDataset(v));
        }

        public Dataset getQuantile(int axis, double q) {
            Map<Double, ReferencedDataset> qm = this.getMap(axis);
            ReferencedDataset rd = qm.get(q);
            return rd == null ? null : (Dataset)rd.get();
        }

        Dataset getSortedDataset(int axis) {
            return this.smap.containsKey(axis) ? (Dataset)this.smap.get(axis).get() : null;
        }

        void setSortedDataset(int axis, Dataset v) {
            this.smap.put(axis, new ReferencedDataset(v));
        }
    }

    private static class ReferencedDataset
    extends SoftReference<Dataset> {
        public ReferencedDataset(Dataset d) {
            super(d);
        }
    }
}

