/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import java.util.Properties;

public class StopOrFailOnExitStatusWithRestartTests
extends ServiceEETest {
    private static JobOperatorBridge jobOp;

    private void begin(String str) {
        TestUtil.logMsg((String)("Begin test method: " + str));
    }

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            StopOrFailOnExitStatusWithRestartTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public static void cleanup() throws EETest.Fault {
    }

    public void testInvokeJobWithUserStopAndRestart() throws EETest.Fault {
        String METHOD = "testInvokeJobWithUserStopAndRestart";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "5000";
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_longrunning.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties overrideJobParams = new Properties();
            TestUtil.logMsg((String)"run.indefinitely=true");
            overrideJobParams.setProperty("run.indefinitely", "true");
            TestUtil.logMsg((String)"Invoke startJobWithoutWaitingForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobWithoutWaitingForResult("job_batchlet_longrunning", overrideJobParams);
            long execID = execution1.getExecutionId();
            TestUtil.logMsg((String)("StopRestart: Started job with execId=" + execID + ""));
            int sleepTime = Integer.parseInt(System.getProperty("StopOrFailOnExitStatusWithRestartTests.testInvokeJobWithUserStop.sleep", "5000"));
            TestUtil.logMsg((String)("Sleep " + sleepTime + ""));
            Thread.sleep(sleepTime);
            BatchStatus exec1BatchStatus = execution1.getBatchStatus();
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + exec1BatchStatus + ""));
            boolean startedOrStarting = exec1BatchStatus == BatchStatus.STARTED || exec1BatchStatus == BatchStatus.STARTING;
            AssertionUtils.assertWithMessage("Found BatchStatus of " + exec1BatchStatus.toString() + "; Hopefully job isn't finished already, if it is fail the test and use a longer sleep time within the batch step-related artifact.", startedOrStarting);
            TestUtil.logMsg((String)"Invoke stopJobAndWaitForResult");
            jobOp.stopJobAndWaitForResult(execution1);
            JobExecution postStopJobExecution = jobOp.getJobExecution(execution1.getExecutionId());
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + postStopJobExecution.getBatchStatus()));
            AssertionUtils.assertWithMessage("The stop should have taken effect by now, even though the batchlet artifact had control at the time of the stop, it should have returned control by now.", BatchStatus.STOPPED, postStopJobExecution.getBatchStatus());
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + postStopJobExecution.getExitStatus()));
            AssertionUtils.assertWithMessage("If this assert fails with an exit status of STOPPED, try increasing the sleep time. It's possiblethe JobOperator stop is being issued before the Batchlet has a chance to run.", "BATCHLET CANCELED BEFORE COMPLETION", postStopJobExecution.getExitStatus());
            TestUtil.logMsg((String)"Create job parameters for execution #2:");
            TestUtil.logMsg((String)"run.indefinitely=false");
            overrideJobParams.setProperty("run.indefinitely", "false");
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with executionId: " + execution1.getInstanceId() + ""));
            TCKJobExecutionWrapper execution2 = jobOp.restartJobAndWaitForResult(execution1.getExecutionId(), overrideJobParams);
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + execution2.getBatchStatus()));
            AssertionUtils.assertWithMessage("If the restarted job hasn't completed yet then try increasing the sleep time.", BatchStatus.COMPLETED, execution2.getBatchStatus());
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + execution2.getExitStatus()));
            AssertionUtils.assertWithMessage("If this fails, the reason could be that step 1 didn't run the second time,though it should since it won't have completed successfully the first time.", "GOOD.STEP.GOOD.STEP", execution2.getExitStatus());
        }
        catch (Exception e) {
            StopOrFailOnExitStatusWithRestartTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobWithUncaughtExceptionFailAndRestart() throws EETest.Fault {
        String METHOD = "testInvokeJobWithUncaughtExceptionFailAndRestart";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_longrunning.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"throw.exc.on.number.3=true");
            jobParameters.setProperty("throw.exc.on.number.3", "true");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper firstJobExecution = jobOp.startJobAndWaitForResult("job_batchlet_longrunning", jobParameters);
            TestUtil.logMsg((String)("Started job with execId=" + firstJobExecution.getExecutionId()));
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + firstJobExecution.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + firstJobExecution.getExitStatus()));
            AssertionUtils.assertWithMessage("If the job hasn't failed yet then try increasing the sleep time.", BatchStatus.FAILED, firstJobExecution.getBatchStatus());
            AssertionUtils.assertObjEquals("FAILED", firstJobExecution.getExitStatus());
            TestUtil.logMsg((String)"Create job parameters for execution #2:");
            Properties overrideJobParams = new Properties();
            TestUtil.logMsg((String)"throw.exc.on.number.3=false");
            TestUtil.logMsg((String)"run.indefinitely=false");
            overrideJobParams.setProperty("throw.exc.on.number.3", "false");
            overrideJobParams.setProperty("run.indefinitely", "false");
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with executionId: " + firstJobExecution.getInstanceId() + ""));
            TCKJobExecutionWrapper secondJobExecution = jobOp.restartJobAndWaitForResult(firstJobExecution.getExecutionId(), overrideJobParams);
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + secondJobExecution.getBatchStatus()));
            AssertionUtils.assertWithMessage("If the restarted job hasn't completed yet then try increasing the sleep time.", BatchStatus.COMPLETED, secondJobExecution.getBatchStatus());
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + secondJobExecution.getExitStatus()));
            AssertionUtils.assertWithMessage("If this fails with only \"GOOD.STEP\", the reason could be that step 1 didn't run the second time,though it should since it won't have completed successfully the first time.", "GOOD.STEP.GOOD.STEP", secondJobExecution.getExitStatus());
        }
        catch (Exception e) {
            StopOrFailOnExitStatusWithRestartTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }
}

