/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.ejb.annotations.WSEjbSOAPHandlersTest2;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.HandlerTracker;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbSOAPHandlersTest2.Hello;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbSOAPHandlersTest2.HelloService;
import jakarta.jws.HandlerChain;
import jakarta.xml.ws.WebServiceRef;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class Client
extends EETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private URLConnection urlConn = null;
    private String SERVLET = "/WSEjbSOAPHandlersTest2Clnt_web/ServletTest";
    private Hello port;
    @HandlerChain(name="", file="Hello_handler.xml")
    @WebServiceRef(name="service/wsejbsoaphandlerstest2")
    static HelloService service;

    private void getPort() throws Exception {
        TestUtil.logMsg((String)"Get wsejbsoaphandlerstest2 Service via @WebServiceRef annotation");
        TestUtil.logMsg((String)"Uses name attribute @WebServiceRef(name=\"service/wsejbsoaphandlerstest2\")");
        TestUtil.logMsg((String)("service=" + (Object)((Object)service)));
        TestUtil.logMsg((String)"Get port from service");
        this.port = service.getHello();
        TestUtil.logMsg((String)("port=" + this.port));
        TestUtil.logMsg((String)"Port obtained");
        JAXWS_Util.dumpTargetEndpointAddress(this.port);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            if (pass) {
                this.getPort();
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    private void printSeperationLine() {
        TestUtil.logMsg((String)"---------------------------");
    }

    public void WSEjbSOAPHandlersApplicationClientTest() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbSOAPHandlersApplicationClientTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Invoke the webservice endpoint from AppClient container");
            String serverSideMsgs = this.port.helloEcho("firstcall");
            serverSideMsgs = this.port.helloEcho("secondcall");
            String clientSideMsgs = HandlerTracker.getMessages1();
            HandlerTracker.purge();
            TestUtil.logMsg((String)"-----------------------------------");
            TestUtil.logMsg((String)"Dumping ClientSide Handler messages");
            TestUtil.logMsg((String)"-----------------------------------");
            TestUtil.logMsg((String)clientSideMsgs);
            TestUtil.logMsg((String)"Verify client side handler callbacks");
            if (!this.VerifyHandlerCallBacks("client", clientSideMsgs)) {
                TestUtil.logErr((String)"ClientSide Handler CallBacks (incorrect)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"ClientSide Handler CallBacks (correct)");
            }
            TestUtil.logMsg((String)"-----------------------------------");
            TestUtil.logMsg((String)"Dumping ServerSide Handler messages");
            TestUtil.logMsg((String)"-----------------------------------");
            TestUtil.logMsg((String)serverSideMsgs);
            TestUtil.logMsg((String)"Verify server side handler callbacks");
            if (!this.VerifyHandlerCallBacks("server", serverSideMsgs)) {
                TestUtil.logErr((String)"ServerSide Handler CallBacks (incorrect)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"ServerSide Handler CallBacks (correct)");
            }
            if (!pass) {
                throw new EETest.Fault("WSEjbSOAPHandlersApplicationClientTest failed");
            }
        }
        catch (Throwable t) {
            throw new EETest.Fault("WSEjbSOAPHandlersApplicationClientTest failed");
        }
    }

    public void WSEjbSOAPHandlersServletClientTest() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbSOAPHandlersServletClientTest");
        try {
            TestUtil.logMsg((String)"Invoke the webservice endpoint from Web container");
            TestUtil.logMsg((String)"Create URL to WebClient (ServletClient)");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)"Invoke the WebClient (ServletClient)");
            TestUtil.logMsg((String)"Get test result from WebClient (ServletClient)");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                throw new EETest.Fault("WSEjbSOAPHandlersServletClientTest failed");
            }
        }
        catch (Throwable t) {
            throw new EETest.Fault("WSEjbSOAPHandlersServletClientTest failed");
        }
    }

    private boolean VerifyHandlerCallBacks(String who, String calls) {
        boolean startIdx = false;
        boolean endIdx = false;
        boolean pass = true;
        if (who.equals("client")) {
            if (calls == null) {
                TestUtil.logErr((String)"Callback string is null (unexpected)");
                return false;
            }
            if (calls.indexOf("ClientHandler1.handleMessage().doInbound()") == -1) {
                TestUtil.logErr((String)"ClientHandler1.handleMessage().doInbound() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler2.handleMessage().doInbound()") == -1) {
                TestUtil.logErr((String)"ClientHandler2.handleMessage().doInbound() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler1.handleMessage().doOutbound()") == -1) {
                TestUtil.logErr((String)"ClientHandler1.handleMessage().doOutbound() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler2.handleMessage().doOutbound()") == -1) {
                TestUtil.logErr((String)"ClientHandler2.handleMessage().doOutbound() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler1.close()") == -1) {
                TestUtil.logErr((String)"ClientHandler1.close() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler2.close()") == -1) {
                TestUtil.logErr((String)"ClientHandler2.close() was not called");
                pass = false;
            }
        } else {
            if (calls == null) {
                TestUtil.logErr((String)"Callback string is null (unexpected)");
                return false;
            }
            if (calls.indexOf("ServerHandler1.handleMessage().doInbound()") == -1) {
                TestUtil.logErr((String)"ServerHandler1.handleMessage().doInbound() was not called");
                pass = false;
            }
            if (calls.indexOf("ServerHandler2.handleMessage().doInbound()") == -1) {
                TestUtil.logErr((String)"ServerHandler2.handleMessage().doInbound() was not called");
                pass = false;
            }
            if (calls.indexOf("ServerHandler1.handleMessage().doOutbound()") == -1) {
                TestUtil.logErr((String)"ServerHandler1.handleMessage().doOutbound() was not called");
                pass = false;
            }
            if (calls.indexOf("ServerHandler2.handleMessage().doOutbound()") == -1) {
                TestUtil.logErr((String)"ServerHandler2.handleMessage().doOutbound() was not called");
                pass = false;
            }
            if (calls.indexOf("ServerHandler1.close()") == -1) {
                TestUtil.logErr((String)"ServerHandler1.close() was not called");
                pass = false;
            }
            if (calls.indexOf("ServerHandler2.close()") == -1) {
                TestUtil.logErr((String)"ServerHandler2.close() was not called");
                pass = false;
            }
        }
        return pass;
    }
}

